/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.ewt.plaf;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import javax.swing.JComponent;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.plaf.basic.BasicBorders;
import oracle.bali.ewt.border.BorderAdapter;
import oracle.bali.ewt.painter.BorderPainter;
import oracle.bali.ewt.painter.PaintContext;
import oracle.bali.ewt.painter.Painter;
import oracle.bali.ewt.util.ImmInsets;

public class UIUtils {
    public static Dimension getMinimumSize(Painter painter, PaintContext paintContext, JComponent jComponent) {
        Dimension dimension = painter.getMinimumSize(paintContext);
        UIUtils.addInsets(jComponent, dimension);
        return dimension;
    }

    public static Dimension getPreferredSize(Painter painter, PaintContext paintContext, JComponent jComponent) {
        Dimension dimension = painter.getPreferredSize(paintContext);
        UIUtils.addInsets(jComponent, dimension);
        return dimension;
    }

    public static Dimension getMaximumSize(Painter painter, PaintContext paintContext, JComponent jComponent) {
        Dimension dimension = painter.getPreferredSize(paintContext);
        UIUtils.addInsets(jComponent, dimension);
        return dimension;
    }

    public static void paint(Graphics graphics, Painter painter, PaintContext paintContext, JComponent jComponent) {
        ImmInsets immInsets = UIUtils.getInsets(jComponent);
        graphics.setColor(paintContext.getPaintForeground());
        painter.paint(paintContext, graphics, immInsets.left, immInsets.top, jComponent.getWidth() - (immInsets.left + immInsets.right), jComponent.getHeight() - (immInsets.top + immInsets.bottom));
    }

    public static void fillBackground(Graphics graphics, JComponent jComponent) {
        ImmInsets immInsets = UIUtils._getInsets(jComponent, true);
        Color color = graphics.getColor();
        graphics.setColor(jComponent.getBackground());
        graphics.fillRect(immInsets.left, immInsets.top, jComponent.getWidth() - (immInsets.left + immInsets.right), jComponent.getHeight() - (immInsets.top + immInsets.bottom));
        graphics.setColor(color);
    }

    public static boolean contains(Painter painter, PaintContext paintContext, JComponent jComponent, int n, int n2) {
        int n3 = jComponent.getWidth();
        int n4 = jComponent.getHeight();
        if (n < 0 || n >= n3 || n2 < 0 || n2 >= n4) {
            return false;
        }
        ImmInsets immInsets = UIUtils.getInsets(jComponent);
        return painter.contains(paintContext, n3 - (immInsets.left + immInsets.right), n4 - (immInsets.top + immInsets.bottom), n - immInsets.left, n2 - immInsets.top);
    }

    public static void addInsets(JComponent jComponent, Dimension dimension) {
        ImmInsets immInsets = UIUtils.getInsets(jComponent);
        dimension.width += immInsets.left + immInsets.right;
        dimension.height += immInsets.top + immInsets.bottom;
    }

    public static ImmInsets getInsets(JComponent jComponent) {
        return UIUtils._getInsets(jComponent, false);
    }

    private static ImmInsets _getInsets(JComponent jComponent, boolean bl) {
        return UIUtils._getInsets(jComponent, jComponent.getBorder(), bl);
    }

    private static ImmInsets _getInsets(JComponent jComponent, Border border, boolean bl) {
        if (border != null) {
            if (border instanceof BorderAdapter) {
                PaintContext paintContext = ((BorderAdapter)border).getPaintContext(jComponent);
                if (paintContext != null) {
                    BorderPainter borderPainter = ((BorderAdapter)border).getBorderPainter();
                    if (bl) {
                        return borderPainter.getFillInsets(paintContext);
                    }
                    return borderPainter.getInsets(paintContext);
                }
            } else if (bl) {
                if (border instanceof EmptyBorder || border instanceof BasicBorders.MarginBorder) {
                    return ImmInsets.getEmptyInsets();
                }
                if (border instanceof CompoundBorder) {
                    return UIUtils._getInsets(jComponent, ((CompoundBorder)border).getOutsideBorder(), bl);
                }
            }
            return new ImmInsets(border.getBorderInsets(jComponent));
        }
        return ImmInsets.getEmptyInsets();
    }

    private UIUtils() {
    }
}

