/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.ewt.pivot;

import java.awt.AWTEvent;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.event.ContainerEvent;
import java.awt.event.ContainerListener;
import java.awt.event.MouseEvent;
import java.beans.PropertyVetoException;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.Locale;
import java.util.ResourceBundle;
import javax.accessibility.Accessible;
import javax.accessibility.AccessibleAction;
import javax.accessibility.AccessibleContext;
import javax.accessibility.AccessibleRole;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JViewport;
import javax.swing.SwingUtilities;
import javax.swing.UIDefaults;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import oracle.bali.ewt.LWComponent;
import oracle.bali.ewt.LookAndFeel;
import oracle.bali.ewt.elaf.EWTPivotGridUI;
import oracle.bali.ewt.elaf.EWTPivotTableUI;
import oracle.bali.ewt.elaf.EWTTableUI;
import oracle.bali.ewt.grid.AppearanceManager;
import oracle.bali.ewt.grid.Grid;
import oracle.bali.ewt.header.Header;
import oracle.bali.ewt.model.NullTwoDModel;
import oracle.bali.ewt.model.TwoDModel;
import oracle.bali.ewt.painter.PaintContext;
import oracle.bali.ewt.painter.Painter;
import oracle.bali.ewt.pivot.CollapseEvent;
import oracle.bali.ewt.pivot.CollapseListener;
import oracle.bali.ewt.pivot.DrillEvent;
import oracle.bali.ewt.pivot.DrillListener;
import oracle.bali.ewt.pivot.DummyPanel;
import oracle.bali.ewt.pivot.PivotCorner;
import oracle.bali.ewt.pivot.PivotEvent;
import oracle.bali.ewt.pivot.PivotGrid;
import oracle.bali.ewt.pivot.PivotGridDropAdapter;
import oracle.bali.ewt.pivot.PivotGridTabAdapt;
import oracle.bali.ewt.pivot.PivotHeader;
import oracle.bali.ewt.pivot.PivotHeaderEvent;
import oracle.bali.ewt.pivot.PivotHeaderResListener;
import oracle.bali.ewt.pivot.PivotHeaderTabAdapt;
import oracle.bali.ewt.pivot.PivotListener;
import oracle.bali.ewt.pivot.PivotScrollPaneView;
import oracle.bali.ewt.pivot.PivotTableSelection;
import oracle.bali.ewt.pivot.PivotTableSelectionAdapt;
import oracle.bali.ewt.print.PrinterUtils;
import oracle.bali.ewt.scrolling.ScrollableComponent;
import oracle.bali.ewt.selection.TwoDSelection;
import oracle.bali.ewt.table.SpreadTable;
import oracle.bali.ewt.table.TableEditListener;
import oracle.bali.ewt.table.TableEvent;
import oracle.bali.ewt.table.TableResizeListener;
import oracle.bali.share.event.ListenerManager;
import oracle.bali.share.nls.LocaleUtils;

public class PivotTable
extends ScrollableComponent
implements Accessible {
    public static final String PROPERTY_SELECTION = "selection";
    public static final Object KEY_DRAW_RAISED = "pivotTable.drawRaised";
    public static final Object PRINT_RAISED = SpreadTable.PRINT_RAISED;
    public static final Object PRINT_CORNER_COMPONENT = "pivotTable.printCorner";
    public static final Object DUPLICATE_COLUMN_PIVOT_HEADER = SpreadTable.DUPLICATE_COLUMN_HEADERS;
    public static final Object DUPLICATE_ROW_PIVOT_HEADER = SpreadTable.DUPLICATE_ROW_HEADERS;
    public static final Object DISPLAY_COLUMN_SELECTORS = SpreadTable.DISPLAY_COLUMN_HEADERS;
    public static final Object DISPLAY_ROW_SELECTORS = SpreadTable.DISPLAY_ROW_HEADERS;
    public static final Object DUPLICATE_COLUMN_HEADER_DATA = "pivotTable.dupColHeaderData";
    public static final Object DUPLICATE_ROW_HEADER_DATA = "pivotTable.dupRowHeaderData";
    public static final Object DISPLAY_COLUMN_DRILL_IMAGES = "pivotTable.dispColDrillImage";
    public static final Object DISPLAY_ROW_DRILL_IMAGES = "pivotTable.dispRowDrillImage";
    static final String _RESOURCE_BUNDLE = "oracle.bali.ewt.resource.AccessibilityBundle";
    static final String _SELECT_ALL_KEY = "SELECT_ALL";
    private static final int _RESIZE_FEEDBACK_SIZE = 3;
    private boolean _swap;
    private PivotGrid _pivotGrid;
    private PivotHeader _columnPivotHeader;
    private PivotHeader _rowPivotHeader;
    private ListenerManager _pivotListeners;
    private ListenerManager _drillListeners;
    private ListenerManager _collapseListeners;
    private ListenerManager _pivotHeaderResListeners;
    private ListenerManager _editListeners;
    private ListenerManager _resizeListeners;
    private boolean _equalSizeColumns;
    private boolean _equalSizeRows;
    private boolean _needToDefaultColumns;
    private boolean _needToDefaultRows;
    private JScrollPane _scrollPane;
    private Component _corner;
    private boolean _drawRaised = true;
    private PivotHeader _resizeHeader;
    private ChangeListener _hListener;
    private ChangeListener _vListener;
    private boolean _columnWidthChanged;
    private boolean _rowHeightChanged;
    private int _rowSelectorHeight;
    private int _columnSelectorWidth;
    private PivotGridTabAdapt _gridListener;
    private PivotHeaderTabAdapt _columnListener;
    private PivotHeaderTabAdapt _rowListener;
    private PivotTableSelectionAdapt _selectionListener;
    private PTContainerListener _containerListener;
    private PivotGridDropAdapter _pivotGridDropAdapter;

    public PivotTable() {
        this(NullTwoDModel.getTwoDModel(), NullTwoDModel.getTwoDModel(), NullTwoDModel.getTwoDModel());
    }

    public PivotTable(TwoDModel twoDModel, TwoDModel twoDModel2, TwoDModel twoDModel3) {
        this(new PivotGrid(twoDModel), new PivotHeader(twoDModel2, 0), new PivotHeader(twoDModel3, 1));
    }

    public PivotTable(PivotGrid pivotGrid, PivotHeader pivotHeader, PivotHeader pivotHeader2) {
        this.setLayout(new _LayoutMgr());
        PivotGridTabAdapt pivotGridTabAdapt = new PivotGridTabAdapt(this);
        pivotGrid.addEditListener(pivotGridTabAdapt);
        pivotGrid.addResizeListener(pivotGridTabAdapt);
        pivotGrid.setPivotTable(this);
        pivotGrid.setCornerComponent("UPPER_LEFT_CORNER", new TableCorner());
        this.add(pivotGrid);
        this._gridListener = pivotGridTabAdapt;
        PivotHeaderTabAdapt pivotHeaderTabAdapt = new PivotHeaderTabAdapt(this);
        pivotHeader.addResizeListener(pivotHeaderTabAdapt);
        pivotHeader.setDrillListener(pivotHeaderTabAdapt);
        pivotHeader.setCollapseListener(pivotHeaderTabAdapt);
        pivotHeader.setPivotTable(this);
        this.add(pivotHeader);
        this._columnListener = pivotHeaderTabAdapt;
        PivotHeaderTabAdapt pivotHeaderTabAdapt2 = new PivotHeaderTabAdapt(this);
        pivotHeader2.addResizeListener(pivotHeaderTabAdapt2);
        pivotHeader2.setDrillListener(pivotHeaderTabAdapt2);
        pivotHeader2.setCollapseListener(pivotHeaderTabAdapt2);
        pivotHeader2.setPivotTable(this);
        this.add(pivotHeader2);
        this._rowListener = pivotHeaderTabAdapt2;
        PivotTableSelectionAdapt pivotTableSelectionAdapt = new PivotTableSelectionAdapt(this);
        pivotGrid.addPropertyChangeListener(pivotTableSelectionAdapt);
        pivotGrid.addVetoableChangeListener(pivotTableSelectionAdapt);
        pivotHeader.addPropertyChangeListener(pivotTableSelectionAdapt);
        pivotHeader.addVetoableChangeListener(pivotTableSelectionAdapt);
        pivotHeader2.addPropertyChangeListener(pivotTableSelectionAdapt);
        pivotHeader2.addVetoableChangeListener(pivotTableSelectionAdapt);
        this._selectionListener = pivotTableSelectionAdapt;
        this._pivotGrid = pivotGrid;
        this._columnPivotHeader = pivotHeader;
        this._rowPivotHeader = pivotHeader2;
        this._equalSizeColumns = true;
        this._equalSizeRows = true;
        this.updateUI();
    }

    public void dispose() {
        if (this._pivotGrid == null) {
            return;
        }
        this._disposeScrollpane();
        this.removeAll();
        this.setCornerComponent(null);
        this._resizeHeader = null;
        this._collapseListeners = null;
        this._drillListeners = null;
        this._pivotListeners = null;
        this._resizeListeners = null;
        this._editListeners = null;
        this._pivotHeaderResListeners = null;
        this._pivotGrid.removePropertyChangeListener(this._selectionListener);
        this._pivotGrid.removeVetoableChangeListener(this._selectionListener);
        this._columnPivotHeader.removePropertyChangeListener(this._selectionListener);
        this._columnPivotHeader.removeVetoableChangeListener(this._selectionListener);
        this._rowPivotHeader.removePropertyChangeListener(this._selectionListener);
        this._rowPivotHeader.removeVetoableChangeListener(this._selectionListener);
        this._selectionListener = null;
        this._pivotGrid.removeEditListener(this._gridListener);
        this._pivotGrid.removeResizeListener(this._gridListener);
        this._pivotGrid.setPivotTable(null);
        this._pivotGrid.setCornerComponent("UPPER_LEFT_CORNER", null);
        this._gridListener.dispose();
        this._gridListener = null;
        this._pivotGrid.dispose();
        this._pivotGridDropAdapter.dispose();
        this._pivotGridDropAdapter = null;
        this._columnPivotHeader.removeResizeListener(this._columnListener);
        this._columnPivotHeader.setDrillListener(null);
        this._columnPivotHeader.setCollapseListener(null);
        this._columnPivotHeader.setPivotTable(null);
        this._columnListener.dispose();
        this._columnListener = null;
        this._columnPivotHeader.dispose();
        this._rowPivotHeader.removeResizeListener(this._rowListener);
        this._rowPivotHeader.setDrillListener(null);
        this._rowPivotHeader.setCollapseListener(null);
        this._rowPivotHeader.setPivotTable(null);
        this._rowListener.dispose();
        this._rowListener = null;
        this._rowPivotHeader.dispose();
        this.removeAll();
        this.setLayout(null);
        this._columnPivotHeader = null;
        this._pivotGrid = null;
        this._rowPivotHeader = null;
    }

    public void setSwapAllowed(boolean bl) {
        this._swap = bl;
    }

    public boolean isSwapAllowed() {
        return this._swap;
    }

    public Component getCornerComponent() {
        if (this._corner == null) {
            this._corner = new PivotCorner(this);
            if (this._scrollPane != null) {
                this.add(this._corner);
            }
        }
        return this._corner;
    }

    public void setCornerComponent(Component component) {
        AccessibleContext accessibleContext;
        if (this._corner == component) {
            return;
        }
        Component component2 = this._corner;
        this._corner = component;
        if (this._corner != null) {
            this._corner.setEnabled(this.isEnabled());
        }
        if (this._scrollPane == null) {
            if (component2 != null) {
                this.remove(component2);
            }
            if (this._corner == null) {
                this._corner = this.getCornerComponent();
            }
            this.add(this._corner);
        } else {
            this._updateScrollpaneLayout();
        }
        if (component2 instanceof PivotCorner) {
            ((PivotCorner)component2).dispose();
        }
        if ((accessibleContext = this.accessibleContext) != null) {
            if (component2 instanceof Accessible) {
                accessibleContext.firePropertyChange("AccessibleChild", component2, null);
                ((Accessible)((Object)component2)).getAccessibleContext().setAccessibleParent(null);
            }
            if (this._corner instanceof Accessible) {
                ((Accessible)((Object)this._corner)).getAccessibleContext().setAccessibleParent(this);
                accessibleContext.firePropertyChange("AccessibleChild", null, this._corner);
            }
        }
        this.invalidateParent();
    }

    public void setDrawRaised(boolean bl) {
        if (this._drawRaised != bl) {
            this._drawRaised = bl;
            this.getColumnPivotHeader().setDrawRaised(bl);
            this.getRowPivotHeader().setDrawRaised(bl);
            this.getPivotGrid().setDrawRaised(bl);
            this.repaint();
        }
    }

    public boolean getDrawRaised() {
        return this._drawRaised;
    }

    public void setColumnPivotHeaderVisible(boolean bl) {
        if (this._columnPivotHeader.isVisible() != bl) {
            this._columnPivotHeader.setVisible(bl);
            this._updateScrollpaneLayout();
            this.invalidateCanvas();
        }
    }

    public void setRowPivotHeaderVisible(boolean bl) {
        if (this._rowPivotHeader.isVisible() != bl) {
            this._rowPivotHeader.setVisible(bl);
            this._updateScrollpaneLayout();
            this.invalidateCanvas();
        }
    }

    public boolean isColumnPivotHeaderVisible() {
        return this._columnPivotHeader.isVisible();
    }

    public boolean isRowPivotHeaderVisible() {
        return this._rowPivotHeader.isVisible();
    }

    public PivotGrid getPivotGrid() {
        return this._pivotGrid;
    }

    public final PivotHeader getPivotHeader(int n) {
        return n == 0 ? this.getColumnPivotHeader() : this.getRowPivotHeader();
    }

    public PivotHeader getRowPivotHeader() {
        return this._rowPivotHeader;
    }

    public PivotHeader getColumnPivotHeader() {
        return this._columnPivotHeader;
    }

    public void setModels(TwoDModel twoDModel, TwoDModel twoDModel2, TwoDModel twoDModel3) {
        this.freezeRepaints();
        this._pivotGrid.freezeRepaints();
        this._columnPivotHeader.freezeRepaints();
        this._rowPivotHeader.freezeRepaints();
        try {
            this._pivotGrid.setModel(twoDModel);
            this._columnPivotHeader.setModel(twoDModel2);
            this._rowPivotHeader.setModel(twoDModel3);
            Object var5_4 = null;
            this.unfreezeRepaints();
            this._pivotGrid.unfreezeRepaints();
            this._columnPivotHeader.unfreezeRepaints();
            this._rowPivotHeader.unfreezeRepaints();
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            this.unfreezeRepaints();
            this._pivotGrid.unfreezeRepaints();
            this._columnPivotHeader.unfreezeRepaints();
            this._rowPivotHeader.unfreezeRepaints();
            throw throwable;
        }
        this.invalidateCanvas();
    }

    public void setColumnSelectorWidth(int n) {
        if (n <= 0) {
            n = this.getPivotTableUI().getSelectorSize(this);
        }
        if (this._columnSelectorWidth != n) {
            this._columnSelectorWidth = n;
            this._columnPivotHeader.setRowHeaderWidth(n);
            this._pivotGrid.setRowHeaderWidth(n);
            this.invalidateParent();
        }
    }

    public int getColumnSelectorWidth() {
        int n = this._columnSelectorWidth;
        if (n <= 0) {
            this._columnSelectorWidth = n = this.getPivotTableUI().getSelectorSize(this);
            this._columnPivotHeader.setRowHeaderWidth(n);
            this._pivotGrid.setRowHeaderWidth(n);
            this.invalidateParent();
        }
        return n;
    }

    public void setRowSelectorHeight(int n) {
        if (n <= 0) {
            n = this.getPivotTableUI().getSelectorSize(this);
        }
        if (this._rowSelectorHeight != n) {
            this._rowSelectorHeight = n;
            this._rowPivotHeader.setColumnHeaderHeight(n);
            this._pivotGrid.setColumnHeaderHeight(n);
            this.invalidateParent();
        }
    }

    public int getRowSelectorHeight() {
        int n = this._rowSelectorHeight;
        if (n <= 0) {
            this._rowSelectorHeight = n = this.getPivotTableUI().getSelectorSize(this);
            this._rowPivotHeader.setColumnHeaderHeight(n);
            this._pivotGrid.setColumnHeaderHeight(n);
            this.invalidateParent();
        }
        return n;
    }

    public final TwoDModel getGridModel() {
        return this._pivotGrid.getModel();
    }

    public final TwoDModel getColumnModel() {
        return this._columnPivotHeader.getModel();
    }

    public final TwoDModel getRowModel() {
        return this._rowPivotHeader.getModel();
    }

    public final AppearanceManager getGridAppearanceManager() {
        return this._pivotGrid.getAppearanceManager();
    }

    public final void setGridAppearanceManager(AppearanceManager appearanceManager) {
        this._pivotGrid.setAppearanceManager(appearanceManager);
    }

    public final AppearanceManager getColumnAppearanceManager() {
        return this._columnPivotHeader.getAppearanceManager();
    }

    public final void setColumnAppearanceManager(AppearanceManager appearanceManager) {
        this._columnPivotHeader.setAppearanceManager(appearanceManager);
    }

    public final AppearanceManager getRowAppearanceManager() {
        return this._rowPivotHeader.getAppearanceManager();
    }

    public final void setRowAppearanceManager(AppearanceManager appearanceManager) {
        this._rowPivotHeader.setAppearanceManager(appearanceManager);
    }

    public void setColumnWidth(int n, int n2) {
        this._pivotGrid.setColumnWidth(n, n2);
        if (n2 != -1) {
            n2 += this._getVerticalSize();
            this._columnWidthChanged = true;
        }
        this._columnPivotHeader.setColumnWidth(n, n2);
        Dimension dimension = this.layoutCanvas();
        this.setCanvasSize(dimension.width, dimension.height);
        this._updateScrollpane();
    }

    public int getColumnWidth(int n) {
        return this._pivotGrid.getColumnWidth(n);
    }

    public void setRowHeight(int n, int n2) {
        this._pivotGrid.setRowHeight(n, n2);
        if (n2 != -1) {
            n2 += this._getHorizontalSize();
            this._rowHeightChanged = true;
        }
        this._rowPivotHeader.setRowHeight(n, n2);
        Dimension dimension = this.layoutCanvas();
        this.setCanvasSize(dimension.width, dimension.height);
        this._updateScrollpane();
    }

    public int getRowHeight(int n) {
        return this._pivotGrid.getRowHeight(n);
    }

    public void setDefaultColumnWidth(int n) {
        this._pivotGrid.setDefaultColumnWidth(n);
        n = this._pivotGrid.getDefaultColumnWidth() + this._getVerticalSize();
        this._columnPivotHeader.setDefaultColumnWidth(n);
        Dimension dimension = this.layoutCanvas();
        this.setCanvasSize(dimension.width, dimension.height);
        this._updateScrollpane();
    }

    public void setDefaultRowHeight(int n) {
        this._pivotGrid.setDefaultRowHeight(n);
        n = this._pivotGrid.getDefaultRowHeight() + this._getHorizontalSize();
        this._rowPivotHeader.setDefaultRowHeight(n);
        Dimension dimension = this.layoutCanvas();
        this.setCanvasSize(dimension.width, dimension.height);
        this._updateScrollpane();
    }

    public void setFirstColumnOnScreen(int n) {
        this._columnPivotHeader.setFirstColumnOnScreen(n);
        this._pivotGrid.setFirstColumnOnScreen(n);
        if (this._scrollPane != null) {
            int n2;
            int n3 = this._pivotGrid.getGrid().getColumnPosition(n);
            int n4 = this._pivotGrid.getColumnGeometryManager().getTotalSize();
            if (n4 - n3 < (n2 = this._pivotGrid.getGrid().getInnerWidth())) {
                n3 = n4 - n2;
            }
            if (n3 < 0) {
                n3 = 0;
            }
            JViewport jViewport = this._scrollPane.getViewport();
            Point point = jViewport.getViewPosition();
            point.x = n3;
            jViewport.setViewPosition(point);
            jViewport = this._scrollPane.getColumnHeader();
            if (jViewport != null) {
                point = jViewport.getViewPosition();
                point.x = n3;
                jViewport.setViewPosition(point);
            }
        }
    }

    public int getFirstColumnOnScreen() {
        return this._pivotGrid.getFirstColumnOnScreen();
    }

    public void setFirstRowOnScreen(int n) {
        this._rowPivotHeader.setFirstRowOnScreen(n);
        this._pivotGrid.setFirstRowOnScreen(n);
        if (this._scrollPane != null) {
            int n2;
            int n3 = this._pivotGrid.getGrid().getRowPosition(n);
            int n4 = this._pivotGrid.getRowGeometryManager().getTotalSize();
            if (n4 - n3 < (n2 = this._pivotGrid.getGrid().getInnerHeight())) {
                n3 = n4 - n2;
            }
            if (n3 < 0) {
                n3 = 0;
            }
            JViewport jViewport = this._scrollPane.getViewport();
            Point point = jViewport.getViewPosition();
            point.y = n3;
            jViewport.setViewPosition(point);
            jViewport = this._scrollPane.getRowHeader();
            if (jViewport != null) {
                point = jViewport.getViewPosition();
                point.y = n3;
                jViewport.setViewPosition(point);
            }
        }
    }

    public int getFirstRowOnScreen() {
        return this._pivotGrid.getFirstRowOnScreen();
    }

    public void setEqualSizedColumns(boolean bl) {
        if (this._equalSizeColumns != bl) {
            this._needToDefaultColumns = this._equalSizeColumns = bl;
        }
    }

    public boolean getEqualSizedColumns() {
        return this._equalSizeColumns;
    }

    public void setEqualSizedRows(boolean bl) {
        if (this._equalSizeRows != bl) {
            this._needToDefaultRows = this._equalSizeRows = bl;
        }
    }

    public boolean getEqualSizedRows() {
        return this._equalSizeRows;
    }

    public void setScrollByColumn(boolean bl) {
        if (bl == this.getScrollByColumn()) {
            return;
        }
        this._pivotGrid.setScrollByColumn(bl);
        if (this._columnPivotHeader != null) {
            this._columnPivotHeader.setScrollByColumn(bl);
        }
        Dimension dimension = this.getCanvasSize();
        this.setCanvasSize(dimension.width, dimension.height);
    }

    public boolean getScrollByColumn() {
        return this._pivotGrid.getScrollByColumn();
    }

    public void setScrollByRow(boolean bl) {
        if (bl == this.getScrollByRow()) {
            return;
        }
        this._pivotGrid.setScrollByRow(bl);
        if (this._rowPivotHeader != null) {
            this._rowPivotHeader.setScrollByRow(bl);
        }
        Dimension dimension = this.getCanvasSize();
        this.setCanvasSize(dimension.width, dimension.height);
    }

    public boolean getScrollByRow() {
        return this._pivotGrid.getScrollByRow();
    }

    public void setSelection(PivotTableSelection pivotTableSelection) throws PropertyVetoException {
        if (pivotTableSelection == null) {
            pivotTableSelection = PivotTableSelection.getEmptySelection();
        }
        TwoDSelection twoDSelection = pivotTableSelection.getColumnSelection();
        this._columnPivotHeader.getGrid().setSelection(twoDSelection);
        this._columnPivotHeader.getRowHeader().setSelection(twoDSelection.getRowSelection());
        twoDSelection = pivotTableSelection.getRowSelection();
        this._rowPivotHeader.getGrid().setSelection(twoDSelection);
        this._rowPivotHeader.getColumnHeader().setSelection(twoDSelection.getColumnSelection());
        twoDSelection = pivotTableSelection.getGridSelection();
        this._pivotGrid.getGrid().setSelection(twoDSelection);
        this._pivotGrid.getColumnHeader().setSelection(twoDSelection.getColumnSelection());
        this._pivotGrid.getRowHeader().setSelection(twoDSelection.getRowSelection());
    }

    public PivotTableSelection getSelection() {
        return new PivotTableSelection(this._columnPivotHeader.getGrid().getSelection(), this._rowPivotHeader.getGrid().getSelection(), this._pivotGrid.getGrid().getSelection());
    }

    public final void fireDrillEvent(int n, int n2, int n3, Object object) {
        this.postEvent(new DrillEvent(this, 2002, n, n2, n3, object));
    }

    public final void fireCollapseEvent(int n, int n2, int n3) {
        this.postEvent(new CollapseEvent(this, 2001, n, n2, n3));
    }

    public final void firePivotEvent(Object object, int n, Object object2, int n2) {
        this.postEvent(new PivotEvent(object, 2001, object2, n, n2));
    }

    public final void fireSwapEvent(Object object, int n, Object object2, int n2) {
        if (!this.isSwapAllowed()) {
            throw new IllegalStateException("swapping is not enabled.");
        }
        this.postEvent(new PivotEvent(object, 2002, object2, n, n2));
    }

    public void fireVetoableChange(String string, Object object, Object object2) throws PropertyVetoException {
        super.fireVetoableChange(string, object, object2);
    }

    public void firePropertyChange(String string, Object object, Object object2) {
        super.firePropertyChange(string, object, object2);
    }

    public synchronized void addEditListener(TableEditListener tableEditListener) {
        if (this._editListeners == null) {
            this._editListeners = new ListenerManager();
        }
        this._editListeners.addListener(tableEditListener);
    }

    public synchronized void removeEditListener(TableEditListener tableEditListener) {
        if (this._editListeners != null) {
            this._editListeners.removeListener(tableEditListener);
        }
    }

    public synchronized void addResizeListener(TableResizeListener tableResizeListener) {
        if (this._resizeListeners == null) {
            this._resizeListeners = new ListenerManager();
        }
        this._resizeListeners.addListener(tableResizeListener);
    }

    public synchronized void removeResizeListener(TableResizeListener tableResizeListener) {
        if (this._resizeListeners != null) {
            this._resizeListeners.removeListener(tableResizeListener);
        }
    }

    public synchronized void addPivotListener(PivotListener pivotListener) {
        if (this._pivotListeners == null) {
            this._pivotListeners = new ListenerManager();
        }
        this._pivotListeners.addListener(pivotListener);
    }

    public synchronized void removePivotListener(PivotListener pivotListener) {
        if (this._pivotListeners != null) {
            this._pivotListeners.removeListener(pivotListener);
        }
    }

    public synchronized void addDrillListener(DrillListener drillListener) {
        if (this._drillListeners == null) {
            this._drillListeners = new ListenerManager();
        }
        this._drillListeners.addListener(drillListener);
    }

    public synchronized void removeDrillListener(DrillListener drillListener) {
        if (this._drillListeners != null) {
            this._drillListeners.removeListener(drillListener);
        }
    }

    public synchronized void addCollapseListener(CollapseListener collapseListener) {
        if (this._collapseListeners == null) {
            this._collapseListeners = new ListenerManager();
        }
        this._collapseListeners.addListener(collapseListener);
    }

    public synchronized void removeCollapseListener(CollapseListener collapseListener) {
        if (this._collapseListeners != null) {
            this._collapseListeners.removeListener(collapseListener);
        }
    }

    public synchronized void addPivotHeaderResListener(PivotHeaderResListener pivotHeaderResListener) {
        if (this._pivotHeaderResListeners == null) {
            this._pivotHeaderResListeners = new ListenerManager();
        }
        this._pivotHeaderResListeners.addListener(pivotHeaderResListener);
    }

    public synchronized void removePivotHeaderResListener(PivotHeaderResListener pivotHeaderResListener) {
        if (this._pivotHeaderResListeners != null) {
            this._pivotHeaderResListeners.removeListener(pivotHeaderResListener);
        }
    }

    public AccessibleContext getAccessibleContext() {
        if (this.accessibleContext == null) {
            this.accessibleContext = new AccessiblePivotTable();
        }
        return this.accessibleContext;
    }

    public String getUIClassID() {
        return "EWTPivotTableUI";
    }

    public void setEnabled(boolean bl) {
        super.setEnabled(bl);
        this.getPivotGrid().setEnabled(bl);
        this.getRowPivotHeader().setEnabled(bl);
        this.getColumnPivotHeader().setEnabled(bl);
        this.getCornerComponent().setEnabled(bl);
    }

    public void requestFocus() {
        this.getPivotGrid().requestFocus();
    }

    public void updateUI() {
        this.setUI((EWTPivotTableUI)UIManager.getUI(this));
        if (this._scrollPane != null) {
            this.getPivotGrid().updateUI();
        }
    }

    public void printPage(PaintContext paintContext, Dictionary dictionary, Graphics graphics) {
        Font font;
        Color color;
        Graphics graphics2;
        Boolean bl;
        boolean bl2;
        boolean bl3;
        boolean bl4;
        boolean bl5;
        int n;
        int n2;
        Shape shape = graphics.getClip();
        Rectangle rectangle = graphics.getClipRect();
        boolean bl6 = PrinterUtils.getPrinterProperty(dictionary, PRINT_CORNER_COMPONENT, false);
        boolean bl7 = rectangle.y == 0 || PrinterUtils.getPrinterProperty(dictionary, DUPLICATE_COLUMN_PIVOT_HEADER, true);
        boolean bl8 = rectangle.x == 0 || PrinterUtils.getPrinterProperty(dictionary, DUPLICATE_ROW_PIVOT_HEADER, true);
        PivotHeader pivotHeader = bl7 && this.isColumnPivotHeaderVisible() ? this.getColumnPivotHeader() : null;
        PivotHeader pivotHeader2 = bl8 && this.isRowPivotHeaderVisible() ? this.getRowPivotHeader() : null;
        int n3 = pivotHeader2 != null ? pivotHeader2.getSize().width : 0;
        int n4 = n2 = pivotHeader != null ? pivotHeader.getSize().height : 0;
        if (n2 >= rectangle.height) {
            n = rectangle.height / 8;
            n2 = rectangle.height - n;
        }
        if (n3 >= rectangle.width) {
            n = rectangle.width / 8;
            n3 = rectangle.width - n;
        }
        n = this.getDrawRaised() ? 1 : 0;
        boolean bl9 = PrinterUtils.getPrinterProperty(dictionary, PRINT_RAISED, false);
        this.freezeRepaints();
        this.setDrawRaised(bl9);
        rectangle.width -= n3;
        rectangle.height -= n2;
        if (pivotHeader != null) {
            bl5 = pivotHeader.getKeepHeaderCellsVisible();
            bl4 = PrinterUtils.getPrinterProperty(dictionary, DUPLICATE_COLUMN_HEADER_DATA, true);
            bl3 = PrinterUtils.getPrinterProperty(dictionary, DISPLAY_COLUMN_DRILL_IMAGES, false);
            bl2 = PrinterUtils.getPrinterProperty(dictionary, DISPLAY_ROW_SELECTORS, false);
            bl = !bl2 && (pivotHeader2 == null || !bl6) && !bl9 ? Boolean.TRUE : Boolean.FALSE;
            dictionary.put(Grid.DISPLAY_VERTICAL_SEPARATOR, bl);
            bl = !bl9 ? Boolean.TRUE : Boolean.FALSE;
            dictionary.put(Grid.DISPLAY_HORIZONTAL_SEPARATOR, bl);
            pivotHeader.freezeRepaints();
            pivotHeader.setKeepHeaderCellsVisible(bl4);
            pivotHeader.setDrillImagesDisplayed(bl3);
            graphics2 = graphics;
            color = graphics2.getColor();
            font = graphics2.getFont();
            graphics2.translate(n3, rectangle.y);
            graphics2.setClip(rectangle.x, 0, rectangle.width, n2);
            graphics2.setFont(pivotHeader.getFont());
            graphics2.setColor(pivotHeader.getForeground());
            pivotHeader.printPage(paintContext, dictionary, graphics2);
            pivotHeader.setKeepHeaderCellsVisible(bl5);
            pivotHeader.setDrillImagesDisplayed(true);
            graphics2.translate(-n3, -rectangle.y);
            graphics2.setClip(shape);
            graphics2.setColor(color);
            graphics2.setFont(font);
            dictionary.remove(Grid.DISPLAY_VERTICAL_SEPARATOR);
            dictionary.remove(Grid.DISPLAY_HORIZONTAL_SEPARATOR);
            pivotHeader.unfreezeRepaints();
        }
        if (pivotHeader2 != null) {
            bl5 = pivotHeader2.getKeepHeaderCellsVisible();
            bl4 = PrinterUtils.getPrinterProperty(dictionary, DUPLICATE_ROW_HEADER_DATA, true);
            bl3 = PrinterUtils.getPrinterProperty(dictionary, DISPLAY_ROW_DRILL_IMAGES, false);
            bl2 = PrinterUtils.getPrinterProperty(dictionary, DISPLAY_COLUMN_SELECTORS, false);
            bl = !bl2 && (pivotHeader == null || !bl6) && !bl9 ? Boolean.TRUE : Boolean.FALSE;
            dictionary.put(Grid.DISPLAY_HORIZONTAL_SEPARATOR, bl);
            bl = !bl9 ? Boolean.TRUE : Boolean.FALSE;
            dictionary.put(Grid.DISPLAY_VERTICAL_SEPARATOR, bl);
            pivotHeader2.freezeRepaints();
            pivotHeader2.setDrillImagesDisplayed(bl3);
            pivotHeader2.setKeepHeaderCellsVisible(bl4);
            graphics2 = graphics;
            color = graphics2.getColor();
            font = graphics2.getFont();
            graphics2.translate(rectangle.x, n2);
            graphics2.setClip(0, rectangle.y, n3, rectangle.height);
            graphics2.setFont(pivotHeader2.getFont());
            graphics2.setColor(pivotHeader2.getForeground());
            pivotHeader2.printPage(paintContext, dictionary, graphics2);
            pivotHeader2.setKeepHeaderCellsVisible(bl5);
            pivotHeader2.setDrillImagesDisplayed(true);
            graphics2.translate(-rectangle.x, -n2);
            graphics2.setClip(shape);
            graphics2.setFont(font);
            graphics2.setColor(color);
            dictionary.remove(Grid.DISPLAY_HORIZONTAL_SEPARATOR);
            dictionary.remove(Grid.DISPLAY_VERTICAL_SEPARATOR);
            pivotHeader2.unfreezeRepaints();
        }
        Boolean bl10 = !(bl5 = PrinterUtils.getPrinterProperty(dictionary, DISPLAY_ROW_SELECTORS, false)) && pivotHeader2 == null ? Boolean.TRUE : Boolean.FALSE;
        dictionary.put(Grid.DISPLAY_VERTICAL_SEPARATOR, bl10);
        bl5 = PrinterUtils.getPrinterProperty(dictionary, DISPLAY_COLUMN_SELECTORS, false);
        bl10 = !bl5 && pivotHeader == null ? Boolean.TRUE : Boolean.FALSE;
        dictionary.put(Grid.DISPLAY_HORIZONTAL_SEPARATOR, bl10);
        PivotGrid pivotGrid = this.getPivotGrid();
        graphics.translate(n3, n2);
        graphics.setClip(rectangle);
        graphics.setFont(pivotGrid.getFont());
        graphics.setColor(pivotGrid.getForeground());
        pivotGrid.printPage(paintContext, dictionary, graphics);
        graphics.translate(-n3, -n2);
        if (bl6) {
            graphics.translate(rectangle.x, rectangle.y);
            graphics.setClip(0, 0, n3, n2);
            this.getCornerComponent().paint(graphics);
            graphics.translate(-rectangle.x, -rectangle.y);
        }
        graphics.setClip(shape);
        this.setDrawRaised(n != 0);
        dictionary.remove(Grid.DISPLAY_HORIZONTAL_SEPARATOR);
        dictionary.remove(Grid.DISPLAY_VERTICAL_SEPARATOR);
        this.unfreezeRepaints();
    }

    public Dimension getDocumentSize(PaintContext paintContext, Dictionary dictionary) {
        Dimension dimension = this.getPivotGrid().getDocumentSize(paintContext, dictionary);
        return dimension;
    }

    public Rectangle getPageBounds(PaintContext paintContext, Dictionary dictionary, int n, int n2, int n3, int n4) {
        int n5;
        int n6;
        boolean bl = n2 == 0 || PrinterUtils.getPrinterProperty(dictionary, DUPLICATE_COLUMN_PIVOT_HEADER, true);
        boolean bl2 = n == 0 || PrinterUtils.getPrinterProperty(dictionary, DUPLICATE_ROW_PIVOT_HEADER, true);
        int n7 = n6 = bl && this.isColumnPivotHeaderVisible() ? this.getColumnPivotHeader().getSize().height : 0;
        if (n6 < n4) {
            n4 -= n6;
        } else {
            n5 = n4 / 8;
            n6 = n4 - n5;
            n4 = n5;
        }
        int n8 = n5 = bl2 && this.isRowPivotHeaderVisible() ? this.getRowPivotHeader().getSize().width : 0;
        if (n5 < n3) {
            n3 -= n5;
        } else {
            int n9 = n3 / 8;
            n5 = n3 - n9;
            n3 = n9;
        }
        Rectangle rectangle = this.getPivotGrid().getPageBounds(paintContext, dictionary, n, n2, n3, n4);
        rectangle.width += n5;
        rectangle.height += n6;
        return rectangle;
    }

    public boolean isHScrollable() {
        return true;
    }

    public boolean isVScrollable() {
        return true;
    }

    public boolean getScrollableTracksViewportWidth() {
        return this.getPivotGrid().getGrid().getScrollableTracksViewportWidth();
    }

    public boolean getScrollableTracksViewportHeight() {
        return this.getPivotGrid().getGrid().getScrollableTracksViewportHeight();
    }

    public Dimension getPreferredScrollableViewportSize() {
        return this.getPivotGrid().getGrid().getPreferredScrollableViewportSize();
    }

    public Dimension getPreferredSize() {
        Dimension dimension = this._pivotGrid.getPreferredSize();
        if (this._scrollPane != null) {
            return dimension;
        }
        if (this.isColumnPivotHeaderVisible()) {
            dimension.height += this._columnPivotHeader.getPreferredSize().height;
        }
        if (this.isRowPivotHeaderVisible()) {
            dimension.width += this._rowPivotHeader.getPreferredSize().width;
        }
        return this.convertInnerToOuterSize(dimension.width, dimension.height);
    }

    public Dimension getMinimumSize() {
        Dimension dimension = this._pivotGrid.getMinimumSize();
        if (this.isColumnPivotHeaderVisible()) {
            dimension.height += this._columnPivotHeader.getMinimumSize().height;
        }
        if (this.isRowPivotHeaderVisible()) {
            dimension.width += this._rowPivotHeader.getMinimumSize().width;
        }
        return this.convertInnerToOuterSize(dimension.width, dimension.height);
    }

    public void addNotify() {
        super.addNotify();
        if (!this._configureScrollPane()) {
            this.remove(this._pivotGrid);
            super.setLayout(new _LayoutMgr());
            this.add(this._pivotGrid);
            this.add(this._rowPivotHeader);
            this.add(this._columnPivotHeader);
            this.add(this.getCornerComponent());
        }
        int n = this._pivotGrid.getDefaultColumnWidth();
        int n2 = this._pivotGrid.getDefaultRowHeight();
        this._columnPivotHeader.setDefaultColumnWidth(n + this._getVerticalSize());
        this._rowPivotHeader.setDefaultRowHeight(n2 + this._getHorizontalSize());
        int n3 = this.getRowSelectorHeight();
        n3 = this.getColumnSelectorWidth();
        this._pivotGridDropAdapter = new PivotGridDropAdapter(this._pivotGrid);
        this._updateScrollpaneLayout();
    }

    public void removeNotify() {
        super.removeNotify();
        this._disposeScrollpane();
    }

    public Object getPaintData(Object object) {
        Object object2 = null;
        object2 = EWTPivotTableUI.HORIZONTAL_KEY.equals(object) ? (this.getRowModel().getColumnCount() != 0 ? Boolean.TRUE : Boolean.FALSE) : (EWTPivotTableUI.VERTICAL_KEY.equals(object) ? (this.getColumnModel().getRowCount() != 0 ? Boolean.TRUE : Boolean.FALSE) : (KEY_DRAW_RAISED.equals(object) ? (this.getDrawRaised() ? Boolean.TRUE : Boolean.FALSE) : (EWTTableUI.KEY_DRAW_RAISED.equals(object) ? (this.getPivotGrid().getDrawRaised() ? Boolean.TRUE : Boolean.FALSE) : super.getPaintData(object))));
        return object2;
    }

    public void setCanvasSize(int n, int n2) {
        super.setCanvasSize(n, n2);
        this.invalidateParent();
    }

    protected final EWTPivotTableUI getPivotTableUI() {
        return (EWTPivotTableUI)this.ui;
    }

    protected void paintOverChildren(Graphics graphics) {
        if (this._resizeHeader != null) {
            PivotHeader pivotHeader = this._resizeHeader;
            Color color = graphics.getColor();
            int n = pivotHeader.getHeaderResizeItem();
            Header header = pivotHeader.getHeader();
            UIDefaults uIDefaults = this.getUIDefaults();
            graphics.setColor(uIDefaults.getColor(LookAndFeel.CONTROL_TEXT));
            if (pivotHeader.getOrientation() == 0) {
                int n2 = header.getItemPosition(n) + header.getItemSize(n);
                if (this._scrollPane != null) {
                    n2 -= pivotHeader.getHeight() + this.getPivotGrid().getColumnHeader().getHeight();
                }
                graphics.fillRect(this.getInnerOrigin().x, n2, this.getInnerWidth(), 3);
            } else {
                int n3 = header.getItemPosition(n) + header.getItemSize(n);
                if (this._scrollPane != null) {
                    n3 -= pivotHeader.getWidth() + this.getPivotGrid().getRowHeader().getWidth();
                }
                graphics.fillRect(n3, this.getInnerOrigin().y, 3, this.getInnerHeight());
            }
            graphics.setColor(color);
        }
    }

    protected void validateTree() {
        this.freezeRepaints();
        try {
            super.validateTree();
            Object var2_1 = null;
            this.unfreezeRepaints();
        }
        catch (Throwable throwable) {
            Object var2_2 = null;
            this.unfreezeRepaints();
            throw throwable;
        }
    }

    protected int getHMaximum() {
        return this.getPivotGrid().getGrid().getHMaximum();
    }

    protected int getHValueOfOffset(int n) {
        return this.getPivotGrid().getGrid().getHValueOfOffset(n);
    }

    protected int getHOffsetOfValue(int n) {
        return this.getPivotGrid().getGrid().getHOffsetOfValue(n);
    }

    protected int getVMaximum() {
        return this.getPivotGrid().getGrid().getVMaximum();
    }

    protected int getVValueOfOffset(int n) {
        return this.getPivotGrid().getGrid().getVValueOfOffset(n);
    }

    protected int getVOffsetOfValue(int n) {
        return this.getPivotGrid().getGrid().getVOffsetOfValue(n);
    }

    protected Dimension layoutCanvas() {
        return this.getPivotGrid().getGrid().layoutCanvas();
    }

    public void setCanvasOrigin(int n, int n2) {
        super.setCanvasOrigin(n, n2);
        this.getPivotGrid().getGrid().setCanvasOrigin(n, n2);
    }

    protected void processEventImpl(AWTEvent aWTEvent) {
        if (aWTEvent instanceof PivotEvent) {
            this.processPivotEvent((PivotEvent)aWTEvent);
        } else if (aWTEvent instanceof DrillEvent) {
            this.processDrillEvent((DrillEvent)aWTEvent);
        } else if (aWTEvent instanceof CollapseEvent) {
            this.processCollapseEvent((CollapseEvent)aWTEvent);
        } else if (aWTEvent instanceof PivotHeaderEvent) {
            switch (aWTEvent.getID()) {
                case 2013: 
                case 2014: 
                case 2015: 
                case 2016: {
                    this.processPivotHeaderResizeEvent((PivotHeaderEvent)aWTEvent);
                }
            }
        } else if (aWTEvent instanceof TableEvent) {
            switch (aWTEvent.getID()) {
                case 2005: 
                case 2006: {
                    this.processEditEvent((TableEvent)aWTEvent);
                    break;
                }
                case 2001: 
                case 2002: 
                case 2003: 
                case 2004: {
                    this.processResizeEvent((TableEvent)aWTEvent);
                }
            }
        } else {
            super.processEventImpl(aWTEvent);
        }
    }

    protected void processEditEvent(TableEvent tableEvent) {
        if (this._editListeners == null) {
            return;
        }
        Enumeration enumeration = this._editListeners.getListeners();
        if (enumeration == null) {
            return;
        }
        switch (tableEvent.getID()) {
            case 2005: {
                while (enumeration.hasMoreElements()) {
                    ((TableEditListener)enumeration.nextElement()).cellEditing(tableEvent);
                }
                break;
            }
            case 2006: {
                while (enumeration.hasMoreElements()) {
                    ((TableEditListener)enumeration.nextElement()).cellEdited(tableEvent);
                }
                break;
            }
        }
    }

    protected void processResizeEvent(TableEvent tableEvent) {
        Object object;
        int n = tableEvent.getID();
        if (n == 2002 || n == 2004) {
            object = this.layoutCanvas();
            this.setCanvasSize(((Dimension)object).width, ((Dimension)object).height);
            this._updateScrollpane();
        }
        if (this._resizeListeners == null) {
            return;
        }
        object = this._resizeListeners.getListeners();
        if (object == null) {
            return;
        }
        switch (n) {
            case 2001: {
                while (object.hasMoreElements()) {
                    ((TableResizeListener)object.nextElement()).columnResizing(tableEvent);
                }
                break;
            }
            case 2002: {
                while (object.hasMoreElements()) {
                    ((TableResizeListener)object.nextElement()).columnResized(tableEvent);
                }
                break;
            }
            case 2003: {
                while (object.hasMoreElements()) {
                    ((TableResizeListener)object.nextElement()).rowResizing(tableEvent);
                }
                break;
            }
            case 2004: {
                while (object.hasMoreElements()) {
                    ((TableResizeListener)object.nextElement()).rowResized(tableEvent);
                }
                break;
            }
        }
    }

    protected void processPivotEvent(PivotEvent pivotEvent) {
        if (this._pivotListeners == null) {
            return;
        }
        Enumeration enumeration = this._pivotListeners.getListeners();
        if (enumeration == null) {
            return;
        }
        switch (pivotEvent.getID()) {
            case 2001: {
                while (enumeration.hasMoreElements()) {
                    try {
                        ((PivotListener)enumeration.nextElement()).pivot(pivotEvent);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                break;
            }
            case 2002: {
                while (enumeration.hasMoreElements()) {
                    try {
                        ((PivotListener)enumeration.nextElement()).swap(pivotEvent);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                break;
            }
        }
    }

    protected void processDrillEvent(DrillEvent drillEvent) {
        if (this._drillListeners == null) {
            return;
        }
        Enumeration enumeration = this._drillListeners.getListeners();
        if (enumeration == null) {
            return;
        }
        switch (drillEvent.getID()) {
            case 2001: {
                while (enumeration.hasMoreElements()) {
                    ((DrillListener)enumeration.nextElement()).headerCellDrillRequest(drillEvent);
                }
                break;
            }
            case 2002: {
                while (enumeration.hasMoreElements()) {
                    ((DrillListener)enumeration.nextElement()).headerCellDrill(drillEvent);
                }
                break;
            }
        }
    }

    protected void processCollapseEvent(CollapseEvent collapseEvent) {
        if (this._collapseListeners == null) {
            return;
        }
        Enumeration enumeration = this._collapseListeners.getListeners();
        if (enumeration == null) {
            return;
        }
        switch (collapseEvent.getID()) {
            case 2001: {
                while (enumeration.hasMoreElements()) {
                    ((CollapseListener)enumeration.nextElement()).collapse(collapseEvent);
                }
                break;
            }
        }
    }

    protected void processPivotHeaderResizeEvent(PivotHeaderEvent pivotHeaderEvent) {
        int n = pivotHeaderEvent.getID();
        if (n == 2014 || n == 2016) {
            this.invalidateCanvas();
            this.invalidateParent();
        }
        if (this._pivotHeaderResListeners == null) {
            return;
        }
        Enumeration enumeration = this._pivotHeaderResListeners.getListeners();
        if (enumeration == null) {
            return;
        }
        switch (n) {
            case 2013: {
                while (enumeration.hasMoreElements()) {
                    ((PivotHeaderResListener)enumeration.nextElement()).headerColumnResizing(pivotHeaderEvent);
                }
                break;
            }
            case 2014: {
                while (enumeration.hasMoreElements()) {
                    ((PivotHeaderResListener)enumeration.nextElement()).headerColumnResized(pivotHeaderEvent);
                }
                break;
            }
            case 2015: {
                while (enumeration.hasMoreElements()) {
                    ((PivotHeaderResListener)enumeration.nextElement()).headerRowResizing(pivotHeaderEvent);
                }
                break;
            }
            case 2016: {
                while (enumeration.hasMoreElements()) {
                    ((PivotHeaderResListener)enumeration.nextElement()).headerRowResized(pivotHeaderEvent);
                }
                break;
            }
        }
    }

    final void checkHeaderSize(PivotHeader pivotHeader, Dimension dimension) {
        Dimension dimension2 = this.getCornerComponent().getPreferredSize();
        if (pivotHeader.getOrientation() == 0) {
            if (dimension2.height > dimension.height) {
                dimension.height = dimension2.height;
            }
        } else if (dimension2.width > dimension.width) {
            dimension.width = dimension2.width;
        }
    }

    final void repaintParent() {
        if (this._scrollPane == null) {
            this.repaint();
        } else {
            this._scrollPane.repaint();
        }
    }

    final void paintParent() {
        if (this._scrollPane == null) {
            this.paintImmediateInterior();
        } else {
            JViewport jViewport = this._scrollPane.getColumnHeader();
            if (jViewport != null) {
                jViewport.paintImmediately(0, 0, jViewport.getWidth(), jViewport.getHeight());
            }
            if ((jViewport = this._scrollPane.getRowHeader()) != null) {
                jViewport.paintImmediately(0, 0, jViewport.getWidth(), jViewport.getHeight());
            }
            if ((jViewport = this._scrollPane.getViewport()) != null) {
                jViewport.paintImmediately(0, 0, jViewport.getWidth(), jViewport.getHeight());
            }
        }
    }

    final void deselectAll() throws PropertyVetoException {
        this.getColumnPivotHeader().getGrid().deselectAll();
        this.getColumnPivotHeader().getRowHeader().deselectAll();
        this.getRowPivotHeader().getGrid().deselectAll();
        this.getRowPivotHeader().getColumnHeader().deselectAll();
        this.getPivotGrid().getGrid().deselectAll();
        this.getPivotGrid().getColumnHeader().deselectAll();
        this.getPivotGrid().getRowHeader().deselectAll();
    }

    final void postEvent(AWTEvent aWTEvent) {
        this.processEvent(aWTEvent);
    }

    final void tryDefaultColumns() {
        if (this._needToDefaultColumns) {
            TwoDModel twoDModel = this.getGridModel();
            int n = twoDModel.getColumnCount();
            this.freezeRepaints();
            try {
                int n2 = 0;
                while (n2 < n) {
                    this._pivotGrid.setColumnWidth(n2, -1);
                    this._columnPivotHeader.setColumnWidth(n2, -1);
                    ++n2;
                }
                Object var5_4 = null;
                this.unfreezeRepaints();
            }
            catch (Throwable throwable) {
                Object var5_5 = null;
                this.unfreezeRepaints();
                throw throwable;
            }
        }
        this._needToDefaultColumns = false;
    }

    final void tryDefaultRows() {
        if (this._needToDefaultRows) {
            TwoDModel twoDModel = this.getGridModel();
            int n = twoDModel.getRowCount();
            this.freezeRepaints();
            try {
                int n2 = 0;
                while (n2 < n) {
                    this._pivotGrid.setRowHeight(n2, -1);
                    this._rowPivotHeader.setRowHeight(n2, -1);
                    ++n2;
                }
                Object var5_4 = null;
                this.unfreezeRepaints();
            }
            catch (Throwable throwable) {
                Object var5_5 = null;
                this.unfreezeRepaints();
                throw throwable;
            }
        }
        this._needToDefaultRows = false;
    }

    final void invalidateParent() {
        if (this._scrollPane != null) {
            Component component;
            JViewport jViewport = this._scrollPane.getColumnHeader();
            if (jViewport != null) {
                jViewport.invalidate();
                jViewport.getView().invalidate();
            }
            if ((jViewport = this._scrollPane.getRowHeader()) != null) {
                jViewport.invalidate();
                jViewport.getView().invalidate();
            }
            if ((jViewport = this._scrollPane.getViewport()) != null) {
                jViewport.invalidate();
                jViewport.getView().invalidate();
            }
            if ((component = this._scrollPane.getCorner("UPPER_LEFT_CORNER")) != null) {
                component.invalidate();
            }
            this._scrollPane.revalidate();
        } else {
            Container container = this.getParent();
            if (container != null && container instanceof JComponent) {
                ((JComponent)container).revalidate();
            }
        }
    }

    final void setResizeHeader(PivotHeader pivotHeader) {
        this._resizeHeader = pivotHeader;
        if (this._scrollPane != null) {
            ((PivotScrollPaneView)this._scrollPane.getColumnHeader().getView()).setResizeHeader(pivotHeader);
            ((PivotScrollPaneView)this._scrollPane.getRowHeader().getView()).setResizeHeader(pivotHeader);
        }
        this.repaint();
    }

    final void matchGridWithHeader(boolean bl) {
        JViewport jViewport = this._scrollPane.getViewport();
        Point point = jViewport.getViewPosition();
        if (bl) {
            point.x = this._scrollPane.getColumnHeader().getViewPosition().x;
        } else {
            point.y = this._scrollPane.getRowHeader().getViewPosition().y;
        }
        jViewport.setViewPosition(point);
    }

    final boolean inScrollPane() {
        return this._scrollPane != null;
    }

    void __updateVerticalSizes() {
        int n = this._getVerticalSize();
        int n2 = this._pivotGrid.getDefaultColumnWidth();
        int n3 = n2 + n;
        this._columnPivotHeader.setDefaultColumnWidth(n3);
        if (this._columnWidthChanged) {
            int n4 = this._pivotGrid.getGrid().getColumnCount();
            int n5 = 0;
            while (n5 < n4) {
                int n6 = this._pivotGrid.getColumnWidth(n5);
                if (n6 != n2) {
                    this._columnPivotHeader.setColumnWidth(n5, n6 + n);
                }
                ++n5;
            }
        }
    }

    void __updateHorizontalSizes() {
        int n = this._getHorizontalSize();
        int n2 = this._pivotGrid.getDefaultRowHeight();
        int n3 = n + n2;
        this._rowPivotHeader.setDefaultRowHeight(n3);
        if (this._rowHeightChanged) {
            int n4 = this._pivotGrid.getGrid().getRowCount();
            int n5 = 0;
            while (n5 < n4) {
                int n6 = this._pivotGrid.getRowHeight(n5);
                if (n6 != n2) {
                    this._rowPivotHeader.setRowHeight(n5, n6 + n);
                }
                ++n5;
            }
        }
    }

    private boolean _configureScrollPane() {
        JScrollPane jScrollPane;
        JViewport jViewport;
        Container container;
        JScrollPane jScrollPane2 = null;
        Container container2 = this.getParent();
        if (container2 instanceof JViewport && (container = container2.getParent()) instanceof JScrollPane && (jViewport = (jScrollPane = (JScrollPane)container).getViewport()) != null && jViewport.getView() == this) {
            this.setBorder(null);
            jScrollPane2 = jScrollPane;
            this.remove(this._pivotGrid);
            this.remove(this._rowPivotHeader);
            this.remove(this._columnPivotHeader);
            this.remove(this.getCornerComponent());
            super.setLayout(new BorderLayout());
            this.add("Center", this._pivotGrid);
            this._pivotGrid.setLayout(new BorderLayout());
            this._pivotGrid.add("Center", this._pivotGrid.getGrid());
            javax.swing.LookAndFeel.installBorder(jScrollPane2, "EWTPivotTable.scrollPaneBorder");
        }
        this._scrollPane = jScrollPane2;
        return jScrollPane2 != null;
    }

    private void _addChangeListeners() {
        JViewport jViewport = this._scrollPane.getColumnHeader();
        if (jViewport != null) {
            if (this._hListener == null) {
                this._hListener = new HListen();
            }
            jViewport.addChangeListener(this._hListener);
        }
        if ((jViewport = this._scrollPane.getRowHeader()) != null) {
            if (this._vListener == null) {
                this._vListener = new VListen();
            }
            jViewport.addChangeListener(this._vListener);
        }
    }

    private void _removeChangeListeners() {
        JViewport jViewport;
        if (this._hListener != null && (jViewport = this._scrollPane.getColumnHeader()) != null) {
            jViewport.removeChangeListener(this._hListener);
        }
        if (this._vListener != null && (jViewport = this._scrollPane.getRowHeader()) != null) {
            jViewport.removeChangeListener(this._vListener);
        }
    }

    private void _updateScrollpane() {
        if (this._scrollPane != null) {
            this._scrollPane.revalidate();
        }
    }

    private void _disposeScrollpane() {
        Component component;
        if (this._scrollPane == null) {
            return;
        }
        this._removeChangeListeners();
        if (this._containerListener != null) {
            this._scrollPane.getViewport().removeContainerListener(this._containerListener);
        }
        this._containerListener = null;
        Component component2 = this._scrollPane.getColumnHeader().getView();
        if (component2 instanceof PivotScrollPaneView) {
            ((PivotScrollPaneView)component2).dispose();
            this._scrollPane.setColumnHeaderView(null);
        }
        if ((component2 = this._scrollPane.getRowHeader().getView()) instanceof PivotScrollPaneView) {
            ((PivotScrollPaneView)component2).dispose();
            this._scrollPane.setRowHeaderView(null);
        }
        if ((component = this._scrollPane.getCorner("UPPER_LEFT_CORNER")) instanceof CornerPanel) {
            ((CornerPanel)component).dispose();
        }
        this._scrollPane.setCorner("UPPER_LEFT_CORNER", new DummyPanel());
        this._scrollPane.setCorner("UPPER_RIGHT_CORNER", new DummyPanel());
        this._scrollPane.setCorner("LOWER_LEFT_CORNER", new DummyPanel());
        javax.swing.LookAndFeel.uninstallBorder(this._scrollPane);
        this._vListener = null;
        this._hListener = null;
        this._scrollPane = null;
    }

    private void _updateScrollpaneLayout() {
        if (this._scrollPane != null) {
            Component component;
            if (this._containerListener != null) {
                this._scrollPane.getViewport().removeContainerListener(this._containerListener);
            }
            this._removeChangeListeners();
            this._scrollPane.setViewportBorder(null);
            if (this._scrollPane.getColumnHeader() == null || this._scrollPane.getColumnHeader().getView() == null) {
                component = new PivotScrollPaneView(this);
                this._scrollPane.setColumnHeaderView(component);
            } else {
                component = this._scrollPane.getColumnHeader().getView();
                if (component instanceof PivotScrollPaneView) {
                    ((PivotScrollPaneView)component).updateLayout();
                }
            }
            if (this._scrollPane.getRowHeader() == null || this._scrollPane.getRowHeader().getView() == null) {
                component = new PivotScrollPaneView(this, 1);
                this._scrollPane.setRowHeaderView(component);
            } else {
                component = this._scrollPane.getRowHeader().getView();
                if (component instanceof PivotScrollPaneView) {
                    ((PivotScrollPaneView)component).updateLayout();
                }
            }
            boolean bl = false;
            String string = "UPPER_LEFT_CORNER";
            if (this._scrollPane.getCorner(string) == null || this._scrollPane.getCorner(string) instanceof DummyPanel) {
                this._scrollPane.setCorner(string, new CornerPanel());
                bl = true;
            } else {
                Component component2 = this._scrollPane.getCorner(string);
                if (component2 instanceof CornerPanel) {
                    ((CornerPanel)component2).updateLayout();
                }
            }
            string = "UPPER_RIGHT_CORNER";
            if (this._scrollPane.getCorner(string) == null || this._scrollPane.getCorner(string) instanceof DummyPanel) {
                this._scrollPane.setCorner(string, new Corner(1));
                bl = true;
            }
            if (this._scrollPane.getCorner(string = "LOWER_LEFT_CORNER") == null || this._scrollPane.getCorner(string) instanceof DummyPanel) {
                this._scrollPane.setCorner(string, new Corner(0));
                bl = true;
            }
            this._addChangeListeners();
            if (bl) {
                if (this._containerListener == null) {
                    this._containerListener = new PTContainerListener();
                }
                this._scrollPane.getViewport().addContainerListener(this._containerListener);
            }
            this.setBorder(null);
            this.getPivotGrid().setBorder(null);
            this._scrollPane.revalidate();
        }
    }

    private int _getHorizontalSize() {
        Grid grid = this._pivotGrid.getGrid();
        PaintContext paintContext = this.getPaintContext();
        Painter painter = grid.getHorizontalSeparatorPainter();
        return grid.getHorizontalSeparatorsVisible() ? painter.getPreferredSize((PaintContext)paintContext).height : 0;
    }

    private int _getVerticalSize() {
        Grid grid = this._pivotGrid.getGrid();
        PaintContext paintContext = this.getPaintContext();
        Painter painter = grid.getVerticalSeparatorPainter();
        return grid.getVerticalSeparatorsVisible() ? painter.getPreferredSize((PaintContext)paintContext).width : 0;
    }

    String __getAccessibleString(String string) {
        Locale locale = LocaleUtils.getDefaultableLocale(this);
        ResourceBundle resourceBundle = ResourceBundle.getBundle(_RESOURCE_BUNDLE, locale);
        return resourceBundle.getString(string);
    }

    protected class AccessiblePivotTable
    extends JComponent.AccessibleJComponent {
        public AccessiblePivotTable() {
            super(PivotTable.this);
            ResourceBundle resourceBundle = ResourceBundle.getBundle(PivotTable._RESOURCE_BUNDLE, ((Component.AccessibleAWTComponent)this).getLocale());
            AccessibleContext accessibleContext = PivotTable.this.getColumnPivotHeader().getAccessibleContext();
            String string = resourceBundle.getString("COLUMN_PIVOT_HEADER");
            accessibleContext.setAccessibleName(string);
            accessibleContext.setAccessibleParent(PivotTable.this);
            accessibleContext = PivotTable.this.getColumnPivotHeader().getRowHeader().getAccessibleContext();
            string = resourceBundle.getString("COLUMN_PIVOT_HEADER.HEADER");
            accessibleContext.setAccessibleName(string);
            accessibleContext = PivotTable.this.getColumnPivotHeader().getGrid().getAccessibleContext();
            string = resourceBundle.getString("COLUMN_PIVOT_HEADER.GRID");
            accessibleContext.setAccessibleName(string);
            accessibleContext = PivotTable.this.getRowPivotHeader().getColumnHeader().getAccessibleContext();
            string = resourceBundle.getString("ROW_PIVOT_HEADER.HEADER");
            accessibleContext.setAccessibleName(string);
            accessibleContext = PivotTable.this.getRowPivotHeader().getAccessibleContext();
            string = resourceBundle.getString("ROW_PIVOT_HEADER");
            accessibleContext.setAccessibleName(string);
            accessibleContext.setAccessibleParent(PivotTable.this);
            accessibleContext = PivotTable.this.getRowPivotHeader().getGrid().getAccessibleContext();
            string = resourceBundle.getString("ROW_PIVOT_HEADER.GRID");
            accessibleContext.setAccessibleName(string);
            accessibleContext = PivotTable.this.getPivotGrid().getAccessibleContext();
            string = resourceBundle.getString("PIVOT_GRID");
            accessibleContext.setAccessibleName(string);
            accessibleContext.setAccessibleParent(PivotTable.this);
            accessibleContext = PivotTable.this.getPivotGrid().getColumnHeader().getAccessibleContext();
            string = resourceBundle.getString("PIVOT_GRID.COLUMN_HEADER");
            accessibleContext.setAccessibleName(string);
            accessibleContext = PivotTable.this.getPivotGrid().getRowHeader().getAccessibleContext();
            string = resourceBundle.getString("PIVOT_GRID.ROW_HEADER");
            accessibleContext.setAccessibleName(string);
            accessibleContext = PivotTable.this.getPivotGrid().getGrid().getAccessibleContext();
            string = resourceBundle.getString("PIVOT_GRID.GRID");
            accessibleContext.setAccessibleName(string);
            Component component = PivotTable.this.getCornerComponent();
            if (component instanceof Accessible) {
                ((Accessible)((Object)component)).getAccessibleContext().setAccessibleParent(PivotTable.this);
            }
        }

        public AccessibleRole getAccessibleRole() {
            return AccessibleRole.TABLE;
        }

        public int getAccessibleChildrenCount() {
            return PivotTable.this.getCornerComponent() instanceof Accessible ? 4 : 3;
        }

        public Accessible getAccessibleChild(int n) {
            if (n >= this.getAccessibleChildrenCount()) {
                return null;
            }
            switch (n) {
                case 0: {
                    return PivotTable.this.getPivotGrid();
                }
                case 1: {
                    return PivotTable.this.getColumnPivotHeader();
                }
                case 2: {
                    return PivotTable.this.getRowPivotHeader();
                }
                case 3: {
                    Component component = PivotTable.this.getCornerComponent();
                    if (!(component instanceof Accessible)) break;
                    return (Accessible)((Object)component);
                }
            }
            return null;
        }
    }

    private class PTContainerListener
    implements ContainerListener {
        private PTContainerListener() {
        }

        public void componentAdded(ContainerEvent containerEvent) {
        }

        public void componentRemoved(ContainerEvent containerEvent) {
            Container container = containerEvent.getContainer();
            if (PivotTable.this._scrollPane != null && container == PivotTable.this._scrollPane.getViewport() && containerEvent.getChild() == PivotTable.this) {
                container.removeContainerListener(this);
                PivotTable.this._scrollPane.setCorner("UPPER_LEFT_CORNER", new JPanel());
                PivotTable.this._scrollPane.setCorner("UPPER_RIGHT_CORNER", new JPanel());
                PivotTable.this._scrollPane.setCorner("LOWER_LEFT_CORNER", new JPanel());
            }
        }
    }

    private class VListen
    implements ChangeListener {
        private VListen() {
        }

        public void stateChanged(ChangeEvent changeEvent) {
            PivotTable.this.matchGridWithHeader(false);
        }
    }

    private class HListen
    implements ChangeListener {
        private HListen() {
        }

        public void stateChanged(ChangeEvent changeEvent) {
            PivotTable.this.matchGridWithHeader(true);
        }
    }

    private class CornerPanel
    extends LWComponent
    implements Accessible {
        private Component _bottomCorner;

        public CornerPanel() {
            this.setLayout(null);
        }

        public void dispose() {
            this.removeAll();
            this._bottomCorner = null;
        }

        public void addNotify() {
            super.addNotify();
            this.updateLayout();
        }

        public Dimension getPreferredSize() {
            int n = PivotTable.this.getRowPivotHeader().getColumnHeader().getPreferredSize().width;
            int n2 = PivotTable.this.getColumnPivotHeader().getRowHeader().getPreferredSize().height;
            return new Dimension(n, n2);
        }

        public void updateLayout() {
            this.removeAll();
            this.add(PivotTable.this.getCornerComponent());
            this.add(PivotTable.this.getRowPivotHeader().getColumnHeader());
            this.add(PivotTable.this.getColumnPivotHeader().getRowHeader());
            this._bottomCorner = PivotTable.this.getPivotGrid().getCornerComponent("UPPER_LEFT_CORNER");
            this.add(this._bottomCorner);
            this.revalidate();
        }

        public void doLayout() {
            Dimension dimension = this.getSize();
            Header header = PivotTable.this.getRowPivotHeader().getColumnHeader();
            Dimension dimension2 = header.getPreferredSize();
            Header header2 = PivotTable.this.getColumnPivotHeader().getRowHeader();
            Dimension dimension3 = header2.getPreferredSize();
            Component component = this.getComponent(0);
            component.validate();
            Dimension dimension4 = component.getPreferredSize();
            int n = dimension.width - dimension3.width;
            int n2 = dimension.height - dimension2.height;
            component.setBounds(0, 0, n, n2);
            header2.setBounds(n, 0, dimension3.width, n2);
            header.setBounds(0, n2, n, dimension2.height);
            Component component2 = this._bottomCorner;
            if (PivotTable.this.getPivotGrid().isSelectAllEnabled()) {
                component2.setVisible(true);
                component2.setBounds(n, n2, dimension3.width, dimension2.height);
            } else {
                component2.setVisible(false);
            }
            PivotTable.this.getColumnPivotHeader().setMinimumSize(dimension4.height);
            PivotTable.this.getRowPivotHeader().setMinimumSize(dimension4.width);
        }

        public AccessibleContext getAccessibleContext() {
            if (this.accessibleContext == null) {
                this.accessibleContext = new AccessibleCorner();
            }
            return this.accessibleContext;
        }

        private class AccessibleCorner
        extends JComponent.AccessibleJComponent {
            private AccessibleCorner() {
                super(CornerPanel.this);
            }

            public int getAccessibleChildrenCount() {
                return 0;
            }

            public Accessible getAccessibleChild(int n) {
                return null;
            }
        }
    }

    private class TableCorner
    extends JComponent
    implements Accessible {
        public TableCorner() {
            long l = 16L;
            this.enableEvents(l);
        }

        public void paint(Graphics graphics) {
            if (PivotTable.this.getPivotGrid().isSelectAllEnabled()) {
                PaintContext paintContext = PivotTable.this.getPaintContext();
                PivotGrid pivotGrid = PivotTable.this.getPivotGrid();
                EWTPivotGridUI eWTPivotGridUI = pivotGrid.getPivotGridUI();
                Painter painter = eWTPivotGridUI.getCornerPainter(pivotGrid, 3);
                Dimension dimension = this.getSize();
                painter.paint(paintContext, graphics, 0, 0, dimension.width, dimension.height);
            }
        }

        public AccessibleContext getAccessibleContext() {
            if (this.accessibleContext == null) {
                this.accessibleContext = new AccessibleTableCorner();
            }
            return this.accessibleContext;
        }

        protected void processMouseEvent(MouseEvent mouseEvent) {
            super.processMouseEvent(mouseEvent);
            if (!mouseEvent.isConsumed() && mouseEvent.getID() == 501 && SwingUtilities.isLeftMouseButton(mouseEvent) && PivotTable.this.getPivotGrid().isSelectAllEnabled()) {
                try {
                    PivotTable.this.getPivotGrid().selectAll();
                }
                catch (PropertyVetoException propertyVetoException) {
                    // empty catch block
                }
            }
        }

        private class AccessibleTableCorner
        extends JComponent.AccessibleJComponent
        implements AccessibleAction {
            private AccessibleTableCorner() {
                super(TableCorner.this);
            }

            public AccessibleAction getAccessibleAction() {
                return this;
            }

            public int getAccessibleActionCount() {
                return 1;
            }

            public String getAccessibleActionDescription(int n) {
                switch (n) {
                    case 0: {
                        return PivotTable.this.__getAccessibleString(PivotTable._SELECT_ALL_KEY);
                    }
                }
                return null;
            }

            public boolean doAccessibleAction(int n) {
                boolean bl;
                boolean bl2 = bl = n == 0 && PivotTable.this.getPivotGrid().isSelectAllEnabled();
                if (bl) {
                    try {
                        PivotTable.this.getPivotGrid().selectAll();
                    }
                    catch (PropertyVetoException propertyVetoException) {
                        bl = false;
                    }
                }
                return bl;
            }
        }
    }

    private class Corner
    extends JComponent {
        private int _corner;

        public Corner(int n) {
            this._corner = n;
        }

        public void paint(Graphics graphics) {
            if (PivotTable.this.isColumnPivotHeaderVisible() && PivotTable.this.isRowPivotHeaderVisible()) {
                PaintContext paintContext = PivotTable.this.getPaintContext();
                EWTPivotTableUI eWTPivotTableUI = PivotTable.this.getPivotTableUI();
                Painter painter = eWTPivotTableUI.getCornerPainter(PivotTable.this, this._corner);
                Dimension dimension = this.getSize();
                painter.paint(paintContext, graphics, 0, 0, dimension.width, dimension.height);
            }
        }
    }

    private class _LayoutMgr
    implements LayoutManager {
        private _LayoutMgr() {
        }

        public void addLayoutComponent(String string, Component component) {
        }

        public void removeLayoutComponent(Component component) {
        }

        public Dimension preferredLayoutSize(Container container) {
            return ((PivotTable)container).getPreferredSize();
        }

        public Dimension minimumLayoutSize(Container container) {
            return this.preferredLayoutSize(container);
        }

        public void layoutContainer(Container container) {
            boolean bl;
            Dimension dimension = PivotTable.this.getInnerSize();
            if (dimension.width == 0 || dimension.height == 0) {
                return;
            }
            int n = PivotTable.this.isRowPivotHeaderVisible() ? ((PivotTable)PivotTable.this)._rowPivotHeader.getPreferredSize().width : 0;
            int n2 = PivotTable.this.isColumnPivotHeaderVisible() ? ((PivotTable)PivotTable.this)._columnPivotHeader.getPreferredSize().height : 0;
            Point point = PivotTable.this.getInnerOrigin();
            int n3 = point.x;
            int n4 = point.y;
            boolean bl2 = PivotTable.this.getActualReadingDirection() == 1;
            boolean bl3 = PivotTable.this.isRowPivotHeaderVisible();
            boolean bl4 = PivotTable.this.isColumnPivotHeaderVisible();
            Component component = PivotTable.this.getCornerComponent();
            Dimension dimension2 = component.getPreferredSize();
            boolean bl5 = dimension2.width > n;
            boolean bl6 = bl = dimension2.height > n2;
            if (bl5) {
                n = dimension2.width;
            }
            Dimension dimension3 = component.getMinimumSize();
            if (bl) {
                n2 = dimension2.height;
            }
            component.setVisible(true);
            if (bl2) {
                component.setBounds(point.x, point.y, n, n2);
            } else {
                component.setBounds(point.x + dimension.width - n, point.y, n, n2);
            }
            if (bl3) {
                if (bl2) {
                    PivotTable.this._rowPivotHeader.setBounds(point.x, point.y + n2, n, dimension.height - n2);
                } else {
                    PivotTable.this._rowPivotHeader.setBounds(point.x + dimension.width - n, point.y + n2, n, dimension.height - n2);
                }
            }
            if (bl4) {
                if (bl2) {
                    PivotTable.this._columnPivotHeader.setBounds(point.x + n, point.y, dimension.width - n, n2);
                } else {
                    PivotTable.this._columnPivotHeader.setBounds(point.x, point.y, dimension.width - n - 1, n2);
                }
            }
            if (bl2) {
                n3 += n;
            }
            int n5 = bl2 ? dimension.width - n3 : dimension.width - n3 - n;
            PivotTable.this._pivotGrid.setBounds(n3, n4 += n2, n5, dimension.height - n4);
            PivotTable.this._columnPivotHeader.setMinimumSize(dimension2.height);
            PivotTable.this._rowPivotHeader.setMinimumSize(dimension2.width);
        }
    }
}

