/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.ewt.pivot;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.beans.PropertyVetoException;
import java.text.MessageFormat;
import java.util.Locale;
import java.util.ResourceBundle;
import javax.accessibility.Accessible;
import javax.accessibility.AccessibleAction;
import javax.swing.JViewport;
import javax.swing.UIManager;
import javax.swing.plaf.ComponentUI;
import oracle.bali.ewt.LookAndFeel;
import oracle.bali.ewt.elaf.EWTPivotHeaderUI;
import oracle.bali.ewt.event.Cancelable;
import oracle.bali.ewt.geometry.AbstractWrappingGeometryManager;
import oracle.bali.ewt.geometry.GeometryManager;
import oracle.bali.ewt.graphics.Appearance;
import oracle.bali.ewt.grid.AppearanceManager;
import oracle.bali.ewt.grid.CellInputHandler;
import oracle.bali.ewt.grid.ComplexAppearanceManager;
import oracle.bali.ewt.grid.Grid;
import oracle.bali.ewt.grid.SingleAppearanceManager;
import oracle.bali.ewt.grid.bigCell.AbstractBigCell;
import oracle.bali.ewt.grid.bigCell.BigCellGridKeyHandler;
import oracle.bali.ewt.grid.bigCell.BigCellSelectionManager;
import oracle.bali.ewt.header.Header;
import oracle.bali.ewt.header.HeaderEvent;
import oracle.bali.ewt.header.NullInputHandler;
import oracle.bali.ewt.model.NullOneDModel;
import oracle.bali.ewt.model.NullTwoDModel;
import oracle.bali.ewt.model.OneDModel;
import oracle.bali.ewt.model.TwoDModel;
import oracle.bali.ewt.model.TwoDModelAdapter;
import oracle.bali.ewt.model.TwoDModelEvent;
import oracle.bali.ewt.painter.BorderPainter;
import oracle.bali.ewt.painter.FixedBorderPainter;
import oracle.bali.ewt.painter.PaintContext;
import oracle.bali.ewt.painter.Painter;
import oracle.bali.ewt.painter.PainterJoiner;
import oracle.bali.ewt.painter.TruncatingTextPainter;
import oracle.bali.ewt.pivot.AbstractPivotHeaderCell;
import oracle.bali.ewt.pivot.CollapseEvent;
import oracle.bali.ewt.pivot.CollapseListener;
import oracle.bali.ewt.pivot.DrillEvent;
import oracle.bali.ewt.pivot.DrillListener;
import oracle.bali.ewt.pivot.GridResizer;
import oracle.bali.ewt.pivot.LevelHighlighter;
import oracle.bali.ewt.pivot.PivotDragDropAdapter;
import oracle.bali.ewt.pivot.PivotHeaderAppearMgr;
import oracle.bali.ewt.pivot.PivotHeaderInputHandler;
import oracle.bali.ewt.pivot.PivotHeaderPainter;
import oracle.bali.ewt.pivot.PivotScrollPaneView;
import oracle.bali.ewt.pivot.PivotTable;
import oracle.bali.ewt.selection.Cell;
import oracle.bali.ewt.selection.OneDSelection;
import oracle.bali.ewt.selection.TwoDSelection;
import oracle.bali.ewt.table.SpreadTable;
import oracle.bali.ewt.util.ImmInsets;
import oracle.bali.share.nls.LocaleUtils;
import oracle.bali.share.util.IntegerUtils;

public class PivotHeader
extends SpreadTable {
    public static final String KEY_OUTLINE = "pivotheader.outline";
    public static final String KEY_HORIZONTAL = "pivotheader.horizontal";
    private static final ImmInsets _HEADER_INSETS = new ImmInsets(0, 0, 0, 0);
    static final String _RESOURCE_BUNDLE = "oracle.bali.ewt.resource.AccessibilityBundle";
    static final String _DRILL_KEY = "DRILL";
    static final String _COLLAPSE_KEY = "COLLAPSE";
    private static final int _PIVOT_FEEDBACK_SIZE = 4;
    private static final int _RESIZE_FEEDBACK_SIZE = 3;
    private static final int _PIVOT_SIZE = 6;
    int mouseItem = -1;
    int _dropIndex = -1;
    int _dragIndex = -1;
    int _highlightItem = -1;
    boolean _swapping;
    private int _resizeItem = -1;
    private int _newSize = -1;
    private Image _drillImage;
    private Image _drilledImage;
    private int _orientation;
    private boolean _dragEnabled = true;
    private DrillListener _drillListener;
    private CollapseListener _collapseListener;
    private TwoDModelAdapter _hListener;
    private TwoDModelAdapter _vListener;
    private PivotTable _pivotTable;
    private boolean _drilling;
    private boolean _needToValidateMinSize;
    int _minSize;
    private int _headerResizeItem = -1;
    private boolean _traversable;
    private boolean _displayDrillImages = true;
    private boolean _axisLabelsVisible;
    private Painter _axisLabelPainter;
    private GridResizer _gridResizer;
    private LevelHighlighter _levelHighlighter;
    private PivotDragDropAdapter _dragDropSupport;
    private JViewport _viewport;
    private boolean[] _resizeArr;

    public PivotHeader() {
        this(NullTwoDModel.getTwoDModel(), 1);
    }

    public PivotHeader(TwoDModel twoDModel, int n) {
        this._orientation = n;
        this._hListener = new _HListen();
        this._vListener = new _VListen();
        if (this._isHorizontal()) {
            this.setRowGeometryManager(super.getRowGeometryManager());
        } else {
            this.setColumnGeometryManager(super.getColumnGeometryManager());
        }
        Grid grid = this.getGrid();
        if (twoDModel == null) {
            this.setVisible(false);
        }
        this.setModel(twoDModel);
        Header header = this._isHorizontal() ? this.getRowHeader() : this.getColumnHeader();
        header.setCanResizeItems(true);
        header.setCanMoveItems(false);
        header.setItemInputHandler(new CursorChange());
        header.setScrollByItem(false);
        Appearance appearance = header.getAppearance();
        appearance.setInsets(_HEADER_INSETS);
        header.setAppearance(appearance);
        this._gridResizer = new GridResizer(this);
        this._levelHighlighter = new LevelHighlighter(this);
        this._dragDropSupport = new PivotDragDropAdapter(this);
        Painter painter = this.getPivotHeaderUI().getDefaultHeaderItemPainter(this, !this._isHorizontal());
        header.setDefaultPainter(painter);
        PivotHeaderPainter pivotHeaderPainter = new PivotHeaderPainter(this);
        grid.setDefaultPainter(pivotHeaderPainter);
        grid.setVerticalSeparatorsVisible(false);
        grid.setHorizontalSeparatorsVisible(false);
        this.setInputHandler(new PivotHeaderInputHandler());
        grid.setGridSelectionManager(new BigCellSelectionManager(grid));
        grid.setGridKeyHandler(BigCellGridKeyHandler.getGridKeyHandler());
        SingleAppearanceManager singleAppearanceManager = (SingleAppearanceManager)grid.getAppearanceManager();
        PivotHeaderAppearMgr pivotHeaderAppearMgr = new PivotHeaderAppearMgr(singleAppearanceManager, this);
        grid.setAppearanceManager(pivotHeaderAppearMgr);
        Object object = UIManager.get("PivotHeader.DefaultAppearance");
        singleAppearanceManager.setAppearance((Appearance)object);
        this._traversable = true;
        this.updateUI();
    }

    public void dispose() {
        PivotHeaderAppearMgr pivotHeaderAppearMgr;
        if (this._gridResizer == null) {
            return;
        }
        this._axisLabelPainter = null;
        this.getHeader().setItemInputHandler(null);
        Painter painter = this.getDefaultPainter();
        if (painter instanceof PivotHeaderPainter) {
            ((PivotHeaderPainter)painter).dispose();
        }
        if ((pivotHeaderAppearMgr = this._getPivotHeaderAppearMgr()) != null) {
            pivotHeaderAppearMgr.dispose();
        }
        this.getGrid().setGridSelectionManager(null);
        this._gridResizer.dispose();
        this._levelHighlighter.dispose();
        this._dragDropSupport.dispose();
        this._gridResizer = null;
        this._levelHighlighter = null;
        this._dragDropSupport = null;
        this.setModel(null);
        this._hListener = null;
        this._vListener = null;
        super.dispose();
    }

    public String getUIClassID() {
        return "EWTPivotHeaderUI";
    }

    public int getOrientation() {
        return this._orientation;
    }

    public final PivotTable getPivotTable() {
        return this._pivotTable;
    }

    void setPivotTable(PivotTable pivotTable) {
        this._pivotTable = pivotTable;
    }

    public final AppearanceManager getAppearanceManager() {
        AppearanceManager appearanceManager = this.getGrid().getAppearanceManager();
        if (appearanceManager instanceof PivotHeaderAppearMgr) {
            appearanceManager = ((PivotHeaderAppearMgr)appearanceManager).getWrapped();
        }
        return appearanceManager;
    }

    public final void setAppearanceManager(AppearanceManager appearanceManager) {
        if (!(appearanceManager instanceof PivotHeaderAppearMgr)) {
            appearanceManager = new PivotHeaderAppearMgr(appearanceManager, this);
        }
        this.getGrid().setAppearanceManager(appearanceManager);
        appearanceManager.updateUI();
    }

    public final TwoDModel getModel() {
        return this.getGrid().getModel();
    }

    public void setModel(TwoDModel twoDModel) {
        TwoDModel twoDModel2 = this.getModel();
        if (twoDModel == null) {
            if (this._isHorizontal()) {
                twoDModel2.removeModelListener(this._hListener);
            } else {
                twoDModel2.removeModelListener(this._vListener);
            }
            this.setModels(null, null, null);
        } else if (this._isHorizontal()) {
            twoDModel2.removeModelListener(this._hListener);
            NullOneDModel nullOneDModel = new NullOneDModel(twoDModel.getRowCount());
            this.setModels(twoDModel, null, nullOneDModel);
            twoDModel.addModelListener(this._hListener);
        } else {
            twoDModel2.removeModelListener(this._vListener);
            NullOneDModel nullOneDModel = new NullOneDModel(twoDModel.getColumnCount());
            this.setModels(twoDModel, nullOneDModel, null);
            twoDModel.addModelListener(this._vListener);
        }
    }

    public void setLevelResizable(int n, boolean bl) {
        int n2 = this.getOrientation() == 0 ? this.getGrid().getRowCount() : this.getGrid().getColumnCount();
        if (this._resizeArr == null) {
            this._resizeArr = new boolean[n2];
            int n3 = 0;
            while (n3 < n2) {
                this._resizeArr[n3] = true;
                ++n3;
            }
        } else {
            int n4 = this._resizeArr.length;
            if (n4 < n2) {
                boolean[] blArray = new boolean[n2];
                System.arraycopy(this._resizeArr, 0, blArray, 0, n4);
                int n5 = n4;
                while (n5 < n2) {
                    blArray[n5] = true;
                    ++n5;
                }
                this._resizeArr = blArray;
            }
        }
        if (n < this._resizeArr.length) {
            this._resizeArr[n] = bl;
        }
    }

    public boolean isLevelResizable(int n) {
        if (this._resizeArr != null && n < this._resizeArr.length) {
            return this._resizeArr[n];
        }
        return true;
    }

    public void setAxisLabelModel(OneDModel oneDModel) {
        this.getHeader().setModel(oneDModel);
    }

    public OneDModel getAxisLabelModel() {
        return this.getHeader().getModel();
    }

    public void setAxisLabelsVisible(boolean bl) {
        if (this._axisLabelsVisible != bl) {
            this._axisLabelsVisible = bl;
            this._setAxisPainter();
        }
    }

    public boolean isAxisLabelsVisible() {
        return this._axisLabelsVisible;
    }

    public Painter getAxisLabelPainter() {
        if (this._axisLabelPainter == null) {
            this._axisLabelPainter = new TruncatingTextPainter();
        }
        return this._axisLabelPainter;
    }

    public void setAxisLabelPainter(Painter painter) {
        if (this._axisLabelPainter != painter) {
            this._axisLabelPainter = painter;
            this._setAxisPainter();
        }
    }

    public void setInputHandler(CellInputHandler cellInputHandler) {
        this.getGrid().setDefaultInputHandler(cellInputHandler);
    }

    public CellInputHandler getInputHandler() {
        return this.getGrid().getDefaultInputHandler();
    }

    public void setDefaultPainter(Painter painter) {
        this.getGrid().setDefaultPainter(painter);
        this.repaint();
    }

    public Painter getDefaultPainter() {
        return this.getGrid().getDefaultPainter();
    }

    public boolean isOutline() {
        PivotHeaderPainter pivotHeaderPainter = this._getPivotHeaderPainter();
        return pivotHeaderPainter == null ? false : pivotHeaderPainter.isOutline();
    }

    public void setOutline(boolean bl) {
        PivotHeaderPainter pivotHeaderPainter = this._getPivotHeaderPainter();
        if (pivotHeaderPainter != null && !this._isHorizontal() && this.isOutline() != bl) {
            pivotHeaderPainter.setOutline(bl);
            this.repaint();
        }
    }

    public void setKeepHeaderCellsVisible(boolean bl) {
        PivotHeaderPainter pivotHeaderPainter = this._getPivotHeaderPainter();
        if (pivotHeaderPainter != null) {
            pivotHeaderPainter.setKeepHeaderCellsVisible(bl);
            this.repaint();
        }
        this._updateScrollMode(bl);
    }

    public boolean getKeepHeaderCellsVisible() {
        PivotHeaderPainter pivotHeaderPainter = this._getPivotHeaderPainter();
        return pivotHeaderPainter == null ? false : pivotHeaderPainter.getKeepHeaderCellsVisible();
    }

    public void setColumnGeometryManager(GeometryManager geometryManager) {
        if (!this._isHorizontal()) {
            geometryManager = new GM(geometryManager);
        }
        super.setColumnGeometryManager(geometryManager);
    }

    public void setRowGeometryManager(GeometryManager geometryManager) {
        if (this._isHorizontal()) {
            geometryManager = new GM(geometryManager);
        }
        super.setRowGeometryManager(geometryManager);
    }

    public final EWTPivotHeaderUI getPivotHeaderUI() {
        return (EWTPivotHeaderUI)this.ui;
    }

    public boolean isGridFocusTraversable() {
        return this._traversable;
    }

    public void setGridFocusTraversable(boolean bl) {
        this._traversable = bl;
    }

    public void setEnabled(boolean bl) {
        super.setEnabled(bl);
        this.setDragEnabled(this.isEnabled());
    }

    public Dimension layoutCanvas() {
        Dimension dimension = super.layoutCanvas();
        this._validateMinimumSize();
        return dimension;
    }

    public Dimension getPreferredSize() {
        Dimension dimension = super.getPreferredSize();
        Header header = this.getHeader();
        if (header.getItemCount() == 0) {
            if (this._isHorizontal()) {
                dimension.height += header.getDefaultItemSize();
            } else {
                dimension.width += header.getDefaultItemSize();
            }
        }
        if (this.getPivotTable() != null) {
            this.getPivotTable().checkHeaderSize(this, dimension);
        }
        return dimension;
    }

    public Dimension getMinimumSize() {
        Dimension dimension = super.getMinimumSize();
        Header header = this.getHeader();
        if (header.getItemCount() == 0) {
            if (this._isHorizontal()) {
                dimension.height += header.getDefaultItemSize();
            } else {
                dimension.width += header.getDefaultItemSize();
            }
        }
        return dimension;
    }

    public void updateUI() {
        this.setUI((EWTPivotHeaderUI)UIManager.getUI(this));
        this.getGrid().getAppearanceManager().updateUI();
    }

    public void setDrawRaised(boolean bl) {
        super.setDrawRaised(bl);
        if (this._isHorizontal()) {
            this.getRowHeader().setDrawRaised(bl);
        } else {
            this.getColumnHeader().setDrawRaised(bl);
        }
    }

    public void addNotify() {
        super.addNotify();
        Container container = this.getParent();
        if (container instanceof PivotScrollPaneView) {
            container = container.getParent();
        }
        if (container instanceof JViewport) {
            this._viewport = (JViewport)container;
        }
    }

    public void removeNotify() {
        super.removeNotify();
        this._viewport = null;
    }

    protected Image getDrillImage(int n, int n2) {
        Image image = null;
        AbstractPivotHeaderCell abstractPivotHeaderCell = this.getPivotHeaderCell(n, n2);
        if (abstractPivotHeaderCell != null) {
            int n3 = abstractPivotHeaderCell.getDrillState();
            switch (n3) {
                case 0: {
                    image = null;
                    break;
                }
                case 2: {
                    if (this._drilledImage == null) {
                        this._drilledImage = this.getPivotHeaderUI().getDrilledImage(this);
                    }
                    image = this._drilledImage;
                    break;
                }
                case 1: {
                    if (this._drillImage == null) {
                        this._drillImage = this.getPivotHeaderUI().getDrillImage(this);
                    }
                    image = this._drillImage;
                }
            }
        }
        return image;
    }

    protected boolean isDrill(int n, int n2, int n3, int n4) {
        boolean bl = false;
        Image image = this.getDrillImage(n, n2);
        if (image != null) {
            AbstractPivotHeaderCell abstractPivotHeaderCell;
            int n5 = image.getWidth(this);
            int n6 = image.getHeight(this);
            if (this.getKeepHeaderCellsVisible() && (abstractPivotHeaderCell = this.getPivotHeaderCell(n, n2)) != null && this.getParent() != null) {
                int n7;
                Point point = this.getParent().getLocation();
                int n8 = this.getGrid().getColumnPosition(n);
                if (n8 < -point.x) {
                    n3 -= -point.x - n8;
                }
                if ((n7 = this.getGrid().getRowPosition(n2)) < -point.y) {
                    n4 -= -point.y - n7;
                }
            }
            bl = n3 >= 0 && n3 <= n5 && n4 >= 0 && n4 <= n6;
        }
        return bl;
    }

    protected boolean isDrillable(int n, int n2) {
        AbstractPivotHeaderCell abstractPivotHeaderCell = this.getPivotHeaderCell(n, n2);
        if (abstractPivotHeaderCell != null) {
            return abstractPivotHeaderCell.getDrillState() == 1;
        }
        return false;
    }

    protected boolean isCollapsable(int n, int n2) {
        AbstractPivotHeaderCell abstractPivotHeaderCell = this.getPivotHeaderCell(n, n2);
        if (abstractPivotHeaderCell != null) {
            return abstractPivotHeaderCell.getDrillState() == 2;
        }
        return false;
    }

    protected Cursor getPivotCursor(int n) {
        return Cursor.getPredefinedCursor(12);
    }

    protected Cursor getDrillCursor(int n, int n2) {
        return Cursor.getPredefinedCursor(12);
    }

    protected void firePivotEvent(Object object, int n, Object object2, int n2) {
        PivotTable pivotTable = this.getPivotTable();
        if (pivotTable != null) {
            try {
                pivotTable.deselectAll();
            }
            catch (PropertyVetoException propertyVetoException) {
                // empty catch block
            }
            pivotTable.firePivotEvent(object, n, object2, n2);
        }
    }

    protected void fireSwapEvent(Object object, int n, Object object2, int n2) {
        PivotTable pivotTable = this.getPivotTable();
        if (pivotTable != null) {
            pivotTable.fireSwapEvent(object, n, object2, n2);
            try {
                pivotTable.deselectAll();
            }
            catch (PropertyVetoException propertyVetoException) {
                // empty catch block
            }
        }
    }

    protected int getDropIndex(Point point, boolean bl, boolean bl2) {
        int n = -1;
        if (this._isHorizontal()) {
            Header header = this.getRowHeader();
            n = header.getItemAt(2, point.y);
            if (!bl2) {
                if (n == -1) {
                    n = 0;
                } else {
                    int n2;
                    int n3 = header.getItemPosition(n);
                    if (point.y > n3 + (n2 = header.getItemSize(n)) / 2) {
                        ++n;
                    }
                }
            }
        } else {
            Header header = this.getColumnHeader();
            boolean bl3 = this.getActualReadingDirection() == 1;
            n = header.getItemAt(point.x, 2);
            if (!bl2) {
                if (n == -1) {
                    n = 0;
                } else {
                    int n4 = header.getItemPosition(n);
                    int n5 = header.getItemSize(n);
                    if (bl3) {
                        if (point.x > n4 + n5 / 2) {
                            ++n;
                        }
                    } else if (point.x < n4 + n5 / 2) {
                        ++n;
                    }
                }
            }
        }
        return n;
    }

    protected boolean isSwap(Point point, boolean bl) {
        if (this.getPivotTable() == null || !this.getPivotTable().isSwapAllowed()) {
            return false;
        }
        int n = -1;
        if (this._isHorizontal()) {
            Header header = this.getRowHeader();
            n = header.getItemAt(point.x, point.y);
            if (n == -1) {
                return false;
            }
            int n2 = header.getItemPosition(n);
            int n3 = header.getItemSize(n);
            if (point.y < n2 + 6) {
                return false;
            }
            if (point.y > n2 + n3 - 6) {
                return false;
            }
        } else {
            Header header = this.getColumnHeader();
            n = header.getItemAt(point.x, point.y);
            if (n == -1) {
                return false;
            }
            int n4 = header.getItemPosition(n);
            int n5 = header.getItemSize(n);
            if (point.x < n4 + 6) {
                return false;
            }
            if (point.x > n4 + n5 - 6) {
                return false;
            }
        }
        return true;
    }

    protected void paintDropFeedback(Graphics graphics, int n, boolean bl) {
        if (bl) {
            return;
        }
        Header header = this.getHeader();
        Rectangle rectangle = this.getInnerBounds();
        Dimension dimension = this.getCanvasSize();
        boolean bl2 = this.getActualReadingDirection() == 1;
        Color color = graphics.getColor();
        graphics.setColor(Color.black);
        int n2 = header.getItemCount();
        int n3 = n < n2 ? header.getItemPosition(n) : (n == n2 && n2 != 0 ? header.getItemPosition(n - 1) + header.getItemSize(n - 1) : 0);
        if (!this._isHorizontal()) {
            if (!(this.getParent() instanceof PivotScrollPaneView)) {
                dimension.height += header.getSize().height;
            }
            int n4 = bl2 ? n3 - 2 : (n2 != 0 ? (n == n2 ? header.getItemPosition(n - 1) - 2 : header.getItemSize(n) + header.getItemPosition(n) - 2) : 0);
            if (n4 < rectangle.x) {
                n4 = rectangle.x;
            }
            if (n4 + 4 > rectangle.width) {
                n4 = rectangle.width - 4;
            }
            if (dimension.height < rectangle.height && n2 != 0) {
                rectangle.height = dimension.height;
            }
            graphics.fillRect(n4, rectangle.y, 4, rectangle.height);
        } else {
            int n5;
            if (!(this.getParent() instanceof PivotScrollPaneView)) {
                dimension.width += header.getSize().width;
            }
            if ((n5 = n3 - 2) < rectangle.y) {
                n5 = rectangle.y;
            }
            if (n5 + 4 > rectangle.height) {
                n5 = rectangle.height - 4;
            }
            if (bl2) {
                if (dimension.width < rectangle.width && n2 != 0) {
                    rectangle.width = dimension.width;
                }
                graphics.fillRect(rectangle.x, n5, rectangle.width, 4);
            } else {
                graphics.fillRect(rectangle.x, n5, rectangle.width, 4);
            }
        }
        if (color != null) {
            graphics.setColor(color);
        }
    }

    protected int getDragIndex(Point point, boolean bl) {
        boolean bl2 = this._isHorizontal();
        Header header = this.getHeader();
        int n = -1;
        if (bl) {
            if (header.getItemCount() == 0) {
                return -1;
            }
            n = header.getItemAt(point.x, point.y);
        } else {
            Grid grid = this.getGrid();
            if (grid.getRowCount() == 0 || grid.getColumnCount() == 0) {
                return -1;
            }
            int n2 = grid.getColumnAt(point.x);
            int n3 = grid.getRowAt(point.y);
            if (n2 == -1 || n3 == -1) {
                return -1;
            }
            AbstractBigCell abstractBigCell = AbstractBigCell.getBigCell(grid, n2, n3);
            int n4 = n2;
            int n5 = n3;
            if (abstractBigCell != null) {
                if (bl2) {
                    n5 = abstractBigCell.getRow();
                } else if (this.isOutline() && abstractBigCell instanceof AbstractPivotHeaderCell) {
                    AbstractPivotHeaderCell abstractPivotHeaderCell = (AbstractPivotHeaderCell)abstractBigCell;
                    n4 = abstractPivotHeaderCell.getColumn() + abstractPivotHeaderCell.getIndent();
                } else {
                    n4 = abstractBigCell.getColumn();
                }
            }
            n = bl2 ? n5 : n4;
        }
        return n;
    }

    protected final int getDragIndex() {
        return this._dragIndex;
    }

    protected final boolean isSwapping() {
        return this._swapping;
    }

    protected final int getDropIndex() {
        return this._dropIndex;
    }

    protected final Grid createGrid(TwoDModel twoDModel) {
        return this.createPivotHeaderGrid(twoDModel);
    }

    protected PivotHeaderGrid createPivotHeaderGrid(TwoDModel twoDModel) {
        return new PivotHeaderGrid(twoDModel);
    }

    protected final Header createColumnHeader(OneDModel oneDModel) {
        return this.createPivotHeaderColumnHeader(oneDModel);
    }

    protected PivotHeaderHeader createPivotHeaderColumnHeader(OneDModel oneDModel) {
        return new PivotHeaderHeader(oneDModel, 0);
    }

    protected final Header createRowHeader(OneDModel oneDModel) {
        return this.createPivotHeaderRowHeader(oneDModel);
    }

    protected PivotHeaderHeader createPivotHeaderRowHeader(OneDModel oneDModel) {
        return new PivotHeaderHeader(oneDModel, 1);
    }

    public void paintOverChildren(Graphics graphics) {
        if (this._dropIndex != -1) {
            this.paintDropFeedback(graphics, this._dropIndex, this._swapping);
        } else if (this._resizeItem != -1) {
            this._paintResizeFeedback(graphics);
        }
    }

    protected void setUI(ComponentUI componentUI) {
        super.setUI(componentUI);
        this._drillImage = null;
        this._drilledImage = null;
    }

    void setDrillImagesDisplayed(boolean bl) {
        this._displayDrillImages = bl;
    }

    boolean getDrillImagesDisplayed() {
        return this._displayDrillImages;
    }

    void resetAppearanceManager() {
        AppearanceManager appearanceManager = this.getAppearanceManager();
        if (appearanceManager instanceof SingleAppearanceManager) {
            SingleAppearanceManager singleAppearanceManager = (SingleAppearanceManager)appearanceManager;
            Object object = UIManager.get("PivotHeader.DefaultAppearance");
            singleAppearanceManager.setAppearance((Appearance)object);
        } else if (appearanceManager instanceof ComplexAppearanceManager) {
            ComplexAppearanceManager complexAppearanceManager = (ComplexAppearanceManager)appearanceManager;
            Object object = UIManager.get("PivotHeader.DefaultAppearance");
            complexAppearanceManager.setAppearance((Appearance)object);
        }
    }

    AbstractPivotHeaderCell getPivotHeaderCell(int n, int n2) {
        Object object = this.getGrid().getModel().getData(n, n2);
        if (object instanceof AbstractPivotHeaderCell) {
            return (AbstractPivotHeaderCell)object;
        }
        return null;
    }

    void setDragEnabled(boolean bl) {
        this._dragEnabled = bl;
    }

    boolean isDragEnabled() {
        return this._dragEnabled;
    }

    void fireHeaderCellDrillRequest(int n, int n2) {
        if (this._drillListener == null) {
            return;
        }
        int n3 = 2001;
        DrillEvent drillEvent = new DrillEvent(this, n3, this.getOrientation(), n, n2);
        this._drillListener.headerCellDrillRequest(drillEvent);
    }

    void fireCollapse(int n, int n2) {
        if (this._collapseListener == null) {
            return;
        }
        int n3 = 2001;
        CollapseEvent collapseEvent = new CollapseEvent(this, n3, this.getOrientation(), n, n2);
        this._collapseListener.collapse(collapseEvent);
    }

    Image getDragImage(int n) {
        Header header;
        int n2;
        int n3;
        PivotTable pivotTable = this.getPivotTable();
        if (this._isHorizontal()) {
            n3 = pivotTable == null ? this.getRowHeaderWidth() : pivotTable.getPivotTableUI().getSelectorSize(pivotTable);
            n2 = n < 0 || n >= this.getGrid().getRowCount() ? this.getDefaultRowHeight() : this.getRowHeight(n);
            header = this.getRowHeader();
        } else {
            n3 = n < 0 || n >= this.getGrid().getColumnCount() ? this.getDefaultColumnWidth() : this.getColumnWidth(n);
            n2 = pivotTable == null ? this.getColumnHeaderHeight() : pivotTable.getPivotTableUI().getSelectorSize(pivotTable);
            header = this.getColumnHeader();
        }
        Image image = this.createImage(n3, n2);
        if (image != null) {
            Graphics graphics = image.getGraphics();
            PaintContext paintContext = header.getPaintContext();
            BorderPainter borderPainter = header.getHeaderItemBorderPainter();
            ImmInsets immInsets = borderPainter.getInsets(paintContext);
            borderPainter.paint(paintContext, graphics, 0, 0, n3, n2);
            Painter painter = header.getDefaultPainter();
            painter.paint(paintContext, graphics, immInsets.left, immInsets.top, n3 -= immInsets.left + immInsets.right, n2 -= immInsets.top + immInsets.bottom);
        }
        return image;
    }

    synchronized void setDrillListener(DrillListener drillListener) {
        this._drillListener = drillListener;
    }

    synchronized void setCollapseListener(CollapseListener collapseListener) {
        this._collapseListener = collapseListener;
    }

    void setDropLocation(int n, boolean bl) {
        if (this._dropIndex != n || this._swapping != bl) {
            PivotHeaderAppearMgr pivotHeaderAppearMgr = this._getPivotHeaderAppearMgr();
            if (pivotHeaderAppearMgr != null) {
                int n2 = !bl ? -1 : (n == -1 ? -1 : (n == this._dragIndex ? -1 : n));
                pivotHeaderAppearMgr.setSwapItem(n2);
            }
            this._swapping = bl;
            if (n == -1 || this._dragIndex == -1 || this._swapping && this._dragIndex != n) {
                this._dropIndex = n;
                this.repaintFeedback();
            } else {
                if (this._dragIndex != -1 && (this._dragIndex == n || this._dragIndex == n - 1)) {
                    n = -1;
                }
                this._dropIndex = n;
                this.repaintFeedback();
            }
        }
    }

    void setDragItem(int n) {
        try {
            if (this._dragIndex != -1) {
                if (this._isHorizontal()) {
                    this.getGrid().deselectAll();
                    this.getRowHeader().deselectAll();
                } else {
                    this.getGrid().deselectAll();
                    this.getColumnHeader().deselectAll();
                }
            }
            this._dragIndex = n;
            if (this._dragIndex >= 0) {
                if (this._isHorizontal()) {
                    if (this._dragIndex < this.getGrid().getRowCount()) {
                        this.getGrid().setSelection(new TwoDSelection(this._dragIndex, true));
                    }
                } else if (this._dragIndex < this.getGrid().getColumnCount()) {
                    this.getGrid().setSelection(new TwoDSelection(this._dragIndex, false));
                }
            }
        }
        catch (PropertyVetoException propertyVetoException) {
            // empty catch block
        }
        this.repaintFeedback();
    }

    Header getHeader() {
        if (this._isHorizontal()) {
            return this.getRowHeader();
        }
        return this.getColumnHeader();
    }

    boolean _isHorizontal() {
        return this.getOrientation() == 0;
    }

    final boolean isDrilling() {
        return this._drilling;
    }

    final void setDrilling(boolean bl) {
        this._drilling = bl;
    }

    final int getResizeItem() {
        return this._resizeItem;
    }

    final void setResizeItem(int n) {
        this._resizeItem = n;
        if (this._resizeItem != -1) {
            this._newSize = this._isHorizontal() ? this.getColumnWidth(n) : this.getRowHeight(n);
        }
        this.repaintFeedback();
    }

    final void updateResizeFeedback(int n) {
        this._newSize = n;
        this.repaintFeedback();
    }

    final void setMinimumSize(int n) {
        this._minSize = n;
        this._needToValidateMinSize = true;
        this._validateMinimumSize();
    }

    final int getHeaderResizeItem() {
        return this._headerResizeItem;
    }

    final void setHeaderResizeItem(int n) {
        if (this._headerResizeItem != n) {
            this._headerResizeItem = n;
            PivotTable pivotTable = this.getPivotTable();
            PivotHeader pivotHeader = n == -1 ? null : this;
            pivotTable.setResizeHeader(pivotHeader);
        }
    }

    final void updateHeaderResizeFeedback() {
        if (this._headerResizeItem != -1 && this.getPivotTable() != null) {
            this.getPivotTable().paintParent();
        }
    }

    final void setHighlightItem(int n) {
        if (this._highlightItem != n) {
            this._highlightItem = n;
            this.getHeader().paintImmediateInterior();
        }
    }

    private void _setAxisPainter() {
        Painter painter = null;
        if (this._axisLabelsVisible) {
            painter = this.getPivotHeaderUI().getDefaultHeaderItemPainter(this, false);
            painter = new PainterJoiner(painter, new FixedBorderPainter(this.getAxisLabelPainter(), 0, 3, 0, 0), 13);
        } else {
            painter = this.getPivotHeaderUI().getDefaultHeaderItemPainter(this, !this._isHorizontal());
        }
        this.getHeader().setDefaultPainter(painter);
    }

    private void _validateMinimumSize() {
        if (!this._needToValidateMinSize) {
            return;
        }
        this._needToValidateMinSize = false;
        this.validate();
        int n = this.getHeader().getItemCount();
        if (n == 0) {
            this._needToValidateMinSize = true;
        } else {
            Dimension dimension = this.getInnerSize();
            if (this._isHorizontal()) {
                int n2 = this.getHeader().getGeometryManager().getTotalSize();
                if (n2 == 0) {
                    this._needToValidateMinSize = true;
                } else {
                    this._needToValidateMinSize = false;
                    if (dimension.height > n2) {
                        int n3 = this.getRowHeight(n - 1) + (dimension.height - n2);
                        this.setRowHeight(n - 1, n3);
                    }
                }
            } else {
                int n4 = this.getHeader().getGeometryManager().getTotalSize();
                if (n4 == 0) {
                    this._needToValidateMinSize = true;
                } else {
                    this._needToValidateMinSize = false;
                    if (dimension.width > n4) {
                        int n5 = this.getColumnWidth(n - 1) + (dimension.width - n4);
                        this.setColumnWidth(n - 1, n5);
                    }
                }
            }
        }
    }

    private void repaintFeedback() {
        this.paintImmediateInterior();
        if (this.getParent() instanceof PivotScrollPaneView || this.getParent() instanceof JViewport) {
            this.getHeader().paintImmediateInterior();
        }
    }

    private void _paintResizeFeedback(Graphics graphics) {
        Color color = graphics.getColor();
        boolean bl = this.getActualReadingDirection() == 1;
        Grid grid = this.getGrid();
        if (this._isHorizontal()) {
            int n = 0;
            n = bl ? grid.getLocation().x + grid.getColumnPosition(this._resizeItem) + grid.getCanvasOriginX() + this._newSize - 1 : grid.getLocation().x + grid.getColumnPosition(this._resizeItem) + grid.getCanvasOriginX() - (this._newSize - grid.getColumnWidth(this._resizeItem)) - 1;
            int n2 = grid.getLocation().y + 1;
            int n3 = grid.getSize().height - 2;
            graphics.setColor(UIManager.getColor(LookAndFeel.CONTROL_TEXT));
            graphics.setXORMode(UIManager.getColor(LookAndFeel.CONTROL));
            graphics.fillRect(n, n2, 3, n3);
            graphics.setPaintMode();
        } else {
            int n = grid.getLocation().y + grid.getRowPosition(this._resizeItem) + grid.getCanvasOriginY() + this._newSize - 1;
            int n4 = grid.getLocation().x + 1;
            int n5 = grid.getSize().width - 2;
            graphics.setColor(UIManager.getColor(LookAndFeel.CONTROL_TEXT));
            graphics.setXORMode(UIManager.getColor(LookAndFeel.CONTROL));
            graphics.fillRect(n4, n, n5, 3);
            graphics.setPaintMode();
        }
        graphics.setColor(color);
    }

    private PivotHeaderPainter _getPivotHeaderPainter() {
        Painter painter = this.getGrid().getDefaultPainter();
        return painter instanceof PivotHeaderPainter ? (PivotHeaderPainter)painter : null;
    }

    private PivotHeaderAppearMgr _getPivotHeaderAppearMgr() {
        AppearanceManager appearanceManager = this.getGrid().getAppearanceManager();
        if (appearanceManager instanceof PivotHeaderAppearMgr) {
            return (PivotHeaderAppearMgr)appearanceManager;
        }
        return null;
    }

    String __getAccessibleString(String string) {
        Locale locale = LocaleUtils.getDefaultableLocale(this);
        ResourceBundle resourceBundle = ResourceBundle.getBundle(_RESOURCE_BUNDLE, locale);
        return resourceBundle.getString(string);
    }

    private void _updateScrollMode(boolean bl) {
        if (this._viewport != null) {
            if (bl) {
                this._viewport.setScrollMode(0);
            } else {
                this._viewport.setScrollMode(1);
            }
        }
    }

    private class GM
    extends AbstractWrappingGeometryManager {
        public GM(GeometryManager geometryManager) {
            super(geometryManager);
        }

        public void setItemSize(int n, int n2) {
            int n3;
            int n4;
            int n5;
            if (this.isResizing() && (n5 = this.getTotalSize()) + (n4 = n2 - (n3 = this.getItemSize(n))) < PivotHeader.this._minSize) {
                n2 = PivotHeader.this._minSize + n3 - n5;
            }
            super.setItemSize(n, n2);
        }
    }

    private class _VListen
    extends TwoDModelAdapter {
        private _VListen() {
        }

        public void rowsAdded(TwoDModelEvent twoDModelEvent) {
            this._clearSelection();
        }

        public void rowsRemoved(TwoDModelEvent twoDModelEvent) {
            this._clearSelection();
        }

        public void invalidateRows(TwoDModelEvent twoDModelEvent) {
            this._clearSelection();
        }

        public void invalidateColumns(TwoDModelEvent twoDModelEvent) {
            this._clearSelection();
        }

        public void invalidateCells(TwoDModelEvent twoDModelEvent) {
            this._clearSelection();
        }

        private void _clearSelection() {
            try {
                PivotHeader.this.deselectAll();
            }
            catch (PropertyVetoException propertyVetoException) {
                // empty catch block
            }
        }

        public void columnsAdded(TwoDModelEvent twoDModelEvent) {
            Object object;
            OneDModel oneDModel = PivotHeader.this.getColumnHeader().getModel();
            if (oneDModel instanceof NullOneDModel) {
                object = (NullOneDModel)oneDModel;
                ((NullOneDModel)object).addItems(twoDModelEvent.getColumnStartIndex(), twoDModelEvent.getColumnCount());
            }
            this._clearSelection();
            PivotHeader.this.revalidate();
            object = PivotHeader.this.getPivotTable();
            if (object != null) {
                ((PivotTable)object).invalidateParent();
            }
        }

        public void columnsRemoved(TwoDModelEvent twoDModelEvent) {
            Object object;
            OneDModel oneDModel = PivotHeader.this.getColumnHeader().getModel();
            if (oneDModel instanceof NullOneDModel) {
                object = (NullOneDModel)oneDModel;
                ((NullOneDModel)object).removeItems(twoDModelEvent.getColumnStartIndex(), twoDModelEvent.getColumnCount());
            }
            this._clearSelection();
            PivotHeader.this.revalidate();
            object = PivotHeader.this.getPivotTable();
            if (object != null) {
                ((PivotTable)object).invalidateParent();
            }
        }
    }

    private class _HListen
    extends TwoDModelAdapter {
        private _HListen() {
        }

        public void columnsAdded(TwoDModelEvent twoDModelEvent) {
            this._clearSelection();
        }

        public void columnsRemoved(TwoDModelEvent twoDModelEvent) {
            this._clearSelection();
        }

        public void invalidateRows(TwoDModelEvent twoDModelEvent) {
            this._clearSelection();
        }

        public void invalidateColumns(TwoDModelEvent twoDModelEvent) {
            this._clearSelection();
        }

        public void invalidateCells(TwoDModelEvent twoDModelEvent) {
            this._clearSelection();
        }

        private void _clearSelection() {
            try {
                PivotHeader.this.deselectAll();
            }
            catch (PropertyVetoException propertyVetoException) {
                // empty catch block
            }
        }

        public void rowsAdded(TwoDModelEvent twoDModelEvent) {
            Object object;
            OneDModel oneDModel = PivotHeader.this.getRowHeader().getModel();
            if (oneDModel instanceof NullOneDModel) {
                object = (NullOneDModel)oneDModel;
                ((NullOneDModel)object).addItems(twoDModelEvent.getRowStartIndex(), twoDModelEvent.getRowCount());
            }
            this._clearSelection();
            PivotHeader.this.revalidate();
            object = PivotHeader.this.getPivotTable();
            if (object != null) {
                ((PivotTable)object).invalidateParent();
            }
        }

        public void rowsRemoved(TwoDModelEvent twoDModelEvent) {
            Object object;
            OneDModel oneDModel = PivotHeader.this.getRowHeader().getModel();
            if (oneDModel instanceof NullOneDModel) {
                object = (NullOneDModel)oneDModel;
                ((NullOneDModel)object).removeItems(twoDModelEvent.getRowStartIndex(), twoDModelEvent.getRowCount());
            }
            this._clearSelection();
            PivotHeader.this.revalidate();
            object = PivotHeader.this.getPivotTable();
            if (object != null) {
                ((PivotTable)object).invalidateParent();
            }
        }
    }

    private class CursorChange
    extends NullInputHandler {
        private CursorChange() {
        }

        public void mouseEntered(MouseEvent mouseEvent, Header header, int n) {
            PivotHeader.this.mouseItem = n;
            header.setCursor(PivotHeader.this.getPivotCursor(n));
        }

        public void mouseMoved(MouseEvent mouseEvent, Header header, int n) {
            PivotHeader.this.mouseItem = n;
            header.setCursor(PivotHeader.this.getPivotCursor(n));
        }

        public void mouseExited(MouseEvent mouseEvent, Header header, int n) {
            PivotHeader.this.mouseItem = -1;
            header.setCursor(Cursor.getDefaultCursor());
        }
    }

    public class PivotHeaderGrid
    extends Grid {
        public PivotHeaderGrid(TwoDModel twoDModel) {
            super(twoDModel);
        }

        public final void updateUI() {
            super.updateUI();
            javax.swing.LookAndFeel.installColors(this, "EWTPivotHeaderGrid.background", "EWTPivotHeaderGrid.foreground");
        }

        public final Object getPaintData(Object object) {
            if (PivotHeader.KEY_OUTLINE.equals(object)) {
                return PivotHeader.this.isOutline() ? Boolean.TRUE : Boolean.FALSE;
            }
            if (PivotHeader.KEY_HORIZONTAL.equals(object)) {
                return PivotHeader.this._isHorizontal() ? Boolean.TRUE : Boolean.FALSE;
            }
            if (PivotTable.KEY_DRAW_RAISED.equals(object)) {
                return PivotHeader.this.getDrawRaised() ? Boolean.TRUE : Boolean.FALSE;
            }
            return super.getPaintData(object);
        }

        public final boolean isFocusTraversable() {
            return PivotHeader.this.isGridFocusTraversable();
        }

        public final void requestFocus() {
            if (PivotHeader.this.getPivotTable() != null && !this.isFocusTraversable()) {
                PivotHeader.this.getPivotTable().requestFocus();
            } else {
                super.requestFocus();
            }
        }

        public final void paintCell(int n, int n2) {
            AbstractPivotHeaderCell abstractPivotHeaderCell = PivotHeader.this.getPivotHeaderCell(n, n2);
            if (abstractPivotHeaderCell == null) {
                super.paintCell(n, n2);
            } else {
                int n3 = abstractPivotHeaderCell.getColumn();
                int n4 = abstractPivotHeaderCell.getRow();
                int n5 = abstractPivotHeaderCell.getColumnCount();
                int n6 = abstractPivotHeaderCell.getRowCount();
                int n7 = 0;
                while (n7 < n5) {
                    int n8 = 0;
                    while (n8 < n6) {
                        super.paintCell(n3 + n7, n4 + n8);
                        ++n8;
                    }
                    ++n7;
                }
            }
        }

        protected final void paintFocusCell(Graphics graphics) {
            Cell cell = this.getFocusCell();
            if (!(this.getDrawFocusCellHighlite() && cell != null && this.isColumnOnScreen(cell.column) && this.isRowOnScreen(cell.row) && this.hasFocus())) {
                return;
            }
            int n = 0;
            int n2 = 0;
            int n3 = 0;
            int n4 = 0;
            AbstractPivotHeaderCell abstractPivotHeaderCell = PivotHeader.this.getPivotHeaderCell(cell.column, cell.row);
            if (abstractPivotHeaderCell == null) {
                n = this.getColumnPosition(cell.column);
                n2 = this.getRowPosition(cell.row);
                n3 = this.getColumnWidth(cell.column);
                n4 = this.getRowHeight(cell.row);
            } else {
                n = this.getColumnPosition(abstractPivotHeaderCell.getColumn());
                n2 = this.getRowPosition(abstractPivotHeaderCell.getRow());
                int n5 = abstractPivotHeaderCell.getColumnCount();
                int n6 = 0;
                while (n6 < n5) {
                    n3 += this.getColumnWidth(abstractPivotHeaderCell.getColumn() + n6);
                    ++n6;
                }
                int n7 = abstractPivotHeaderCell.getRowCount();
                int n8 = 0;
                while (n8 < n7) {
                    n4 += this.getRowHeight(abstractPivotHeaderCell.getRow() + n8);
                    ++n8;
                }
            }
            BorderPainter borderPainter = (BorderPainter)UIManager.get("Grid.focusPainter");
            if (borderPainter != null) {
                borderPainter.paint(this.getPaintContext(), graphics, n, n2, n3, n4);
            }
        }

        public final Insets getAutoscrollInsets() {
            return new Insets(0, 0, 0, 0);
        }

        protected final Component getScrollParent() {
            return this.getParent();
        }

        protected final int getCellPaintState(int n, int n2, int n3) {
            if (PivotHeader.this.isOutline()) {
                TwoDSelection twoDSelection = this.getSelection();
                boolean bl = false;
                OneDSelection oneDSelection = twoDSelection.getColumnSelection();
                if (!oneDSelection.isEmpty()) {
                    int n4 = oneDSelection.getSingleItem();
                    Object object = super.getModel().getData(n2, n3);
                    if (object instanceof AbstractPivotHeaderCell) {
                        AbstractPivotHeaderCell abstractPivotHeaderCell = (AbstractPivotHeaderCell)object;
                        bl = abstractPivotHeaderCell.getIndent() == n4;
                    }
                } else {
                    boolean bl2 = bl = twoDSelection.containsCell(n2, n3) || twoDSelection.containsRow(n3);
                }
                n = !bl ? (n &= 0xFFFFFFDF) : (n |= 0x20);
            }
            return n;
        }

        protected Grid.AccessibleGrid createAccessibleGrid() {
            return new PivotHeaderAccessibleGrid();
        }

        public class PivotHeaderAccessibleGrid
        extends Grid.AccessibleGrid {
            private PivotHeaderAccessibleGridCell[] _children;
            private int _count = -1;

            public PivotHeaderAccessibleGrid() {
                super(PivotHeaderGrid.this);
            }

            public int getAccessibleChildrenCount() {
                if (this._count != -1) {
                    return this._count;
                }
                int n = PivotHeaderGrid.this.getColumnCount();
                int n2 = PivotHeaderGrid.this.getRowCount();
                int n3 = 0;
                TwoDModel twoDModel = PivotHeaderGrid.this.getModel();
                int n4 = 0;
                while (n4 < n2) {
                    int n5 = 0;
                    while (n5 < n) {
                        Object object = twoDModel.getData(n5, n4);
                        if (object != null && object instanceof AbstractBigCell) {
                            AbstractBigCell abstractBigCell = (AbstractBigCell)object;
                            if (abstractBigCell.getColumn() == n5 && abstractBigCell.getRow() == n4) {
                                ++n3;
                            }
                        } else {
                            ++n3;
                        }
                        ++n5;
                    }
                    ++n4;
                }
                this._count = n3;
                return this._count;
            }

            public int getAccessibleSelectionCount() {
                int n = 0;
                TwoDSelection twoDSelection = PivotHeaderGrid.this.getSelection();
                int n2 = twoDSelection.getSelectedCellCount();
                TwoDModel twoDModel = PivotHeaderGrid.this.getModel();
                int n3 = 0;
                while (n3 < n2) {
                    AbstractBigCell abstractBigCell;
                    Cell cell = twoDSelection.getSelectedCellAtIndex(n3);
                    Object object = twoDModel.getData(cell.column, cell.row);
                    if (object != null && object instanceof AbstractBigCell && (abstractBigCell = (AbstractBigCell)object).getColumn() == cell.column && abstractBigCell.getRow() == cell.row) {
                        ++n;
                    }
                    ++n3;
                }
                return n;
            }

            public Accessible getAccessibleSelection(int n) {
                int n2 = -1;
                TwoDSelection twoDSelection = PivotHeaderGrid.this.getSelection();
                int n3 = twoDSelection.getSelectedCellCount();
                TwoDModel twoDModel = PivotHeaderGrid.this.getModel();
                int n4 = 0;
                while (n4 < n3) {
                    AbstractBigCell abstractBigCell;
                    Cell cell = twoDSelection.getSelectedCellAtIndex(n4);
                    Object object = twoDModel.getData(cell.column, cell.row);
                    if (object != null && object instanceof AbstractBigCell && (abstractBigCell = (AbstractBigCell)object).getColumn() == cell.column && abstractBigCell.getRow() == cell.row) {
                        ++n2;
                    }
                    if (n2 == n) {
                        int n5 = this._convertCellToIndex(cell.column, cell.row);
                        return this.getAccessibleChild(n5);
                    }
                    ++n4;
                }
                return null;
            }

            public boolean isAccessibleChildSelected(int n) {
                TwoDSelection twoDSelection = this._getSelectionFromIndex(n);
                TwoDSelection twoDSelection2 = PivotHeaderGrid.this.getSelection();
                return twoDSelection2.contains(twoDSelection);
            }

            public void addAccessibleSelection(int n) {
                TwoDSelection twoDSelection = this._getSelectionFromIndex(n);
                try {
                    PivotHeaderGrid.this.getGridSelectionManager().addSelection(twoDSelection);
                }
                catch (PropertyVetoException propertyVetoException) {
                    // empty catch block
                }
            }

            public void removeAccessibleSelection(int n) {
                TwoDSelection twoDSelection = this._getSelectionFromIndex(n);
                try {
                    PivotHeaderGrid.this.getGridSelectionManager().removeSelection(twoDSelection);
                }
                catch (PropertyVetoException propertyVetoException) {
                    // empty catch block
                }
            }

            public int getAccessibleRowAtIndex(int n) {
                return this._convertIndexToCell((int)n).row;
            }

            public int getAccessibleColumnAtIndex(int n) {
                return this._convertIndexToCell((int)n).column;
            }

            public int getAccessibleIndexAt(int n, int n2) {
                return this._convertCellToIndex(n, n2);
            }

            public void rowsAdded(TwoDModelEvent twoDModelEvent) {
                super.rowsAdded(twoDModelEvent);
                this._children = null;
                this._count = -1;
            }

            public void rowsRemoved(TwoDModelEvent twoDModelEvent) {
                super.rowsRemoved(twoDModelEvent);
                this._children = null;
                this._count = -1;
            }

            public void columnsAdded(TwoDModelEvent twoDModelEvent) {
                super.columnsAdded(twoDModelEvent);
                this._children = null;
                this._count = -1;
            }

            public void columnsRemoved(TwoDModelEvent twoDModelEvent) {
                super.columnsRemoved(twoDModelEvent);
                this._children = null;
                this._count = -1;
            }

            public Accessible getAccessibleChild(int n) {
                int n2 = this.getAccessibleChildrenCount();
                if (n < 0 || n >= n2) {
                    return null;
                }
                if (this._children == null) {
                    this._children = new PivotHeaderAccessibleGridCell[n2];
                }
                if (this._children[n] == null) {
                    this._children[n] = new PivotHeaderAccessibleGridCell(n);
                }
                return this._children[n];
            }

            protected String getAccessibleName(int n, int n2, Object object) {
                String string = super.getAccessibleName(n, n2, object);
                String string2 = null;
                if (PivotHeader.this.isDrillable(n, n2)) {
                    string2 = "PIVOT_HEADER.IS_DRILLABLE";
                } else if (PivotHeader.this.isCollapsable(n, n2)) {
                    string2 = "PIVOT_HEADER.IS_COLLAPSABLE";
                }
                if (string2 != null) {
                    String string3 = PivotHeader.this.__getAccessibleString(string2);
                    MessageFormat messageFormat = new MessageFormat(string3);
                    Object[] objectArray = new Object[]{string};
                    string = messageFormat.format(objectArray);
                }
                return string;
            }

            private TwoDSelection _getSelectionFromIndex(int n) {
                TwoDSelection twoDSelection;
                int n2 = this.getAccessibleColumnAtIndex(n);
                int n3 = this.getAccessibleRowAtIndex(n);
                TwoDModel twoDModel = PivotHeaderGrid.this.getModel();
                Object object = twoDModel.getData(n2, n3);
                if (object instanceof AbstractBigCell) {
                    AbstractBigCell abstractBigCell = (AbstractBigCell)object;
                    twoDSelection = new TwoDSelection(null, null, abstractBigCell.getColumn(), abstractBigCell.getRow(), abstractBigCell.getColumn() + abstractBigCell.getColumnCount() - 1, abstractBigCell.getRow() + abstractBigCell.getRowCount() - 1);
                } else {
                    twoDSelection = new TwoDSelection(n2, n3);
                }
                return twoDSelection;
            }

            private Cell _convertIndexToCell(int n) {
                int n2 = PivotHeaderGrid.this.getColumnCount();
                int n3 = PivotHeaderGrid.this.getRowCount();
                int n4 = -1;
                TwoDModel twoDModel = PivotHeaderGrid.this.getModel();
                int n5 = 0;
                while (n5 < n3) {
                    int n6 = 0;
                    while (n6 < n2) {
                        Object object = twoDModel.getData(n6, n5);
                        if (object != null && object instanceof AbstractBigCell) {
                            AbstractBigCell abstractBigCell = (AbstractBigCell)object;
                            if (abstractBigCell.getColumn() == n6 && abstractBigCell.getRow() == n5) {
                                ++n4;
                            }
                        } else {
                            ++n4;
                        }
                        if (n4 == n) {
                            return new Cell(n6, n5);
                        }
                        ++n6;
                    }
                    ++n5;
                }
                return null;
            }

            private int _convertCellToIndex(int n, int n2) {
                int n3 = PivotHeaderGrid.this.getColumnCount();
                int n4 = PivotHeaderGrid.this.getRowCount();
                int n5 = 0;
                TwoDModel twoDModel = PivotHeaderGrid.this.getModel();
                int n6 = 0;
                while (n6 < n4) {
                    int n7 = 0;
                    while (n7 < n3) {
                        if (n7 == n && n6 == n2) {
                            return n5;
                        }
                        Object object = twoDModel.getData(n7, n6);
                        if (object != null && object instanceof AbstractBigCell) {
                            AbstractBigCell abstractBigCell = (AbstractBigCell)object;
                            if (abstractBigCell.getColumn() == n7 && abstractBigCell.getRow() == n6) {
                                ++n5;
                            }
                        } else {
                            ++n5;
                        }
                        ++n7;
                    }
                    ++n6;
                }
                return -1;
            }

            private class PivotHeaderAccessibleGridCell
            extends Grid.AccessibleGrid.AccessibleGridCell
            implements AccessibleAction {
                public PivotHeaderAccessibleGridCell(int n) {
                    super(PivotHeaderAccessibleGrid.this, n);
                }

                public Rectangle getBounds() {
                    AbstractPivotHeaderCell abstractPivotHeaderCell = this._getPivotHeaderCell();
                    if (abstractPivotHeaderCell == null) {
                        return super.getBounds();
                    }
                    int n = abstractPivotHeaderCell.getColumn();
                    int n2 = abstractPivotHeaderCell.getRow();
                    int n3 = PivotHeaderGrid.this.getColumnPosition(n);
                    int n4 = PivotHeaderGrid.this.getRowPosition(n2);
                    int n5 = 0;
                    int n6 = 0;
                    int n7 = n;
                    while (n7 < n + abstractPivotHeaderCell.getColumnCount()) {
                        n5 += PivotHeaderGrid.this.getColumnWidth(n7);
                        ++n7;
                    }
                    int n8 = n2;
                    while (n8 < n2 + abstractPivotHeaderCell.getRowCount()) {
                        n6 += PivotHeaderGrid.this.getRowHeight(n8);
                        ++n8;
                    }
                    return new Rectangle(n3, n4, n5, n6);
                }

                public Dimension getSize() {
                    AbstractPivotHeaderCell abstractPivotHeaderCell = this._getPivotHeaderCell();
                    if (abstractPivotHeaderCell == null) {
                        return super.getSize();
                    }
                    int n = abstractPivotHeaderCell.getColumn();
                    int n2 = abstractPivotHeaderCell.getRow();
                    Rectangle rectangle = AbstractBigCell.getCellBounds(PivotHeaderGrid.this, n, n2);
                    return rectangle.getSize();
                }

                public AccessibleAction getAccessibleAction() {
                    return this;
                }

                public int getAccessibleActionCount() {
                    return 2;
                }

                public String getAccessibleActionDescription(int n) {
                    if (n < 0 || n >= this.getAccessibleActionCount()) {
                        return null;
                    }
                    switch (n) {
                        case 0: {
                            return PivotHeader.this.__getAccessibleString(PivotHeader._DRILL_KEY);
                        }
                        case 1: {
                            return PivotHeader.this.__getAccessibleString(PivotHeader._COLLAPSE_KEY);
                        }
                    }
                    return null;
                }

                public boolean doAccessibleAction(int n) {
                    if (n < 0 || n >= this.getAccessibleActionCount()) {
                        return false;
                    }
                    AbstractPivotHeaderCell abstractPivotHeaderCell = this._getPivotHeaderCell();
                    if (abstractPivotHeaderCell == null) {
                        return false;
                    }
                    int n2 = abstractPivotHeaderCell.getColumn();
                    int n3 = abstractPivotHeaderCell.getRow();
                    boolean bl = true;
                    switch (n) {
                        case 0: {
                            bl = PivotHeader.this.isDrillable(n2, n3);
                            if (!bl) break;
                            PivotHeader.this.fireHeaderCellDrillRequest(n2, n3);
                            break;
                        }
                        case 1: {
                            bl = PivotHeader.this.isCollapsable(n2, n3);
                            if (!bl) break;
                            PivotHeader.this.fireCollapse(n2, n3);
                        }
                    }
                    return bl;
                }

                private AbstractPivotHeaderCell _getPivotHeaderCell() {
                    int n = this.getAccessibleIndexInParent();
                    int n2 = PivotHeaderAccessibleGrid.this.getAccessibleRowAtIndex(n);
                    int n3 = PivotHeaderAccessibleGrid.this.getAccessibleColumnAtIndex(n);
                    return PivotHeader.this.getPivotHeaderCell(n3, n2);
                }
            }
        }
    }

    public class PivotHeaderHeader
    extends Header {
        public PivotHeaderHeader(OneDModel oneDModel, int n) {
            super(oneDModel, n);
        }

        public final Insets getAutoscrollInsets() {
            return new Insets(0, 0, 0, 0);
        }

        protected final void paintExtraCanvas(Graphics graphics, PaintContext paintContext, int n, int n2, int n3, int n4) {
            graphics.setColor(this.getAppearance().getBackground());
            graphics.fillRect(n, n2, n3, n4);
        }

        protected final void resetCursor() {
            if (PivotHeader.this.mouseItem == -1) {
                super.resetCursor();
            }
        }

        protected final int getItemPaintState(int n, int n2) {
            if (PivotHeader.this._dragIndex == n2 || PivotHeader.this._swapping & PivotHeader.this._dropIndex == n2) {
                n |= 2;
            } else if (PivotHeader.this._highlightItem == n2) {
                n |= 0x22;
            }
            return n;
        }

        protected final void processResizeEvent(HeaderEvent headerEvent) {
            super.processResizeEvent(headerEvent);
            if (headerEvent instanceof Cancelable && ((Cancelable)((Object)headerEvent)).isCancelled()) {
                return;
            }
            int n = headerEvent.getID();
            int n2 = headerEvent.getHeaderItem();
            if (n == 2006) {
                n2 = -1;
            }
            PivotHeader.this.setHeaderResizeItem(n2);
        }

        protected final void processMouseMotionEvent(MouseEvent mouseEvent) {
            PivotTable pivotTable = PivotHeader.this.getPivotTable();
            if (pivotTable != null) {
                pivotTable.freezeRepaints();
            }
            try {
                super.processMouseMotionEvent(mouseEvent);
                PivotHeader.this.updateHeaderResizeFeedback();
                Object var4_3 = null;
                if (pivotTable != null) {
                    pivotTable.unfreezeRepaints();
                }
            }
            catch (Throwable throwable) {
                Object var4_4 = null;
                if (pivotTable != null) {
                    pivotTable.unfreezeRepaints();
                }
                throw throwable;
            }
        }

        protected Header.AccessibleHeader createAccessibleHeader() {
            return new PivotHeaderAccessibleHeader();
        }

        public class PivotHeaderAccessibleHeader
        extends Header.AccessibleHeader {
            public PivotHeaderAccessibleHeader() {
                super(PivotHeaderHeader.this);
            }

            protected String getAccessibleName(int n, Object object) {
                String string;
                String string2 = string = object == null ? null : super.getAccessibleName(n, object);
                if (string == null) {
                    string = IntegerUtils.getString(n);
                }
                String string3 = PivotHeader.this.__getAccessibleString("PIVOT_HEADER.NAMED_LEVEL");
                MessageFormat messageFormat = new MessageFormat(string3);
                Object[] objectArray = new Object[]{string};
                string = messageFormat.format(objectArray);
                return string;
            }

            protected String getAccessibleNameForTable(int n, Object object, String string) {
                return string;
            }
        }
    }
}

