/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.ewt.pivot;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.Point;
import oracle.bali.ewt.grid.Grid;
import oracle.bali.ewt.header.Header;
import oracle.bali.ewt.table.SpreadTable;

final class PivotGridLayout
implements LayoutManager {
    Grid _grid;
    Header _rowHeader;
    Header _columnHeader;

    PivotGridLayout() {
    }

    public void addLayoutComponent(String string, Component component) {
        if (string.equals("grid")) {
            this._grid = (Grid)component;
        } else if (string.equals("rowHeader")) {
            this._rowHeader = (Header)component;
        } else if (string.equals("columnHeader")) {
            this._columnHeader = (Header)component;
        }
    }

    public void removeLayoutComponent(Component component) {
        if (component == this._grid) {
            this._grid = null;
        } else if (component == this._rowHeader) {
            this._rowHeader = null;
        } else if (component == this._columnHeader) {
            this._columnHeader = null;
        }
    }

    public Dimension preferredLayoutSize(Container container) {
        return ((SpreadTable)container).getPreferredSize();
    }

    public Dimension minimumLayoutSize(Container container) {
        return this.preferredLayoutSize(container);
    }

    public void layoutContainer(Container container) {
        int n;
        SpreadTable spreadTable = (SpreadTable)container;
        boolean bl = spreadTable.getActualReadingDirection() == 1;
        Dimension dimension = spreadTable.getSize();
        if (dimension.width == 0 || dimension.height == 0) {
            return;
        }
        int n2 = spreadTable.getRowHeaderWidth();
        int n3 = spreadTable.getColumnHeaderHeight();
        Point point = spreadTable.getInnerOrigin();
        int n4 = point.x;
        int n5 = point.y;
        if (spreadTable.isRowHeaderVisible() && this._rowHeader != null) {
            this._rowHeader.setVisible(true);
            n = bl ? point.x : dimension.width - n2 + point.x;
            this._rowHeader.setBounds(n, n3 + point.y, n2, dimension.height - n3);
        } else if (this._rowHeader != null) {
            this._rowHeader.setVisible(false);
        }
        if (spreadTable.isColumnHeaderVisible() && this._columnHeader != null) {
            this._columnHeader.setVisible(true);
            n = bl ? n2 + point.x : point.x;
            this._columnHeader.setBounds(n, point.y, dimension.width - n2, n3);
        } else if (this._columnHeader != null) {
            this._columnHeader.setVisible(false);
        }
        if (bl) {
            n4 += n2;
        }
        n5 += n3;
        n = dimension.width - n4 + 1;
        if (!bl && spreadTable.isRowHeaderVisible()) {
            n -= n2;
        }
        this._grid.setBounds(n4, n5, n, dimension.height - n5 + 1);
        if (spreadTable.isColumnHeaderVisible() && spreadTable.isRowHeaderVisible()) {
            Component component;
            if (bl) {
                component = spreadTable.getCornerComponent("UPPER_LEFT_CORNER");
                if (component != null) {
                    component.setBounds(point.x, point.y, n2, n3);
                }
            } else {
                component = spreadTable.getCornerComponent("UPPER_RIGHT_CORNER");
                if (component != null) {
                    component.setBounds(n4 + (dimension.width - n2), point.y, n2, n3);
                }
            }
            if (component != null) {
                component.setVisible(true);
            }
        }
    }
}

