/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.ewt.pivot;

import java.awt.Component;
import java.awt.Point;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.beans.PropertyVetoException;
import java.io.IOException;
import oracle.bali.ewt.dnd.DropTarget;
import oracle.bali.ewt.dnd.DropTargetDragEvent;
import oracle.bali.ewt.dnd.DropTargetDropEvent;
import oracle.bali.ewt.dnd.DropTargetEvent;
import oracle.bali.ewt.dnd.DropTargetListener;
import oracle.bali.ewt.grid.Grid;
import oracle.bali.ewt.header.Header;
import oracle.bali.ewt.model.TwoDModel;
import oracle.bali.ewt.pivot.PivotGrid;
import oracle.bali.ewt.pivot.PivotHeader;
import oracle.bali.ewt.pivot.PivotTable;
import oracle.bali.ewt.pivot.PivotTransfer;
import oracle.bali.share.datatransfer.TransferUtils;

class PivotGridDropAdapter
implements DropTargetListener {
    private PivotGrid _pivotGrid;
    private PivotHeader _pivotHeader;
    private Component _corner;
    private DropTarget _pivotGridDropTarget;
    private DropTarget _columnHeaderDropTarget;
    private DropTarget _rowHeaderDropTarget;
    private DropTarget _pivotGridGridDropTarget;
    private DropTarget _cornerDropTarget;

    public PivotGridDropAdapter(PivotGrid pivotGrid) {
        this._pivotGrid = pivotGrid;
        this._corner = this._pivotGrid.getCornerComponent("UPPER_LEFT_CORNER");
        this._pivotGridDropTarget = new DropTarget(this._pivotGrid, this);
        Header header = this._pivotGrid.getColumnHeader();
        if (header != null) {
            this._columnHeaderDropTarget = new DropTarget(header, this);
        }
        if ((header = this._pivotGrid.getRowHeader()) != null) {
            this._rowHeaderDropTarget = new DropTarget(header, this);
        }
        Grid grid = this._pivotGrid.getGrid();
        this._pivotGridGridDropTarget = new DropTarget(grid, this);
        this._cornerDropTarget = new DropTarget(this._corner, this);
    }

    public void dispose() {
        this._pivotGridDropTarget.setComponent(null);
        this._pivotGridDropTarget.removeDropTargetListener(this);
        this._pivotGridDropTarget = null;
        this._columnHeaderDropTarget.setComponent(null);
        this._columnHeaderDropTarget.removeDropTargetListener(this);
        this._columnHeaderDropTarget = null;
        this._rowHeaderDropTarget.setComponent(null);
        this._rowHeaderDropTarget.removeDropTargetListener(this);
        this._rowHeaderDropTarget = null;
        this._pivotGridGridDropTarget.setComponent(null);
        this._pivotGridGridDropTarget.removeDropTargetListener(this);
        this._pivotGridGridDropTarget = null;
        this._cornerDropTarget.setComponent(null);
        this._cornerDropTarget.removeDropTargetListener(this);
        this._cornerDropTarget = null;
        this._pivotGrid = null;
        this._pivotHeader = null;
        this._corner = null;
    }

    public void dragEnter(DropTargetDragEvent dropTargetDragEvent) {
    }

    public void dragOver(DropTargetDragEvent dropTargetDragEvent) {
        if (!this._acceptDrag(dropTargetDragEvent)) {
            dropTargetDragEvent.rejectDrag();
            return;
        }
        this._updateFeedback(dropTargetDragEvent.getDropTargetContext().getComponent(), dropTargetDragEvent.getLocation());
    }

    public void dragScroll(DropTargetDragEvent dropTargetDragEvent) {
    }

    public void dragExit(DropTargetEvent dropTargetEvent) {
        this._updatePivotHeader(null);
    }

    public void dropActionChanged(DropTargetDragEvent dropTargetDragEvent) {
    }

    public void drop(DropTargetDropEvent dropTargetDropEvent) {
        dropTargetDropEvent.acceptDrop(1);
        this._updatePivotHeader(null);
        Transferable transferable = dropTargetDropEvent.getTransferable();
        Object object = null;
        try {
            object = transferable.getTransferData(PivotTransfer.DATA_FLAVOR);
        }
        catch (IOException iOException) {
            object = null;
        }
        catch (UnsupportedFlavorException unsupportedFlavorException) {
            object = null;
        }
        boolean bl = false;
        if (object != null && object instanceof PivotTransfer) {
            PivotTransfer pivotTransfer = (PivotTransfer)object;
            Object object2 = pivotTransfer.getSource();
            int n = pivotTransfer.getIndex();
            PivotHeader pivotHeader = this._getPivotHeader(dropTargetDropEvent.getDropTargetContext().getComponent(), dropTargetDropEvent.getLocation());
            int n2 = this._getIndex(pivotHeader);
            PivotTable pivotTable = this._pivotGrid.getPivotTable();
            boolean bl2 = true;
            if (object2 == pivotHeader) {
                if (n < n2) {
                    --n2;
                }
                if (n == n2) {
                    bl2 = false;
                }
            }
            if (bl2) {
                try {
                    pivotTable.deselectAll();
                }
                catch (PropertyVetoException propertyVetoException) {
                    // empty catch block
                }
                pivotTable.firePivotEvent(object2, n, pivotHeader, n2);
            }
            bl = true;
        }
        dropTargetDropEvent.dropComplete(bl);
    }

    private boolean _acceptDrag(DropTargetDragEvent dropTargetDragEvent) {
        if (!this._pivotGrid.isEnabled()) {
            return false;
        }
        DataFlavor[] dataFlavorArray = dropTargetDragEvent.getCurrentDataFlavors();
        if (dataFlavorArray == null) {
            return false;
        }
        int n = 0;
        while (n < dataFlavorArray.length) {
            if (TransferUtils.supportsDataFlavor(dataFlavorArray[n], PivotTransfer.DATA_FLAVOR)) {
                return true;
            }
            ++n;
        }
        return false;
    }

    private PivotHeader _getPivotHeader(Component component, Point point) {
        PivotHeader pivotHeader = null;
        if (component == this._pivotGrid || component == this._pivotGrid.getGrid() || component == this._corner) {
            boolean bl;
            boolean bl2 = bl = this._pivotGrid.getActualReadingDirection() == 1;
            pivotHeader = bl ? (point.x >= point.y ? this._getHorizontalHeader() : this._getVerticalHeader()) : (component.getSize().width - point.x >= point.y ? this._getHorizontalHeader() : this._getVerticalHeader());
        } else if (component == this._pivotGrid.getColumnHeader()) {
            pivotHeader = this._getHorizontalHeader();
        } else if (component == this._pivotGrid.getRowHeader()) {
            pivotHeader = this._getVerticalHeader();
        }
        return pivotHeader;
    }

    private void _updateFeedback(Component component, Point point) {
        PivotHeader pivotHeader = this._getPivotHeader(component, point);
        this._updatePivotHeader(pivotHeader);
    }

    private void _updatePivotHeader(PivotHeader pivotHeader) {
        if (this._pivotHeader != pivotHeader && this._pivotHeader != null) {
            this._pivotHeader.setDropLocation(-1, false);
        }
        this._pivotHeader = pivotHeader;
        if (this._pivotHeader != null) {
            int n = this._getIndex(pivotHeader);
            this._pivotHeader.setDropLocation(n, false);
        }
    }

    private int _getIndex(PivotHeader pivotHeader) {
        boolean bl = pivotHeader.getOrientation() == 0;
        TwoDModel twoDModel = pivotHeader.getModel();
        return bl ? twoDModel.getRowCount() : twoDModel.getColumnCount();
    }

    private PivotHeader _getHorizontalHeader() {
        return this._pivotGrid.getPivotTable().getColumnPivotHeader();
    }

    private PivotHeader _getVerticalHeader() {
        return this._pivotGrid.getPivotTable().getRowPivotHeader();
    }
}

