/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.ewt.pivot;

import java.awt.AWTEvent;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.io.Serializable;
import java.util.Dictionary;
import java.util.Enumeration;
import javax.accessibility.Accessible;
import javax.accessibility.AccessibleContext;
import javax.accessibility.AccessibleSelection;
import javax.accessibility.AccessibleState;
import javax.accessibility.AccessibleStateSet;
import javax.swing.JComponent;
import javax.swing.JViewport;
import javax.swing.KeyStroke;
import javax.swing.Scrollable;
import javax.swing.UIManager;
import oracle.bali.ewt.LWComponent;
import oracle.bali.ewt.dnd.DragGestureEvent;
import oracle.bali.ewt.dnd.DragGestureListener;
import oracle.bali.ewt.dnd.DragGestureRecognizer;
import oracle.bali.ewt.dnd.DragSource;
import oracle.bali.ewt.dnd.DragSourceDragEvent;
import oracle.bali.ewt.dnd.DragSourceDropEvent;
import oracle.bali.ewt.dnd.DragSourceEvent;
import oracle.bali.ewt.dnd.DragSourceListener;
import oracle.bali.ewt.dnd.DropTarget;
import oracle.bali.ewt.dnd.DropTargetDragEvent;
import oracle.bali.ewt.dnd.DropTargetDropEvent;
import oracle.bali.ewt.dnd.DropTargetEvent;
import oracle.bali.ewt.dnd.DropTargetListener;
import oracle.bali.ewt.dnd.JFCSupport;
import oracle.bali.ewt.elaf.EWTPagingComponentUI;
import oracle.bali.ewt.painter.PaintContext;
import oracle.bali.ewt.pivot.PageItem;
import oracle.bali.ewt.pivot.PagingPivotEvent;
import oracle.bali.ewt.pivot.PagingPivotListener;
import oracle.bali.ewt.pivot.PivotTransfer;
import oracle.bali.ewt.print.PrinterUtils;
import oracle.bali.ewt.util.ImmInsets;
import oracle.bali.share.datatransfer.TransferUtils;
import oracle.bali.share.event.ListenerManager;

public class PagingComponent
extends LWComponent
implements Scrollable,
Accessible {
    public static final Object PRINT_RAISED = "pagingComponent.printRaised";
    public static final String PROPERTY_SELECTION = "selectedIndex";
    private static final KeyStroke _KEY_STROKE_LEFT = KeyStroke.getKeyStroke(37, 0);
    private static final KeyStroke _KEY_STROKE_RIGHT = KeyStroke.getKeyStroke(39, 0);
    private static final String _DRAG_GESTURE_RECOGNIZER = "oracle.bali.ewt.pivot.PagingComponent.DRAG_GESTURE_RECOGNIZER";
    static final String COMMAND_LEFT = "LEFT";
    static final String COMMAND_RIGHT = "RIGHT";
    static final int _MIN_HEIGHT = 30;
    private static final int _VINSETS = 5;
    private static final int _FEEDBACK_SIZE = 5;
    private static final int _PIVOT_SIZE = 6;
    private PageItem _dragComponent;
    private int _dragIndex = -1;
    private int _dropIndex = -1;
    private PageItem _selectedItem;
    private boolean _allowSwap;
    private boolean _swapping;
    private DragGestureListener _draggy;
    private DropTargetListener _droppy;
    private ListenerManager _pivotListeners;
    private UIListener _listener;
    private boolean _prefSizeSet;
    private DropTarget _dropTarget;

    public PagingComponent() {
        this(null);
    }

    public PagingComponent(PageItem[] pageItemArray) {
        this.setLayout(null);
        this._listener = new UIListener();
        this._droppy = new Droppy();
        this._draggy = new Draggy();
        this.enableEvents(16L);
        if (pageItemArray != null) {
            int n = 0;
            while (n < pageItemArray.length) {
                this.add(pageItemArray[n]);
                ++n;
            }
        }
        this._dropTarget = new DropTarget(this, this._droppy);
        this.updateUI();
    }

    public void dispose() {
        if (this._dropTarget == null) {
            return;
        }
        Component[] componentArray = this.getComponents();
        int n = componentArray == null ? 0 : componentArray.length;
        int n2 = 0;
        while (n2 < n) {
            this.remove(componentArray[n2]);
            if (componentArray[n2] instanceof PageItem) {
                ((PageItem)componentArray[n2]).dispose();
            }
            ++n2;
        }
        this._dropTarget.setComponent(null);
        this._dropTarget.removeDropTargetListener(this._droppy);
        this._dropTarget = null;
        this._listener = null;
        this._droppy = null;
        this._draggy = null;
        this._dragComponent = null;
        this._selectedItem = null;
        this._pivotListeners = null;
    }

    public PageItem getItem(int n) {
        Component component = this.getComponent(n);
        return component instanceof PageItem ? (PageItem)component : null;
    }

    public int getIndex(PageItem pageItem) {
        return this._getIndex(pageItem);
    }

    public void setSelectedItem(PageItem pageItem) {
        if (this._selectedItem != pageItem) {
            PageItem pageItem2 = this._selectedItem;
            if (this._selectedItem != null) {
                this._selectedItem.setSelected(false);
            }
            this._selectedItem = pageItem;
            if (this._selectedItem != null) {
                this._selectedItem.setSelected(true);
                this._ensureVisible(this._selectedItem);
            }
            this.firePropertyChange(PROPERTY_SELECTION, pageItem2, this._selectedItem);
            this.repaint();
        }
    }

    public PageItem getSelectedItem() {
        return this._selectedItem;
    }

    public void setSwapAllowed(boolean bl) {
        this._allowSwap = bl;
    }

    public boolean isSwapAllowed() {
        return this._allowSwap;
    }

    public synchronized void addPivotListener(PagingPivotListener pagingPivotListener) {
        if (this._pivotListeners == null) {
            this._pivotListeners = new ListenerManager();
        }
        this._pivotListeners.addListener(pagingPivotListener);
    }

    public synchronized void removePivotListener(PagingPivotListener pagingPivotListener) {
        if (this._pivotListeners != null) {
            this._pivotListeners.removeListener(pagingPivotListener);
        }
    }

    public Dimension getPreferredScrollableViewportSize() {
        return this.getPreferredSize();
    }

    public int getScrollableUnitIncrement(Rectangle rectangle, int n, int n2) {
        int n3 = 0;
        if (1 == n) {
            return n3;
        }
        ImmInsets immInsets = this.getBorderInsets();
        rectangle.x += immInsets.left;
        Component component = this.getComponentAt(rectangle.x, this.getHeight() / 2);
        if (component == null || component == this) {
            return n3;
        }
        int n4 = this._getIndex(component);
        if (n2 < 0) {
            int n5 = rectangle.x - component.getLocation().x;
            if (n4 == 0) {
                n3 = n5 > rectangle.width ? rectangle.width : n5;
            } else if (n5 == 0) {
                int n6;
                component = this.getComponent(n4 - 1);
                n3 = n6 = component.getSize().width;
                if (n4 == 1 && n6 > rectangle.width) {
                    n3 = rectangle.width;
                }
            } else {
                n3 = n5;
            }
        } else {
            int n7;
            int n8;
            n3 = n4 != this.getComponentCount() - 1 ? component.getSize().width : ((n8 = component.getSize().width - (n7 = rectangle.x - component.getLocation().x)) > rectangle.width ? rectangle.width : n8);
        }
        return n3;
    }

    public int getScrollableBlockIncrement(Rectangle rectangle, int n, int n2) {
        return this.getScrollableUnitIncrement(rectangle, n, n2);
    }

    public boolean getScrollableTracksViewportWidth() {
        int n;
        int n2 = this.getPreferredSize().width;
        if (this.getParent() instanceof JViewport) {
            JViewport jViewport = (JViewport)this.getParent();
            n = jViewport.getExtentSize().width;
        } else {
            n = n2;
        }
        return n > n2;
    }

    public boolean getScrollableTracksViewportHeight() {
        return true;
    }

    public void printPage(PaintContext paintContext, Dictionary dictionary, Graphics graphics) {
        Shape shape = graphics.getClip();
        Rectangle rectangle = graphics.getClipBounds();
        this.freezeRepaints();
        try {
            boolean bl = PrinterUtils.getPrinterProperty(dictionary, PRINT_RAISED, false);
            int n = this.getComponentCount();
            int n2 = 0;
            int n3 = 0;
            int n4 = 0;
            ImmInsets immInsets = this.getBorderInsets();
            int n5 = this.getPreferredSize().height - (immInsets.top + immInsets.bottom + 4);
            int n6 = 0;
            while (n6 < n) {
                Component component = this.getComponent(n6);
                if (component instanceof PageItem) {
                    PageItem pageItem = (PageItem)component;
                    Dimension dimension = pageItem.getDocumentSize(paintContext, dictionary);
                    if (n2 + dimension.width > rectangle.width) {
                        graphics.translate(0, n3);
                        graphics.setClip(0, 0, 2, n4);
                        graphics.setColor(Color.black);
                        graphics.drawLine(0, 0, 0, n4);
                        graphics.translate(0, -n3);
                        n3 += n5;
                        n2 = 0;
                        n4 = 0;
                    }
                    graphics.translate(n2, n3);
                    graphics.setClip(0, 0, dimension.width, n5);
                    boolean bl2 = pageItem.isDrawRaised();
                    pageItem.setDrawRaised(bl);
                    pageItem.printPage(paintContext, dictionary, graphics);
                    pageItem.setDrawRaised(bl2);
                    graphics.translate(-n2, -n3);
                    n2 += dimension.width;
                    if (dimension.height + 1 > n4) {
                        n4 = dimension.height + 1;
                    }
                }
                ++n6;
            }
            graphics.translate(0, n3);
            graphics.setClip(0, 0, 2, n4);
            graphics.setColor(Color.black);
            graphics.drawLine(0, 0, 0, n4);
            graphics.translate(0, -n3);
            Object var19_18 = null;
            this.unfreezeRepaints();
        }
        catch (Throwable throwable) {
            Object var19_19 = null;
            this.unfreezeRepaints();
            throw throwable;
        }
        graphics.setClip(shape);
    }

    public Dimension getDocumentSize(PaintContext paintContext, Dictionary dictionary) {
        return this.getPreferredSize();
    }

    public Rectangle getPageBounds(PaintContext paintContext, Dictionary dictionary, int n, int n2, int n3, int n4) {
        Dimension dimension = this.getPreferredSize();
        ImmInsets immInsets = this.getBorderInsets();
        int n5 = dimension.height - (immInsets.top + immInsets.bottom + 4);
        if (dimension.width >= n3) {
            int n6 = 0;
            int n7 = this.getComponentCount();
            int n8 = 0;
            int n9 = 1;
            int n10 = 0;
            while (n10 < n7) {
                Component component = this.getComponent(n10);
                if (component instanceof PageItem) {
                    PageItem pageItem = (PageItem)component;
                    Dimension dimension2 = pageItem.getDocumentSize(paintContext, dictionary);
                    if (n8 + dimension2.width > n3) {
                        ++n9;
                        if (n8 > n6) {
                            n6 = n8;
                        }
                        n8 = 0;
                    }
                    n8 += dimension2.width;
                }
                ++n10;
            }
            n3 = n6;
            n4 = n9 * n5;
            n = dimension.width;
        } else {
            n = n3;
            n4 = dimension.height;
        }
        return new Rectangle(n, n4, n3, n4);
    }

    public AccessibleContext getAccessibleContext() {
        if (this.accessibleContext == null) {
            this.accessibleContext = new AccessiblePagingComponent();
        }
        return this.accessibleContext;
    }

    public String getUIClassID() {
        return "EWTPagingComponentUI";
    }

    public void updateUI() {
        this.setUI((EWTPagingComponentUI)UIManager.getUI(this));
    }

    public void doLayout() {
        ImmInsets immInsets = this.getBorderInsets();
        int n = this.getHeight() - (immInsets.top + immInsets.bottom);
        Component[] componentArray = this.getComponents();
        int n2 = componentArray == null ? 0 : componentArray.length;
        int n3 = immInsets.left;
        int n4 = 0;
        while (n4 < n2) {
            Component component = componentArray[n4];
            Dimension dimension = component.getPreferredSize();
            component.setBounds(n3, immInsets.top, dimension.width, n);
            n3 += dimension.width;
            ++n4;
        }
    }

    public void setPreferredSize(Dimension dimension) {
        super.setPreferredSize(dimension);
        this._prefSizeSet = true;
    }

    public Dimension getPreferredSize() {
        Object object;
        if (this._prefSizeSet) {
            return super.getPreferredSize();
        }
        int n = 5;
        int n2 = 30;
        Component[] componentArray = this.getComponents();
        int n3 = componentArray == null ? 0 : componentArray.length;
        int n4 = 0;
        while (n4 < n3) {
            object = componentArray[n4];
            Dimension dimension = ((Component)object).getPreferredSize();
            n += dimension.width;
            if (dimension.height > n2) {
                n2 = dimension.height;
            }
            ++n4;
        }
        object = this.getBorderInsets();
        return new Dimension(n += ((ImmInsets)object).left + ((ImmInsets)object).right, n2 += ((ImmInsets)object).top + ((ImmInsets)object).bottom);
    }

    public void remove(int n) {
        Object object;
        Component component = this.getComponent(n);
        super.remove(n);
        this._removeDropTarget(component);
        if (component instanceof PageItem) {
            this._removeDragListener(component);
        }
        component.removeMouseListener(this._listener);
        component.removeFocusListener(this._listener);
        if (component instanceof JComponent) {
            object = (JComponent)component;
            ((Component)object).removePropertyChangeListener(this._listener);
            this._unregisterKeyStrokes((JComponent)object);
        }
        if (this._selectedItem == component) {
            this.setSelectedItem(null);
        }
        if ((object = this.accessibleContext) != null && component instanceof Accessible) {
            ((AccessibleContext)object).firePropertyChange("AccessibleChild", component, null);
        }
        this.revalidate();
        this.repaint();
    }

    public void removeAll() {
        int n = this.getComponentCount();
        int n2 = 0;
        while (n2 < n) {
            this.remove(0);
            ++n2;
        }
        this.setSelectedItem(null);
        this.revalidate();
        this.repaint();
    }

    public void addNotify() {
        super.addNotify();
        Container container = this.getParent();
        if (container instanceof JViewport) {
            DropTarget dropTarget = new DropTarget(container, this._droppy);
        }
    }

    public void removeNotify() {
        super.removeNotify();
        Container container = this.getParent();
        if (container instanceof JViewport) {
            JFCSupport.setEWTDropTarget((JComponent)container, null);
        }
    }

    protected void addImpl(Component component, Object object, int n) {
        Object object2;
        super.addImpl(component, object, n);
        this._addDropTarget(component);
        if (component instanceof PageItem) {
            this._addDragListener((PageItem)component);
        }
        component.addMouseListener(this._listener);
        component.addFocusListener(this._listener);
        if (component instanceof JComponent) {
            object2 = (JComponent)component;
            ((Container)object2).addPropertyChangeListener(this._listener);
            this._registerKeyStrokes((JComponent)object2);
        }
        if (component instanceof Accessible && (object2 = this.accessibleContext) != null) {
            ((Accessible)((Object)component)).getAccessibleContext().setAccessibleParent(this);
            ((AccessibleContext)object2).firePropertyChange("AccessibleChild", null, component);
        }
        this.revalidate();
        this.repaint();
    }

    protected void processEventImpl(AWTEvent aWTEvent) {
        if (aWTEvent instanceof PagingPivotEvent) {
            this.processPivotEvent((PagingPivotEvent)aWTEvent);
        } else {
            super.processEventImpl(aWTEvent);
        }
    }

    protected void processPivotEvent(PagingPivotEvent pagingPivotEvent) {
        if (this._pivotListeners == null) {
            return;
        }
        Enumeration enumeration = this._pivotListeners.getListeners();
        if (enumeration == null) {
            return;
        }
        switch (pagingPivotEvent.getID()) {
            case 2001: {
                while (enumeration.hasMoreElements()) {
                    ((PagingPivotListener)enumeration.nextElement()).pivot(pagingPivotEvent);
                }
                break;
            }
            case 2002: {
                while (enumeration.hasMoreElements()) {
                    ((PagingPivotListener)enumeration.nextElement()).swap(pagingPivotEvent);
                }
                break;
            }
        }
    }

    protected void processMouseEvent(MouseEvent mouseEvent) {
        super.processMouseEvent(mouseEvent);
        if (mouseEvent.isConsumed() || !this.isEnabled() || mouseEvent.getID() != 501) {
            return;
        }
        this.setSelectedItem(null);
    }

    protected void paintOverChildren(Graphics graphics) {
        if (!this._swapping && this._dropIndex != -1) {
            Serializable serializable;
            int n;
            if (this._dragComponent != null && ((n = this._getIndex(this._dragComponent)) == this._dropIndex || n + 1 == this._dropIndex)) {
                return;
            }
            int n2 = this.getComponentCount();
            if (this._dropIndex == n2) {
                if (n2 == 0) {
                    n = 0;
                } else {
                    serializable = this.getComponent(n2 - 1);
                    n = ((Component)serializable).getLocation().x + ((Component)serializable).getSize().width;
                }
            } else {
                n = this.getComponent((int)this._dropIndex).getLocation().x;
            }
            serializable = graphics.getColor();
            graphics.setColor(Color.black);
            ImmInsets immInsets = this.getBorderInsets();
            Rectangle rectangle = new Rectangle(immInsets.left, immInsets.top, this.getWidth() - (immInsets.left + immInsets.right), this.getHeight() - (immInsets.top + immInsets.bottom));
            int n3 = n - 2;
            if (n3 < rectangle.x) {
                n3 = rectangle.x;
            }
            if (n3 + 5 > rectangle.width) {
                n3 = rectangle.width - 5;
            }
            graphics.fillRect(n3, rectangle.y, 5, rectangle.height);
            if (serializable != null) {
                graphics.setColor((Color)serializable);
            }
        }
    }

    EWTPagingComponentUI getUI() {
        return (EWTPagingComponentUI)this.ui;
    }

    Image getDragImage(int n) {
        PageItem pageItem = this.getItem(n);
        return pageItem == null ? null : pageItem.getDragImage();
    }

    final void firePivotEvent(Object object, int n, Object object2, int n2) {
        PagingPivotEvent pagingPivotEvent = new PagingPivotEvent(object, 2001, object2, n, n2);
        this.processEvent(pagingPivotEvent);
    }

    final void fireSwapEvent(Object object, int n, Object object2, int n2) {
        PagingPivotEvent pagingPivotEvent = new PagingPivotEvent(object, 2002, object2, n, n2);
        this.processEvent(pagingPivotEvent);
    }

    boolean isSwap(Component component, Point point) {
        boolean bl = false;
        if (this.isSwapAllowed() && component != this && component != this.getParent()) {
            bl = point.x >= 6 && point.x <= component.getSize().width - 6;
        }
        return bl;
    }

    private PageItem _convertPointAndFindPageItem(Component component, Point point) {
        if (component instanceof PageItem) {
            return (PageItem)component;
        }
        if (component == null) {
            return null;
        }
        Point point2 = component.getLocation();
        point.x += point2.x;
        point.y += point2.y;
        return this._convertPointAndFindPageItem(component.getParent(), point);
    }

    int getIndex(Component component, Point point, boolean bl) {
        if (component == this || component == this.getParent()) {
            return this.getComponentCount();
        }
        int n = this._getIndex(component);
        if (!bl && point.x > component.getSize().width / 2) {
            ++n;
        }
        return n;
    }

    void setDropLocation(int n, boolean bl) {
        if (this._dropIndex != n || bl != this._swapping) {
            PageItem pageItem;
            if (this._dropIndex != -1 && this._dropIndex < this.getComponentCount() && (pageItem = this.getItem(this._dropIndex)) != null) {
                pageItem.setSwapping(false);
            }
            this._dropIndex = n;
            this._swapping = bl;
            if (this._dropIndex != -1 && this._dropIndex < this.getComponentCount() && (pageItem = this.getItem(this._dropIndex)) != null) {
                pageItem.setSwapping(bl);
            }
            this.repaint();
        }
    }

    boolean acceptDrag(DropTargetDragEvent dropTargetDragEvent) {
        if (!this.isEnabled()) {
            return false;
        }
        DataFlavor[] dataFlavorArray = dropTargetDragEvent.getCurrentDataFlavors();
        if (dataFlavorArray == null) {
            return false;
        }
        int n = 0;
        while (n < dataFlavorArray.length) {
            if (TransferUtils.supportsDataFlavor(dataFlavorArray[n], PivotTransfer.DATA_FLAVOR)) {
                return true;
            }
            ++n;
        }
        return false;
    }

    void moveRight() {
        int n;
        int n2 = this.getComponentCount();
        if (n2 == 0) {
            return;
        }
        int n3 = n = this._selectedItem == null ? 0 : this._getIndex(this._selectedItem);
        if (++n > n2 - 1) {
            n = n2 - 1;
        }
        PageItem pageItem = this.getItem(n);
        this.setSelectedItem(pageItem);
        if (pageItem != null) {
            pageItem.requestFocus();
        }
    }

    void moveLeft() {
        int n;
        int n2 = this.getComponentCount();
        if (n2 == 0) {
            return;
        }
        int n3 = n = this._selectedItem == null ? 0 : this._getIndex(this._selectedItem);
        if (--n < 0) {
            n = 0;
        }
        PageItem pageItem = this.getItem(n);
        this.setSelectedItem(pageItem);
        if (pageItem != null) {
            pageItem.requestFocus();
        }
    }

    private void _ensureVisible(PageItem pageItem) {
        this.scrollRectToVisible(pageItem.getBounds());
    }

    private int _getIndex(Component component) {
        int n = -1;
        int n2 = this.getComponentCount();
        int n3 = 0;
        while (n3 < n2) {
            if (this.getComponent(n3) == component) {
                n = n3;
                break;
            }
            ++n3;
        }
        return n;
    }

    private void _addDropTarget(Component component) {
        DropTarget dropTarget = new DropTarget(component, this._droppy);
        if (component instanceof Container) {
            Container container = (Container)component;
            int n = container.getComponentCount();
            int n2 = 0;
            while (n2 < n) {
                this._addDropTarget(container.getComponent(n2));
                ++n2;
            }
        }
    }

    private void _addDragListener(Component component) {
        Container container;
        DragGestureRecognizer dragGestureRecognizer = DragSource.getDefaultDragSource().createDefaultDragGestureRecognizer(component, 2, this._draggy);
        if (component instanceof JComponent) {
            container = (JComponent)component;
            ((JComponent)container).putClientProperty(_DRAG_GESTURE_RECOGNIZER, dragGestureRecognizer);
        }
        if (component instanceof Container) {
            container = (Container)component;
            int n = container.getComponentCount();
            int n2 = 0;
            while (n2 < n) {
                this._addDragListener(container.getComponent(n2));
                ++n2;
            }
        }
    }

    private void _removeDragListener(Component component) {
        Container container;
        if (component instanceof JComponent) {
            container = (JComponent)component;
            Object object = ((JComponent)container).getClientProperty(_DRAG_GESTURE_RECOGNIZER);
            if (object instanceof DragGestureRecognizer) {
                DragGestureRecognizer dragGestureRecognizer = (DragGestureRecognizer)object;
                dragGestureRecognizer.setComponent(null);
                dragGestureRecognizer.removeDragGestureListener(this._draggy);
            }
            ((JComponent)container).putClientProperty(_DRAG_GESTURE_RECOGNIZER, null);
        }
        if (component instanceof Container) {
            container = (Container)component;
            int n = container.getComponentCount();
            int n2 = 0;
            while (n2 < n) {
                this._removeDragListener(container.getComponent(n2));
                ++n2;
            }
        }
    }

    private void _removeDropTarget(Component component) {
        if (component instanceof JComponent) {
            JComponent jComponent = (JComponent)component;
            DropTarget dropTarget = JFCSupport.getEWTDropTarget(jComponent);
            if (dropTarget != null) {
                dropTarget.setComponent(null);
                dropTarget.removeDropTargetListener(this._droppy);
            }
            JFCSupport.setEWTDropTarget(jComponent, null);
            int n = jComponent.getComponentCount();
            int n2 = 0;
            while (n2 < n) {
                this._removeDropTarget(jComponent.getComponent(n2));
                ++n2;
            }
        }
    }

    private void _registerKeyStrokes(JComponent jComponent) {
        UIListener uIListener = this._listener;
        jComponent.registerKeyboardAction(uIListener, COMMAND_LEFT, _KEY_STROKE_LEFT, 0);
        jComponent.registerKeyboardAction(uIListener, COMMAND_RIGHT, _KEY_STROKE_RIGHT, 0);
    }

    private void _unregisterKeyStrokes(JComponent jComponent) {
        jComponent.unregisterKeyboardAction(_KEY_STROKE_LEFT);
        jComponent.unregisterKeyboardAction(_KEY_STROKE_RIGHT);
    }

    private class Droppy
    implements DropTargetListener {
        private Droppy() {
        }

        public void dragEnter(DropTargetDragEvent dropTargetDragEvent) {
            if (!PagingComponent.this.acceptDrag(dropTargetDragEvent)) {
                dropTargetDragEvent.rejectDrag();
                return;
            }
            Component component = dropTargetDragEvent.getDropTargetContext().getComponent();
            Point point = dropTargetDragEvent.getLocation();
            if (component != PagingComponent.this && component != PagingComponent.this.getParent()) {
                component = PagingComponent.this._convertPointAndFindPageItem(component, point);
            }
            boolean bl = PagingComponent.this.isSwap(component, point);
            int n = PagingComponent.this.getIndex(component, point, bl);
            PagingComponent.this.setDropLocation(n, bl);
        }

        public void dragOver(DropTargetDragEvent dropTargetDragEvent) {
            if (!PagingComponent.this.acceptDrag(dropTargetDragEvent)) {
                dropTargetDragEvent.rejectDrag();
                return;
            }
            Component component = dropTargetDragEvent.getDropTargetContext().getComponent();
            Point point = dropTargetDragEvent.getLocation();
            if (component != PagingComponent.this && component != PagingComponent.this.getParent()) {
                component = PagingComponent.this._convertPointAndFindPageItem(component, point);
            }
            boolean bl = PagingComponent.this.isSwap(component, point);
            int n = PagingComponent.this.getIndex(component, point, bl);
            PagingComponent.this.setDropLocation(n, bl);
        }

        public void dragExit(DropTargetEvent dropTargetEvent) {
            PagingComponent.this.setDropLocation(-1, false);
        }

        public void drop(DropTargetDropEvent dropTargetDropEvent) {
            if (PagingComponent.this._dragComponent != null && PagingComponent.this._dropIndex != -1 && PagingComponent.this._getIndex(PagingComponent.this._dragComponent) == PagingComponent.this._dropIndex) {
                dropTargetDropEvent.rejectDrop();
                PagingComponent.this.setDropLocation(-1, false);
                PagingComponent.this.repaint();
                return;
            }
            int n = PagingComponent.this._dropIndex;
            boolean bl = PagingComponent.this._swapping;
            PagingComponent.this.setDropLocation(-1, false);
            PagingComponent.this.repaint();
            Transferable transferable = dropTargetDropEvent.getTransferable();
            Object object = null;
            try {
                object = transferable.getTransferData(PivotTransfer.DATA_FLAVOR);
            }
            catch (IOException iOException) {
                object = null;
            }
            catch (UnsupportedFlavorException unsupportedFlavorException) {
                object = null;
            }
            boolean bl2 = false;
            if (object != null && object instanceof PivotTransfer) {
                PivotTransfer pivotTransfer = (PivotTransfer)object;
                Object object2 = pivotTransfer.getSource();
                int n2 = pivotTransfer.getIndex();
                if (!bl) {
                    if ((object2 == PagingComponent.this || object2 == PagingComponent.this.getParent()) && n2 < n) {
                        --n;
                    }
                    PagingComponent.this.firePivotEvent(object2, n2, PagingComponent.this, n);
                } else {
                    PagingComponent.this.fireSwapEvent(object2, n2, PagingComponent.this, n);
                }
                bl2 = true;
            }
            dropTargetDropEvent.dropComplete(bl2);
        }

        public void dropActionChanged(DropTargetDragEvent dropTargetDragEvent) {
        }
    }

    private class Draggy
    implements DragGestureListener,
    DragSourceListener {
        private Draggy() {
        }

        public void dragGestureRecognized(DragGestureEvent dragGestureEvent) {
            Point point = dragGestureEvent.getDragOrigin();
            Component component = dragGestureEvent.getComponent();
            PageItem pageItem = this._getPageItem(component);
            if (pageItem != null && pageItem.isDragEnabled()) {
                int n = PagingComponent.this._getIndex(pageItem);
                Image image = PagingComponent.this.getDragImage(n);
                PagingComponent.this._dragComponent = pageItem;
                PagingComponent.this._dragIndex = n;
                PagingComponent.this._dragComponent.setDragging(true);
                Transferable transferable = PivotTransfer.createTransferable(PagingComponent.this, n);
                dragGestureEvent.startDrag(null, image, new Point(5, -point.y), transferable, this);
            }
        }

        public void dragDropEnd(DragSourceDropEvent dragSourceDropEvent) {
            if (PagingComponent.this._dragComponent != null) {
                int n;
                if (PagingComponent.this._dragComponent.isShowing()) {
                    PagingComponent.this._dragComponent.requestFocus();
                } else if (PagingComponent.this._dragIndex != -1 && (n = PagingComponent.this.getComponentCount()) != 0) {
                    int n2 = PagingComponent.this._dragIndex - 1;
                    if (n2 < 0) {
                        n2 = 0;
                    }
                    if (n2 >= n) {
                        n2 = n - 1;
                    }
                    PagingComponent.this.getComponent(n2).requestFocus();
                }
                PagingComponent.this._dragComponent.setDragging(false);
                PagingComponent.this._dragComponent = null;
                PagingComponent.this._dragIndex = -1;
            }
            PagingComponent.this.repaint();
        }

        public void dragEnter(DragSourceDragEvent dragSourceDragEvent) {
        }

        public void dragOver(DragSourceDragEvent dragSourceDragEvent) {
        }

        public void dropActionChanged(DragSourceDragEvent dragSourceDragEvent) {
        }

        public void dragExit(DragSourceEvent dragSourceEvent) {
        }

        private PageItem _getPageItem(Component component) {
            if (component == null) {
                return null;
            }
            if (component instanceof PageItem) {
                return (PageItem)component;
            }
            return this._getPageItem(component.getParent());
        }
    }

    private class UIListener
    extends MouseAdapter
    implements PropertyChangeListener,
    ActionListener,
    FocusListener {
        private UIListener() {
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            if (PagingComponent.PROPERTY_SELECTION.equals(propertyChangeEvent.getPropertyName())) {
                PagingComponent.this.revalidate();
                PagingComponent.this.repaint();
            }
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (PagingComponent.COMMAND_LEFT.equals(actionEvent.getActionCommand())) {
                PagingComponent.this.moveLeft();
            } else if (PagingComponent.COMMAND_RIGHT.equals(actionEvent.getActionCommand())) {
                PagingComponent.this.moveRight();
            }
        }

        public void mousePressed(MouseEvent mouseEvent) {
            if (mouseEvent.getComponent() instanceof PageItem) {
                PagingComponent.this.setSelectedItem((PageItem)mouseEvent.getComponent());
            }
        }

        public void focusGained(FocusEvent focusEvent) {
            PageItem pageItem = focusEvent.getComponent() instanceof PageItem ? (PageItem)focusEvent.getComponent() : null;
            PagingComponent.this.setSelectedItem(pageItem);
        }

        public void focusLost(FocusEvent focusEvent) {
            PageItem pageItem = null;
            pageItem = focusEvent.isTemporary() || PagingComponent.this._dragComponent != null ? PagingComponent.this._selectedItem : null;
            PagingComponent.this.setSelectedItem(pageItem);
        }
    }

    protected class AccessiblePagingComponent
    extends JComponent.AccessibleJComponent
    implements AccessibleSelection {
        protected AccessiblePagingComponent() {
            super(PagingComponent.this);
        }

        public AccessibleSelection getAccessibleSelection() {
            return this;
        }

        public int getAccessibleSelectionCount() {
            return PagingComponent.this.getSelectedItem() == null ? 0 : 1;
        }

        public Accessible getAccessibleSelection(int n) {
            return n >= this.getAccessibleSelectionCount() ? null : PagingComponent.this.getSelectedItem();
        }

        public boolean isAccessibleChildSelected(int n) {
            return PagingComponent.this.getSelectedItem() == PagingComponent.this.getComponent(n);
        }

        public void addAccessibleSelection(int n) {
            PagingComponent.this.setSelectedItem(PagingComponent.this.getItem(n));
        }

        public void removeAccessibleSelection(int n) {
            if (PagingComponent.this.getSelectedItem() == PagingComponent.this.getComponent(n)) {
                PagingComponent.this.setSelectedItem(null);
            }
        }

        public void clearAccessibleSelection() {
            PagingComponent.this.setSelectedItem(null);
        }

        public void selectAllAccessibleSelection() {
        }

        public AccessibleStateSet getAccessibleStateSet() {
            AccessibleStateSet accessibleStateSet = super.getAccessibleStateSet();
            if (PagingComponent.this.getComponentCount() != 0 && accessibleStateSet.contains(AccessibleState.ENABLED)) {
                accessibleStateSet.add(AccessibleState.EDITABLE);
            }
            if (PagingComponent.this.hasFocus()) {
                accessibleStateSet.add(AccessibleState.FOCUSED);
            }
            return accessibleStateSet;
        }
    }
}

