/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.ewt.pivot;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.beans.PropertyVetoException;
import java.text.MessageFormat;
import java.util.Dictionary;
import java.util.Locale;
import java.util.ResourceBundle;
import javax.accessibility.Accessible;
import javax.accessibility.AccessibleAction;
import javax.accessibility.AccessibleContext;
import javax.accessibility.AccessibleRole;
import javax.accessibility.AccessibleState;
import javax.accessibility.AccessibleStateSet;
import javax.swing.DefaultListModel;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.KeyStroke;
import javax.swing.ListModel;
import javax.swing.MenuElement;
import javax.swing.MenuSelectionManager;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ListDataListener;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import oracle.bali.ewt.LWComponent;
import oracle.bali.ewt.border.GrayPane;
import oracle.bali.ewt.button.DialogButtonBar;
import oracle.bali.ewt.elaf.EWTPageItemUI;
import oracle.bali.ewt.graphics.Appearance;
import oracle.bali.ewt.graphics.SpacingIcon;
import oracle.bali.ewt.model.OneDModel;
import oracle.bali.ewt.model.OneDModelEvent;
import oracle.bali.ewt.model.OneDModelListener;
import oracle.bali.ewt.painter.FixedAlignmentPainter;
import oracle.bali.ewt.painter.FixedIconPainter;
import oracle.bali.ewt.painter.PaintContext;
import oracle.bali.ewt.painter.PaintContextProxy;
import oracle.bali.ewt.painter.Painter;
import oracle.bali.ewt.painter.TextPainter;
import oracle.bali.ewt.pivot.PagingComponent;
import oracle.bali.ewt.util.ImmInsets;
import oracle.bali.ewt.util.LocaleUtils;
import oracle.bali.ewt.util.MenuUtils;
import oracle.bali.ewt.util.WindowUtils;
import oracle.bali.share.nls.StringUtils;
import oracle.bali.share.util.IntegerUtils;

public class PageItem
extends LWComponent
implements Accessible {
    public static final String KEY_SELECTED_VALUE = "pageItem.selectedValue";
    public static final String PROPERTY_SELECTED_INDEX = "selectedIndex";
    private static final int _HINSET = 3;
    private static final String _ACCESS_RESOURCE_BUNDLE = "oracle.bali.ewt.resource.AccessibilityBundle";
    private static final String _RESOURCE_BUNDLE = "oracle.bali.ewt.resource.JEWTBundle";
    private static final String _COMMAND_UP = "up";
    private static final String _COMMAND_DOWN = "down";
    private static final String _COMMAND_SHOW_DIALOG = "showdialog";
    private static final String _TOGGLE_DROP_DOWN_KEY = "TOGGLE_DROP_DOWN";
    private static final String _OK_KEY = "OK";
    private static final String _CANCEL_KEY = "CANCEL";
    private static final String _SELECT_LABEL_KEY = "PAGEITEM.SELECT_LABEL";
    private static final String _TITLE_KEY = "PAGEITEM.SELECT_DIALOG_TITLE";
    private int _selectedIndex;
    private boolean _dragging;
    private boolean _swapping;
    private boolean _selected;
    private OneDModel _model;
    private OneDModelListener _dsListener;
    private boolean _dragEnabled;
    private JPopupMenu _menu;
    private PopupListen _popupListener;
    private LabelComponent _labelComponent = new LabelComponent();
    private ValueComponent _valueComponent = new ValueComponent();
    private JDialog _dialog;
    private JLabel _dialogLabel;
    private JList _dialogList;
    private JScrollPane _scrollPane;
    private DialogListen _dialogListener;
    private JButton _ok;
    private JButton _cancel;
    private boolean _editable;
    private Appearance _labelAppearance;
    private Appearance _valueAppearance;
    private Painter _valuePainter;
    private Painter _labelPainter;
    private String _label;
    private boolean _drawRaised = true;
    private int _minWidth = -1;
    private int _minHeight = -1;

    public PageItem() {
        this(null);
    }

    public PageItem(String string) {
        this(string, null);
    }

    public PageItem(String string, OneDModel oneDModel) {
        this.setLayout(new BorderLayout());
        this.add("West", this._labelComponent);
        this.add("East", this._valueComponent);
        this._selectedIndex = -1;
        this._dragEnabled = true;
        this._dsListener = new DSListen();
        this.setText(string);
        this.setModel(oneDModel);
        this.setEditable(oneDModel != null);
        this.updateUI();
        this._registerKeyboardActions();
    }

    public void dispose() {
        if (this._labelComponent == null) {
            return;
        }
        this._unregisterKeyboardActions();
        this.setModel(null);
        this._dsListener = null;
        this.removeAll();
        this._labelComponent = null;
        this._valueComponent = null;
        if (this._menu != null) {
            this._menu.addPopupMenuListener(this._popupListener);
            PageItem._removeActionListeners(this._menu, this._popupListener);
            this._menu.removeAll();
            this._menu.setInvoker(null);
        }
        this._menu = null;
        this._popupListener = null;
        this._cleanupDialog();
        this._valueAppearance = null;
        this._labelAppearance = null;
        this._labelPainter = null;
        this._valuePainter = null;
    }

    public void setText(String string) {
        if (this._label != string) {
            String string2 = null;
            if (this.accessibleContext != null) {
                string2 = this.accessibleContext.getAccessibleName();
            }
            this._label = string;
            AccessibleContext accessibleContext = this.accessibleContext;
            if (accessibleContext != null && accessibleContext.getAccessibleName() != string2) {
                accessibleContext.firePropertyChange("AccessibleName", string2, accessibleContext.getAccessibleName());
                this._fireFakeSelectionEvent(accessibleContext);
            }
            this.revalidate();
            this.repaint();
        }
    }

    public String getText() {
        return this._label;
    }

    public void setModel(OneDModel oneDModel) {
        if (this._model != null) {
            this._model.removeModelListener(this._dsListener);
        }
        this._model = oneDModel;
        if (this._model != null) {
            this._model.addModelListener(this._dsListener);
        }
        boolean bl = oneDModel == null || oneDModel.getItemCount() == 0;
        int n = bl ? -1 : 0;
        this.setSelectedIndex(n);
        this.setEditable(bl);
        this.revalidate();
        this.repaint();
    }

    public OneDModel getModel() {
        return this._model;
    }

    public final String getSelectedValue() {
        int n = this.getSelectedIndex();
        if (n == -1) {
            return null;
        }
        Object object = this.getModel().getData(n);
        return object == null ? null : object.toString();
    }

    public int getSelectedIndex() {
        return this._selectedIndex;
    }

    public void setSelectedIndex(int n) {
        if (this._selectedIndex != n) {
            String string = null;
            if (this.accessibleContext != null) {
                string = this.accessibleContext.getAccessibleName();
            }
            Integer n2 = IntegerUtils.getInteger(this._selectedIndex);
            Integer n3 = IntegerUtils.getInteger(n);
            try {
                this.fireVetoableChange(PROPERTY_SELECTED_INDEX, n2, n3);
            }
            catch (PropertyVetoException propertyVetoException) {
                return;
            }
            this._selectedIndex = n;
            this.firePropertyChange(PROPERTY_SELECTED_INDEX, n2, n3);
            this._fireSelectedIndexChanged(n2, n3);
            AccessibleContext accessibleContext = this.accessibleContext;
            if (accessibleContext != null && accessibleContext.getAccessibleName() != string) {
                accessibleContext.firePropertyChange("AccessibleName", string, accessibleContext.getAccessibleName());
                this._fireFakeSelectionEvent(accessibleContext);
            }
            this.revalidate();
            this.repaint();
        }
    }

    public void setDropDownVisible(boolean bl) {
        if (this.isDropDownVisible() != bl) {
            if (bl) {
                if (this.isEditable()) {
                    OneDModel oneDModel = this.getModel();
                    int n = oneDModel.getItemCount();
                    JMenuItem jMenuItem = new JMenuItem(" ");
                    Dimension dimension = MenuUtils.getBoundingSize(this);
                    Point point = this.getLocationOnScreen();
                    point.y += this.getHeight();
                    if (point.y + jMenuItem.getPreferredSize().height * n > dimension.height) {
                        this.setSelected(false);
                        this.setSelectDialogVisible(true);
                        this.setSelected(true);
                    } else {
                        EWTPageItemUI eWTPageItemUI = this.getEWTPageItemUI();
                        int n2 = this._valueComponent.getX();
                        PaintContext paintContext = this.getPaintContext();
                        JPopupMenu jPopupMenu = this._getMenu();
                        PageItem._removeActionListeners(jPopupMenu, this._popupListener);
                        jPopupMenu.removeAll();
                        Icon icon = eWTPageItemUI.getSelectedIcon(this);
                        SpacingIcon spacingIcon = icon == null ? null : new SpacingIcon(icon.getIconWidth(), icon.getIconHeight());
                        int n3 = this.getSelectedIndex();
                        int n4 = 0;
                        while (n4 < n) {
                            Icon icon2 = n4 == n3 ? icon : spacingIcon;
                            Object object = oneDModel.getData(n4);
                            String string = object == null ? null : object.toString();
                            jMenuItem = new JMenuItem(string, icon2);
                            jMenuItem.setSelected(n4 == n3);
                            jMenuItem.setActionCommand(IntegerUtils.getString(n4));
                            jMenuItem.addActionListener(this._popupListener);
                            jPopupMenu.add(jMenuItem);
                            ++n4;
                        }
                        if (MenuUtils.willPopupFit(jPopupMenu, this)) {
                            MenuUtils.showPopupMenu(jPopupMenu, this, n2, this.getHeight());
                        } else {
                            this.setSelected(false);
                            this.setSelectDialogVisible(true);
                            this.setSelected(true);
                        }
                    }
                }
            } else {
                this._getMenu().setVisible(false);
                this.setSelectDialogVisible(false);
            }
        }
    }

    public boolean isDropDownVisible() {
        return this._getMenu().isVisible() || this.isSelectDialogVisible();
    }

    public void setEditable(boolean bl) {
        if (this._editable != bl) {
            this._editable = bl;
            this._valueComponent.setDropDownIconVisible(bl);
            this.revalidate();
            this.repaint();
        }
    }

    public boolean isEditable() {
        return this._editable && this._getItemCount() != 0;
    }

    public boolean isDragEnabled() {
        return this._dragEnabled && !this.isDropDownVisible();
    }

    public void setDragEnabled(boolean bl) {
        this._labelComponent.setGrippyVisible(bl);
        this._dragEnabled = bl;
    }

    public void setAppearance(Appearance appearance) {
        this._labelAppearance = appearance == null ? null : appearance.copy();
        this.revalidate();
        this.repaint();
    }

    public Appearance getAppearance() {
        return this._getAppearance().copy();
    }

    public void setSelectedValueAppearance(Appearance appearance) {
        this._valueAppearance = appearance == null ? null : appearance.copy();
        this.revalidate();
        this.repaint();
    }

    public Appearance getSelectedValueAppearance() {
        return this._getSelectedValueAppearance().copy();
    }

    public void setPainter(Painter painter) {
        if (this._labelPainter != painter) {
            this._labelPainter = painter;
            this.revalidate();
            this.repaint();
        }
    }

    public Painter getPainter() {
        if (this._labelPainter == null) {
            this._labelPainter = new TextPainter();
        }
        return this._labelPainter;
    }

    public void setSelectedValuePainter(Painter painter) {
        if (this._valuePainter != painter) {
            this._valuePainter = painter;
            this.revalidate();
            this.repaint();
        }
    }

    public Painter getSelectedValuePainter() {
        if (this._valuePainter == null) {
            this._valuePainter = new TextPainter(KEY_SELECTED_VALUE);
        }
        return this._valuePainter;
    }

    public void setDrawRaised(boolean bl) {
        if (this._drawRaised != bl) {
            this._drawRaised = bl;
            this.repaint();
        }
    }

    public boolean isDrawRaised() {
        return this._drawRaised;
    }

    public boolean isFocusTraversable() {
        return true;
    }

    public String getUIClassID() {
        return "EWTPageItemUI";
    }

    public Object getPaintData(Object object) {
        Object object2 = null;
        if (KEY_SELECTED_VALUE.equals(object)) {
            object2 = this.getSelectedValue();
        } else if (PaintContext.LABEL_KEY.equals(object)) {
            object2 = this._label;
        } else if ("PageItem.drawRaised".equals(object)) {
            object2 = this.isDrawRaised() ? Boolean.TRUE : Boolean.FALSE;
        }
        return object2 != null ? object2 : super.getPaintData(object);
    }

    public void printPage(PaintContext paintContext, Dictionary dictionary, Graphics graphics) {
        this.freezeRepaints();
        try {
            boolean bl = this._editable;
            boolean bl2 = this.isSelected();
            boolean bl3 = this._labelComponent.isGrippyVisible();
            this._valueComponent.setDropDownIconVisible(false);
            this.setSelected(false);
            this._labelComponent.setGrippyVisible(false);
            super.printPage(paintContext, dictionary, graphics);
            this._valueComponent.setDropDownIconVisible(bl);
            this.setSelected(bl2);
            this._labelComponent.setGrippyVisible(bl3);
            Object var8_7 = null;
            this.unfreezeRepaints();
        }
        catch (Throwable throwable) {
            Object var8_8 = null;
            this.unfreezeRepaints();
            throw throwable;
        }
    }

    public Dimension getDocumentSize(PaintContext paintContext, Dictionary dictionary) {
        this.freezeRepaints();
        Dimension dimension = super.getDocumentSize(paintContext, dictionary);
        try {
            boolean bl = this._editable;
            this._valueComponent.setDropDownIconVisible(false);
            dimension = this.getPreferredSize();
            this._valueComponent.setDropDownIconVisible(bl);
            Object var6_5 = null;
            this.unfreezeRepaints();
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            this.unfreezeRepaints();
            throw throwable;
        }
        return dimension;
    }

    public AccessibleContext getAccessibleContext() {
        if (this.accessibleContext == null) {
            this.accessibleContext = new AccessiblePageItem();
        }
        return this.accessibleContext;
    }

    public void updateUI() {
        this.setUI((EWTPageItemUI)UIManager.getUI(this));
        this._valueComponent.updateIcon();
    }

    public void removeNotify() {
        super.removeNotify();
        this._cleanupDialog();
    }

    protected String getDialogText() {
        return this.getText();
    }

    protected void setSelectDialogVisible(boolean bl) {
        if (this.isSelectDialogVisible() != bl) {
            if (bl) {
                if (this._dialog == null) {
                    this._createDialog();
                }
                String string = this._getTranslatedString(_SELECT_LABEL_KEY);
                MessageFormat messageFormat = new MessageFormat(string);
                Object[] objectArray = new Object[]{this.getDialogText()};
                string = messageFormat.format(objectArray);
                this._dialogLabel.setDisplayedMnemonic(StringUtils.getMnemonicKeyCode(string));
                this._dialogLabel.setText(StringUtils.stripMnemonic(string));
                int n = this.getSelectedIndex();
                OneDModel oneDModel = this.getModel();
                this._dialogList.setModel(new OneDModelAdapter(oneDModel));
                this._dialogList.setVisibleRowCount(oneDModel.getItemCount());
                this._dialog.pack();
                int n2 = this._dialog.getWidth();
                int n3 = this._dialog.getHeight();
                boolean bl2 = false;
                if (n2 > WindowUtils.DIALOG_MAXIMUM_WIDTH) {
                    this._scrollPane.setHorizontalScrollBarPolicy(32);
                    bl2 = true;
                }
                if (n3 > WindowUtils.DIALOG_MAXIMUM_HEIGHT) {
                    this._scrollPane.setVerticalScrollBarPolicy(22);
                    bl2 = true;
                }
                if (bl2) {
                    this._dialog.pack();
                    n2 = this._dialog.getWidth();
                    n3 = this._dialog.getHeight();
                    this._scrollPane.setVerticalScrollBarPolicy(20);
                    this._scrollPane.setHorizontalScrollBarPolicy(30);
                    if (n2 > WindowUtils.DIALOG_MAXIMUM_WIDTH) {
                        n2 = WindowUtils.DIALOG_MAXIMUM_WIDTH;
                    }
                    if (n3 > WindowUtils.DIALOG_MAXIMUM_HEIGHT) {
                        n3 = WindowUtils.DIALOG_MAXIMUM_HEIGHT;
                    }
                    ((Component)this._dialog).setSize(n2, n3);
                }
                this._dialogList.setSelectedIndex(n);
                if (n != -1) {
                    this._dialogList.ensureIndexIsVisible(n);
                }
                this._dialogList.requestFocus();
                PageItem._setWindowLocation(this._dialog, this);
            }
            if (bl) {
                this._minWidth = this._dialog.getWidth();
                this._minHeight = this._dialog.getHeight();
            } else {
                this._minWidth = -1;
                this._minHeight = -1;
            }
            if (this._dialog != null) {
                ((Component)this._dialog).setVisible(bl);
            }
        }
    }

    private static void _setWindowLocation(Window window, PageItem pageItem) {
        Point point = pageItem.getLocationOnScreen();
        Dimension dimension = pageItem.getSize();
        Dimension dimension2 = window.getSize();
        Dimension dimension3 = Toolkit.getDefaultToolkit().getScreenSize();
        if (point.y + dimension.height + dimension2.height <= dimension3.height) {
            if (point.x + dimension2.width <= dimension3.width) {
                ((Component)window).setLocation(point.x, point.y + dimension.height);
                return;
            }
            if (point.x + dimension.width - dimension2.width >= 0) {
                ((Component)window).setLocation(point.x + dimension.width - dimension2.width, point.y + dimension.height);
                return;
            }
        } else if (point.y - dimension2.height >= 0) {
            if (point.x + dimension2.width <= dimension3.width) {
                ((Component)window).setLocation(point.x, point.y - dimension2.height);
                return;
            }
            if (point.x + dimension.width - dimension2.width >= 0) {
                ((Component)window).setLocation(point.x + dimension.width - dimension2.width, point.y - dimension2.height);
                return;
            }
        }
        WindowUtils.centerWindow(window);
    }

    protected boolean isSelectDialogVisible() {
        return this._dialog == null ? false : this._dialog.isVisible();
    }

    protected JDialog createDialog(Frame frame, String string, boolean bl) {
        return new JDialog(frame, string, bl);
    }

    protected JDialog createDialog(Dialog dialog, String string, boolean bl) {
        return new JDialog(dialog, string, bl);
    }

    void setSelected(boolean bl) {
        if (this.isSelected() != bl) {
            this._selected = bl;
            this.paintImmediateInterior();
        }
    }

    boolean isSelected() {
        return this._selected;
    }

    void setDragging(boolean bl) {
        if (this.isDragging() != bl) {
            this._dragging = bl;
            this.paintImmediateInterior();
        }
    }

    boolean isDragging() {
        return this._dragging;
    }

    void setSwapping(boolean bl) {
        if (this.isSwapping() != bl) {
            this._swapping = bl;
            this.paintImmediateInterior();
        }
    }

    boolean isSwapping() {
        return this._swapping;
    }

    Image getDragImage() {
        Painter painter = this.getEWTPageItemUI().getGrippyPainter(this);
        PaintContext paintContext = this.getPaintContext();
        int n = this.getWidth();
        int n2 = this.getHeight();
        Dimension dimension = painter.getSize(paintContext, n, n2);
        n = dimension.width + 5;
        Image image = this.createImage(n, n2);
        if (image != null) {
            Graphics graphics = image.getGraphics();
            graphics.setColor(this._getAppearance().getBackground());
            graphics.fillRect(0, 0, n, n2);
            Border border = this.getBorder();
            int n3 = 0;
            int n4 = 0;
            if (border != null) {
                border.paintBorder(this, graphics, n3, n4, n, n2);
                Insets insets = border.getBorderInsets(this);
                if (insets != null) {
                    n3 += insets.left;
                    n4 += insets.top;
                    n -= insets.left + insets.right;
                    n2 -= insets.top + insets.bottom;
                }
            }
            painter.paint(paintContext, graphics, n3, n4, n, n2);
        }
        return image;
    }

    private static void _removeActionListeners(JPopupMenu jPopupMenu, ActionListener actionListener) {
        int n = 0;
        while (n < jPopupMenu.getComponentCount()) {
            Component component = jPopupMenu.getComponent(n);
            if (component instanceof JMenuItem) {
                ((JMenuItem)component).removeActionListener(actionListener);
            }
            ++n;
        }
    }

    private void _createDialog() {
        this._dialogListener = new DialogListen();
        Window window = WindowUtils.getWindow(this);
        String string = this._getTranslatedString(_TITLE_KEY);
        JDialog jDialog = null;
        if (window instanceof Frame) {
            jDialog = this.createDialog((Frame)window, string, true);
        } else if (window instanceof Dialog) {
            jDialog = this.createDialog((Dialog)window, string, true);
        } else {
            throw new IllegalStateException("PageItem must be in a Frame or Dialog");
        }
        jDialog.addComponentListener(this._dialogListener);
        jDialog.addWindowListener(this._dialogListener);
        ((Component)jDialog).setBackground(UIManager.getColor("EWTDialog.background"));
        jDialog.getContentPane().setBackground(UIManager.getColor("EWTDialog.background"));
        DialogButtonBar dialogButtonBar = new DialogButtonBar();
        String string2 = this._getTranslatedString(_OK_KEY);
        JButton jButton = new JButton(StringUtils.stripMnemonic(string2));
        jButton.setDefaultCapable(true);
        jButton.setMnemonic(StringUtils.getMnemonicKeyCode(string2));
        jButton.setActionCommand(_OK_KEY);
        jButton.addActionListener(this._dialogListener);
        dialogButtonBar.add((Component)jButton, DialogButtonBar.CONSTRAINT_YES);
        this._ok = jButton;
        string2 = this._getTranslatedString(_CANCEL_KEY);
        JButton jButton2 = new JButton(StringUtils.stripMnemonic(string2));
        jButton2.setMnemonic(StringUtils.getMnemonicKeyCode(string2));
        jButton2.setActionCommand(_CANCEL_KEY);
        jButton2.addActionListener(this._dialogListener);
        this._cancel = jButton2;
        KeyStroke keyStroke = KeyStroke.getKeyStroke(27, 0);
        jButton2.registerKeyboardAction(this._dialogListener, _CANCEL_KEY, keyStroke, 2);
        dialogButtonBar.add((Component)jButton2, DialogButtonBar.CONSTRAINT_CANCEL);
        this._dialogList = new JList();
        this._dialogList.addMouseListener(this._dialogListener);
        this._dialogList.setVisibleRowCount(10);
        this._dialogList.setSelectionMode(0);
        this._dialogLabel = new JLabel(" ");
        this._dialogLabel.setLabelFor(this._dialogList);
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout(2, 2));
        jPanel.setBorder(new EmptyBorder(5, 5, 5, 5));
        jPanel.add("North", this._dialogLabel);
        this._scrollPane = new JScrollPane(this._dialogList);
        jPanel.add("Center", this._scrollPane);
        GrayPane grayPane = new GrayPane();
        grayPane.setLayout(new BorderLayout());
        grayPane.add("Center", jPanel);
        JPanel jPanel2 = new JPanel();
        jPanel2.setBorder(new EmptyBorder(8, 8, 8, 8));
        jPanel2.setLayout(new BorderLayout(8, 8));
        jPanel2.add("Center", grayPane);
        jPanel2.add("South", dialogButtonBar);
        Container container = jDialog.getContentPane();
        container.setLayout(new BorderLayout());
        container.add("Center", jPanel2);
        jDialog.getRootPane().setDefaultButton(jButton);
        this._dialog = jDialog;
    }

    private void _cleanupDialog() {
        if (this._dialog == null) {
            return;
        }
        this._dialog.removeComponentListener(this._dialogListener);
        this._dialog.removeWindowListener(this._dialogListener);
        this._ok.removeActionListener(this._dialogListener);
        this._cancel.removeActionListener(this._dialogListener);
        this._dialogList.removeMouseListener(this._dialogListener);
        this._dialogList.setModel(new DefaultListModel());
        KeyStroke keyStroke = KeyStroke.getKeyStroke(27, 0);
        this._cancel.unregisterKeyboardAction(keyStroke);
        this._dialogLabel.setLabelFor(null);
        this._dialog.dispose();
        this._ok = null;
        this._cancel = null;
        this._dialogListener = null;
        this._dialogList = null;
        this._dialogLabel = null;
        this._dialog = null;
    }

    private String _getTranslatedString(String string) {
        ResourceBundle resourceBundle = ResourceBundle.getBundle(_RESOURCE_BUNDLE, this.getLocale());
        return resourceBundle.getString(string);
    }

    private int _getItemCount() {
        return this._model == null ? 0 : this._model.getItemCount();
    }

    EWTPageItemUI getEWTPageItemUI() {
        return (EWTPageItemUI)this.ui;
    }

    private JPopupMenu _getMenu() {
        if (this._menu == null) {
            this._menu = new JPopupMenu();
            this._popupListener = new PopupListen();
            this._menu.addPopupMenuListener(this._popupListener);
        }
        return this._menu;
    }

    private Appearance _getSelectedValueAppearance() {
        if (this._valueAppearance == null) {
            return this._getAppearance();
        }
        return this._valueAppearance;
    }

    private Appearance _getAppearance() {
        if (this._labelAppearance == null) {
            this._labelAppearance = (Appearance)UIManager.get("PageItem.DefaultAppearance");
        }
        return this._labelAppearance;
    }

    private final void _fireFakeSelectionEvent(AccessibleContext accessibleContext) {
        PagingComponent pagingComponent;
        Accessible accessible = accessibleContext.getAccessibleParent();
        if (accessible instanceof PagingComponent && (pagingComponent = (PagingComponent)accessible).getSelectedItem() == this) {
            accessible.getAccessibleContext().firePropertyChange("AccessibleSelection", null, this);
        }
    }

    private final void _fireSelectedIndexChanged(int n, int n2) {
        Object object;
        OneDModel oneDModel = this.getModel();
        Object object2 = n == -1 ? null : (object = oneDModel == null ? null : oneDModel.getData(n));
        Object object3 = n2 == -1 ? null : (oneDModel == null ? null : oneDModel.getData(n2));
        this._fireSelectedStringChanged(object, object3);
    }

    private void _fireSelectedStringChanged(Object object, Object object2) {
        AccessibleContext accessibleContext = this.accessibleContext;
        if (accessibleContext != null) {
            accessibleContext.firePropertyChange("AccessibleVisibleData", object, object2);
        }
    }

    private void _registerKeyboardActions() {
        KeyListen keyListen = new KeyListen();
        KeyStroke keyStroke = KeyStroke.getKeyStroke(38, 0);
        this.registerKeyboardAction(keyListen, _COMMAND_UP, keyStroke, 0);
        keyStroke = KeyStroke.getKeyStroke(40, 0);
        this.registerKeyboardAction(keyListen, _COMMAND_DOWN, keyStroke, 0);
        keyStroke = KeyStroke.getKeyStroke(40, 8);
        this.registerKeyboardAction(keyListen, _COMMAND_SHOW_DIALOG, keyStroke, 0);
        keyStroke = KeyStroke.getKeyStroke(32, 0);
        this.registerKeyboardAction(keyListen, _COMMAND_SHOW_DIALOG, keyStroke, 0);
    }

    private void _unregisterKeyboardActions() {
        KeyStroke keyStroke = KeyStroke.getKeyStroke(38, 0);
        this.unregisterKeyboardAction(keyStroke);
        keyStroke = KeyStroke.getKeyStroke(40, 0);
        this.unregisterKeyboardAction(keyStroke);
        keyStroke = KeyStroke.getKeyStroke(40, 8);
        this.unregisterKeyboardAction(keyStroke);
        keyStroke = KeyStroke.getKeyStroke(32, 0);
        this.unregisterKeyboardAction(keyStroke);
    }

    private class ItemPaintContext
    extends PaintContextProxy {
        private int _paintState;
        private PaintContext _context;
        private Appearance _appearance;

        public ItemPaintContext(PaintContext paintContext, Appearance appearance) {
            this._context = paintContext;
            this._appearance = appearance;
            this._paintState = this._getPaintState();
        }

        protected PaintContext getPaintContext() {
            return this._context;
        }

        public int getPaintState() {
            return this._paintState;
        }

        private int _getPaintState() {
            int n = super.getPaintState();
            if (PageItem.this.isEnabled() && PageItem.this.isSelected()) {
                n |= 0x20;
            }
            return n;
        }

        public Color getPaintForeground() {
            int n = this.getPaintState();
            Color color = null;
            color = PageItem.this.isSwapping() && !PageItem.this.isDragging() ? PageItem.this.getEWTPageItemUI().getSwapForegroundColor(PageItem.this, this.getAppearance()) : ((n & 0x20) == 0 ? this.getAppearance().getForeground() : this.getAppearance().getSelectForeground());
            return color;
        }

        public Font getPaintFont() {
            int n = this.getPaintState();
            Font font = null;
            if ((n & 0x20) != 0) {
                font = this.getAppearance().getSelectFont();
            }
            if (font == null) {
                font = this.getAppearance().getFont();
            }
            if (font == null) {
                font = super.getPaintFont();
            }
            return font;
        }

        public Color getPaintBackground() {
            return this.getUsefulPaintBackground();
        }

        Color getUsefulPaintBackground() {
            boolean bl;
            int n = this.getPaintState();
            Color color = null;
            boolean bl2 = (n & 0x20) != 0;
            boolean bl3 = (n & 4) == 0;
            boolean bl4 = bl = (n & 1) != 0;
            if (PageItem.this.isSwapping() && !PageItem.this.isDragging()) {
                return PageItem.this.getEWTPageItemUI().getSwapBackgroundColor(PageItem.this, this.getAppearance());
            }
            if (!PageItem.this.isEnabled()) {
                return UIManager.getColor("PageItem.disabledBackground");
            }
            if (bl2) {
                color = bl3 ? this.getAppearance().getSelectBackground() : UIManager.getColor("PageItem.inactiveSelectedBackground");
            }
            if (color == null) {
                color = this.getAppearance().getBackground();
            }
            if (color == null) {
                color = super.getPaintBackground();
            }
            return color;
        }

        public float getInteriorAlignmentX() {
            float f;
            Appearance appearance = this.getAppearance();
            int n = appearance.getHorizontalJustify();
            if (n == 0) {
                int n2 = appearance.getReadingDirection();
                switch (n2) {
                    case 0: {
                        return super.getInteriorAlignmentX();
                    }
                }
                n = LocaleUtils.getAlignmentForReadingDirection(n2);
            }
            switch (n) {
                case 3: {
                    f = 0.5f;
                    break;
                }
                case 2: {
                    f = 1.0f;
                    break;
                }
                default: {
                    f = 0.0f;
                }
            }
            return f;
        }

        public float getInteriorAlignmentY() {
            int n = this.getAppearance().getVerticalJustify();
            float f = 0.0f;
            switch (n) {
                case 1: {
                    f = 0.5f;
                    break;
                }
                case 0: {
                    f = 0.0f;
                    break;
                }
                case 2: {
                    f = 1.0f;
                }
            }
            return f;
        }

        public int getReadingDirection() {
            int n = this.getAppearance().getReadingDirection();
            if (n == 0) {
                n = super.getReadingDirection();
            }
            return n;
        }

        public Object getPaintData(Object object) {
            if (object == PaintContext.MNEMONIC_INDEX_KEY) {
                return null;
            }
            return super.getPaintData(object);
        }

        public Appearance getAppearance() {
            return this._appearance;
        }
    }

    private static class OneDModelAdapter
    implements ListModel {
        private OneDModel _toAdapt;

        public OneDModelAdapter(OneDModel oneDModel) {
            this._toAdapt = oneDModel;
        }

        public int getSize() {
            return this._toAdapt.getItemCount();
        }

        public Object getElementAt(int n) {
            return this._toAdapt.getData(n);
        }

        public void addListDataListener(ListDataListener listDataListener) {
        }

        public void removeListDataListener(ListDataListener listDataListener) {
        }
    }

    private class DialogListen
    extends WindowAdapter
    implements ActionListener,
    MouseListener,
    ComponentListener {
        private DialogListen() {
        }

        public void windowClosing(WindowEvent windowEvent) {
            PageItem.this.setSelectDialogVisible(false);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            int n;
            if (PageItem._OK_KEY.equals(actionEvent.getActionCommand()) && (n = PageItem.this._dialogList.getSelectedIndex()) != -1) {
                PageItem.this.setSelectedIndex(n);
            }
            PageItem.this.setSelectDialogVisible(false);
        }

        public void mouseClicked(MouseEvent mouseEvent) {
            if (mouseEvent.getClickCount() == 2) {
                int n = PageItem.this._dialogList.locationToIndex(mouseEvent.getPoint());
                if (n != -1) {
                    PageItem.this.setSelectedIndex(n);
                }
                PageItem.this.setSelectDialogVisible(false);
            }
        }

        public void mousePressed(MouseEvent mouseEvent) {
        }

        public void mouseReleased(MouseEvent mouseEvent) {
        }

        public void mouseEntered(MouseEvent mouseEvent) {
        }

        public void mouseExited(MouseEvent mouseEvent) {
        }

        public void componentResized(ComponentEvent componentEvent) {
            if (PageItem.this._minWidth != -1) {
                int n = PageItem.this._dialog.getWidth();
                int n2 = PageItem.this._dialog.getHeight();
                boolean bl = false;
                if (n < PageItem.this._minWidth) {
                    n = PageItem.this._minWidth;
                    bl = true;
                }
                if (n2 < PageItem.this._minHeight) {
                    n2 = PageItem.this._minHeight;
                    bl = true;
                }
                if (bl) {
                    ((Component)PageItem.this._dialog).setSize(n, n2);
                }
            }
        }

        public void componentHidden(ComponentEvent componentEvent) {
        }

        public void componentShown(ComponentEvent componentEvent) {
        }

        public void componentMoved(ComponentEvent componentEvent) {
        }
    }

    private class ValueComponent
    extends LWComponent
    implements Accessible {
        private Painter _iconPainter;
        private boolean _dropDownIconVisible;

        public ValueComponent() {
            this.setOpaque(true);
            this._dropDownIconVisible = false;
            this.enableEvents(16L);
        }

        public void setDropDownIconVisible(boolean bl) {
            this._dropDownIconVisible = bl;
        }

        public void paintComponent(Graphics graphics) {
            ItemPaintContext itemPaintContext = new ItemPaintContext(PageItem.this.getPaintContext(), PageItem.this._getSelectedValueAppearance());
            this.__paintInterior(itemPaintContext, graphics);
        }

        protected void processMouseEvent(MouseEvent mouseEvent) {
            super.processMouseEvent(mouseEvent);
            if (mouseEvent.isConsumed() || !this.isEnabled() || !SwingUtilities.isLeftMouseButton(mouseEvent) || mouseEvent.getID() != 501) {
                return;
            }
            mouseEvent.consume();
            PageItem.this.requestFocus();
            PageItem.this.setDropDownVisible(true);
        }

        private Painter _getIconPainter() {
            if (this._iconPainter == null) {
                this.updateIcon();
            }
            return this._iconPainter;
        }

        void __paintInterior(PaintContext paintContext, Graphics graphics) {
            Painter painter;
            Dimension dimension = this.getSize();
            Appearance appearance = PageItem.this._getSelectedValueAppearance();
            ImmInsets immInsets = appearance.getInsets();
            graphics.setColor(paintContext.getPaintBackground());
            graphics.fillRect(0, 0, dimension.width, dimension.height);
            graphics.setFont(paintContext.getPaintFont());
            int n = 0;
            int n2 = 0;
            int n3 = dimension.width;
            int n4 = dimension.height;
            if (this._dropDownIconVisible) {
                painter = this._getIconPainter();
                Dimension dimension2 = painter.getSize(paintContext, n3, n4);
                int n5 = n + n3 - dimension2.width;
                painter.paint(paintContext, graphics, n5, n2, dimension2.width, n4);
                n3 -= dimension2.width;
            }
            if (immInsets != null) {
                n += immInsets.left;
                n2 += immInsets.top;
                n3 -= immInsets.left + immInsets.right;
                n4 -= immInsets.top + immInsets.bottom;
            }
            graphics.setColor(paintContext.getPaintForeground());
            painter = PageItem.this.getSelectedValuePainter();
            painter.paint(paintContext, graphics, n += 3, n2, n3 -= 3, n4);
        }

        public Dimension getPreferredSize() {
            Cloneable cloneable;
            Object object;
            Painter painter = PageItem.this.getSelectedValuePainter();
            ItemPaintContext itemPaintContext = new ItemPaintContext(PageItem.this.getPaintContext(), PageItem.this._getSelectedValueAppearance());
            Dimension dimension = painter.getPreferredSize(itemPaintContext);
            if (this._dropDownIconVisible) {
                object = this._getIconPainter();
                cloneable = object.getPreferredSize(itemPaintContext);
                dimension.width += cloneable.width;
                if (dimension.height < cloneable.height) {
                    dimension.height = cloneable.height;
                }
            }
            if ((cloneable = ((Appearance)(object = PageItem.this._getAppearance())).getInsets()) != null) {
                dimension.width += ((ImmInsets)cloneable).left + ((ImmInsets)cloneable).right;
                dimension.height += ((ImmInsets)cloneable).top + ((ImmInsets)cloneable).bottom;
            }
            dimension.width += 3;
            return dimension;
        }

        public Dimension getMinimumSize() {
            return this.getPreferredSize();
        }

        public void updateIcon() {
            Icon icon = PageItem.this.getEWTPageItemUI().getDropDownIcon(PageItem.this);
            this._iconPainter = new FixedAlignmentPainter(new FixedIconPainter(icon), 0.5f, 0.5f);
        }

        public AccessibleContext getAccessibleContext() {
            if (this.accessibleContext == null) {
                this.accessibleContext = new ICAccessible();
            }
            return this.accessibleContext;
        }

        private class ICAccessible
        extends JComponent.AccessibleJComponent
        implements AccessibleAction {
            private ICAccessible() {
                super(ValueComponent.this);
            }

            public int getAccessibleChildrenCount() {
                return 0;
            }

            public Accessible getAccessibleChild(int n) {
                return null;
            }

            public Accessible getAccessibleParent() {
                return PageItem.this;
            }

            public int getAccessibleIndexInParent() {
                return 1;
            }

            public String getAccessibleName() {
                if (PageItem.this.getModel() == null) {
                    return super.getAccessibleName();
                }
                String string = PageItem.this.getSelectedValue();
                if (string == null) {
                    string = super.getAccessibleName();
                }
                return string;
            }

            public AccessibleRole getAccessibleRole() {
                return AccessibleRole.COMBO_BOX;
            }

            public AccessibleAction getAccessibleAction() {
                return this;
            }

            public String getAccessibleActionDescription(int n) {
                Locale locale = LocaleUtils.getDefaultableLocale(PageItem.this);
                ResourceBundle resourceBundle = ResourceBundle.getBundle(PageItem._ACCESS_RESOURCE_BUNDLE, locale);
                if (n == 0) {
                    return resourceBundle.getString(PageItem._TOGGLE_DROP_DOWN_KEY);
                }
                return null;
            }

            public int getAccessibleActionCount() {
                return 1;
            }

            public boolean doAccessibleAction(int n) {
                if (n == 0 && PageItem.this.isEditable()) {
                    PageItem.this.setDropDownVisible(!PageItem.this.isDropDownVisible());
                    return true;
                }
                return false;
            }
        }
    }

    private class LabelComponent
    extends LWComponent
    implements Accessible {
        private boolean _grippyVisible;

        public LabelComponent() {
            this.setOpaque(true);
            this._grippyVisible = true;
            this.enableEvents(16L);
        }

        public void setGrippyVisible(boolean bl) {
            this._grippyVisible = bl;
            this.revalidate();
        }

        public boolean isGrippyVisible() {
            return this._grippyVisible;
        }

        public void paintComponent(Graphics graphics) {
            ItemPaintContext itemPaintContext = new ItemPaintContext(PageItem.this.getPaintContext(), PageItem.this._getAppearance());
            this.__paintInterior(itemPaintContext, graphics);
        }

        protected void processMouseEvent(MouseEvent mouseEvent) {
            super.processMouseEvent(mouseEvent);
            if (mouseEvent.isConsumed() || !this.isEnabled() || !SwingUtilities.isLeftMouseButton(mouseEvent) || mouseEvent.getID() != 501) {
                return;
            }
            PageItem.this.requestFocus();
        }

        void __paintInterior(PaintContext paintContext, Graphics graphics) {
            Painter painter;
            Dimension dimension = this.getSize();
            Appearance appearance = PageItem.this._getAppearance();
            ImmInsets immInsets = appearance.getInsets();
            graphics.setColor(paintContext.getPaintBackground());
            graphics.fillRect(0, 0, dimension.width, dimension.height);
            graphics.setFont(paintContext.getPaintFont());
            int n = 0;
            int n2 = 0;
            int n3 = dimension.width;
            int n4 = dimension.height;
            if (this._grippyVisible) {
                painter = PageItem.this.getEWTPageItemUI().getGrippyPainter(PageItem.this);
                Dimension dimension2 = painter.getSize(paintContext, n3, n4);
                painter.paint(paintContext, graphics, n, n2, dimension2.width, n4);
                n += dimension2.width;
                n3 -= dimension2.width;
            }
            if (immInsets != null) {
                n += immInsets.left;
                n2 += immInsets.top;
                n3 -= immInsets.left + immInsets.right;
                n4 -= immInsets.top + immInsets.bottom;
            }
            graphics.setColor(paintContext.getPaintForeground());
            painter = PageItem.this.getPainter();
            painter.paint(paintContext, graphics, n += 3, n2, n3 -= 3, n4);
        }

        public Dimension getPreferredSize() {
            Cloneable cloneable;
            Object object;
            Painter painter = PageItem.this.getPainter();
            ItemPaintContext itemPaintContext = new ItemPaintContext(PageItem.this.getPaintContext(), PageItem.this._getAppearance());
            Dimension dimension = painter.getPreferredSize(itemPaintContext);
            if (this._grippyVisible) {
                object = PageItem.this.getEWTPageItemUI().getGrippyPainter(PageItem.this);
                cloneable = object.getPreferredSize(itemPaintContext);
                dimension.width += ((Dimension)cloneable).width;
                if (dimension.height < ((Dimension)cloneable).height) {
                    dimension.height = ((Dimension)cloneable).height;
                }
            }
            if ((cloneable = ((Appearance)(object = PageItem.this._getAppearance())).getInsets()) != null) {
                dimension.width += cloneable.left + cloneable.right;
                dimension.height += cloneable.top + cloneable.bottom;
            }
            dimension.width += 3;
            return dimension;
        }

        public Dimension getMinimumSize() {
            return this.getPreferredSize();
        }

        public AccessibleContext getAccessibleContext() {
            if (this.accessibleContext == null) {
                this.accessibleContext = new LCAccessible();
            }
            return this.accessibleContext;
        }

        private class LCAccessible
        extends JComponent.AccessibleJComponent {
            private LCAccessible() {
                super(LabelComponent.this);
            }

            public Accessible getAccessibleParent() {
                return PageItem.this;
            }

            public int getAccessibleIndexInParent() {
                return 0;
            }

            public int getAccessibleChildrenCount() {
                return 0;
            }

            public Accessible getAccessibleChild(int n) {
                return null;
            }

            public String getAccessibleName() {
                String string = PageItem.this.getText();
                if (string == null) {
                    string = super.getAccessibleName();
                }
                return string;
            }

            public AccessibleRole getAccessibleRole() {
                return AccessibleRole.LABEL;
            }
        }
    }

    private class DSListen
    implements OneDModelListener {
        private DSListen() {
        }

        public void itemsAdded(OneDModelEvent oneDModelEvent) {
            int n = oneDModelEvent.getStartIndex();
            int n2 = oneDModelEvent.getItemCount();
            if (PageItem.this._selectedIndex >= n) {
                PageItem.this._selectedIndex += n2;
            }
        }

        public void itemsRemoved(OneDModelEvent oneDModelEvent) {
            int n = oneDModelEvent.getStartIndex();
            int n2 = oneDModelEvent.getItemCount();
            if (PageItem.this._selectedIndex >= n && PageItem.this._selectedIndex <= n + n2) {
                Object object = null;
                if (PageItem.this.getModel().getItemCount() == 0) {
                    PageItem.this._selectedIndex = -1;
                } else {
                    PageItem.this._selectedIndex = 0;
                    object = PageItem.this.getModel().getData(PageItem.this._selectedIndex);
                }
                PageItem.this._fireSelectedStringChanged(null, object);
                PageItem.this.revalidate();
                PageItem.this.repaint();
            } else if (PageItem.this._selectedIndex > n + n2) {
                PageItem.this._selectedIndex -= n2;
            }
        }

        public void invalidateItems(OneDModelEvent oneDModelEvent) {
            int n = oneDModelEvent.getStartIndex();
            int n2 = oneDModelEvent.getItemCount();
            if (PageItem.this._selectedIndex >= n && PageItem.this._selectedIndex <= n + n2) {
                Object object = PageItem.this.getModel().getData(PageItem.this._selectedIndex);
                PageItem.this._fireSelectedStringChanged(null, object);
                PageItem.this.revalidate();
                PageItem.this.repaint();
            }
        }
    }

    private class PopupListen
    implements ActionListener,
    PopupMenuListener {
        private PopupListen() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            try {
                String string = actionEvent.getActionCommand();
                int n = Integer.valueOf(string);
                PageItem.this.setSelectedIndex(n);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }

        public void popupMenuWillBecomeVisible(PopupMenuEvent popupMenuEvent) {
            PageItem.this.setSelected(false);
            int n = PageItem.this.getSelectedIndex();
            if (n != -1) {
                JPopupMenu jPopupMenu = (JPopupMenu)popupMenuEvent.getSource();
                MenuElement[] menuElementArray = new MenuElement[]{jPopupMenu, jPopupMenu.getSubElements()[n]};
                MenuSelectionManager.defaultManager().setSelectedPath(menuElementArray);
            }
        }

        public void popupMenuWillBecomeInvisible(PopupMenuEvent popupMenuEvent) {
            if (PageItem.this.hasFocus()) {
                PageItem.this.setSelected(true);
            }
        }

        public void popupMenuCanceled(PopupMenuEvent popupMenuEvent) {
        }
    }

    private class KeyListen
    implements ActionListener {
        private KeyListen() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            String string = actionEvent.getActionCommand();
            if (PageItem._COMMAND_UP.equals(string)) {
                int n = PageItem.this.getSelectedIndex();
                if (n >= 1) {
                    PageItem.this.setSelectedIndex(--n);
                }
            } else if (PageItem._COMMAND_DOWN.equals(string)) {
                int n;
                int n2 = PageItem.this.getSelectedIndex();
                if (n2 < (n = PageItem.this._getItemCount()) - 1) {
                    PageItem.this.setSelectedIndex(++n2);
                }
            } else if (PageItem._COMMAND_SHOW_DIALOG.equals(string)) {
                PageItem.this.setDropDownVisible(true);
            }
        }
    }

    protected class AccessiblePageItem
    extends JComponent.AccessibleJComponent {
        protected AccessiblePageItem() {
            super(PageItem.this);
        }

        public String getAccessibleName() {
            String string;
            Accessible accessible;
            String string2 = this.getAccessibleChild(0).getAccessibleContext().getAccessibleName();
            String string3 = this.getAccessibleChild(1).getAccessibleContext().getAccessibleName();
            String string4 = null;
            if (string2 != null) {
                string4 = string3 != null ? string2 + " " + string3 : string2;
            } else if (string3 != null) {
                string4 = string3;
            }
            if (string4 != null && (accessible = ((Component.AccessibleAWTComponent)this).getAccessibleParent()) instanceof PagingComponent && (string = accessible.getAccessibleContext().getAccessibleName()) != null) {
                string4 = string + " " + string4;
            }
            return string4;
        }

        public int getAccessibleIndexInParent() {
            Accessible accessible = ((Component.AccessibleAWTComponent)this).getAccessibleParent();
            if (accessible instanceof PagingComponent) {
                return ((PagingComponent)accessible).getIndex(PageItem.this);
            }
            return super.getAccessibleIndexInParent();
        }

        public AccessibleStateSet getAccessibleStateSet() {
            AccessibleStateSet accessibleStateSet = super.getAccessibleStateSet();
            if (PageItem.this.getModel() != null && PageItem.this.getModel().getItemCount() != 0 && PageItem.this.isEditable() && accessibleStateSet.contains(AccessibleState.ENABLED)) {
                accessibleStateSet.add(AccessibleState.EDITABLE);
            }
            accessibleStateSet.add(AccessibleState.SELECTABLE);
            if (PageItem.this.isSelected()) {
                accessibleStateSet.add(AccessibleState.SELECTED);
            }
            return accessibleStateSet;
        }
    }
}

