/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.ewt.pivot;

import java.awt.Component;
import java.awt.Image;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import oracle.bali.ewt.grid.Grid;
import oracle.bali.ewt.pivot.DrillEvent;
import oracle.bali.ewt.pivot.PivotHeader;
import oracle.bali.ewt.pivot.PivotTable;
import oracle.bali.ewt.util.MenuUtils;
import oracle.bali.share.util.IntegerUtils;

public class DrillPopup {
    private static final int _DEFAULT_IMAGE_WIDTH = 5;
    private static final int _DEFAULT_IMAGE_HEIGHT = 5;
    PivotTable _pivot;
    boolean _isHorizontal;
    int _column;
    int _row;
    Object[] _cmds;
    private _Listener _listener;
    private JPopupMenu _menu;
    private boolean _dirty;
    private String[] _items;
    PivotHeader _header;
    private PopupMenuListener _popupListener;

    public DrillPopup() {
        this(null, null);
    }

    public DrillPopup(String[] stringArray, Object[] objectArray) {
        this.setItems(stringArray, objectArray);
    }

    public void dispose() {
        this.removeAll();
        this._pivot = null;
        this._header = null;
        if (this._menu != null) {
            this._menu.setInvoker(null);
            this._menu.removePopupMenuListener(this._popupListener);
            if (this._listener != null) {
                this._removeActionListeners(this._menu, this._listener);
            }
            this._menu.removeAll();
        }
        this._menu = null;
        this._listener = null;
        this._popupListener = null;
    }

    public void removeAll() {
        this._items = null;
        this._cmds = null;
    }

    public void setItems(String[] stringArray, Object[] objectArray) {
        this.removeAll();
        this._items = stringArray;
        this._cmds = objectArray;
        this._dirty = true;
    }

    public void show(DrillEvent drillEvent) {
        this._pivot = drillEvent.getPivotTable();
        this._column = drillEvent.getColumn();
        this._row = drillEvent.getRow();
        this._isHorizontal = drillEvent.getOrientation() == 0;
        PivotHeader pivotHeader = this._isHorizontal ? this._pivot.getColumnPivotHeader() : this._pivot.getRowPivotHeader();
        Grid grid = pivotHeader.getGrid();
        int n = 5;
        int n2 = 5;
        Image image = pivotHeader.getDrillImage(this._column, this._row);
        if (image != null) {
            n = image.getWidth(pivotHeader);
            n2 = image.getHeight(pivotHeader);
        }
        boolean bl = grid.getActualReadingDirection() == 1;
        int n3 = bl ? grid.getColumnPosition(this._column) + n : grid.getColumnPosition(this._column) + grid.getColumnWidth(this._column) - n;
        int n4 = grid.getRowPosition(this._row) + n2 / 2;
        Point point = grid.convertCanvasToOuter(n3, n4);
        this._header = pivotHeader;
        this._header.setDrilling(true);
        this._showMenu(grid, point.x, point.y);
    }

    private void _showMenu(Component component, int n, int n2) {
        if (this._items == null || this._items.length == 0) {
            return;
        }
        if (this._menu == null) {
            this._menu = new JPopupMenu();
            this._popupListener = new MenuListen();
            this._menu.addPopupMenuListener(this._popupListener);
            this._listener = new _Listener();
        }
        if (this._dirty) {
            this._removeActionListeners(this._menu, this._listener);
            this._menu.removeAll();
            int n3 = 0;
            while (n3 < this._items.length) {
                JMenuItem jMenuItem = new JMenuItem(this._items[n3]);
                jMenuItem.addActionListener(this._listener);
                jMenuItem.setActionCommand(IntegerUtils.getString(n3));
                this._menu.add(jMenuItem);
                ++n3;
            }
            this._dirty = false;
        }
        MenuUtils.showPopupMenu(this._menu, component, n, n2);
    }

    private void _removeActionListeners(JPopupMenu jPopupMenu, ActionListener actionListener) {
        int n = 0;
        while (n < jPopupMenu.getComponentCount()) {
            Component component = jPopupMenu.getComponent(n);
            if (component instanceof JMenuItem) {
                ((JMenuItem)component).removeActionListener(actionListener);
            }
            ++n;
        }
    }

    private class _Listener
    implements ActionListener {
        private _Listener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            String string = actionEvent.getActionCommand();
            int n = 0;
            try {
                n = Integer.parseInt(string);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            int n2 = DrillPopup.this._isHorizontal ? 0 : 1;
            DrillPopup.this._pivot.fireDrillEvent(n2, DrillPopup.this._column, DrillPopup.this._row, DrillPopup.this._cmds[n]);
        }
    }

    private class MenuListen
    implements PopupMenuListener {
        private MenuListen() {
        }

        public void popupMenuWillBecomeVisible(PopupMenuEvent popupMenuEvent) {
        }

        public void popupMenuWillBecomeInvisible(PopupMenuEvent popupMenuEvent) {
            if (DrillPopup.this._header != null) {
                DrillPopup.this._header.setDrilling(false);
            }
        }

        public void popupMenuCanceled(PopupMenuEvent popupMenuEvent) {
        }
    }
}

