/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.ewt.painter;

import java.awt.FontMetrics;
import oracle.bali.ewt.painter.PaintContext;
import oracle.bali.ewt.painter.TextPainter;

public class TruncatingTextPainter
extends TextPainter {
    protected static final String _ELLIPSIS = "...";

    public TruncatingTextPainter() {
    }

    public TruncatingTextPainter(Object object) {
        super(object);
    }

    public TruncatingTextPainter(Object object, boolean bl) {
        super(object, bl);
    }

    protected String getPaintText(PaintContext paintContext, String string, FontMetrics fontMetrics, int n) {
        int n2 = fontMetrics.stringWidth(string);
        if (n2 > n) {
            int n3 = fontMetrics.stringWidth(_ELLIPSIS);
            float f = this.getAlignmentX(paintContext);
            if (f == 1.0f || f != 0.0f && paintContext.getReadingDirection() == 2) {
                int n4 = n - n3 - n2;
                int n5 = 0;
                int n6 = string.length();
                while (n4 < 0) {
                    n4 += fontMetrics.charWidth(string.charAt(n5++));
                    if (n5 == n6) break;
                }
                string = _ELLIPSIS + string.substring(n5);
            } else {
                int n7 = n - n3;
                int n8 = -1;
                int n9 = string.length();
                while (n7 > 0) {
                    if (++n8 == n9) break;
                    n7 -= fontMetrics.charWidth(string.charAt(n8));
                }
                if (n8 < 0) {
                    n8 = 0;
                }
                string = string.substring(0, n8) + _ELLIPSIS;
            }
        }
        return string;
    }

    protected static String getEllipsis(PaintContext paintContext) {
        return _ELLIPSIS;
    }
}

