/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.ewt.painter;

import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import oracle.bali.ewt.painter.AbstractPainter;
import oracle.bali.ewt.painter.PaintContext;
import oracle.bali.ewt.util.StringUtils;

public class TextPainter
extends AbstractPainter {
    private boolean _supportMnemonics;
    private Object _dataKey;

    public TextPainter() {
        this._init(PaintContext.LABEL_KEY, true);
    }

    public TextPainter(Object object) {
        this._init(object, true);
    }

    public TextPainter(Object object, boolean bl) {
        this._init(object, bl);
    }

    public Dimension getSize(PaintContext paintContext, int n, int n2) {
        Dimension dimension = this.getPreferredSize(paintContext);
        if (this.getAlignmentX(paintContext) != 0.0f && dimension.width < n) {
            dimension.width = n;
        }
        if (this.getAlignmentY(paintContext) != 0.0f && dimension.height < n2) {
            dimension.height = n2;
        }
        return dimension;
    }

    public Dimension getPreferredSize(PaintContext paintContext) {
        return this._getSize(paintContext, true);
    }

    public Dimension getMinimumSize(PaintContext paintContext) {
        return this._getSize(paintContext, false);
    }

    public void paint(PaintContext paintContext, Graphics graphics, int n, int n2, int n3, int n4) {
        int n5;
        String string;
        FontMetrics fontMetrics = graphics.getFontMetrics();
        if (fontMetrics != null && (string = this.getStringData(paintContext)) != null && (n5 = string.length()) != 0) {
            Object object;
            int n6;
            float f = this.getAlignmentX(paintContext);
            int n7 = TextPainter._getNumberOfTextLines(string);
            float f2 = this.getAlignmentY(paintContext);
            if (f2 != 0.0f && (n6 = n7 * fontMetrics.getHeight()) < n4) {
                n2 = (int)((float)n2 + (float)(n4 - n6) * f2);
            }
            n2 += fontMetrics.getAscent();
            n6 = -1;
            if (this._supportMnemonics && (object = paintContext.getPaintData(PaintContext.MNEMONIC_INDEX_KEY)) != null && object instanceof Integer) {
                n6 = (Integer)object;
            }
            if (n7 == 1 && string.charAt(n5 - 1) != '\n') {
                this.paintText(paintContext, graphics, fontMetrics, string, n, n2, n3, f, n6);
            } else {
                int n8;
                int n9 = -1;
                int n10 = fontMetrics.getHeight();
                while ((n8 = n9 + 1) < n5) {
                    n9 = string.indexOf(10, n8);
                    if (n9 == -1) {
                        n9 = n5;
                    }
                    this.paintText(paintContext, graphics, fontMetrics, string.substring(n8, n9), n, n2, n3, f, n6 - n8);
                    n2 += n10;
                }
            }
        }
    }

    public boolean isTransparent(PaintContext paintContext) {
        return true;
    }

    public int getRepaintFlags(PaintContext paintContext) {
        return 19328;
    }

    public int getInvalidateFlags(PaintContext paintContext) {
        return 384;
    }

    protected String getPaintText(PaintContext paintContext, String string, FontMetrics fontMetrics, int n) {
        return string;
    }

    protected String getStringData(PaintContext paintContext) {
        return (String)this.getData(paintContext);
    }

    protected String getMinimumStringData(PaintContext paintContext) {
        return this.getStringData(paintContext);
    }

    protected Object getData(PaintContext paintContext) {
        Object object = super.getData(paintContext);
        if (object != null) {
            return object.toString();
        }
        return null;
    }

    protected Object getDataKey() {
        return this._dataKey;
    }

    private Dimension _getSize(PaintContext paintContext, boolean bl) {
        int n = 0;
        int n2 = 0;
        Font font = paintContext.getPaintFont();
        if (font != null) {
            String string;
            FontMetrics fontMetrics = paintContext.getFontMetrics(font);
            String string2 = string = bl ? this.getStringData(paintContext) : this.getMinimumStringData(paintContext);
            if (fontMetrics != null && string != null) {
                int n3 = TextPainter._getNumberOfTextLines(string);
                if (n3 == 1) {
                    string = StringUtils.getDisplayString(string, paintContext);
                    n = fontMetrics.stringWidth(string);
                } else {
                    n = TextPainter._getMaxLineWidth(paintContext, string, fontMetrics);
                }
                n2 = n3 * fontMetrics.getHeight() - fontMetrics.getLeading();
            }
        }
        return new Dimension(n, n2);
    }

    private static final int _getNumberOfTextLines(String string) {
        int n;
        int n2 = 0;
        int n3 = -1;
        int n4 = string.length();
        while ((n = n3 + 1) != n4) {
            n3 = string.indexOf(10, n);
            ++n2;
            if (n3 != -1) continue;
        }
        return n2;
    }

    private static final int _getMaxLineWidth(PaintContext paintContext, String string, FontMetrics fontMetrics) {
        int n;
        int n2 = 0;
        int n3 = -1;
        int n4 = string.length();
        while ((n = n3 + 1) < n4) {
            String string2;
            int n5;
            n3 = string.indexOf(10, n);
            if (n3 == -1) {
                n3 = n4;
            }
            if (n2 >= (n5 = fontMetrics.stringWidth(string2 = StringUtils.getDisplayString(string.substring(n, n3), paintContext)))) continue;
            n2 = n5;
        }
        return n2;
    }

    protected int paintText(PaintContext paintContext, Graphics graphics, FontMetrics fontMetrics, String string, int n, int n2, int n3, float f, int n4) {
        int n5;
        string = StringUtils.getDisplayString(string, paintContext);
        String string2 = this.getPaintText(paintContext, string, fontMetrics, n3);
        if (f != 0.0f && (n5 = fontMetrics.stringWidth(string2)) < n3) {
            n = (int)((float)n + (float)(n3 - n5) * f);
        }
        graphics.drawString(string2, n, n2);
        if (n4 >= 0 && n4 < string2.length()) {
            n5 = n;
            if (n4 > 0) {
                n5 += fontMetrics.stringWidth(string2.substring(0, n4));
            }
            graphics.drawLine(n5 + 1, n2 + 1, n5 + fontMetrics.charWidth(string2.charAt(n4)) - 2, n2 + 1);
        }
        return n;
    }

    protected float getAlignmentX(PaintContext paintContext) {
        return paintContext.getInteriorAlignmentX();
    }

    protected float getAlignmentY(PaintContext paintContext) {
        return paintContext.getInteriorAlignmentY();
    }

    private void _init(Object object, boolean bl) {
        this._dataKey = object;
        this._supportMnemonics = bl;
    }
}

