/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.ewt.painter;

import java.applet.Applet;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Frame;
import java.awt.Window;
import java.awt.image.ImageObserver;
import java.util.Locale;
import javax.swing.JComponent;
import javax.swing.JInternalFrame;
import javax.swing.UIDefaults;
import javax.swing.UIManager;
import oracle.bali.ewt.graphics.ColorUtils;
import oracle.bali.ewt.painter.PaintContext;
import oracle.bali.ewt.util.WindowUtils;
import oracle.bali.share.collection.StringKey;
import oracle.bali.share.nls.LocaleUtils;
import oracle.bali.share.util.IntegerUtils;

public class JPaintContext
implements PaintContext {
    private JComponent _c;
    private boolean _useParentBackground;
    private UIDefaults _defaults;
    private static final int _REALLY_DARK_LUMINANCE = 51;
    private static final int _DARK_LUMINANCE = 139;
    private static final int _LIGHT_LUMINANCE = 240;
    private static final String _DARK_DEFAULTS = "UIDefaults.dark";
    private static final String _LIGHT_DEFAULTS = "UIDefaults.light";
    private static boolean _sAppletsActive = false;
    private static boolean _sAppletParameterTested = false;
    private static final Object _PAINT_CONTEXT_KEY = new StringKey("_EWTPaintContext");

    public static void setAppletsAlwaysActive(boolean bl) {
        _sAppletsActive = bl;
    }

    public static PaintContext getPaintContext(JComponent jComponent) {
        Object object = jComponent.getClientProperty(_PAINT_CONTEXT_KEY);
        if (object instanceof PaintContext) {
            return (PaintContext)object;
        }
        return null;
    }

    public static void putPaintContext(JComponent jComponent, PaintContext paintContext) {
        jComponent.putClientProperty(_PAINT_CONTEXT_KEY, paintContext);
    }

    public static void removePaintContext(JComponent jComponent) {
        JPaintContext.putPaintContext(jComponent, null);
    }

    public JPaintContext(JComponent jComponent) {
        this(jComponent, null, false);
    }

    public JPaintContext(JComponent jComponent, boolean bl) {
        this(jComponent, null, bl);
    }

    private JPaintContext(JComponent jComponent, UIDefaults uIDefaults, boolean bl) {
        this._c = jComponent;
        this._useParentBackground = bl;
        this._defaults = uIDefaults == null ? UIManager.getLookAndFeelDefaults() : uIDefaults;
    }

    public Color getPaintForeground() {
        return this._c.getForeground();
    }

    public Color getPaintBackground() {
        return this._c.getBackground();
    }

    public Color getSurroundingColor() {
        if (this._useParentBackground || !this._c.isOpaque()) {
            Container container = this._c.getParent();
            if (container != null) {
                return container.getBackground();
            }
            return null;
        }
        return this._c.getBackground();
    }

    public Font getPaintFont() {
        return this._c.getFont();
    }

    public FontMetrics getFontMetrics(Font font) {
        return ((Component)this._c).getFontMetrics(font);
    }

    public int getPaintState() {
        JComponent jComponent = this._c;
        int n = JPaintContext.getBasePaintState(jComponent);
        if (jComponent.hasFocus()) {
            n |= 0x40;
        }
        return n;
    }

    public static Integer getMnemonicIndex(String string, int n) {
        if (string != null && n != 0) {
            char c;
            char c2 = Character.toUpperCase((char)n);
            int n2 = string.indexOf(c2);
            if (n2 < 0 && (c = Character.toLowerCase((char)n)) != c2) {
                n2 = string.indexOf(c);
            }
            if (n2 >= 0) {
                return IntegerUtils.getInteger(n2);
            }
        }
        return null;
    }

    public Object getPaintData(Object object) {
        return null;
    }

    public ImageObserver getImageObserver() {
        return this._c;
    }

    public Locale getPaintLocale() {
        return LocaleUtils.getDefaultableLocale(this._c);
    }

    public UIDefaults getPaintUIDefaults() {
        UIDefaults uIDefaults = this._defaults;
        Color color = this.getSurroundingColor();
        if (color != null) {
            Object object;
            int n = ColorUtils.getApproximateLuminance(color);
            if (n <= 139 && n > 51) {
                Object object2 = uIDefaults.get(_DARK_DEFAULTS);
                if (object2 instanceof UIDefaults) {
                    return (UIDefaults)object2;
                }
            } else if (n > 240 && (object = uIDefaults.get(_LIGHT_DEFAULTS)) instanceof UIDefaults) {
                return (UIDefaults)object;
            }
        }
        return uIDefaults;
    }

    public float getInteriorAlignmentX() {
        return this._c.getAlignmentX();
    }

    public float getInteriorAlignmentY() {
        return this._c.getAlignmentY();
    }

    public int getReadingDirection() {
        return 1;
    }

    public JComponent getComponent() {
        return this._c;
    }

    public void dispose() {
        this._c = null;
        this._defaults = null;
    }

    public String toString() {
        String string = super.toString();
        string = string + ", Component:" + this._c.getName();
        int n = this.getPaintState();
        if ((n & 1) != 0) {
            string = string + ", disabled";
        }
        if ((n & 2) != 0) {
            string = string + ", armed";
        }
        if ((n & 4) != 0) {
            string = string + ", inactive";
        }
        if ((n & 8) != 0) {
            string = string + ", set";
        }
        if ((n & 0x10) != 0) {
            string = string + ", mouse over";
        }
        if ((n & 0x40) != 0) {
            string = string + ", focused";
        }
        if ((n & 0x80) != 0) {
            string = string + ", default";
        }
        return string;
    }

    public static int getBasePaintState(Component component) {
        int n = 0;
        if (!JPaintContext._isActive(component)) {
            n |= 4;
        }
        if (!component.isEnabled()) {
            n |= 1;
        }
        return n;
    }

    private static boolean _isActive(Component component) {
        Window window = null;
        while (component != null) {
            if (component instanceof Applet) {
                if (_sAppletsActive) {
                    return true;
                }
                if (!_sAppletParameterTested) {
                    _sAppletParameterTested = true;
                    try {
                        Applet applet = (Applet)component;
                        if ("true".equals(applet.getParameter("JEWTAlwaysActive"))) {
                            _sAppletsActive = true;
                            return true;
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
            if (component instanceof Window) {
                window = (Window)component;
                break;
            }
            if (component instanceof JInternalFrame && !((JInternalFrame)component).isSelected() || component instanceof JInternalFrame.JDesktopIcon && !((JInternalFrame.JDesktopIcon)component).getInternalFrame().isSelected()) {
                return false;
            }
            component = component.getParent();
        }
        if (window == null) {
            return false;
        }
        if (window == WindowUtils.getActiveWindow()) {
            return true;
        }
        if (window instanceof Frame || window instanceof Dialog) {
            return window.getFocusOwner() != null;
        }
        return true;
    }
}

