/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.ewt.olaf;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyVetoException;
import java.util.Locale;
import java.util.ResourceBundle;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JInternalFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.UIDefaults;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import oracle.bali.ewt.border.BorderAdapter;
import oracle.bali.ewt.olaf.ColorScheme;
import oracle.bali.ewt.olaf.OracleButtonPainter;
import oracle.bali.ewt.olaf.PainterButton;
import oracle.bali.ewt.painter.AbstractPainter;
import oracle.bali.ewt.painter.AndOrStatePainterSwitcher;
import oracle.bali.ewt.painter.FixedAlignmentPainter;
import oracle.bali.ewt.painter.FixedBorderPainter;
import oracle.bali.ewt.painter.IconPainter;
import oracle.bali.ewt.painter.PaintContext;
import oracle.bali.ewt.painter.PaintContextComponent;
import oracle.bali.ewt.painter.Painter;
import oracle.bali.ewt.util.MenuUtils;
import oracle.bali.ewt.util.WindowUtils;
import oracle.bali.share.nls.StringUtils;

final class TitleBar
extends PaintContextComponent
implements PropertyChangeListener,
WindowListener {
    private JInternalFrame _frame;
    private Window _window;
    private JLabel _titleLabel;
    private CaptionComp _captionComp;
    private boolean _armed;
    private JMenuBar _systemMenuBar;
    private JMenu _systemMenu;
    private JButton _minimizeButton;
    private JButton _maximizeButton;
    private JButton _restoreButton;
    private JButton _closeButton;
    static final String _SYSTEM_MENU_BUNDLE_NAME = "oracle.bali.ewt.olaf.resource.OLAFBundle";
    static final String _RESTORE_KEY = "SYSTEMMENU.RESTORE";
    static final String _MOVE_KEY = "SYSTEMMENU.MOVE";
    static final String _RESIZE_KEY = "SYSTEMMENU.RESIZE";
    static final String _MINIMIZE_KEY = "SYSTEMMENU.MINIMIZE";
    static final String _MAXIMIZE_KEY = "SYSTEMMENU.MAXIMIZE";
    static final String _CLOSE_KEY = "SYSTEMMENU.CLOSE";
    private Painter _sCaptionFill = new AndOrStatePainterSwitcher(new FixedBorderPainter(new FixedAlignmentPainter(new Tile(), 0.0f, 0.5f), 0, 8, 0, 0), null, 4, 0, 0, 0);
    private static final Painter _sButtonPainter = new OracleButtonPainter((Painter)new IconPainter(), true, true, false);

    public TitleBar(JInternalFrame jInternalFrame) {
        this._frame = jInternalFrame;
        this.setBorder(new BorderAdapter(new FixedBorderPainter(null, 0, 0, 2, 0, true, true)));
        this._createComponents();
        this._addListeners();
        this._updateActiveState();
        this._updateButtons();
        this._updateFrameIcon();
        this._updateTitle();
        this._titleLabel.setFont(new Font("Dialog", 1, 12));
    }

    public boolean isArmed() {
        return this._armed;
    }

    public void setArmed(boolean bl) {
        if (bl != this._armed) {
            this._armed = bl;
            this.repaint();
        }
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        String string = propertyChangeEvent.getPropertyName();
        if (string.equals("selected")) {
            this._updateActiveState();
        } else if (string.equals("title")) {
            this._updateTitle();
        } else if (string.equals("frameIcon") || string.equals("menuBar")) {
            this._updateFrameIcon();
        } else if (string.equals("maximum") || string.equals("icon")) {
            this._updateButtons();
        }
    }

    public void doLayout() {
        this._updateButtons();
        super.doLayout();
    }

    public void addNotify() {
        super.addNotify();
        if (this._window == null) {
            this._window = WindowUtils.getWindow(this);
            if (this._window != null) {
                this._window.addWindowListener(this);
            }
        }
    }

    public void removeNotify() {
        super.removeNotify();
        JInternalFrame jInternalFrame = this.__getFrame();
        Container container = this.getParent();
        if (jInternalFrame != null && container == null) {
            jInternalFrame.removePropertyChangeListener(this);
            this._frame = null;
        }
        if (this._window != null) {
            this._window.removeWindowListener(this);
            this._window = null;
        }
    }

    protected void paintComponent(Graphics graphics) {
        Color color = graphics.getColor();
        graphics.setColor(this.getBackground());
        graphics.fillRect(0, 0, this.getWidth(), this.getHeight());
        graphics.setColor(color);
    }

    final JInternalFrame __getFrame() {
        return this._frame;
    }

    final JMenu __getSystemMenu() {
        return this._systemMenu;
    }

    private void _addListeners() {
        this._frame.addPropertyChangeListener(this);
        Armer armer = new Armer();
        this._titleLabel.addMouseListener(armer);
        this._captionComp.addMouseListener(armer);
        Redispatcher redispatcher = new Redispatcher();
        this._titleLabel.addMouseListener(redispatcher);
        this._titleLabel.addMouseMotionListener(redispatcher);
        this._captionComp.addMouseListener(redispatcher);
        this._captionComp.addMouseMotionListener(redispatcher);
        new SMLoader(this._systemMenu.getPopupMenu());
        Maximizer maximizer = new Maximizer();
        this._titleLabel.addMouseListener(maximizer);
        this._captionComp.addMouseListener(maximizer);
        this.addMouseListener(maximizer);
        this._maximizeButton.addActionListener(maximizer);
        Minimizer minimizer = new Minimizer();
        this._minimizeButton.addActionListener(minimizer);
        Restorer restorer = new Restorer();
        this._restoreButton.addActionListener(restorer);
        Closer closer = new Closer();
        this._closeButton.addActionListener(closer);
        this._systemMenu.addMouseListener(closer);
        SystemMenuDisplayer systemMenuDisplayer = new SystemMenuDisplayer();
        this._titleLabel.addMouseListener(systemMenuDisplayer);
        this._captionComp.addMouseListener(systemMenuDisplayer);
    }

    private JButton _createButton(String string) {
        PainterButton painterButton = new PainterButton(_sButtonPainter);
        painterButton.setIcon(this.getUIDefaults().getIcon(string));
        painterButton.setFocusable(false);
        painterButton.setBackground(null);
        return painterButton;
    }

    private void _createComponents() {
        JMenuBar jMenuBar = this._createSystemMenu();
        this._titleLabel = new JLabel();
        this._captionComp = new CaptionComp();
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.add("West", this._titleLabel);
        jPanel.add("Center", this._captionComp);
        this._minimizeButton = this._createButton("InternalFrame.iconifyIcon");
        this._restoreButton = this._createButton("InternalFrame.minimizeIcon");
        this._maximizeButton = this._createButton("InternalFrame.maximizeIcon");
        this._closeButton = this._createButton("InternalFrame.closeIcon");
        JPanel jPanel2 = new JPanel(new FlowLayout(0, 0, 0));
        jPanel2.add(this._minimizeButton);
        jPanel2.add(this._restoreButton);
        jPanel2.add(this._maximizeButton);
        jPanel2.add(this._closeButton);
        this.setLayout(new BorderLayout());
        this.add("West", jMenuBar);
        this.add("Center", jPanel);
        this.add("East", jPanel2);
    }

    private JMenuBar _createSystemMenu() {
        this._systemMenu = new ImageMenu();
        this._systemMenu.setMnemonic('-');
        this._systemMenuBar = new JMenuBar();
        this._systemMenuBar.setOpaque(false);
        this._systemMenuBar.setBorder(new BorderAdapter(new FixedBorderPainter(null, 0, 0, 0, 2, true)));
        this._systemMenuBar.add(this._systemMenu);
        return this._systemMenuBar;
    }

    private boolean _isActive() {
        PaintContext paintContext = this.getPaintContext();
        return (paintContext.getPaintState() & 4) == 0;
    }

    private void _updateActiveState() {
        JInternalFrame jInternalFrame = this.__getFrame();
        boolean bl = jInternalFrame.isSelected() && this._isActive();
        String string = bl ? "InternalFrame.activeTitleBackground" : "InternalFrame.inactiveTitleBackground";
        UIDefaults uIDefaults = this.getUIDefaults();
        this.setBackground(uIDefaults.getColor(string));
        String string2 = bl ? "InternalFrame.activeTitleForeground" : "InternalFrame.inactiveTitleForeground";
        this._titleLabel.setForeground(uIDefaults.getColor(string2));
        if (jInternalFrame.isIcon()) {
            JInternalFrame.JDesktopIcon jDesktopIcon = jInternalFrame.getDesktopIcon();
            jDesktopIcon.repaint();
        }
    }

    private void _updateButtons() {
        JInternalFrame jInternalFrame = this.__getFrame();
        boolean bl = jInternalFrame.isIcon();
        boolean bl2 = jInternalFrame.isMaximum();
        this._minimizeButton.setVisible(jInternalFrame.isIconifiable() && !bl);
        this._restoreButton.setVisible(bl || bl2);
        this._maximizeButton.setVisible(jInternalFrame.isMaximizable() && !bl2);
        this._closeButton.setVisible(jInternalFrame.isClosable());
        this._minimizeButton.setBackground(null);
        this._restoreButton.setBackground(null);
        this._maximizeButton.setBackground(null);
        this._closeButton.setBackground(null);
    }

    private void _updateFrameIcon() {
        JInternalFrame jInternalFrame = this.__getFrame();
        Icon icon = jInternalFrame.getFrameIcon();
        this._systemMenu.setIcon(icon);
        this._systemMenuBar.setVisible(icon != null);
    }

    private void _updateTitle() {
        JInternalFrame jInternalFrame = this.__getFrame();
        String string = jInternalFrame.getTitle();
        if (string != this._titleLabel.getText()) {
            this._titleLabel.setText(string);
        }
    }

    public void windowDeactivated(WindowEvent windowEvent) {
        this._updateActiveState();
    }

    public void windowActivated(WindowEvent windowEvent) {
        this._updateActiveState();
    }

    public void windowIconified(WindowEvent windowEvent) {
    }

    public void windowOpened(WindowEvent windowEvent) {
    }

    public void windowClosed(WindowEvent windowEvent) {
    }

    public void windowClosing(WindowEvent windowEvent) {
    }

    public void windowDeiconified(WindowEvent windowEvent) {
    }

    private class SystemMenuDisplayer
    extends MouseAdapter {
        private JPopupMenu _systemPopup;

        private SystemMenuDisplayer() {
        }

        public void mousePressed(MouseEvent mouseEvent) {
            JInternalFrame jInternalFrame = TitleBar.this.__getFrame();
            if (!jInternalFrame.isSelected()) {
                try {
                    jInternalFrame.setSelected(true);
                }
                catch (PropertyVetoException propertyVetoException) {
                    return;
                }
            }
            this._popup(mouseEvent);
        }

        public void mouseReleased(MouseEvent mouseEvent) {
            this._popup(mouseEvent);
        }

        private void _popup(MouseEvent mouseEvent) {
            if (mouseEvent.isPopupTrigger()) {
                if (this._systemPopup == null) {
                    this._systemPopup = new JPopupMenu();
                    new SMLoader(this._systemPopup);
                }
                MenuUtils.showPopupMenu(this._systemPopup, (Component)mouseEvent.getSource(), mouseEvent.getX(), mouseEvent.getY());
                mouseEvent.consume();
            }
        }
    }

    private static class Tile
    extends AbstractPainter {
        private Tile() {
        }

        public int getRepaintFlags(PaintContext paintContext) {
            return 2;
        }

        public Dimension getMinimumSize(PaintContext paintContext) {
            return new Dimension(0, 12);
        }

        public Dimension getSize(PaintContext paintContext, int n, int n2) {
            return new Dimension(n, this.getMinimumSize((PaintContext)paintContext).height);
        }

        public void paint(PaintContext paintContext, Graphics graphics, int n, int n2, int n3, int n4) {
            UIDefaults uIDefaults = paintContext.getPaintUIDefaults();
            Color color = Color.black;
            Color color2 = uIDefaults.getColor(ColorScheme.NORMAL_INTENSITY);
            boolean bl = (paintContext.getPaintState() & 2) != 0;
            int n5 = n + n3 - 1;
            if (n % 4 != 0) {
                n -= n % 4;
            }
            while (n < n5) {
                if (n % 8 == 0) {
                    if (n5 - n >= 4) {
                        this._drawDot(graphics, n, n2, color, color2, bl);
                        this._drawDot(graphics, n, n2 + 8, color, color2, bl);
                    }
                } else if (n5 - n >= 8) {
                    this._drawDot(graphics, n, n2 + 4, color, color2, bl);
                }
                n += 4;
            }
        }

        private void _drawDot(Graphics graphics, int n, int n2, Color color, Color color2, boolean bl) {
            if (bl) {
                graphics.setColor(color);
                graphics.drawLine(n + 1, n2, n + 1, n2);
                graphics.drawLine(n, n2 + 1, n, n2 + 1);
                graphics.setColor(color2);
                graphics.drawLine(n + 2, n2 + 1, n + 2, n2 + 1);
                graphics.drawLine(n + 1, n2 + 2, n + 2, n2 + 2);
            } else {
                graphics.setColor(color);
                graphics.drawLine(n + 2, n2 + 3, n + 2, n2 + 3);
                graphics.drawLine(n + 3, n2 + 2, n + 3, n2 + 2);
                graphics.setColor(color2);
                graphics.drawLine(n + 1, n2 + 1, n + 2, n2 + 1);
                graphics.drawLine(n + 1, n2 + 2, n + 1, n2 + 2);
            }
        }
    }

    private class SMLoader
    implements PopupMenuListener {
        private JMenuItem _restoreItem = new JMenuItem();
        private JMenuItem _moveItem;
        private JMenuItem _resizeItem;
        private JMenuItem _minimizeItem;
        private JMenuItem _maximizeItem;
        private JMenuItem _closeItem;
        private Locale _menuLocale;

        public SMLoader(JPopupMenu jPopupMenu) {
            jPopupMenu.add(this._restoreItem);
            this._moveItem = new JMenuItem();
            jPopupMenu.add(this._moveItem);
            this._resizeItem = new JMenuItem();
            jPopupMenu.add(this._resizeItem);
            this._minimizeItem = new JMenuItem();
            jPopupMenu.add(this._minimizeItem);
            this._maximizeItem = new JMenuItem();
            jPopupMenu.add(this._maximizeItem);
            jPopupMenu.addSeparator();
            this._closeItem = new JMenuItem();
            this._closeItem.setAccelerator(KeyStroke.getKeyStroke(115, 2, true));
            jPopupMenu.add(this._closeItem);
            this._restoreItem.addActionListener(new Restorer());
            this._minimizeItem.addActionListener(new Minimizer());
            this._maximizeItem.addActionListener(new Maximizer());
            this._closeItem.addActionListener(new Closer());
            jPopupMenu.addPopupMenuListener(this);
        }

        public void popupMenuWillBecomeVisible(PopupMenuEvent popupMenuEvent) {
            this._updateMessages();
            this._updateEnabled();
        }

        public void popupMenuWillBecomeInvisible(PopupMenuEvent popupMenuEvent) {
        }

        public void popupMenuCanceled(PopupMenuEvent popupMenuEvent) {
        }

        private void _loadMessage(ResourceBundle resourceBundle, JMenuItem jMenuItem, String string) {
            String string2 = resourceBundle.getString(string);
            if (string2 != null) {
                jMenuItem.setText(StringUtils.stripMnemonic(string2));
                jMenuItem.setMnemonic(StringUtils.getMnemonicKeyCode(string2));
            }
        }

        private void _updateEnabled() {
            JInternalFrame jInternalFrame = TitleBar.this.__getFrame();
            boolean bl = jInternalFrame.isIcon();
            boolean bl2 = jInternalFrame.isMaximum();
            this._restoreItem.setEnabled(bl || bl2);
            this._moveItem.setEnabled(false);
            this._resizeItem.setEnabled(false);
            this._minimizeItem.setEnabled(jInternalFrame.isIconifiable() && !bl);
            this._maximizeItem.setEnabled(jInternalFrame.isMaximizable() && !bl2);
            this._closeItem.setEnabled(jInternalFrame.isClosable());
        }

        private void _updateMessages() {
            ResourceBundle resourceBundle;
            Locale locale = TitleBar.this.getLocale();
            if (locale == null) {
                locale = Locale.getDefault();
            }
            if (!locale.equals(this._menuLocale) && (resourceBundle = ResourceBundle.getBundle(TitleBar._SYSTEM_MENU_BUNDLE_NAME, locale)) != null) {
                this._loadMessage(resourceBundle, this._restoreItem, TitleBar._RESTORE_KEY);
                this._loadMessage(resourceBundle, this._moveItem, TitleBar._MOVE_KEY);
                this._loadMessage(resourceBundle, this._resizeItem, TitleBar._RESIZE_KEY);
                this._loadMessage(resourceBundle, this._minimizeItem, TitleBar._MINIMIZE_KEY);
                this._loadMessage(resourceBundle, this._maximizeItem, TitleBar._MAXIMIZE_KEY);
                this._loadMessage(resourceBundle, this._closeItem, TitleBar._CLOSE_KEY);
                this._menuLocale = locale;
            }
        }
    }

    private class Restorer
    implements ActionListener {
        private Restorer() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            JInternalFrame jInternalFrame = TitleBar.this.__getFrame();
            try {
                if (jInternalFrame.isMaximum()) {
                    jInternalFrame.setMaximum(false);
                } else if (jInternalFrame.isIcon()) {
                    jInternalFrame.setIcon(false);
                }
            }
            catch (PropertyVetoException propertyVetoException) {
                // empty catch block
            }
        }
    }

    private class Redispatcher
    implements MouseListener,
    MouseMotionListener {
        private Redispatcher() {
        }

        public void mouseClicked(MouseEvent mouseEvent) {
            this._redispatch(mouseEvent);
        }

        public void mousePressed(MouseEvent mouseEvent) {
            this._redispatch(mouseEvent);
        }

        public void mouseReleased(MouseEvent mouseEvent) {
            this._redispatch(mouseEvent);
        }

        public void mouseDragged(MouseEvent mouseEvent) {
            this._redispatch(mouseEvent);
        }

        public void mouseEntered(MouseEvent mouseEvent) {
        }

        public void mouseExited(MouseEvent mouseEvent) {
        }

        public void mouseMoved(MouseEvent mouseEvent) {
        }

        private void _redispatch(MouseEvent mouseEvent) {
            if (!SwingUtilities.isLeftMouseButton(mouseEvent)) {
                return;
            }
            JInternalFrame jInternalFrame = TitleBar.this.__getFrame();
            JComponent jComponent = jInternalFrame.isIcon() ? jInternalFrame.getDesktopIcon() : TitleBar.this;
            Point point = SwingUtilities.convertPoint(mouseEvent.getComponent(), mouseEvent.getX(), mouseEvent.getY(), jComponent);
            jComponent.dispatchEvent(new MouseEvent(jComponent, mouseEvent.getID(), mouseEvent.getWhen(), mouseEvent.getModifiers(), point.x, point.y, mouseEvent.getClickCount(), mouseEvent.isPopupTrigger()));
        }
    }

    private class Minimizer
    implements ActionListener {
        private Minimizer() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            try {
                TitleBar.this.__getFrame().setIcon(true);
            }
            catch (PropertyVetoException propertyVetoException) {
                // empty catch block
            }
        }
    }

    private class Maximizer
    extends MouseAdapter
    implements ActionListener {
        private Maximizer() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            this._setMaximum(true);
        }

        public void mousePressed(MouseEvent mouseEvent) {
            if (mouseEvent.getClickCount() == 2 && SwingUtilities.isLeftMouseButton(mouseEvent)) {
                JInternalFrame jInternalFrame = TitleBar.this.__getFrame();
                this._setMaximum(!jInternalFrame.isMaximum());
            }
        }

        private void _setMaximum(boolean bl) {
            try {
                TitleBar.this.__getFrame().setMaximum(bl);
            }
            catch (PropertyVetoException propertyVetoException) {
                // empty catch block
            }
        }
    }

    private static class ImageMenu
    extends JMenu {
        private ImageMenu() {
        }

        protected void paintComponent(Graphics graphics) {
            Icon icon = this.getIcon();
            if (icon != null) {
                icon.paintIcon(this, graphics, 0, 0);
            }
        }

        public Dimension getPreferredSize() {
            return this.getMinimumSize();
        }

        public Dimension getMinimumSize() {
            Icon icon = this.getIcon();
            if (icon != null) {
                return new Dimension(icon.getIconWidth(), icon.getIconHeight());
            }
            return new Dimension(0, 0);
        }
    }

    private class Closer
    extends MouseAdapter
    implements ActionListener {
        private Closer() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            this._close();
        }

        public void mousePressed(MouseEvent mouseEvent) {
            if (mouseEvent.getClickCount() == 2 && SwingUtilities.isLeftMouseButton(mouseEvent)) {
                JMenu jMenu = TitleBar.this.__getSystemMenu();
                jMenu.setPopupMenuVisible(false);
                this._close();
            }
        }

        private void _close() {
            JInternalFrame jInternalFrame = TitleBar.this.__getFrame();
            if (jInternalFrame.isClosable()) {
                try {
                    jInternalFrame.setClosed(true);
                }
                catch (PropertyVetoException propertyVetoException) {
                    // empty catch block
                }
            }
        }
    }

    private class CaptionComp
    extends PaintContextComponent {
        private CaptionComp() {
        }

        public Dimension getMinimumSize() {
            return TitleBar.this._sCaptionFill.getPreferredSize(this.getPaintContext());
        }

        public Dimension getPeferredSize() {
            return TitleBar.this._sCaptionFill.getPreferredSize(this.getPaintContext());
        }

        protected int getPaintState() {
            int n = super.getPaintState();
            if (TitleBar.this.isArmed()) {
                n |= 2;
            }
            return n;
        }

        protected void paintComponent(Graphics graphics) {
            Dimension dimension = this.getSize();
            TitleBar.this._sCaptionFill.paint(this.getPaintContext(), graphics, 0, 0, dimension.width, dimension.height);
        }
    }

    private class Armer
    extends MouseAdapter {
        private Armer() {
        }

        public void mousePressed(MouseEvent mouseEvent) {
            if (SwingUtilities.isLeftMouseButton(mouseEvent)) {
                TitleBar.this.setArmed(true);
            }
        }

        public void mouseReleased(MouseEvent mouseEvent) {
            TitleBar.this.setArmed(false);
        }
    }
}

