/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.ewt.olaf;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.util.Enumeration;
import javax.swing.UIDefaults;
import oracle.bali.ewt.LWComponent;
import oracle.bali.ewt.LookAndFeel;
import oracle.bali.ewt.olaf.ColorScheme;
import oracle.bali.ewt.olaf.OracleThumbPainter;
import oracle.bali.ewt.olaf.OracleUIUtils;
import oracle.bali.share.event.ListenerManager;

class SplitterButton
extends LWComponent {
    public static final int NON_ONE_TOUCH_ACTION_EVENT = 1;
    public static final int ONE_TOUCH_FIRST_ACTION_EVENT = 2;
    public static final int ONE_TOUCH_SECOND_ACTION_EVENT = 3;
    private static final int _RIGHT = 1;
    private static final int _LEFT = 2;
    private static final int _TOP = 3;
    private static final int _BOTTOM = 4;
    private static final int _COMMON = 1;
    private static final int _SPECIAL_1 = 2;
    private static final int _SPECIAL_2 = 3;
    private static final int _GRIPPY_SIZE = 3;
    private static final int _GRIPPY_GAP = 5;
    private static final int _GRIPPY_STRIDE = 8;
    private static final int _MAX_SEC_BUTTON_SIZE = 10;
    private static final int _MIN_SEC_BUTTON_SIZE = 4;
    private static final int _ONETOUCH_MIN_GRIPPIES = 0;
    private static final int _ONETOUCH_MAX_GRIPPIES = 6;
    private static final int _ONETOUCH_ARROW_SIZE = 7;
    private static final int _ONETOUCH_BORDER_ARROW_SPACE = 5;
    private static final int _ONETOUCH_ARROW_GRIPPY_SPACE = 3;
    private static final int _ONETOUCH_GRIPPY_SEPARATOR_SPACE = 7;
    private static final int _ONETOUCH_SEPARATOR_SIZE = 6;
    private static final int _ONETOUCH_MIN_BUTTON_SIZE = 50;
    private static final int _ONETOUCH_MAX_BUTTON_SIZE = 88;
    private static final int _NON_ONETOUCH_MIN_GRIPPIES = 3;
    private static final int _NON_ONETOUCH_MAX_GRIPPIES = 7;
    private static final int _NON_ONETOUCH_BORDER_GRIPPY_SPACE = 7;
    private static final int _NON_ONETOUCH_MIN_BUTTON_SIZE = 33;
    private static final int _NON_ONETOUCH_MAX_BUTTON_SIZE = 65;
    private static final int _ONETOUCH_FOUR_GRIPPY_SIZE = 72;
    private static final int _ONETOUCH_TWO_GRIPPY_SIZE = 56;
    private static final int _NON_ONETOUCH_FIVE_GRIPPY_SIZE = 44;
    private boolean _isHorizontal = false;
    private boolean _oneTouchExpandable = false;
    private boolean _firstPressed;
    private boolean _secondPressed;
    private boolean _firstArmed;
    private boolean _secondArmed;
    private boolean _firstEnabled = true;
    private boolean _secondEnabled = true;
    private ListenerManager _listenerManager = new ListenerManager();
    private UIDefaults _defaults = OracleUIUtils.getUIDefaults(this);
    private Color _highlight = null;
    private Color _shadow = null;
    private Color _darkBorder = null;
    private Color _lightBorder = null;
    private static final int[] _sXOffsetCommon = new int[]{0, 0, 1, 1, 2, 2, 3, 3};
    private static final int[] _sYOffsetCommon = new int[]{0, 6, 1, 5, 2, 4, 3, 3};
    private static final int[] _sXOffsetDimension5 = new int[]{0, 0, 1, 1, 2, 2};
    private static final int[] _sYOffsetDimension5 = new int[]{0, 4, 1, 3, 2, 2};
    private static final int[] _sXOffsetDimension4 = new int[]{0, 0, 1, 1};
    private static final int[] _sYOffsetDimension4 = new int[]{0, 2, 1, 1};
    private static final int[] _sXOffsetSeparatorCommon = new int[]{0, 0, 1, 2, 3, 4, 5, 6, 7, 7};
    private static final int[] _sYOffsetSeparatorCommon = new int[]{0, 0, 1, 1, 2, 2, 3, 3, 4, 4};
    private static final int[] _sXOffsetSeparatorDimension5 = new int[]{0, 0, 1, 1, 2, 2};
    private static final int[] _sYOffsetSeparatorDimension5 = new int[]{0, 0, 1, 1, 2, 2};
    private static final int[] _sXOffsetSeparatorDimension4 = new int[]{0, 0, 1, 1};
    private static final int[] _sYOffsetSeparatorDimension4 = new int[]{0, 0, 1, 1};

    public SplitterButton(int n, boolean bl) {
        this.setOpaque(true);
        this._isHorizontal = n == 0;
        this._oneTouchExpandable = bl;
        this.enableEvents(48L);
        this.updateUI();
    }

    public void addActionListener(ActionListener actionListener) {
        this._listenerManager.addListener(actionListener);
    }

    public void removeActionListener(ActionListener actionListener) {
        this._listenerManager.removeListener(actionListener);
    }

    public void setOneTouchExpandable(boolean bl) {
        this._oneTouchExpandable = bl;
        this.revalidate();
    }

    public Dimension getMinimumSize() {
        Dimension dimension = new Dimension();
        if (this._isHorizontal) {
            dimension.width = this._oneTouchExpandable ? 50 : 33;
            dimension.height = 4;
        } else {
            dimension.width = 4;
            dimension.height = this._oneTouchExpandable ? 50 : 33;
        }
        return dimension;
    }

    public void updateUI() {
        super.updateUI();
        UIDefaults uIDefaults = OracleUIUtils.getUIDefaults(this);
        this._highlight = uIDefaults.getColor(LookAndFeel.CONTROL_LT_HIGHLIGHT);
        this._shadow = uIDefaults.getColor(ColorScheme.CONTROL_SHADOW_DARK);
        this._lightBorder = uIDefaults.getColor("Button.lightBorder");
        this._darkBorder = uIDefaults.getColor("Button.darkBorder");
    }

    public Dimension getButtonSize(Dimension dimension) {
        int n;
        int n2 = this._isHorizontal ? (dimension.getHeight() >= 10.0 ? 10 : (dimension.getHeight() >= 4.0 ? (int)dimension.getHeight() : 4)) : (dimension.getWidth() >= 10.0 ? 10 : (n = dimension.getWidth() >= 4.0 ? (int)dimension.getWidth() : 4));
        int n3 = this._oneTouchExpandable ? (this._isHorizontal ? (dimension.getWidth() >= 88.0 ? 88 : (dimension.getWidth() > 50.0 ? ((int)((dimension.getWidth() - 50.0) / 22.0) == 0 ? (dimension.getWidth() - 50.0 >= 6.0 ? 56 : 50) : 72) : 50)) : (dimension.getHeight() >= 88.0 ? 88 : (dimension.getHeight() > 50.0 ? ((int)((dimension.getHeight() - 50.0) / 22.0) == 0 ? (dimension.getHeight() - 50.0 >= 6.0 ? 56 : 50) : 72) : 50))) : (this._isHorizontal ? (dimension.getWidth() >= 65.0 ? 65 : (dimension.getWidth() > 33.0 ? (int)((dimension.getWidth() - 33.0) / 16.0) * 16 + 33 : 33)) : (dimension.getHeight() >= 65.0 ? 65 : (dimension.getHeight() > 33.0 ? (int)((dimension.getHeight() - 33.0) / 16.0) * 16 + 33 : 33)));
        return this._isHorizontal ? new Dimension(n3, n) : new Dimension(n, n3);
    }

    public int getOrientation() {
        return this._isHorizontal ? 0 : 1;
    }

    public void setOrientation(int n) {
        this._isHorizontal = n == 0;
        this.revalidate();
    }

    public void setButtonArmed(boolean bl) {
        if (this._oneTouchExpandable) {
            String string = "setButtonArmed() method cannot be invoked for One Touch Expandable SplitButton";
            throw new UnsupportedOperationException(string);
        }
        this._firstArmed = bl;
    }

    public boolean isButtonArmed() {
        if (this._oneTouchExpandable) {
            throw new UnsupportedOperationException("isButtonArmed() method cannotbe invoked for One Touch Expandable SplitButton");
        }
        return this._firstArmed;
    }

    public void setFirstArmed(boolean bl) {
        if (!this._oneTouchExpandable) {
            throw new UnsupportedOperationException("setFirstArmed() method cannotbe invoked for Non One Touch Expandable SplitButton");
        }
        this._firstArmed = bl;
    }

    public boolean isFirstArmed() {
        if (!this._oneTouchExpandable) {
            throw new UnsupportedOperationException("isFirstArmed() method cannot be invoked for Non One Touch Expandable SplitButton");
        }
        return this._firstArmed;
    }

    public void setSecondArmed(boolean bl) {
        if (!this._oneTouchExpandable) {
            throw new UnsupportedOperationException("setSecondArmed() method cannotbe invoked for Non One Touch Expandable SplitButton");
        }
        this._secondArmed = bl;
    }

    public boolean isSecondArmed() {
        if (!this._oneTouchExpandable) {
            throw new UnsupportedOperationException("isSecondArmed() method cannotbe invoked forNon One Touch Expandable SplitButton");
        }
        return this._secondArmed;
    }

    public void setButtonPressed(boolean bl) {
        if (this._oneTouchExpandable) {
            throw new UnsupportedOperationException("setButtonPressed() method cannot be invoked forOne Touch Expandable SplitButton");
        }
        if (this._firstPressed == bl) {
            return;
        }
        this._firstPressed = bl;
        this.repaint();
        if (!this._firstPressed && this._firstArmed) {
            this._fireActionPerformed(1);
        }
    }

    public boolean isButtonPressed() {
        if (this._oneTouchExpandable) {
            throw new UnsupportedOperationException("isButtonPressed() method cannot be invoked for One Touch Expandable SplitButton");
        }
        return this._firstPressed;
    }

    public void setFirstPressed(boolean bl) {
        if (!this._oneTouchExpandable) {
            throw new UnsupportedOperationException("setFirstPressed() method cannotbe invoked for Non One Touch Expandable SplitButton");
        }
        if (this._firstPressed == bl) {
            return;
        }
        this._firstPressed = bl;
        this.repaint();
        if (!this._firstPressed && this._firstArmed) {
            this._fireActionPerformed(2);
        }
    }

    public boolean isFirstPressed() {
        if (!this._oneTouchExpandable) {
            throw new UnsupportedOperationException("isFirstPressed() method cannotbe invoked for Non One Touch Expandable SplitButton");
        }
        return this._firstPressed;
    }

    public void setSecondPressed(boolean bl) {
        if (!this._oneTouchExpandable) {
            throw new UnsupportedOperationException("setSecondPressed() method cannot be invoked for Non One Touch Expandable SplitButton");
        }
        if (this._secondPressed == bl) {
            return;
        }
        this._secondPressed = bl;
        this.repaint();
        if (!this._secondPressed && this._secondArmed) {
            this._fireActionPerformed(3);
        }
    }

    public boolean isSecondPressed() {
        if (!this._oneTouchExpandable) {
            throw new UnsupportedOperationException("isSecondPressed() method cannotbe invoked for Non One Touch Expandable SplitButton");
        }
        return this._secondPressed;
    }

    public void setFirstEnabled(boolean bl) {
        if (!this._oneTouchExpandable) {
            throw new UnsupportedOperationException("setFirstEnabled() method cannotbe invoked for Non One Touch Expandable SplitButton");
        }
        this._firstEnabled = bl;
    }

    public boolean isFirstEnabled() {
        if (!this._oneTouchExpandable) {
            throw new UnsupportedOperationException("isFirstEnabled() method cannot be invoked for Non One Touch Expandable SplitButton");
        }
        return this._firstEnabled;
    }

    public void setSecondEnabled(boolean bl) {
        if (!this._oneTouchExpandable) {
            throw new UnsupportedOperationException("setSecondEnabled() method cannot be invoked for Non One Touch Expandable SplitButton");
        }
        this._secondEnabled = bl;
    }

    public boolean isSecondEnabled() {
        if (!this._oneTouchExpandable) {
            throw new UnsupportedOperationException("isSecondEnabled() method cannotbe invoked for Non One Touch Expandable SplitButton");
        }
        return this._secondEnabled;
    }

    public void setButtonEnabled(boolean bl) {
        if (this._oneTouchExpandable) {
            throw new UnsupportedOperationException("setButtonEnabled() method  cannot be invoked for One Touch Expandable SplitButton");
        }
        this._firstEnabled = bl;
    }

    public boolean isButtonEnabled() {
        if (this._oneTouchExpandable) {
            throw new UnsupportedOperationException("setButtonEnabled() method cannot be invoked for One Touch Expandable SplitButton");
        }
        return this._firstEnabled;
    }

    protected void processMouseEvent(MouseEvent mouseEvent) {
        super.processMouseEvent(mouseEvent);
        switch (mouseEvent.getID()) {
            case 504: {
                this._handleMouseEntered(mouseEvent);
                break;
            }
            case 505: {
                this._handleMouseExited(mouseEvent);
                break;
            }
            case 501: {
                this._handleMousePressed(mouseEvent);
                break;
            }
            case 502: {
                this._handleMouseReleased(mouseEvent);
            }
        }
    }

    protected void processMouseMotionEvent(MouseEvent mouseEvent) {
        super.processMouseMotionEvent(mouseEvent);
        switch (mouseEvent.getID()) {
            case 503: {
                this._handleMouseMoved(mouseEvent);
                break;
            }
            case 506: {
                this._handleMouseDragged(mouseEvent);
            }
        }
    }

    /*
     * Unable to fully structure code
     */
    protected void paintComponent(Graphics var1_1) {
        block16: {
            block17: {
                block15: {
                    var2_2 = 0;
                    var3_3 = OracleUIUtils.getPaintContext(this);
                    var4_4 = this.getHeight();
                    var5_5 = this.getWidth();
                    var6_6 = 0;
                    var7_7 = 0;
                    var8_8 = 0;
                    var9_9 = 3;
                    var10_10 = 3;
                    var11_11 = 0;
                    var12_12 = 0;
                    var13_13 = 0;
                    var14_14 = var1_1.getColor();
                    var1_1.setColor(var3_3.getPaintBackground());
                    var1_1.fillRect(0, 0, var5_5, var4_4);
                    v0 = var15_15 = this._isHorizontal != false ? var5_5 : var4_4;
                    if (!this._oneTouchExpandable) break block15;
                    var2_2 = var15_15 >= 88 ? 6 : (var15_15 >= 72 ? 4 : (var15_15 >= 56 ? 2 : 0));
                    var6_6 = var2_2 / 2;
                    if (var6_6 != 0) {
                        var11_11 = var6_6 * 3 + (var6_6 - 1) * 5;
                    }
                    if (this._isHorizontal) {
                        var7_7 = 8;
                        this._drawOneTouchHorizontalSplitter(var1_1, var4_4, var11_11, var6_6, var7_7, var8_8);
                    } else {
                        var8_8 = 8;
                        this._drawOneTouchVerticalSplitter(var1_1, var5_5, var11_11, var6_6, var7_7, var8_8);
                    }
                    break block16;
                }
                if (var15_15 < 33) {
                    return;
                }
                var2_2 = var15_15 >= 65 ? 7 : (var15_15 >= 44 ? 5 : 3);
                var6_6 = var2_2;
                var11_11 = var6_6 * 3 + (var6_6 - 1) * 5;
                if (this._isHorizontal) {
                    var9_9 = var11_11;
                    var7_7 = 8;
                    if (var4_4 == 5) {
                        var13_13 = 0;
                    } else {
                        var16_16 = var4_4 % 2 == 0 ? var4_4 : var4_4 - 1;
                        var13_13 = (var16_16 - var10_10) / 2;
                    }
                    var12_12 = 7;
                } else {
                    var10_10 = var11_11;
                    var8_8 = 8;
                    if (var4_4 == 5) {
                        var12_12 = 0;
                    } else {
                        var16_16 = var5_5 % 2 == 0 ? var5_5 : var5_5 - 1;
                        var12_12 = (var16_16 - var9_9) / 2;
                    }
                    var13_13 = 7;
                }
                var16_16 = (int)this.isButtonPressed();
                if (var5_5 != 4) break block17;
                while (var6_6 > 0) {
                    if (this.getActualReadingDirection() == 1) {
                        var1_1.setColor(this._highlight);
                        var1_1.drawLine(1, var13_13 + 1, 1, var13_13 + 1);
                        var1_1.setColor(this._shadow);
                        var1_1.drawLine(2, var13_13 + 2, 2, var13_13 + 2);
                    } else {
                        var1_1.setColor(this._highlight);
                        var1_1.drawLine(2, var13_13 + 1, 2, var13_13 + 1);
                        var1_1.setColor(this._shadow);
                        var1_1.drawLine(1, var13_13 + 2, 1, var13_13 + 2);
                    }
                    --var6_6;
                    var12_12 += var7_7;
                    var13_13 += var8_8;
                }
                break block16;
            }
            if (var4_4 != 4) ** GOTO lbl87
            while (var6_6 > 0) {
                var1_1.setColor(this._highlight);
                var1_1.drawLine(var12_12, 1, var12_12, 1);
                var1_1.setColor(this._shadow);
                var1_1.drawLine(var12_12 + 1, 2, var12_12 + 1, 2);
                --var6_6;
                var12_12 += var7_7;
                var13_13 += var8_8;
            }
            break block16;
lbl-1000:
            // 1 sources

            {
                OracleThumbPainter.__drawGrippy(var1_1, var12_12, var13_13, this._highlight, this._shadow, (boolean)var16_16);
                --var6_6;
                var12_12 += var7_7;
                var13_13 += var8_8;
lbl87:
                // 2 sources

                ** while (var6_6 > 0)
            }
        }
        var1_1.setColor(var14_14);
    }

    protected void paintBorder(Graphics graphics) {
        Color color = graphics.getColor();
        int n = this.getWidth();
        int n2 = this.getHeight();
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        int n6 = 0;
        int n7 = 0;
        if (this._isHorizontal) {
            n5 = n - 7;
            n6 = n2;
            n7 = n / 2;
            if (this._oneTouchExpandable) {
                boolean bl = this.isFirstPressed();
                this._drawLeftButtonBorder(graphics, bl, n3, n4, n5, n6, n7);
                bl = this.isSecondPressed();
                this._drawRightButtonBorder(graphics, bl, n3, n4, n5, n6, n7);
            } else {
                boolean bl = this.isButtonPressed();
                this._drawLeftButtonBorder(graphics, bl, n3, n4, n5, n6, n7);
                this._drawRightButtonBorder(graphics, bl, n3, n4, n5, n6, n7);
            }
        } else {
            n5 = n;
            n6 = n2 - 7;
            n7 = n2 / 2;
            if (this._oneTouchExpandable) {
                boolean bl = this.isFirstPressed();
                this._drawTopButtonBorder(graphics, bl, n3, n4, n5, n6, n7);
                bl = this.isSecondPressed();
                this._drawBottomButtonBorder(graphics, bl, n3, n4, n5, n6, n7);
            } else {
                boolean bl = this.isButtonPressed();
                this._drawTopButtonBorder(graphics, bl, n3, n4, n5, n6, n7);
                this._drawBottomButtonBorder(graphics, bl, n3, n4, n5, n6, n7);
            }
        }
        graphics.setColor(color);
    }

    private void _drawLeftButtonBorder(Graphics graphics, boolean bl, int n, int n2, int n3, int n4, int n5) {
        int n6 = n;
        int n7 = 0;
        if (bl) {
            graphics.setColor(this._darkBorder);
        } else {
            graphics.setColor(this._lightBorder);
        }
        graphics.drawLine(n + 3, n2, n5 + 3, n2);
        if (n4 <= 9) {
            graphics.drawLine(n + 2, n2, n + 2, n2);
        } else {
            graphics.drawLine(n + 1, ++n6, n + 2, n6);
        }
        if (n4 <= 7) {
            graphics.drawLine(n + 2, n2, n + 1, n2);
        } else {
            graphics.drawLine(n + 1, ++n6, n + 1, n6);
        }
        if (bl) {
            graphics.setColor(this._darkBorder);
        } else {
            graphics.setColor(this._lightBorder);
        }
        ++n6;
        if (n4 > 5) {
            n7 = n6 + 3;
        } else if (n4 == 5) {
            n7 = n6 + 2;
        } else if (n4 == 4) {
            n7 = n6 + 1;
        }
        graphics.drawLine(n, n6, n, n7 - 1);
        graphics.setColor(this._lightBorder);
        graphics.drawLine(n, n7, n, n7);
        graphics.setColor(this._lightBorder);
        n6 = n7;
        if (n4 > 6) {
            graphics.drawLine(n + 1, ++n6, n + 1, n6);
        }
        if (n4 > 8) {
            graphics.drawLine(n + 1, ++n6, n + 2, n6);
        }
        ++n6;
        if (n4 <= 8) {
            graphics.drawLine(n + 2, n6, n + 2, n6);
        }
        if (n4 <= 6) {
            graphics.drawLine(n + 1, n6, n + 1, n6);
            if (bl) {
                graphics.setColor(this._lightBorder);
            } else {
                graphics.setColor(this._darkBorder);
            }
        }
        graphics.drawLine(n + 3, n6, n + 3, n6);
        if (bl) {
            graphics.setColor(this._lightBorder);
        } else {
            graphics.setColor(this._darkBorder);
        }
        graphics.drawLine(n + 4, n6, n5 - 3, n6);
    }

    private void _drawRightButtonBorder(Graphics graphics, boolean bl, int n, int n2, int n3, int n4, int n5) {
        if (bl) {
            graphics.setColor(this._darkBorder);
        } else {
            graphics.setColor(this._lightBorder);
        }
        int n6 = n2;
        int n7 = 0;
        graphics.drawLine(n5 + 3 + 1, n2, n + 3 + n3, n2);
        if (n4 <= 9) {
            graphics.drawLine(n + 4 + n3, n2, n + 4 + n3, n2);
        } else {
            graphics.drawLine(n + 4 + n3, ++n6, n + 4 + n3, n6);
            graphics.setColor(this._darkBorder);
            graphics.drawLine(n + 5 + n3, n6, n + 5 + n3, n6);
        }
        graphics.setColor(this._darkBorder);
        if (n4 <= 7) {
            graphics.drawLine(n + 5 + n3, n2, n + 5 + n3, n2);
        } else {
            graphics.drawLine(n + 5 + n3, ++n6, n + 5 + n3, n6);
        }
        ++n6;
        if (n4 > 5) {
            n7 = n6 + 3;
        } else if (n4 == 5) {
            n7 = n6 + 2;
        } else if (n4 == 4) {
            n7 = n6 + 1;
        }
        graphics.setColor(this._darkBorder);
        graphics.drawLine(n + 6 + n3, n6, n + 6 + n3, n6);
        if (bl) {
            graphics.setColor(this._lightBorder);
        } else {
            graphics.setColor(this._darkBorder);
        }
        graphics.drawLine(n + 6 + n3, n6 + 1, n + 6 + n3, n7);
        n6 = n7;
        if (bl) {
            graphics.setColor(this._lightBorder);
        } else {
            graphics.setColor(this._darkBorder);
        }
        if (n4 > 6) {
            graphics.drawLine(n + 5 + n3, ++n6, n + 5 + n3, n6);
        }
        if (n4 > 8) {
            graphics.drawLine(n + 4 + n3, ++n6, n + 4 + n3, n6);
        }
        ++n6;
        if (bl) {
            graphics.setColor(this._lightBorder);
        } else {
            graphics.setColor(this._darkBorder);
        }
        graphics.drawLine(n5 - 3 + 1, n6, n + 3 + n3, n6);
        if (n4 <= 8) {
            graphics.drawLine(n + 4 + n3, n6, n + 4 + n3, n6);
        }
        if (n4 <= 6) {
            graphics.drawLine(n + 5 + n3, n6, n + 5 + n3, n6);
        }
    }

    private void _drawTopButtonBorder(Graphics graphics, boolean bl, int n, int n2, int n3, int n4, int n5) {
        int n6;
        int n7 = n;
        int n8 = 0;
        boolean bl2 = this.getActualReadingDirection() == 2;
        int n9 = bl2 ? n5 - 3 : n5 + 3;
        int n10 = n6 = bl2 ? n5 + 3 : n5 - 3;
        if (bl && !bl2) {
            graphics.setColor(this._darkBorder);
        } else {
            graphics.setColor(this._lightBorder);
        }
        graphics.drawLine(n, n2 + 3, n, n2 + 3);
        if (n3 <= 9) {
            graphics.drawLine(n, n2 + 2, n, n2 + 2);
        } else {
            graphics.drawLine(++n7, n2 + 1, n7, n2 + 2);
        }
        if (n3 <= 7) {
            graphics.drawLine(n, n2 + 1, n, n2 + 1);
        } else {
            graphics.drawLine(++n7, n2 + 1, n7, n2 + 1);
        }
        if (bl2 && !bl) {
            graphics.setColor(this._darkBorder);
        }
        graphics.drawLine(n, n2 + 4, n, n9);
        graphics.setColor(this._lightBorder);
        ++n7;
        if (n3 > 5) {
            n8 = n7 + 3;
        } else if (n3 == 5) {
            n8 = n7 + 2;
        } else if (n3 == 4) {
            n8 = n7 + 1;
        }
        if (bl && !bl2) {
            graphics.setColor(this._darkBorder);
        }
        graphics.drawLine(n7, n2, n7, n2);
        if (n8 != n7 + 1) {
            if (bl) {
                graphics.setColor(this._darkBorder);
            }
            graphics.drawLine(n7 + 1, n2, n8 - 1, n2);
        }
        if (bl && bl2) {
            graphics.setColor(this._darkBorder);
        } else {
            graphics.setColor(this._lightBorder);
        }
        graphics.drawLine(n8, n2, n8, n2);
        n7 = n8;
        if (bl && bl2) {
            graphics.setColor(this._darkBorder);
        } else {
            graphics.setColor(this._lightBorder);
        }
        if (n3 > 6) {
            graphics.drawLine(++n7, n2 + 1, n7, n2 + 1);
        }
        if (n3 > 8) {
            graphics.drawLine(++n7, n2 + 1, n7, n2 + 2);
        }
        ++n7;
        if (n3 <= 8) {
            graphics.drawLine(n7, n2 + 2, n7, n2 + 2);
        }
        if (n3 <= 6) {
            graphics.drawLine(n7, n2 + 1, n7, n2 + 1);
        }
        graphics.drawLine(n7, n2 + 3, n7, n2 + 3);
        if (bl && !bl2 || !bl && bl2) {
            graphics.setColor(this._lightBorder);
        } else {
            graphics.setColor(this._darkBorder);
        }
        graphics.drawLine(n7, n2 + 4, n7, n6);
    }

    private void _drawBottomButtonBorder(Graphics graphics, boolean bl, int n, int n2, int n3, int n4, int n5) {
        int n6;
        int n7 = n;
        int n8 = 0;
        boolean bl2 = this.getActualReadingDirection() == 2;
        int n9 = bl2 ? n5 - 3 + 1 : n5 + 3 + 1;
        int n10 = n6 = bl2 ? n5 + 3 + 1 : n5 - 3 + 1;
        if (bl && bl2 || !bl && !bl2) {
            graphics.setColor(this._lightBorder);
        } else {
            graphics.setColor(this._darkBorder);
        }
        graphics.drawLine(n, n9, n, n2 + 3 + n4);
        if (n3 <= 9) {
            graphics.drawLine(n, n2 + 4 + n4, n, n2 + 4 + n4);
        }
        if (n3 <= 7) {
            graphics.drawLine(n, n2 + 5 + n4, n, n2 + 5 + n4);
        }
        if (bl && bl2) {
            graphics.setColor(this._lightBorder);
        } else {
            graphics.setColor(this._darkBorder);
        }
        if (n3 > 9) {
            graphics.drawLine(++n7, n2 + 5 + n4, n7, n2 + 5 + n4);
            if (!bl && !bl2) {
                graphics.setColor(this._lightBorder);
            }
            graphics.drawLine(n7, n2 + 4 + n4, n7, n2 + 4 + n4);
        }
        if (bl && bl2) {
            graphics.setColor(this._lightBorder);
        } else {
            graphics.setColor(this._darkBorder);
        }
        if (n3 > 7) {
            graphics.drawLine(++n7, n2 + 5 + n4, n7, n2 + 5 + n4);
        }
        ++n7;
        if (n3 > 5) {
            n8 = n7 + 3;
        } else if (n3 == 5) {
            n8 = n7 + 2;
        } else if (n3 == 4) {
            n8 = n7 + 1;
        }
        graphics.setColor(this._darkBorder);
        if (bl && bl2) {
            graphics.setColor(this._lightBorder);
        }
        graphics.drawLine(n7, n2 + 6 + n4, n7, n2 + 6 + n4);
        if (n8 != n7 + 1) {
            if (bl) {
                graphics.setColor(this._lightBorder);
            }
            graphics.drawLine(n7 + 1, n2 + 6 + n4, n8 - 1, n2 + 6 + n4);
        }
        if (bl && !bl2) {
            graphics.setColor(this._lightBorder);
        } else {
            graphics.setColor(this._darkBorder);
        }
        graphics.drawLine(n8, n2 + 6 + n4, n8, n2 + 6 + n4);
        n7 = n8;
        if (bl && !bl2) {
            graphics.setColor(this._lightBorder);
        } else {
            graphics.setColor(this._darkBorder);
        }
        if (n3 > 6) {
            graphics.drawLine(++n7, n2 + 5 + n4, n7, n2 + 5 + n4);
        }
        if (n3 > 8) {
            graphics.drawLine(++n7, n2 + 5 + n4, n7, n2 + 5 + n4);
            if (!bl && bl2) {
                graphics.setColor(this._lightBorder);
            }
            graphics.drawLine(n7, n2 + 4 + n4, n7, n2 + 4 + n4);
        }
        ++n7;
        if (bl && !bl2 || !bl && bl2) {
            graphics.setColor(this._lightBorder);
        } else {
            graphics.setColor(this._darkBorder);
        }
        if (n3 <= 8) {
            graphics.drawLine(n7, n2 + 4 + n4, n7, n2 + 4 + n4);
        }
        if (n3 <= 6) {
            graphics.drawLine(n7, n2 + 5 + n4, n7, n2 + 5 + n4);
        }
        graphics.drawLine(n7, n6, n7, n2 + 3 + n4);
    }

    private void _drawOneTouchHorizontalSplitter(Graphics graphics, int n, int n2, int n3, int n4, int n5) {
        block9: {
            int n6;
            int n7;
            int n8;
            block8: {
                n8 = 16;
                int n9 = 0;
                n7 = 8 + n2 + 7 + 7;
                boolean bl = this.isFirstPressed();
                boolean bl2 = this.isSecondPressed();
                boolean bl3 = this.isFirstEnabled();
                boolean bl4 = this.isSecondEnabled();
                boolean bl5 = false;
                n6 = 0;
                int n10 = this.getWidth();
                int n11 = this.getHeight();
                int n12 = n11 / 2;
                int n13 = n10 / 2;
                int[] nArray = null;
                int[] nArray2 = null;
                int[] nArray3 = null;
                int[] nArray4 = null;
                int n14 = 0;
                int n15 = 0;
                int n16 = 0;
                int n17 = 0;
                switch (n) {
                    case 5: {
                        nArray = _sYOffsetDimension5;
                        nArray2 = _sXOffsetDimension5;
                        nArray3 = _sYOffsetSeparatorDimension5;
                        nArray4 = _sXOffsetSeparatorDimension5;
                        n9 = 0;
                        n14 = 10;
                        n16 = n10 - n14;
                        n17 = 1;
                        n15 = 3;
                        break;
                    }
                    case 4: {
                        nArray = _sYOffsetDimension4;
                        nArray2 = _sXOffsetDimension4;
                        nArray3 = _sYOffsetSeparatorDimension4;
                        nArray4 = _sXOffsetSeparatorDimension4;
                        n9 = 0;
                        n14 = 8;
                        n16 = n10 - n14;
                        n17 = 1;
                        n15 = 2;
                        break;
                    }
                    default: {
                        nArray = _sYOffsetCommon;
                        nArray2 = _sXOffsetCommon;
                        nArray3 = _sYOffsetSeparatorCommon;
                        nArray4 = _sXOffsetSeparatorCommon;
                        n9 = n12 - 2;
                        n14 = 12;
                        n16 = n10 - n14;
                        n17 = n12 - 2;
                        n15 = n12 + 1;
                    }
                }
                this._drawArrow(graphics, nArray, nArray2, n14, n15, 3, bl3);
                this._drawArrow(graphics, nArray, nArray2, n16, n17, 4, bl4);
                this._drawSeparator(graphics, nArray3, nArray4, n13 + 2, 1);
                if (n < 5) break block8;
                n6 = n3;
                while (n6 > 0) {
                    OracleThumbPainter.__drawGrippy(graphics, n8, n9, this._highlight, this._shadow, bl);
                    --n6;
                    n8 += n4;
                    n9 += n5;
                }
                n8 = n7 + 5 + 7 + 1;
                n6 = n3;
                while (n6 > 0) {
                    OracleThumbPainter.__drawGrippy(graphics, n8, n9, this._highlight, this._shadow, bl2);
                    --n6;
                    n8 += n4;
                    n9 += n5;
                }
                break block9;
            }
            if (n != 4) break block9;
            n6 = n3;
            while (n6 > 0) {
                graphics.setColor(this._highlight);
                graphics.drawLine(n8, 1, n8, 1);
                graphics.setColor(this._shadow);
                graphics.drawLine(n8 + 1, 2, n8 + 1, 2);
                --n6;
                n8 += n4;
                n9 += n5;
            }
            n8 = n7 + 5 + 7 + 1;
            n6 = n3;
            while (n6 > 0) {
                graphics.setColor(this._highlight);
                graphics.drawLine(n8, 1, n8, 1);
                graphics.setColor(this._shadow);
                graphics.drawLine(n8 + 1, 2, n8 + 1, 2);
                --n6;
                n8 += n4;
                n9 += n5;
            }
        }
    }

    private void _drawArrow(Graphics graphics, int[] nArray, int[] nArray2, int n, int n2, int n3, boolean bl) {
        int n4 = this.getActualReadingDirection();
        Color color = bl ? this._darkBorder : this._shadow;
        graphics.setColor(color);
        int n5 = 0;
        if (n3 == 1 || n3 == 4) {
            n5 = 0;
            while (n5 < nArray.length - 1) {
                graphics.drawLine(n + nArray[n5], n2 + nArray2[n5], n + nArray[n5 + 1], n2 + nArray2[n5 + 1]);
                n5 += 2;
            }
        } else {
            n5 = nArray.length - 1;
            while (n5 > 0) {
                graphics.drawLine(n - nArray[n5], n2 - nArray2[n5], n - nArray[n5 - 1], n2 - nArray2[n5 - 1]);
                n5 -= 2;
            }
        }
    }

    private void _drawSeparator(Graphics graphics, int[] nArray, int[] nArray2, int n, int n2) {
        int n3 = 0;
        int n4 = this.getActualReadingDirection();
        int n5 = 0;
        int n6 = 0;
        int n7 = 0;
        int n8 = 0;
        if (this._isHorizontal) {
            n5 = -1;
            n6 = 1;
            n7 = -1;
            n8 = 0;
        } else {
            if (n4 == 1) {
                n5 = 1;
                n6 = -1;
            } else {
                n5 = -1;
                n6 = -1;
            }
            n7 = 0;
            n8 = -1;
        }
        n3 = 0;
        while (n3 < nArray.length - 1) {
            graphics.setColor(this._darkBorder);
            graphics.drawLine(n + n5 * nArray[n3], n2 + n6 * nArray2[n3], n + n5 * nArray[n3 + 1], n2 + n6 * nArray2[n3 + 1]);
            graphics.setColor(this._lightBorder);
            graphics.drawLine(n + n5 * nArray[n3] - n7, n2 + n6 * nArray2[n3] - n8, n + n5 * nArray[n3 + 1] - n7, n2 + n6 * nArray2[n3 + 1] - n8);
            n3 += 2;
        }
    }

    private void _drawOneTouchVerticalSplitter(Graphics graphics, int n, int n2, int n3, int n4, int n5) {
        block16: {
            int n6;
            int n7;
            int n8;
            int n9;
            block15: {
                int n10 = 0;
                n9 = 16;
                n8 = 8 + n2 + 7 + 7;
                boolean bl = this.isFirstPressed();
                boolean bl2 = this.isSecondPressed();
                n7 = this.getActualReadingDirection();
                boolean bl3 = this.isFirstEnabled();
                boolean bl4 = this.isSecondEnabled();
                boolean bl5 = false;
                n6 = 0;
                int n11 = this.getHeight();
                int n12 = this.getWidth();
                int n13 = n12 / 2;
                int n14 = n11 / 2;
                int[] nArray = null;
                int[] nArray2 = null;
                int[] nArray3 = null;
                int[] nArray4 = null;
                int n15 = 0;
                int n16 = 0;
                int n17 = 0;
                int n18 = 0;
                switch (n) {
                    case 5: {
                        nArray = _sXOffsetDimension5;
                        nArray2 = _sYOffsetDimension5;
                        nArray3 = _sXOffsetSeparatorDimension5;
                        nArray4 = _sYOffsetSeparatorDimension5;
                        n10 = n7 == 1 ? 0 : 4;
                        n15 = 1;
                        n16 = 3;
                        n17 = 10;
                        n18 = n11 - n17;
                        break;
                    }
                    case 4: {
                        nArray = _sXOffsetDimension4;
                        nArray2 = _sYOffsetDimension4;
                        nArray3 = _sXOffsetSeparatorDimension4;
                        nArray4 = _sYOffsetSeparatorDimension4;
                        n10 = n7 == 1 ? 0 : 3;
                        n15 = 1;
                        n16 = 2;
                        n17 = 8;
                        n18 = n11 - n17;
                        break;
                    }
                    default: {
                        nArray = _sXOffsetCommon;
                        nArray2 = _sYOffsetCommon;
                        nArray3 = _sXOffsetSeparatorCommon;
                        nArray4 = _sYOffsetSeparatorCommon;
                        n10 = n7 == 1 ? n13 - 2 : n13 + 1;
                        n15 = n13 - 2;
                        n16 = n13 + 1;
                        n17 = 12;
                        n18 = n11 - n17;
                    }
                }
                if (n7 == 1) {
                    this._drawArrow(graphics, nArray, nArray2, n15, 6, 1, bl3);
                    this._drawArrow(graphics, nArray, nArray2, n16, n11 - 5 + 1, 2, bl4);
                    this._drawSeparator(graphics, nArray3, nArray4, 1, n14 + 2);
                } else {
                    this._drawArrow(graphics, nArray, nArray2, n16, n17, 2, bl3);
                    this._drawArrow(graphics, nArray, nArray2, n15, n18, 1, bl4);
                    this._drawSeparator(graphics, nArray3, nArray4, n - 2, n14 + 2);
                }
                if (n < 5) break block15;
                n6 = n3;
                while (n6 > 0) {
                    OracleThumbPainter.__drawGrippy(graphics, n10, n9, this._highlight, this._shadow, bl, this.getActualReadingDirection());
                    --n6;
                    n10 += n4;
                    n9 += n5;
                }
                n9 = n8 + 5 + 7 + 1;
                n6 = n3;
                while (n6 > 0) {
                    OracleThumbPainter.__drawGrippy(graphics, n10, n9, this._highlight, this._shadow, bl2, this.getActualReadingDirection());
                    --n6;
                    n10 += n4;
                    n9 += n5;
                }
                break block16;
            }
            if (n != 4) break block16;
            n6 = n3;
            while (n6 > 0) {
                if (n7 == 1) {
                    graphics.setColor(this._highlight);
                    graphics.drawLine(1, n9 + 1, 1, n9 + 1);
                    graphics.setColor(this._shadow);
                    graphics.drawLine(2, n9 + 2, 2, n9 + 2);
                } else if (n7 == 2) {
                    graphics.setColor(this._highlight);
                    graphics.drawLine(2, n9 + 1, 2, n9 + 1);
                    graphics.setColor(this._shadow);
                    graphics.drawLine(1, n9 + 2, 1, n9 + 2);
                }
                --n6;
                n10 += n4;
                n9 += n5;
            }
            n9 = n8 + 5 + 7 + 1;
            n6 = n3;
            while (n6 > 0) {
                if (n7 == 1) {
                    graphics.setColor(this._highlight);
                    graphics.drawLine(1, n9 + 1, 1, n9 + 1);
                    graphics.setColor(this._shadow);
                    graphics.drawLine(2, n9 + 2, 2, n9 + 2);
                } else {
                    graphics.setColor(this._highlight);
                    graphics.drawLine(2, n9 + 1, 2, n9 + 1);
                    graphics.setColor(this._shadow);
                    graphics.drawLine(1, n9 + 2, 1, n9 + 2);
                }
                --n6;
                n10 += n4;
                n9 += n5;
            }
        }
    }

    private void _fireActionPerformed(int n) {
        Enumeration enumeration = this._listenerManager.getListeners();
        if (enumeration != null) {
            ActionEvent actionEvent = new ActionEvent(this, n, "");
            while (enumeration.hasMoreElements()) {
                ActionListener actionListener = (ActionListener)enumeration.nextElement();
                actionListener.actionPerformed(actionEvent);
            }
        }
    }

    private boolean _isInFirstButton(int n, int n2) {
        boolean bl;
        int n3 = this.getActualReadingDirection();
        boolean bl2 = false;
        if (this._isHorizontal) {
            boolean bl3;
            int n4 = this.getWidth() / 2;
            int n5 = this.getHeight();
            boolean bl4 = bl3 = n2 >= 0 && n2 < n5 - 1 && n >= 0 && n < n4 - 3;
            if (bl3) {
                return bl3;
            }
            bl2 = n2 > 0 && n > n4 - 3 && 6 * n2 < (3 + n4 - n) * (n5 - 1);
            return bl2;
        }
        int n6 = this.getHeight() / 2;
        int n7 = this.getWidth();
        boolean bl5 = bl = n >= 0 && n < n7 - 1 && n2 >= 0 && n2 < n6 - 3;
        if (bl) {
            return bl;
        }
        bl2 = n3 == 1 ? n > 0 && n2 > n6 - 3 && 6 * n < (3 + n6 - n2) * (n7 - 1) : n < n7 - 1 && n2 > n6 - 3 && 6 * n > (3 - n6 + n2) * (n7 - 1);
        return bl2;
    }

    private void _handleMouseExited(MouseEvent mouseEvent) {
        if (this._oneTouchExpandable) {
            this.setFirstArmed(false);
            this.setSecondArmed(false);
        } else {
            this.setButtonArmed(false);
        }
    }

    private void _handleMouseEntered(MouseEvent mouseEvent) {
        int n = mouseEvent.getX();
        int n2 = mouseEvent.getY();
        if (this._oneTouchExpandable) {
            boolean bl = this._isInFirstButton(n, n2);
            if (this.isFirstEnabled()) {
                this.setFirstArmed(bl);
            }
            if (this.isSecondEnabled()) {
                this.setSecondArmed(!bl);
            }
        } else if (this.isButtonEnabled()) {
            this.setButtonArmed(true);
        }
    }

    private void _handleMousePressed(MouseEvent mouseEvent) {
        int n = mouseEvent.getX();
        int n2 = mouseEvent.getY();
        if (this._oneTouchExpandable) {
            boolean bl = this._isInFirstButton(n, n2);
            if (this.isFirstEnabled()) {
                this.setFirstPressed(bl);
            }
            if (this.isSecondEnabled()) {
                this.setSecondPressed(!bl);
            }
        } else if (this.isButtonEnabled()) {
            this.setButtonPressed(true);
        }
    }

    private void _handleMouseReleased(MouseEvent mouseEvent) {
        if (mouseEvent.isConsumed()) {
            this._resetPressedState();
            this.repaint();
        } else if (this._oneTouchExpandable) {
            if (this.isFirstEnabled()) {
                this.setFirstPressed(false);
            }
            if (this.isSecondEnabled()) {
                this.setSecondPressed(false);
            }
        } else if (this.isButtonEnabled()) {
            this.setButtonPressed(false);
        }
    }

    private void _handleMouseMoved(MouseEvent mouseEvent) {
        int n = mouseEvent.getX();
        int n2 = mouseEvent.getY();
        Rectangle rectangle = this.getBounds();
        if (this._oneTouchExpandable) {
            boolean bl = this._isInFirstButton(n, n2);
            if (this.isFirstEnabled()) {
                this.setFirstArmed(bl);
            }
            if (this.isSecondEnabled()) {
                this.setSecondArmed(!bl);
            }
        } else if (this.isButtonEnabled()) {
            this.setButtonArmed(true);
        }
    }

    private void _handleMouseDragged(MouseEvent mouseEvent) {
        int n = this.getHeight();
        int n2 = this.getWidth();
        int n3 = mouseEvent.getX();
        int n4 = mouseEvent.getY();
        if (this._oneTouchExpandable) {
            if (n3 < 0 || n3 > n2 || n4 < 0 || n4 > n) {
                if (this.isFirstEnabled()) {
                    this.setFirstArmed(false);
                }
                if (this.isSecondEnabled()) {
                    this.setSecondArmed(false);
                }
            } else {
                boolean bl = this._isInFirstButton(n3, n4);
                if (this.isFirstEnabled()) {
                    this.setFirstArmed(bl);
                }
                if (this.isSecondEnabled()) {
                    this.setSecondArmed(!bl);
                }
            }
        }
    }

    private void _resetPressedState() {
        this._firstPressed = false;
        this._secondPressed = false;
    }
}

