/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.ewt.olaf;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.event.ContainerEvent;
import java.awt.event.ContainerListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Hashtable;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JToggleButton;
import javax.swing.JToolBar;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.UIDefaults;
import javax.swing.border.Border;
import javax.swing.event.MouseInputListener;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.UIResource;
import javax.swing.plaf.basic.BasicToolBarUI;
import oracle.bali.ewt.olaf.OracleButtonPainter;
import oracle.bali.ewt.olaf.OracleToolBarPainter;
import oracle.bali.ewt.olaf.OracleUIUtils;
import oracle.bali.ewt.painter.AbstractPainter;
import oracle.bali.ewt.painter.AlignmentPainter;
import oracle.bali.ewt.painter.FixedBorderPainter;
import oracle.bali.ewt.painter.Painter;
import oracle.bali.ewt.painter.PainterJoiner;
import oracle.bali.ewt.plaf.BorderAdapter;
import oracle.bali.ewt.util.FocusUtils;

public class OracleToolBarUI
extends BasicToolBarUI
implements ContainerListener,
PropertyChangeListener {
    private Hashtable borderTable = new Hashtable();
    private static final int _HORIZONTAL_BIT = 1;
    private static final int _TEXT_BIT = 2;
    private static final int _ICON_BIT = 4;
    private static final int _ROLLOVER_ICON_BIT = 8;
    private static Painter[] _sPainterCache = new Painter[16];

    public static ComponentUI createUI(JComponent jComponent) {
        return new OracleToolBarUI();
    }

    public static Object instantiate(UIDefaults uIDefaults, Object object, String string) {
        if (object.equals("ToolBar.border")) {
            return new BorderAdapter(new OracleToolBarPainter(null, false));
        }
        return null;
    }

    public void installUI(JComponent jComponent) {
        super.installUI(jComponent);
        Component[] componentArray = jComponent.getComponents();
        int n = 0;
        while (n < componentArray.length) {
            this._fixChild(componentArray[n]);
            ++n;
        }
        jComponent.setOpaque(false);
    }

    public void uninstallUI(JComponent jComponent) {
        super.uninstallUI(jComponent);
        Component[] componentArray = jComponent.getComponents();
        int n = 0;
        while (n < componentArray.length) {
            Component component = componentArray[n];
            if (OracleToolBarUI._isButton(component)) {
                ((JComponent)component).removePropertyChangeListener(this);
            }
            ++n;
        }
    }

    public void update(Graphics graphics, JComponent jComponent) {
        OracleUIUtils.fillBackground(graphics, jComponent);
        this.paint(graphics, jComponent);
    }

    protected void installListeners() {
        super.installListeners();
        this.toolBar.addContainerListener(this);
    }

    protected void uninstallListeners() {
        super.uninstallListeners();
        this.toolBar.removeContainerListener(this);
    }

    public void componentAdded(ContainerEvent containerEvent) {
        Component component = containerEvent.getChild();
        if (OracleToolBarUI._isButton(component)) {
            AbstractButton abstractButton = (AbstractButton)component;
            this._fixChild(abstractButton);
            abstractButton.addPropertyChangeListener(this);
        }
    }

    public void componentRemoved(ContainerEvent containerEvent) {
        Component component = containerEvent.getChild();
        if (OracleToolBarUI._isButton(component)) {
            ((JComponent)component).removePropertyChangeListener(this);
        }
    }

    public boolean isFloating() {
        return false;
    }

    public void setFloating(boolean bl, Point point) {
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if ("ToolTipText".equals(propertyChangeEvent.getPropertyName())) {
            SwingUtilities.invokeLater(new KeyStrokeUnregisterer((AbstractButton)propertyChangeEvent.getSource()));
        }
    }

    protected MouseInputListener createDockingListener() {
        return null;
    }

    protected Border createRolloverBorder() {
        return null;
    }

    protected Border createNonRolloverBorder() {
        return null;
    }

    protected void setBorderToRollover(Component component) {
        if (component instanceof AbstractButton) {
            AbstractButton abstractButton = (AbstractButton)component;
            Border border = (Border)this.borderTable.get(abstractButton);
            if ((border == null || border instanceof UIResource) && abstractButton.getBorder() != null) {
                this.borderTable.put(abstractButton, abstractButton.getBorder());
            }
            abstractButton.setBorder(null);
        }
    }

    protected void setBorderToNonRollover(Component component) {
        if (component instanceof AbstractButton) {
            AbstractButton abstractButton = (AbstractButton)component;
            Border border = (Border)this.borderTable.get(abstractButton);
            if ((border == null || border instanceof UIResource) && abstractButton.getBorder() != null) {
                this.borderTable.put(abstractButton, abstractButton.getBorder());
            }
            abstractButton.setBorder(null);
        }
    }

    protected void setBorderToNormal(Component component) {
        if (component instanceof AbstractButton) {
            AbstractButton abstractButton = (AbstractButton)component;
            Border border = (Border)this.borderTable.remove(abstractButton);
            abstractButton.setBorder(border);
        }
    }

    private void _fixChild(Component component) {
        if (OracleToolBarUI._isButton(component)) {
            AbstractButton abstractButton = (AbstractButton)component;
            if (abstractButton.getBorder() instanceof UIResource) {
                abstractButton.setBorder(null);
            }
            abstractButton.setRolloverEnabled(true);
            abstractButton.setOpaque(false);
            abstractButton.setBackground(null);
            OracleToolBarUI._resetFocusableKeyboardActions(abstractButton);
        }
    }

    private static boolean _isButton(Component component) {
        return component instanceof JButton || component instanceof JToggleButton;
    }

    private static void _resetFocusableKeyboardActions(Component component) {
        if (OracleToolBarUI._isButton(component)) {
            JComponent jComponent = (JComponent)component;
            FocusUtils.setFocusable(jComponent, false);
            KeyStroke[] keyStrokeArray = jComponent.getRegisteredKeyStrokes();
            int n = 0;
            while (n < keyStrokeArray.length) {
                KeyStroke keyStroke = keyStrokeArray[n];
                if (jComponent.getConditionForKeyStroke(keyStroke) == 0) {
                    jComponent.unregisterKeyboardAction(keyStroke);
                }
                ++n;
            }
        }
    }

    public static Painter getButtonPainter(JToolBar jToolBar, AbstractButton abstractButton) {
        Painter painter;
        String string;
        int n = 0;
        Dimension dimension = jToolBar.getSize();
        if (dimension.width > dimension.height) {
            ++n;
        }
        if ((string = abstractButton.getText()) != null && string.length() > 0) {
            n += 2;
        }
        if (abstractButton.getIcon() != null) {
            n += 4;
        }
        if (abstractButton.getRolloverIcon() != null) {
            n += 8;
        }
        if ((painter = _sPainterCache[n]) == null) {
            OracleToolBarUI._sPainterCache[n] = painter = new AlignmentPainter(new FixedBorderPainter(OracleToolBarUI._createContentPainter(n), 0, 2, 0, 2));
        }
        return painter;
    }

    private static Painter _createContentPainter(int n) {
        boolean bl = (n & 1) != 0;
        boolean bl2 = (n & 8) != 0;
        AbstractPainter abstractPainter = null;
        switch (n &= 0xFFFFFFF6) {
            default: {
                break;
            }
            case 4: {
                abstractPainter = new OracleButtonPainter((Painter)new FixedBorderPainter(OracleUIUtils.getIconPainter(), 0, 0, 1, 0), true, true, !bl2);
                break;
            }
            case 2: {
                abstractPainter = new OracleButtonPainter((Painter)new FixedBorderPainter(OracleToolBarUI._createContentTextPainter(bl), 1, 2, 1, 2), true, true, true);
                break;
            }
            case 6: {
                abstractPainter = new PainterJoiner(OracleToolBarUI._createContentTextPainter(bl), new OracleButtonPainter(OracleUIUtils.getIconPainter(), true, true, !bl2), 3);
            }
        }
        return abstractPainter;
    }

    private static Painter _createContentTextPainter(boolean bl) {
        if (bl) {
            return new FixedBorderPainter(OracleUIUtils.getHTMLTextPainter(), 0, 4, 0, 4, false);
        }
        return OracleUIUtils.getHTMLTextPainter();
    }

    private static class KeyStrokeUnregisterer
    implements Runnable {
        private AbstractButton _buttonChild;

        KeyStrokeUnregisterer(AbstractButton abstractButton) {
            this._buttonChild = abstractButton;
        }

        public void run() {
            Container container = this._buttonChild.getParent();
            if (container != null && container instanceof JToolBar) {
                OracleToolBarUI._resetFocusableKeyboardActions(this._buttonChild);
            }
        }
    }
}

