/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.ewt.olaf;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.Serializable;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JTabbedPane;
import javax.swing.KeyStroke;
import javax.swing.LookAndFeel;
import javax.swing.MenuElement;
import javax.swing.MenuSelectionManager;
import javax.swing.SwingUtilities;
import javax.swing.UIDefaults;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.TabbedPaneUI;
import oracle.bali.ewt.graphics.ImageSetIcon;
import oracle.bali.ewt.graphics.ImageStrip;
import oracle.bali.ewt.graphics.SpacingIcon;
import oracle.bali.ewt.olaf.OracleButtonPainter;
import oracle.bali.ewt.olaf.OracleFocusPainter;
import oracle.bali.ewt.olaf.OracleTabPainter;
import oracle.bali.ewt.olaf.OracleUIUtils;
import oracle.bali.ewt.olaf.TabTextPainter;
import oracle.bali.ewt.painter.AlignmentPainter;
import oracle.bali.ewt.painter.ColorChange;
import oracle.bali.ewt.painter.DirectionalBorderPainter;
import oracle.bali.ewt.painter.FixedBorderPainter;
import oracle.bali.ewt.painter.IconPainter;
import oracle.bali.ewt.painter.JPaintContext;
import oracle.bali.ewt.painter.PaintContext;
import oracle.bali.ewt.painter.Painter;
import oracle.bali.ewt.painter.PainterJoiner;
import oracle.bali.ewt.painter.PainterStacker;
import oracle.bali.ewt.plaf.DisablingPainter;
import oracle.bali.ewt.util.ImmInsets;
import oracle.bali.ewt.util.MenuUtils;
import oracle.bali.share.sort.Comparator;
import oracle.bali.share.sort.LexiComparator;
import oracle.bali.share.sort.Sort;
import oracle.bali.share.util.IntegerUtils;

public class OracleTabbedPaneUI
extends TabbedPaneUI
implements LayoutManager {
    private Component _visibleComponent;
    private static final int _MINIMUM_TRUNCATION = 4;
    private static final int _TAB_OVERLAP = 3;
    private static final int _SCROLL_BUTTON_MARGIN = 2;
    private TabCtxt _buttonContext;
    private TabCtxt _context;
    private Listeners _listeners;
    private KeyStroke _upKey;
    private KeyStroke _downKey;
    private KeyStroke _altUpKey;
    private KeyStroke _altDownKey;
    private KeyStroke _previousKey;
    private KeyStroke _nextKey;
    private KeyStroke _pageDownKey;
    private KeyStroke _pageUpKey;
    Integer _minimumChars;
    Rectangle _buttonBounds;
    boolean _buttonArmed;
    int _firstVisible;
    int _lastVisible;
    Rectangle[] _rects;
    JTabbedPane _tabPane;
    private static final ImmInsets _sContentInsets = new ImmInsets(3, 3, 3, 3);
    private static Painter _sButtonPainter;
    private static final Painter[] _sPainterCache;
    private static final String _PROPERTY_DONT_TRUNCATE = "DontTruncateTabs";

    public static ComponentUI createUI(JComponent jComponent) {
        return new OracleTabbedPaneUI();
    }

    public static Object instantiate(UIDefaults uIDefaults, Object object, String string) {
        if ("TabbedPane.visibleSet".equals(object)) {
            return new ImageSetIcon(new ImageStrip((Image)OracleUIUtils.cImageInst(uIDefaults, null, "tabvisstrip.gif"), 2));
        }
        return null;
    }

    public void installUI(JComponent jComponent) {
        this._tabPane = (JTabbedPane)jComponent;
        jComponent.setLayout(this);
        this._listeners = new Listeners();
        jComponent.addMouseListener(this._listeners);
        jComponent.addFocusListener(this._listeners);
        jComponent.addPropertyChangeListener(this._listeners);
        this._tabPane.addChangeListener(this._listeners);
        this._buttonBounds = new Rectangle();
        this._buttonContext = new TabCtxt(this._tabPane, true);
        this._context = new TabCtxt(this._tabPane, false);
        LookAndFeel.installColorsAndFont(jComponent, "TabbedPane.background", "TabbedPane.foreground", "TabbedPane.font");
        this._installKeyboardActions();
    }

    public void uninstallUI(JComponent jComponent) {
        this._uninstallKeyboardActions();
        jComponent.removeMouseListener(this._listeners);
        jComponent.removeFocusListener(this._listeners);
        jComponent.removePropertyChangeListener(this._listeners);
        this._tabPane.removeChangeListener(this._listeners);
        jComponent.setLayout(null);
        this._tabPane = null;
        this._buttonBounds = null;
        this._listeners = null;
        this._buttonContext.dispose();
        this._buttonContext = null;
        this._context.dispose();
        this._context = null;
    }

    public Rectangle getTabBounds(JTabbedPane jTabbedPane, int n) {
        Rectangle rectangle = this._getTabBounds(n);
        rectangle = rectangle != null ? new Rectangle(rectangle) : new Rectangle();
        return rectangle;
    }

    public int getTabRunCount(JTabbedPane jTabbedPane) {
        return 1;
    }

    public int tabForCoordinate(JTabbedPane jTabbedPane, int n, int n2) {
        if (this._buttonBounds.contains(n, n2)) {
            return -1;
        }
        Rectangle[] rectangleArray = this._rects;
        if (rectangleArray != null) {
            int n3 = this._firstVisible;
            while (n3 <= this._lastVisible) {
                if (rectangleArray[n3].contains(n, n2)) {
                    return n3;
                }
                ++n3;
            }
        }
        return -1;
    }

    public Dimension getPreferredSize(JComponent jComponent) {
        return null;
    }

    public Dimension getMinimumSize(JComponent jComponent) {
        return null;
    }

    public Dimension getMaximumSize(JComponent jComponent) {
        return null;
    }

    public void paint(Graphics graphics, JComponent jComponent) {
        JTabbedPane jTabbedPane = this._tabPane;
        int n = jTabbedPane.getSelectedIndex();
        int n2 = jTabbedPane.getTabCount();
        if (n2 > 0) {
            Rectangle rectangle;
            if (n2 != this._rects.length) {
                jTabbedPane.validate();
            }
            Rectangle rectangle2 = graphics.getClipBounds();
            int n3 = this._firstVisible;
            while (n3 <= this._lastVisible) {
                if (n3 != n && (rectangle = this._rects[n3]).intersects(rectangle2)) {
                    this._paintTab(graphics, n3, rectangle);
                }
                ++n3;
            }
            if (n >= 0 && (rectangle = this._rects[n]).intersects(rectangle2)) {
                this._paintTab(graphics, n, rectangle);
            }
            if (this._isScrollButtonVisible()) {
                rectangle = this._buttonBounds;
                OracleTabbedPaneUI._getButtonPainter().paint(this._getButtonContext(), graphics, rectangle.x, rectangle.y, rectangle.width, rectangle.height);
            }
        }
        this._paintContentBorder(graphics, n);
    }

    public ImmInsets getContentBorderInsets(int n) {
        return _sContentInsets;
    }

    void selectNextTab() {
        JTabbedPane jTabbedPane = this._tabPane;
        int n = this._tabPane.getSelectedIndex();
        int n2 = this._getNextTabIndex(n);
        while (n2 >= 0 && n2 != n && !jTabbedPane.isEnabledAt(n2)) {
            n2 = this._getNextTabIndex(n2);
        }
        if (n2 >= 0) {
            jTabbedPane.setSelectedIndex(n2);
        }
    }

    void selectPreviousTab() {
        JTabbedPane jTabbedPane = this._tabPane;
        int n = this._tabPane.getSelectedIndex();
        int n2 = this._getPreviousTabIndex(n);
        while (n2 >= 0 && n2 != n && !jTabbedPane.isEnabledAt(n2)) {
            n2 = this._getPreviousTabIndex(n2);
        }
        if (n2 >= 0) {
            jTabbedPane.setSelectedIndex(n2);
        }
    }

    private int _getPreviousTabIndex(int n) {
        return n - 1;
    }

    private int _getNextTabIndex(int n) {
        if (++n == this._tabPane.getTabCount()) {
            return -1;
        }
        return n;
    }

    private void _paintTab(Graphics graphics, int n, Rectangle rectangle) {
        PaintContext paintContext = this._getTabContext(n);
        this._getPainter(rectangle).paint(paintContext, graphics, rectangle.x, rectangle.y, rectangle.width, rectangle.height);
    }

    private void _paintContentBorder(Graphics graphics, int n) {
        int n2;
        int n3;
        boolean bl;
        Rectangle rectangle;
        boolean bl2;
        boolean bl3;
        Color color;
        Color color2;
        Color color3;
        JTabbedPane jTabbedPane = this._tabPane;
        int n4 = jTabbedPane.getWidth();
        int n5 = jTabbedPane.getHeight();
        int n6 = jTabbedPane.getTabPlacement();
        Insets insets = jTabbedPane.getInsets();
        boolean bl4 = jTabbedPane.getTabCount() == 0;
        int n7 = insets.left;
        int n8 = insets.top;
        int n9 = n4 - insets.right - insets.left;
        int n10 = n5 - insets.top - insets.bottom;
        if (bl4) {
            n6 = Integer.MIN_VALUE;
        }
        switch (n6) {
            case 2: {
                n9 -= (n7 += this._getTabBounds((int)0).width) - insets.left;
                break;
            }
            case 4: {
                n9 -= this._getTabBounds((int)0).width;
                break;
            }
            case 3: {
                n10 -= this._getTabBounds((int)0).height;
                break;
            }
            case 1: {
                n10 -= (n8 += this._getTabBounds((int)0).height) - insets.top;
                break;
            }
        }
        int n11 = n7 + n9 - 1;
        int n12 = n8 + n10 - 1;
        PaintContext paintContext = this._getTabContext(0);
        UIDefaults uIDefaults = paintContext.getPaintUIDefaults();
        Color color4 = uIDefaults.getColor("TabbedPane.darkShadow");
        Color color5 = uIDefaults.getColor("TabbedPane.normalColor");
        Color color6 = jTabbedPane.getBackground();
        Color color7 = uIDefaults.getColor("TabbedPane.selectedColor");
        boolean bl5 = Boolean.TRUE.equals(uIDefaults.get("TabbedPane.changeCornerColor"));
        if ((paintContext.getPaintState() & 4) == 0 || !bl5) {
            color3 = uIDefaults.getColor("TabbedPane.lightBorder");
            color2 = color5;
            color7 = uIDefaults.getColor("TabbedPane.selectedColor");
            color = uIDefaults.getColor("TabbedPane.cornerPixel");
        } else {
            color3 = color4;
            color2 = color4;
            color = color4;
            color7 = uIDefaults.getColor("TabbedPane.inactiveSelectedColor");
        }
        graphics.setColor(color6);
        graphics.fillRect(n7 + 1, n8 + 1, n9 - 2, n10 - 2);
        boolean bl6 = this._flipItems();
        if (bl4) {
            bl3 = false;
            bl2 = false;
        } else if (this._isVertical()) {
            bl3 = this._getTabBounds((int)this._firstVisible).y == n8;
            rectangle = this._getTabBounds(this._lastVisible);
            bl2 = rectangle.y + rectangle.height - 1 == n12;
        } else {
            bl3 = this._getTabBounds((int)(bl6 ? this._lastVisible : this._firstVisible)).x == n7;
            rectangle = this._getTabBounds(bl6 ? this._firstVisible : this._lastVisible);
            boolean bl7 = bl2 = rectangle.x + rectangle.width - 1 == n11;
        }
        boolean bl8 = bl3 && n == (bl6 ? this._lastVisible : this._firstVisible) ? true : (bl = false);
        boolean bl9 = bl2 && n == (bl6 ? this._firstVisible : this._lastVisible);
        Rectangle rectangle2 = bl4 ? null : this._getTabBounds(n);
        graphics.setColor(color3);
        if (n6 == 1) {
            if (!bl) {
                graphics.drawLine(n7 + 3, n8, rectangle2.x - 1, n8);
            }
            if (!bl9) {
                graphics.drawLine(rectangle2.x + rectangle2.width, n8, n11 - 3, n8);
            }
            graphics.setColor(color7);
            graphics.drawLine(rectangle2.x, n8, rectangle2.x + rectangle2.width - 1, n8);
            graphics.setColor(color3);
        } else {
            n3 = n6 == 2 && bl ? n7 : n7 + 3;
            n2 = n6 == 4 && bl ? n11 : n11 - 3;
            graphics.drawLine(n3, n8, n2, n8);
        }
        if (!bl || n6 != 1 && n6 != 2) {
            if (n6 == 1 || n6 == 2) {
                graphics.setColor(color);
            }
            graphics.drawLine(n7 + 1, n8 + 1, n7 + 2, n8 + 1);
            graphics.drawLine(n7 + 1, n8 + 2, n7 + 1, n8 + 2);
            graphics.setColor(color3);
        }
        if ((n6 == 1 || n6 == 2) && bl3 && !bl) {
            graphics.setColor(color5);
            graphics.drawLine(n7, n8, n7 + 2, n8);
            graphics.drawLine(n7, n8 + 1, n7, n8 + 2);
            graphics.setColor(color3);
        }
        if (n6 == 2) {
            if (!bl) {
                graphics.drawLine(n7, n8 + 3, n7, rectangle2.y - 1);
            }
            if (!bl9) {
                graphics.drawLine(n7, rectangle2.y + rectangle2.height, n7, n12 - 3);
            }
            graphics.setColor(color7);
            graphics.drawLine(n7, rectangle2.y + (bl ? 1 : 0), n7, rectangle2.y + rectangle2.height - 1);
            graphics.setColor(color3);
        } else {
            n3 = n6 == 1 && bl ? n8 : n8 + 3;
            n2 = n6 == 3 && bl ? n12 : n12 - 3;
            graphics.drawLine(n7, n3, n7, n2);
        }
        if (!(n6 == 2 && bl9 || n6 == 3 && bl)) {
            if (n6 == 3) {
                graphics.setColor(color);
            }
            graphics.drawLine(n7 + 1, n12 - 2, n7 + 1, n12 - 2);
            if (bl5) {
                graphics.setColor(color2);
            }
            graphics.drawLine(n7 + 1, n12 - 1, n7 + 1, n12 - 1);
            if (bl5) {
                graphics.setColor(color3);
            }
            graphics.drawLine(n7 + 2, n12 - 1, n7 + 2, n12 - 1);
            graphics.setColor(color3);
        }
        if (n6 == 2 && bl2 && !bl9 || n6 == 3 && bl3 && !bl) {
            graphics.setColor(color5);
            graphics.drawLine(n7, n12 - 2, n7, n12);
            graphics.drawLine(n7 + 1, n12, n7 + 2, n12);
            graphics.setColor(color4);
        } else {
            graphics.setColor(color4);
        }
        if (n6 == 3) {
            if (!bl) {
                graphics.drawLine(n7 + 3, n12, rectangle2.x - 1, n12);
            }
            if (!bl9) {
                graphics.drawLine(rectangle2.x + rectangle2.width, n12, n11 - 3, n12);
            }
            graphics.setColor(color7);
            n3 = rectangle2.x;
            if (n3 == n7) {
                ++n3;
            }
            graphics.drawLine(n3, n12, rectangle2.x + rectangle2.width - 1, n12);
            graphics.setColor(color4);
        } else {
            n3 = n6 == 2 && bl9 ? n7 : n7 + 3;
            n2 = n6 == 4 && bl9 ? n11 : n11 - 3;
            graphics.drawLine(n3, n12, n2, n12);
        }
        if (!bl9 || n6 != 3 && n6 != 4) {
            graphics.drawLine(n11 - 1, n12 - 1, n11 - 2, n12 - 1);
            graphics.drawLine(n11 - 1, n12 - 2, n11 - 1, n12 - 2);
        }
        if ((n6 == 3 || n6 == 4) && bl2 && !bl9) {
            graphics.setColor(color5);
            graphics.drawLine(n12, n8, n11 - 2, n12);
            graphics.drawLine(n11, n12 - 1, n11, n12 - 2);
            graphics.setColor(color4);
        }
        if (n6 == 4) {
            if (!bl) {
                graphics.drawLine(n11, n8 + 3, n11, rectangle2.y - 1);
            }
            if (!bl9) {
                graphics.drawLine(n11, rectangle2.y + rectangle2.height, n11, n12 - 3);
            }
            graphics.setColor(color7);
            graphics.drawLine(n11, rectangle2.y + (bl ? 1 : 0), n11, rectangle2.y + rectangle2.height - 1);
            graphics.setColor(color4);
        } else {
            n3 = n6 == 1 && bl9 ? n8 : n8 + 3;
            n2 = n6 == 3 && bl9 ? n12 : n12 - 3;
            graphics.drawLine(n11, n3, n11, n2);
        }
        if (!(n6 == 4 && bl || n6 == 1 && bl9)) {
            if (n6 == 4) {
                graphics.setColor(color);
            }
            graphics.drawLine(n11 - 1, n8 + 2, n11 - 1, n8 + 2);
            if (bl5) {
                graphics.setColor(color2);
            }
            graphics.drawLine(n11 - 1, n8 + 1, n11 - 1, n8 + 1);
            if (bl5) {
                graphics.setColor(color3);
            }
            graphics.drawLine(n11 - 2, n8 + 1, n11 - 2, n8 + 1);
            graphics.setColor(color3);
        }
        if (n6 == 4 && bl3 && !bl || n6 == 1 && bl2 && !bl9) {
            graphics.setColor(color5);
            graphics.drawLine(n11 - 2, n8, n11, n8);
            graphics.drawLine(n11, n8 + 1, n11, n8 + 2);
        }
    }

    void _installKeyboardActions() {
        JTabbedPane jTabbedPane = this._tabPane;
        boolean bl = this._isVertical();
        if (bl) {
            this._altDownKey = KeyStroke.getKeyStroke(39, 8);
            this._altUpKey = KeyStroke.getKeyStroke(37, 8);
            this._nextKey = KeyStroke.getKeyStroke(40, 0);
            this._previousKey = KeyStroke.getKeyStroke(38, 0);
            this._upKey = KeyStroke.getKeyStroke(39, 0);
            this._downKey = KeyStroke.getKeyStroke(37, 0);
        } else {
            this._altDownKey = KeyStroke.getKeyStroke(40, 8);
            this._altUpKey = KeyStroke.getKeyStroke(38, 8);
            if (OracleUIUtils.isLeftToRight(this._getButtonContext())) {
                this._nextKey = KeyStroke.getKeyStroke(39, 0);
                this._previousKey = KeyStroke.getKeyStroke(37, 0);
            } else {
                this._nextKey = KeyStroke.getKeyStroke(37, 0);
                this._previousKey = KeyStroke.getKeyStroke(39, 0);
            }
            this._upKey = KeyStroke.getKeyStroke(38, 0);
            this._downKey = KeyStroke.getKeyStroke(40, 0);
        }
        PrevNext prevNext = new PrevNext();
        jTabbedPane.registerKeyboardAction(prevNext, "Prev", this._previousKey, 0);
        jTabbedPane.registerKeyboardAction(prevNext, "Next", this._nextKey, 0);
        this._pageUpKey = KeyStroke.getKeyStroke(33, 2);
        this._pageDownKey = KeyStroke.getKeyStroke(34, 2);
        jTabbedPane.registerKeyboardAction(prevNext, "Prev", this._pageUpKey, 1);
        jTabbedPane.registerKeyboardAction(prevNext, "Next", this._pageDownKey, 1);
        AbstractAction abstractAction = new AbstractAction(){

            public void actionPerformed(ActionEvent actionEvent) {
                OracleTabbedPaneUI.this._showScrollMenu();
            }

            public boolean isEnabled() {
                return OracleTabbedPaneUI.this._isScrollButtonVisible();
            }
        };
        jTabbedPane.registerKeyboardAction(abstractAction, this._upKey, 0);
        jTabbedPane.registerKeyboardAction(abstractAction, this._downKey, 0);
        jTabbedPane.registerKeyboardAction(abstractAction, this._altUpKey, 1);
        jTabbedPane.registerKeyboardAction(abstractAction, this._altDownKey, 1);
    }

    void _uninstallKeyboardActions() {
        JTabbedPane jTabbedPane = this._tabPane;
        jTabbedPane.unregisterKeyboardAction(this._upKey);
        jTabbedPane.unregisterKeyboardAction(this._downKey);
        jTabbedPane.unregisterKeyboardAction(this._altUpKey);
        jTabbedPane.unregisterKeyboardAction(this._altDownKey);
        jTabbedPane.unregisterKeyboardAction(this._previousKey);
        jTabbedPane.unregisterKeyboardAction(this._nextKey);
        jTabbedPane.unregisterKeyboardAction(this._pageUpKey);
        jTabbedPane.unregisterKeyboardAction(this._pageDownKey);
        this._pageDownKey = null;
        this._pageUpKey = null;
        this._nextKey = null;
        this._previousKey = null;
        this._altDownKey = null;
        this._altUpKey = null;
        this._downKey = null;
        this._upKey = null;
    }

    boolean _isScrollButtonVisible() {
        Rectangle rectangle = this._buttonBounds;
        return rectangle.width != 0 || rectangle.height != 0;
    }

    void _showScrollMenu() {
        if (this._isScrollButtonVisible()) {
            int n;
            int n2;
            Serializable serializable;
            Serializable serializable2;
            JTabbedPane jTabbedPane = this._tabPane;
            final JPopupMenu jPopupMenu = new JPopupMenu();
            Font font = jTabbedPane.getFont();
            Font font2 = new Font(font.getName(), font.getStyle() | 1, font.getSize());
            UIDefaults uIDefaults = this._getButtonContext().getPaintUIDefaults();
            Icon icon = uIDefaults.getIcon("TabbedPane.visibleSet");
            SpacingIcon spacingIcon = new SpacingIcon(icon);
            int n3 = jTabbedPane.getSelectedIndex();
            int n4 = 0;
            while (n4 < jTabbedPane.getTabCount()) {
                if (jTabbedPane.isEnabledAt(n4)) {
                    serializable2 = new JMenuItem(jTabbedPane.getTitleAt(n4), jTabbedPane.getIconAt(n4));
                    ((AbstractButton)serializable2).setHorizontalTextPosition(4);
                    if (n4 >= this._firstVisible && n4 <= this._lastVisible) {
                        ((AbstractButton)serializable2).setIcon(icon);
                        ((JComponent)serializable2).setFont(font2);
                    } else {
                        ((AbstractButton)serializable2).setIcon(spacingIcon);
                        ((JComponent)serializable2).setFont(font);
                    }
                    ((AbstractButton)serializable2).setActionCommand(IntegerUtils.getString(n4));
                    ((AbstractButton)serializable2).addActionListener(this._listeners);
                    jPopupMenu.add((JMenuItem)serializable2);
                    if (n4 == n3) {
                        serializable = serializable2;
                        jPopupMenu.addPopupMenuListener(new PopupMenuListener((JMenuItem)serializable){
                            private final /* synthetic */ JMenuItem val$selectedItem;
                            {
                                this.val$selectedItem = jMenuItem;
                            }

                            public void popupMenuWillBecomeVisible(PopupMenuEvent popupMenuEvent) {
                                MenuElement[] menuElementArray = new MenuElement[]{jPopupMenu, this.val$selectedItem};
                                MenuSelectionManager.defaultManager().setSelectedPath(menuElementArray);
                                OracleTabbedPaneUI.this._setButtonArmed(true);
                            }

                            public void popupMenuWillBecomeInvisible(PopupMenuEvent popupMenuEvent) {
                                OracleTabbedPaneUI.this._setButtonArmed(false);
                            }

                            public void popupMenuCanceled(PopupMenuEvent popupMenuEvent) {
                            }
                        });
                    }
                }
                ++n4;
            }
            serializable2 = jPopupMenu.getPreferredSize();
            serializable = this._buttonBounds;
            int n5 = serializable.x + serializable.width - 1;
            int n6 = serializable.y + serializable.height - 1;
            switch (jTabbedPane.getTabPlacement()) {
                case 2: {
                    n2 = n5;
                    n = n6 - ((Dimension)serializable2).height;
                    break;
                }
                case 4: {
                    n2 = serializable.x - ((Dimension)serializable2).width;
                    n = n6 - ((Dimension)serializable2).height;
                    break;
                }
                case 1: {
                    n2 = n5 - ((Dimension)serializable2).width;
                    n = n6;
                    break;
                }
                default: {
                    n2 = n5 - ((Dimension)serializable2).width;
                    n = serializable.y - ((Dimension)serializable2).height;
                }
            }
            MenuUtils.showPopupMenu(jPopupMenu, jTabbedPane, n2, n);
        }
    }

    void _setButtonArmed(boolean bl) {
        if (bl != this._buttonArmed) {
            this._buttonArmed = bl;
            this._tabPane.repaint(this._buttonBounds.x, this._buttonBounds.y, this._buttonBounds.width, this._buttonBounds.height);
        }
    }

    Icon _getIconForTab(int n) {
        JTabbedPane jTabbedPane = this._tabPane;
        return !jTabbedPane.isEnabledAt(n) && jTabbedPane.getDisabledIconAt(n) != null ? jTabbedPane.getDisabledIconAt(n) : jTabbedPane.getIconAt(n);
    }

    private Painter _getPainter(Rectangle rectangle) {
        boolean bl;
        boolean bl2;
        Insets insets = this._tabPane.getInsets();
        if (this._isVertical()) {
            bl2 = rectangle.y == insets.top;
            bl = rectangle.y + rectangle.height - 1 == this._tabPane.getHeight() - (insets.top + insets.bottom);
        } else {
            bl2 = rectangle.x == insets.left;
            boolean bl3 = bl = rectangle.x + rectangle.width - 1 == this._tabPane.getWidth() - (insets.left + insets.right);
        }
        int n = bl2 ? 1 : (bl ? 2 : 0);
        return this._getPainter(n);
    }

    Painter _getPainter(int n) {
        int n2 = this._tabPane.getTabPlacement();
        int n3 = n + 3 * (n2 - 1);
        Painter painter = _sPainterCache[n3];
        if (painter == null) {
            OracleTabbedPaneUI._sPainterCache[n3] = painter = new OracleTabPainter(new FixedBorderPainter(new TabFocusColorChange(new OracleFocusPainter(new AlignmentPainter(new PainterJoiner(new DirectionalBorderPainter(OracleUIUtils.getIconPainter(), 0, 2, 0, 0, false), new DirectionalBorderPainter(new DisablingPainter(new TabTextPainter()), 0, 2, 0, 0, false), 13)))), 0, 2, 0, 2), n2, n);
        }
        return painter;
    }

    PaintContext _getButtonContext() {
        return this._buttonContext;
    }

    PaintContext _getTabContext(int n) {
        this._context.setIndex(n);
        return this._context;
    }

    JTabbedPane getTabbedPane() {
        return this._tabPane;
    }

    boolean _isVertical() {
        int n = this._tabPane.getTabPlacement();
        return n == 2 || n == 4;
    }

    int _getInnerSize() {
        JTabbedPane jTabbedPane = this._tabPane;
        ImmInsets immInsets = OracleUIUtils.getInsets(jTabbedPane);
        if (this._isVertical()) {
            return jTabbedPane.getHeight() - (immInsets.top + immInsets.bottom);
        }
        return jTabbedPane.getWidth() - (immInsets.left + immInsets.right);
    }

    int _getTabSpace() {
        int n = this._getInnerSize();
        n = this._isVertical() ? (n -= this._buttonBounds.height) : (n -= this._buttonBounds.width);
        return n;
    }

    void repaintTab(int n) {
        Rectangle rectangle = this._getTabBounds(n);
        if (rectangle != null) {
            this._tabPane.repaint(rectangle);
        }
    }

    Rectangle _getTabBounds(int n) {
        if (this._rects != null && n >= 0 && n < this._rects.length) {
            return this._rects[n];
        }
        return null;
    }

    public void addLayoutComponent(String string, Component component) {
    }

    public void removeLayoutComponent(Component component) {
        if (this._visibleComponent == component) {
            this._visibleComponent = null;
        }
    }

    public Dimension preferredLayoutSize(Container container) {
        return this.calculateSize(false);
    }

    public Dimension minimumLayoutSize(Container container) {
        return this.calculateSize(true);
    }

    protected Dimension calculateSize(boolean bl) {
        JTabbedPane jTabbedPane = this._tabPane;
        int n = jTabbedPane.getTabPlacement();
        Insets insets = jTabbedPane.getInsets();
        ImmInsets immInsets = this.getContentBorderInsets(n);
        Dimension dimension = new Dimension(0, 0);
        int n2 = immInsets.top + immInsets.bottom;
        int n3 = immInsets.left + immInsets.right;
        int n4 = 0;
        int n5 = 0;
        int n6 = 0;
        while (n6 < jTabbedPane.getTabCount()) {
            Component component = jTabbedPane.getComponentAt(n6);
            Dimension dimension2 = dimension;
            Dimension dimension3 = dimension2 = bl ? component.getMinimumSize() : component.getPreferredSize();
            if (dimension2 != null) {
                n5 = Math.max(dimension2.height, n5);
                n4 = Math.max(dimension2.width, n4);
            }
            ++n6;
        }
        n3 += n4;
        n2 += n5;
        switch (n) {
            case 2: 
            case 4: {
                n3 += this.calculateMaxTabWidth();
                break;
            }
            default: {
                n2 += this.calculateMaxTabHeight();
            }
        }
        return new Dimension(n3 + insets.left + insets.right, n2 + insets.bottom + insets.top);
    }

    protected int calculateMaxTabWidth() {
        int n = this._tabPane.getTabCount();
        Painter painter = this._getPainter(0);
        int n2 = 0;
        int n3 = 0;
        while (n3 < n) {
            PaintContext paintContext = this._getTabContext(n3);
            n2 = Math.max(painter.getPreferredSize((PaintContext)paintContext).width, n2);
            ++n3;
        }
        return n2;
    }

    protected int calculateMaxTabHeight() {
        int n = this._tabPane.getTabCount();
        Painter painter = this._getPainter(0);
        int n2 = 0;
        int n3 = 0;
        while (n3 < n) {
            PaintContext paintContext = this._getTabContext(n3);
            n2 = Math.max(painter.getPreferredSize((PaintContext)paintContext).height, n2);
            ++n3;
        }
        return n2;
    }

    public void layoutContainer(Container container) {
        JTabbedPane jTabbedPane = this._tabPane;
        int n = jTabbedPane.getTabPlacement();
        Insets insets = jTabbedPane.getInsets();
        int n2 = jTabbedPane.getSelectedIndex();
        Component component = this._visibleComponent;
        int n3 = jTabbedPane.getTabCount();
        this.calculateLayoutInfo();
        if (n2 < 0 || n3 == 0) {
            this._setVisibleComponent(null);
        } else {
            int n4 = 0;
            int n5 = 0;
            ImmInsets immInsets = this.getContentBorderInsets(n);
            Component component2 = jTabbedPane.getComponentAt(n2);
            boolean bl = false;
            if (component2 != null) {
                int n6;
                int n7;
                if (component2 != component && component != null && SwingUtilities.findFocusOwner(component) != null) {
                    bl = true;
                }
                Dimension dimension = jTabbedPane.getSize();
                this._setVisibleComponent(component2);
                switch (n) {
                    case 2: {
                        n4 = this._getTabBounds((int)0).width;
                        n7 = insets.left + n4 + immInsets.left;
                        n6 = insets.top + immInsets.top;
                        break;
                    }
                    case 4: {
                        n4 = this._getTabBounds((int)0).width;
                        n7 = insets.left + immInsets.left;
                        n6 = insets.top + immInsets.top;
                        break;
                    }
                    case 3: {
                        n5 = this._getTabBounds((int)0).height;
                        n7 = insets.left + immInsets.left;
                        n6 = insets.top + immInsets.top;
                        break;
                    }
                    default: {
                        n5 = this._getTabBounds((int)0).height;
                        n7 = insets.left + immInsets.left;
                        n6 = insets.top + n5 + immInsets.top;
                    }
                }
                int n8 = dimension.width - n4 - insets.left - insets.right - immInsets.left - immInsets.right;
                int n9 = dimension.height - n5 - insets.top - insets.bottom - immInsets.top - immInsets.bottom;
                component2.setBounds(n7, n6, n8, n9);
                if (bl) {
                    if (component2.isFocusTraversable()) {
                        component2.requestFocus();
                        bl = false;
                    } else if (component2 instanceof JComponent && ((JComponent)component2).requestDefaultFocus()) {
                        bl = false;
                    }
                    if (bl) {
                        jTabbedPane.requestFocus();
                    }
                }
            }
        }
    }

    protected void calculateLayoutInfo() {
        boolean bl;
        int n;
        int n2;
        int n3;
        int n4;
        int n5;
        JTabbedPane jTabbedPane = this._tabPane;
        int n6 = jTabbedPane.getTabPlacement();
        int n7 = jTabbedPane.getTabCount();
        Dimension dimension = jTabbedPane.getSize();
        Insets insets = jTabbedPane.getInsets();
        int[] nArray = new int[n7];
        this._calculateTabSizes(n7, nArray);
        switch (n6) {
            case 2: {
                n5 = this.calculateMaxTabWidth();
                n4 = insets.left;
                n3 = insets.top;
                this._buttonBounds.setLocation(n4 + n5 - (this._buttonBounds.width + 2), jTabbedPane.getHeight() - insets.bottom - this._buttonBounds.height);
                break;
            }
            case 4: {
                n5 = this.calculateMaxTabWidth();
                n4 = dimension.width - insets.right - n5;
                n3 = insets.top;
                this._buttonBounds.setLocation(n4 + 2, jTabbedPane.getHeight() - insets.bottom - this._buttonBounds.height);
                break;
            }
            case 3: {
                n5 = this.calculateMaxTabHeight();
                n4 = insets.left;
                n3 = dimension.height - insets.bottom - n5;
                this._buttonBounds.setLocation(jTabbedPane.getWidth() - insets.right - this._buttonBounds.width, n3 + 2);
                break;
            }
            default: {
                n5 = this.calculateMaxTabHeight();
                n4 = insets.left;
                n3 = insets.top;
                this._buttonBounds.setLocation(jTabbedPane.getWidth() - insets.right - this._buttonBounds.width, n3 + n5 - (this._buttonBounds.height + 2));
            }
        }
        Rectangle[] rectangleArray = this._rects;
        int n8 = n2 = rectangleArray == null ? 0 : rectangleArray.length;
        if (n7 != n2) {
            Rectangle[] rectangleArray2 = new Rectangle[n7];
            if (rectangleArray != null) {
                System.arraycopy(rectangleArray, 0, rectangleArray2, 0, Math.min(n2, n7));
            }
            rectangleArray = rectangleArray2;
            this._rects = rectangleArray2;
            n = n2;
            while (n < n7) {
                rectangleArray[n] = new Rectangle();
                ++n;
            }
        }
        this._layoutItems(nArray, (bl = this._isVertical()) ? n3 : n4, bl ? n4 : n3, n5, n7);
        if (n7 > 0 && (this._firstVisible != 0 || this._lastVisible != n7 - 1)) {
            int n9;
            int n10;
            int n11;
            int n12;
            if (this._flipItems()) {
                n12 = 0;
                n11 = this._lastVisible;
                n10 = this._firstVisible;
            } else {
                n12 = n7 - 1;
                n11 = this._firstVisible;
                n10 = this._lastVisible;
            }
            if (n10 == n12) {
                int n13;
                n9 = this._getTabSpace();
                Rectangle rectangle = this._rects[n10];
                n = n9 - (bl ? rectangle.y + rectangle.height - 1 + insets.top : rectangle.x + rectangle.width - 1) + insets.left;
                Rectangle rectangle2 = this._rects[n11];
                int n14 = n13 = bl ? -rectangle2.y + insets.top : -rectangle2.x + insets.left;
                if (n < n13 + 3) {
                    n = n13;
                }
            } else {
                Rectangle rectangle = this._rects[n11];
                int n15 = n = bl ? -rectangle.y + insets.top : -rectangle.x + insets.left;
            }
            if (n != 0) {
                n9 = bl ? 0 : n;
                int n16 = bl ? n : 0;
                int n17 = 0;
                while (n17 < n7) {
                    this._rects[n17].translate(n9, n16);
                    ++n17;
                }
            }
        }
    }

    private void _setVisibleComponent(Component component) {
        if (this._visibleComponent != component) {
            if (this._visibleComponent != null) {
                this._visibleComponent.setVisible(false);
            }
            if (component != null) {
                component.setVisible(true);
            }
            this._visibleComponent = component;
        }
    }

    private boolean _flipItems() {
        return !this._isVertical() && this._getTabContext(0).getReadingDirection() == 2;
    }

    private void _calculateTabSizes(int n, int[] nArray) {
        Integer[] integerArray;
        Integer[] integerArray2;
        this._buttonBounds.setSize(0, 0);
        if (n == 0) {
            return;
        }
        Painter painter = this._getPainter(0);
        boolean bl = this._isVertical();
        int n2 = this._getInnerSize();
        if (n2 < 0) {
            return;
        }
        int n3 = 3;
        n2 -= n3;
        int n4 = 0;
        int n5 = 0;
        while (n5 < n) {
            integerArray2 = this._getTabContext(n5);
            integerArray = painter.getPreferredSize((PaintContext)integerArray2);
            nArray[n5] = bl ? integerArray.height : integerArray.width;
            n4 += nArray[n5] - n3;
            ++n5;
        }
        if (n4 <= n2) {
            if (n4 < n2 && !bl) {
                integerArray2 = new Integer[n];
                int n6 = this._getSortedSizes(integerArray2, nArray);
                int n7 = 0;
                n5 = 0;
                while (n5 < n6) {
                    n7 += nArray[integerArray2[n5]];
                    ++n5;
                }
                n7 = n7 * 3 / (2 * n6);
                int n8 = n3;
                boolean bl2 = false;
                int n9 = 0;
                n5 = n6 - 1;
                while (n5 >= 0) {
                    int n10 = integerArray2[n5];
                    if (bl2) {
                        nArray[n10] = n9;
                    } else {
                        int n11 = nArray[n10];
                        if (n11 < n7 && n8 + (n11 - n3) * (n5 + 1) <= n2) {
                            bl2 = true;
                            n9 = n11;
                        }
                        n8 += n11;
                    }
                    --n5;
                }
            }
            this._firstVisible = 0;
            this._lastVisible = n - 1;
            return;
        }
        if (bl) {
            this._buttonBounds.setSize(OracleTabbedPaneUI._getButtonPainter().getPreferredSize(this._getButtonContext()));
            this._doScrolledLayout(n, nArray, nArray);
            return;
        }
        this._calculateMinimumChars(n);
        integerArray2 = new int[n];
        n4 = 0;
        n5 = 0;
        while (n5 < n) {
            integerArray = this._getTabContext(n5);
            Dimension dimension = painter.getMinimumSize((PaintContext)integerArray);
            integerArray2[n5] = bl ? dimension.height : dimension.width;
            n4 += integerArray2[n5] - n3;
            ++n5;
        }
        if (n4 > n2) {
            this._buttonBounds.setSize(OracleTabbedPaneUI._getButtonPainter().getPreferredSize(this._getButtonContext()));
            this._doScrolledLayout(n, integerArray2, nArray);
            return;
        }
        this._firstVisible = 0;
        this._lastVisible = n - 1;
        integerArray = new Integer[n];
        int n12 = this._getSortedSizes(integerArray, nArray);
        n4 = 0;
        n5 = 0;
        while (n5 < n12) {
            int n13;
            int n14 = nArray[integerArray[n5]];
            if (n4 + (n14 - n3) * (n13 = n12 - n5) > n2) {
                int n15 = (n2 - n4) / n13;
                int n16 = n2 - n4 - n15 * n13;
                n15 += n3;
                int n17 = n5;
                while (n17 < n12) {
                    int n18 = n15;
                    if (n16-- > 0) {
                        // empty if block
                    }
                    nArray[integerArray[n17].intValue()] = ++n18;
                    ++n17;
                }
                break;
            }
            n4 += n14 - n3;
            ++n5;
        }
    }

    private int _getSortedSizes(Integer[] integerArray, int[] nArray) {
        int n = 0;
        int n2 = nArray.length;
        int n3 = 0;
        while (n3 < n2) {
            integerArray[n++] = IntegerUtils.getInteger(n3);
            ++n3;
        }
        Sort.qSort((Object[])integerArray, n, new SizeComp(nArray));
        return n;
    }

    private void _calculateMinimumChars(int n) {
        this._minimumChars = null;
        if (n <= 1) {
            return;
        }
        if (Boolean.TRUE.equals(this._tabPane.getClientProperty(_PROPERTY_DONT_TRUNCATE))) {
            return;
        }
        Object[] objectArray = new String[n];
        int n2 = 0;
        while (n2 < n) {
            String string = this._tabPane.getTitleAt(n2);
            if (string == null) {
                return;
            }
            objectArray[n2] = string;
            ++n2;
        }
        Sort.qSort(objectArray, n, LexiComparator.getComparator());
        int n3 = 4;
        Object object = objectArray[0];
        int n4 = 1;
        while (n4 < n) {
            Object object2 = objectArray[n4];
            int n5 = Math.min(((String)object).length(), ((String)object2).length());
            int n6 = 0;
            while (n6 < n5) {
                if (((String)object).charAt(n6) != ((String)object2).charAt(n6)) {
                    if (n6 <= n3) break;
                    n3 = n6;
                    break;
                }
                ++n6;
            }
            object = object2;
            ++n4;
        }
        this._minimumChars = IntegerUtils.getInteger(n3 + 2);
    }

    private void _layoutItems(int[] nArray, int n, int n2, int n3, int n4) {
        int n5;
        int n6;
        int n7;
        if (n4 == 0) {
            return;
        }
        boolean bl = this._isVertical();
        if (!this._flipItems()) {
            n7 = 0;
            n6 = 1;
        } else {
            n7 = n4 - 1;
            n6 = -1;
        }
        int n8 = 3;
        if (n7 != 0) {
            int n9 = n8;
            n5 = 0;
            while (n5 < n4) {
                n9 += nArray[n5] - n8;
                ++n5;
            }
            int n10 = this._getTabSpace();
            if (n9 < n10) {
                n = n10 - n9 - n - n8;
            }
        }
        Rectangle[] rectangleArray = this._rects;
        while (n7 >= 0 && n7 < n4) {
            n5 = nArray[n7];
            Rectangle rectangle = rectangleArray[n7];
            if (bl) {
                rectangle.setBounds(n2, n, n3, n5);
            } else {
                rectangle.setBounds(n, n2, n5, n3);
            }
            n += n5 - n8;
            n7 += n6;
        }
    }

    private void _doScrolledLayout(int n, int[] nArray, int[] nArray2) {
        int n2;
        int n3;
        if (n == 0) {
            return;
        }
        int n4 = this._firstVisible;
        int n5 = this._getTabSpace();
        int n6 = this._getLastVisible(n, n4, n5, nArray);
        int n7 = this._tabPane.getSelectedIndex();
        if (n7 != -1 && (n7 < n4 || n7 > n6)) {
            if (n7 < n4) {
                n4 = n7;
                n6 = this._getLastVisible(n, n4, n5, nArray);
            } else {
                n4 = 0;
                n6 = n7;
                n3 = nArray[n6];
                n2 = n6 - 1;
                while (n2 >= 0) {
                    if ((n3 += nArray[n2] - 3) > n5) {
                        n4 = n2 + 1;
                        break;
                    }
                    --n2;
                }
            }
        } else if (n6 == n - 1) {
            n3 = nArray[n6];
            n2 = n6 - 1;
            while (n2 >= 0) {
                if ((n3 += nArray[n2] - 3) > n5) {
                    n4 = n2 + 1;
                    break;
                }
                --n2;
            }
        }
        n3 = nArray[n4];
        n2 = n4 + 1;
        while (n2 <= n6) {
            n3 += nArray[n2] - 3;
            ++n2;
        }
        int n8 = n5 - n3;
        int n9 = n4;
        while (n9 <= n6) {
            int n10 = nArray[n9];
            int n11 = nArray2[n9];
            if (n10 < n11) {
                int n12 = Math.min(n8, n11 - n10);
                n10 += n12;
                n8 -= n12;
            }
            nArray2[n9] = n10;
            ++n9;
        }
        this._firstVisible = n4;
        this._lastVisible = n6;
    }

    private int _getLastVisible(int n, int n2, int n3, int[] nArray) {
        int n4 = nArray[n2];
        int n5 = n - 1;
        int n6 = 3;
        int n7 = n2 + 1;
        while (n7 < n) {
            if ((n4 += nArray[n7] - n6) > n3) {
                n5 = n7 - 1;
                break;
            }
            ++n7;
        }
        return n5;
    }

    static Painter _getButtonPainter() {
        if (_sButtonPainter == null) {
            _sButtonPainter = new OracleButtonPainter(new PainterStacker(OracleUIUtils.getBackgroundPainter(), new IconPainter()));
        }
        return _sButtonPainter;
    }

    static {
        _sPainterCache = new Painter[12];
    }

    private class Listeners
    extends MouseAdapter
    implements ChangeListener,
    FocusListener,
    PropertyChangeListener,
    ActionListener {
        private Listeners() {
        }

        public void stateChanged(ChangeEvent changeEvent) {
            JTabbedPane jTabbedPane = (JTabbedPane)changeEvent.getSource();
            jTabbedPane.invalidate();
            jTabbedPane.validate();
            jTabbedPane.repaint();
        }

        public void actionPerformed(ActionEvent actionEvent) {
            int n = Integer.parseInt(actionEvent.getActionCommand());
            OracleTabbedPaneUI.this._firstVisible = Math.max(0, n - (OracleTabbedPaneUI.this._lastVisible - OracleTabbedPaneUI.this._firstVisible) / 2);
            OracleTabbedPaneUI.this._tabPane.setSelectedIndex(n);
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            if ("tabPlacement".equals(propertyChangeEvent.getPropertyName())) {
                OracleTabbedPaneUI.this._uninstallKeyboardActions();
                OracleTabbedPaneUI.this._installKeyboardActions();
            }
        }

        public void mousePressed(MouseEvent mouseEvent) {
            JTabbedPane jTabbedPane = (JTabbedPane)mouseEvent.getSource();
            if (mouseEvent.isConsumed() || !jTabbedPane.isEnabled() || !SwingUtilities.isLeftMouseButton(mouseEvent)) {
                return;
            }
            if (OracleTabbedPaneUI.this._buttonBounds.contains(mouseEvent.getX(), mouseEvent.getY())) {
                OracleTabbedPaneUI.this._showScrollMenu();
                mouseEvent.consume();
            } else {
                int n = OracleTabbedPaneUI.this.tabForCoordinate(jTabbedPane, mouseEvent.getX(), mouseEvent.getY());
                if (n >= 0 && jTabbedPane.isEnabledAt(n)) {
                    if (n == OracleTabbedPaneUI.this._tabPane.getSelectedIndex()) {
                        jTabbedPane.requestFocus();
                        OracleTabbedPaneUI.this.repaintTab(n);
                    } else {
                        jTabbedPane.setSelectedIndex(n);
                    }
                }
                mouseEvent.consume();
            }
        }

        public void focusGained(FocusEvent focusEvent) {
            OracleTabbedPaneUI.this.repaintTab(OracleTabbedPaneUI.this._tabPane.getSelectedIndex());
        }

        public void focusLost(FocusEvent focusEvent) {
            OracleTabbedPaneUI.this.repaintTab(OracleTabbedPaneUI.this._tabPane.getSelectedIndex());
        }
    }

    private static class SizeComp
    implements Comparator {
        private int[] _sizes;

        public SizeComp(int[] nArray) {
            this._sizes = nArray;
        }

        public int compare(Object object, Object object2) {
            int n = (Integer)object;
            int n2 = (Integer)object2;
            return this._sizes[n] - this._sizes[n2];
        }
    }

    private class TabCtxt
    extends JPaintContext {
        private int _index;
        private boolean _button;

        public TabCtxt(JTabbedPane jTabbedPane, boolean bl) {
            super(jTabbedPane);
            this._button = bl;
        }

        public void setIndex(int n) {
            this._index = n;
        }

        public Color getPaintBackground() {
            UIDefaults uIDefaults = this.getPaintUIDefaults();
            JTabbedPane jTabbedPane = OracleTabbedPaneUI.this.getTabbedPane();
            if (this._button) {
                return uIDefaults.getColor("control");
            }
            if (jTabbedPane.getSelectedIndex() == this._index) {
                if ((super.getPaintState() & 4) == 0) {
                    return uIDefaults.getColor("TabbedPane.selectedColor");
                }
                return uIDefaults.getColor("TabbedPane.inactiveSelectedColor");
            }
            return uIDefaults.getColor("TabbedPane.notSelectedColor");
        }

        public int getPaintState() {
            int n = super.getPaintState();
            if (this._button) {
                if (OracleTabbedPaneUI.this._buttonArmed) {
                    n |= 2;
                }
            } else {
                JTabbedPane jTabbedPane = OracleTabbedPaneUI.this.getTabbedPane();
                int n2 = this._index;
                if (n2 >= 0 && n2 < jTabbedPane.getTabCount()) {
                    n = jTabbedPane.getSelectedIndex() == n2 ? (n |= 0x20) : (n &= 0xFFFFFFBF);
                    if (!jTabbedPane.isEnabledAt(n2)) {
                        n |= 1;
                    }
                }
            }
            return n;
        }

        public Object getPaintData(Object object) {
            JTabbedPane jTabbedPane = OracleTabbedPaneUI.this.getTabbedPane();
            if (PaintContext.LABEL_KEY.equals(object)) {
                return jTabbedPane.getTitleAt(this._index);
            }
            if (PaintContext.ICON_KEY.equals(object)) {
                if (this._button) {
                    String string = OracleTabbedPaneUI.this._firstVisible == 0 ? "TabbedPane.scrollLeft" : (OracleTabbedPaneUI.this._lastVisible == jTabbedPane.getTabCount() - 1 ? "TabbedPane.scrollRight" : "TabbedPane.scrollBoth");
                    return this.getPaintUIDefaults().get(string);
                }
                return OracleTabbedPaneUI.this._getIconForTab(this._index);
            }
            if (TabTextPainter.MINIMUM_TAB_CHARACTERS.equals(object)) {
                return OracleTabbedPaneUI.this._minimumChars;
            }
            return null;
        }
    }

    private class TabFocusColorChange
    extends ColorChange {
        public TabFocusColorChange(Painter painter) {
            super(painter);
        }

        protected Color getColor(PaintContext paintContext) {
            if ((paintContext.getPaintState() & 0x20) != 0) {
                return paintContext.getPaintUIDefaults().getColor("TabbedPane.selectedTextColor");
            }
            return paintContext.getPaintUIDefaults().getColor("TabbedPane.foreground");
        }
    }

    private class PrevNext
    implements ActionListener {
        private PrevNext() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if ("Next".equals(actionEvent.getActionCommand())) {
                OracleTabbedPaneUI.this.selectNextTab();
            } else {
                OracleTabbedPaneUI.this.selectPreviousTab();
            }
        }
    }
}

