/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.ewt.olaf;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Window;
import java.awt.event.ActionListener;
import java.util.ResourceBundle;
import javax.swing.AbstractButton;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.EmptyBorder;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicOptionPaneUI;
import oracle.bali.ewt.border.GrayPane;
import oracle.bali.ewt.button.DialogButtonBar;
import oracle.bali.ewt.button.PushButton;
import oracle.bali.ewt.text.MultiLineLabel;
import oracle.bali.ewt.text.WordWrapper;
import oracle.bali.ewt.util.WindowUtils;
import oracle.bali.share.nls.LocaleUtils;
import oracle.bali.share.nls.StringUtils;

public class OracleOptionPaneUI
extends BasicOptionPaneUI {
    private static final Insets _sMESSAGE_INSETS = new Insets(15, 25, 15, 25);
    private static final Insets _sPANE_INSETS = new Insets(8, 8, 8, 8);
    private static final int _sICON_DELTA = 20;
    private static final String _YES_KEY = "OPTIONPANE.YES";
    private static final String _NO_KEY = "OPTIONPANE.NO";
    private static final String _OK_KEY = "COMMON.OK";
    private static final String _CANCEL_KEY = "COMMON.CANCEL";
    private static final String _HELP_KEY = "COMMON.HELP";
    private static final int _sMINIMUM_WIDTH = 400;
    private static final int _sMINIMUM_HEIGHT = 200;

    public static ComponentUI createUI(JComponent jComponent) {
        return new OracleOptionPaneUI();
    }

    public Dimension getPreferredSize(JComponent jComponent) {
        Dimension dimension = super.getPreferredSize(jComponent);
        Window window = SwingUtilities.getWindowAncestor(jComponent);
        Insets insets = window == null ? new Insets(0, 0, 0, 0) : window.getInsets();
        int n = insets.left + insets.right;
        int n2 = insets.top + insets.bottom;
        int n3 = dimension.width + n;
        int n4 = dimension.height + n2;
        if (n3 > WindowUtils.DIALOG_MAXIMUM_WIDTH) {
            dimension.width = WindowUtils.DIALOG_MAXIMUM_WIDTH - n;
        } else if (n3 < 400) {
            dimension.width = 400 - n;
        }
        if (n4 > WindowUtils.DIALOG_MAXIMUM_HEIGHT) {
            dimension.height = WindowUtils.DIALOG_MAXIMUM_HEIGHT - n2;
        } else if (n4 < 200) {
            dimension.height = 200 - n2;
        }
        return dimension;
    }

    protected void installDefaults() {
        super.installDefaults();
        this.optionPane.setBorder(new EmptyBorder(_sPANE_INSETS));
    }

    protected void uninstallDefaults() {
        this.optionPane.setBorder(null);
    }

    protected void installComponents() {
        this.optionPane.add("South", this.createButtonArea());
        this.optionPane.add("Center", this.createMessageArea());
    }

    protected LayoutManager createLayoutManager() {
        return new BorderLayout(0, 8);
    }

    protected void addIcon(Container container) {
        Icon icon = this.getIcon();
        if (icon != null) {
            JLabel jLabel = new JLabel(icon);
            jLabel.setVerticalAlignment(1);
            container.add("icon", jLabel);
        }
    }

    protected Container createMessageArea() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new OptionPaneLayout());
        jPanel.setBorder(new EmptyBorder(_sMESSAGE_INSETS));
        this.addIcon(jPanel);
        this.addMessageComponents(jPanel, this.getMessage(), null, false);
        return new GrayPane(jPanel);
    }

    protected void addMessageComponents(Container container, Object object, Object object2, boolean bl) {
        if (object == null) {
            return;
        }
        if (object instanceof Component) {
            container.add((Component)object, object2);
            if (!bl) {
                this.hasCustomComponents = true;
            }
        } else if (object instanceof Object[]) {
            Object[] objectArray = (Object[])object;
            int n = 0;
            while (n < objectArray.length) {
                this.addMessageComponents(container, objectArray[n], null, false);
                ++n;
            }
        } else if (object instanceof Icon) {
            JLabel jLabel = new JLabel((Icon)object, 0);
            Color color = UIManager.getColor("OptionPane.messageForeground");
            jLabel.setForeground(color);
            this.addMessageComponents(container, jLabel, null, true);
        } else {
            String string = object.toString();
            MultiLineLabel multiLineLabel = new MultiLineLabel(WordWrapper.getTextWrapper(), string);
            multiLineLabel.setPreferredAspectRatio(2.0f);
            multiLineLabel.setMaximumColumns(this.getMaxCharactersPerLineCount());
            this.addMessageComponents(container, multiLineLabel, "label", true);
        }
    }

    protected Container createButtonArea() {
        DialogButtonBar dialogButtonBar = new DialogButtonBar();
        this.addButtonComponents(dialogButtonBar, this.getButtons(), this.getInitialValueIndex());
        return dialogButtonBar;
    }

    protected void addButtonComponents(Container container, Object[] objectArray, int n) {
        DialogButtonBar dialogButtonBar;
        if (objectArray == null || objectArray.length == 0) {
            return;
        }
        if (container instanceof DialogButtonBar) {
            dialogButtonBar = (DialogButtonBar)container;
        } else {
            dialogButtonBar = new DialogButtonBar();
            container.setLayout(new BorderLayout());
            container.add("Center", dialogButtonBar);
        }
        int n2 = objectArray.length;
        int n3 = 0;
        while (n3 < n2) {
            Object object;
            Object object2;
            Object object3;
            Object object4 = objectArray[n3];
            if (object4 instanceof Component) {
                object3 = DialogButtonBar.CONSTRAINT_NULL;
                object2 = (Component)object4;
                boolean bl = this.hasCustomComponents = !(object4 instanceof Extra);
                if (object4 instanceof Extra) {
                    object = (Extra)object4;
                    ActionListener actionListener = this.createButtonActionListener(n3);
                    if (actionListener != null) {
                        ((AbstractButton)object).addActionListener(actionListener);
                    }
                    object3 = ((Extra)object).getConstraint();
                }
                dialogButtonBar.add((Component)object2, object3);
            } else {
                object3 = object4 instanceof Icon ? new PushButton((Icon)object4) : new PushButton(object4.toString());
                dialogButtonBar.add((Component)object3, DialogButtonBar.CONSTRAINT_NULL);
                object = this.createButtonActionListener(n3);
                if (object != null) {
                    ((AbstractButton)object3).addActionListener((ActionListener)object);
                }
                object2 = object3;
            }
            if (n3 == n) {
                this.initialFocusComponent = object2;
            }
            ++n3;
        }
    }

    protected Object[] getButtons() {
        if (this.optionPane != null) {
            Object[] objectArray = this.optionPane.getOptions();
            if (objectArray == null) {
                Object[] objectArray2;
                int n = this.optionPane.getOptionType();
                ResourceBundle resourceBundle = ResourceBundle.getBundle("oracle.bali.ewt.olaf.resource.OLAFBundle", LocaleUtils.getDefaultableLocale(this.optionPane));
                switch (n) {
                    case 0: {
                        objectArray2 = new Object[2];
                        String string = resourceBundle.getString(_YES_KEY);
                        String string2 = StringUtils.stripMnemonic(string);
                        int n2 = StringUtils.getMnemonicKeyCode(string);
                        Extra extra = new Extra(string2, DialogButtonBar.CONSTRAINT_YES);
                        objectArray2[0] = extra;
                        extra.setMnemonic(n2);
                        string = resourceBundle.getString(_NO_KEY);
                        string2 = StringUtils.stripMnemonic(string);
                        n2 = StringUtils.getMnemonicKeyCode(string);
                        extra = new Extra(string2, DialogButtonBar.CONSTRAINT_NO);
                        objectArray2[1] = extra;
                        extra.setMnemonic(n2);
                        break;
                    }
                    case 1: {
                        objectArray2 = new Object[3];
                        String string = resourceBundle.getString(_YES_KEY);
                        String string3 = StringUtils.stripMnemonic(string);
                        int n3 = StringUtils.getMnemonicKeyCode(string);
                        Extra extra = new Extra(string3, DialogButtonBar.CONSTRAINT_YES);
                        objectArray2[0] = extra;
                        extra.setMnemonic(n3);
                        string = resourceBundle.getString(_NO_KEY);
                        string3 = StringUtils.stripMnemonic(string);
                        n3 = StringUtils.getMnemonicKeyCode(string);
                        extra = new Extra(string3, DialogButtonBar.CONSTRAINT_NO);
                        objectArray2[1] = extra;
                        extra.setMnemonic(n3);
                        string3 = StringUtils.stripMnemonic(resourceBundle.getString(_CANCEL_KEY));
                        extra = new Extra(string3, DialogButtonBar.CONSTRAINT_CANCEL);
                        objectArray2[2] = extra;
                        break;
                    }
                    case 2: {
                        objectArray2 = new Object[2];
                        String string = StringUtils.stripMnemonic(resourceBundle.getString(_OK_KEY));
                        Extra extra = new Extra(string, DialogButtonBar.CONSTRAINT_YES);
                        objectArray2[0] = extra;
                        string = StringUtils.stripMnemonic(resourceBundle.getString(_CANCEL_KEY));
                        extra = new Extra(string, DialogButtonBar.CONSTRAINT_CANCEL);
                        objectArray2[1] = extra;
                        break;
                    }
                    default: {
                        objectArray2 = new Object[1];
                        String string = StringUtils.stripMnemonic(resourceBundle.getString(_OK_KEY));
                        Extra extra = new Extra(string, DialogButtonBar.CONSTRAINT_YES);
                        objectArray2[0] = extra;
                    }
                }
                return objectArray2;
            }
            return objectArray;
        }
        return null;
    }

    private class OptionPaneLayout
    implements LayoutManager {
        private Component _icon;
        private Component _label;

        private OptionPaneLayout() {
        }

        public void addLayoutComponent(String string, Component component) {
            if ("icon".equals(string)) {
                this._icon = component;
            } else if ("label".equals(string)) {
                this._label = component;
            }
        }

        public void removeLayoutComponent(Component component) {
            if (component == this._icon) {
                this._icon = null;
            } else if (component == this._label) {
                this._label = null;
            }
        }

        public Dimension preferredLayoutSize(Container container) {
            return this._getSize(container, true);
        }

        public Dimension minimumLayoutSize(Container container) {
            return this._getSize(container, false);
        }

        public void layoutContainer(Container container) {
            Insets insets = container.getInsets();
            Dimension dimension = container.getSize();
            int n = 0;
            int n2 = 0;
            if (insets != null) {
                dimension.width -= insets.left + insets.right;
                dimension.height -= insets.top + insets.bottom;
                n = insets.left;
                n2 = insets.top;
            }
            if (this._icon != null) {
                Dimension dimension2 = this._icon.getPreferredSize();
                this._icon.setBounds(n, n2, dimension2.width, dimension2.height);
                n += dimension2.width + 20;
                dimension.width -= dimension2.width + 20;
                if (n2 + dimension2.height > dimension.height) {
                    dimension.height = n2 + dimension2.height;
                }
            }
            int n3 = this._getVOffset(container);
            int n4 = container.getComponentCount();
            int n5 = 0;
            while (n5 < n4) {
                Component component = container.getComponent(n5);
                if (component != this._icon) {
                    Dimension dimension3 = component.getPreferredSize();
                    if (n5 == n4 - 1 && component == this._label) {
                        dimension3.height = dimension.height - n2;
                    }
                    component.setBounds(n, n2, dimension.width, dimension3.height);
                    n2 += dimension3.height + n3;
                }
                ++n5;
            }
        }

        private Dimension _getSize(Container container, boolean bl) {
            Insets insets;
            Dimension dimension = this._icon == null ? new Dimension() : (bl ? this._icon.getPreferredSize() : this._icon.getMinimumSize());
            int n = container.getComponentCount();
            int n2 = 0;
            int n3 = 0;
            Dimension dimension2 = null;
            int n4 = 0;
            while (n4 < n) {
                Component component = container.getComponent(n4);
                if (component != this._icon) {
                    Dimension dimension3 = dimension2 = bl ? component.getPreferredSize() : component.getMinimumSize();
                    if (dimension2.width > n2) {
                        n2 = dimension2.width;
                    }
                    n3 += dimension2.height;
                }
                ++n4;
            }
            if (n != 0) {
                n3 += this._getVOffset(container) * (n - 1);
            }
            n2 += dimension.width + 20;
            if (dimension.height > n3) {
                n3 = dimension.height;
            }
            if ((insets = container.getInsets()) != null) {
                n2 += insets.left + insets.right;
                n3 += insets.top + insets.bottom;
            }
            return new Dimension(n2, n3);
        }

        private int _getVOffset(Component component) {
            Font font = component.getFont();
            int n = font == null ? 0 : component.getFontMetrics(font).getHeight();
            return Math.min(15, n);
        }
    }

    private class Extra
    extends PushButton {
        private Object _constraint;

        public Extra(String string, Object object) {
            super(string);
            this._constraint = object;
        }

        public Object getConstraint() {
            return this._constraint;
        }
    }
}

