/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.ewt.olaf;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JMenuBar;
import javax.swing.UIDefaults;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicMenuUI;
import oracle.bali.ewt.graphics.GraphicsProxy;
import oracle.bali.ewt.olaf.ColorScheme;
import oracle.bali.ewt.olaf.OracleMenuItemUI;
import oracle.bali.ewt.olaf.OracleUIUtils;

public class OracleMenuUI
extends BasicMenuUI {
    private GProxy _graphicsProxy;

    public static ComponentUI createUI(JComponent jComponent) {
        return new OracleMenuUI();
    }

    protected void paintMenuItem(Graphics graphics, JComponent jComponent, Icon icon, Icon icon2, Color color, Color color2, int n) {
        if (this._graphicsProxy == null) {
            this._graphicsProxy = new GProxy();
        }
        this._graphicsProxy.setGraphics(graphics);
        super.paintMenuItem(this._graphicsProxy, jComponent, icon, icon2, color, color2, n);
        this._graphicsProxy.setGraphics(null);
        if (jComponent.getParent() instanceof JMenuBar) {
            Dimension dimension = jComponent.getSize();
            Color color3 = graphics.getColor();
            graphics.setColor(jComponent.getBackground());
            graphics.drawLine(0, 0, 2, 0);
            graphics.drawLine(0, 1, 0, 2);
            graphics.drawLine(dimension.width - 3, 0, dimension.width - 1, 0);
            graphics.drawLine(dimension.width - 1, 1, dimension.width - 1, 2);
            graphics.setColor(color3);
        } else {
            OracleMenuItemUI.drawSelection(graphics, jComponent);
        }
    }

    protected JComponent getComponent() {
        return this.menuItem;
    }

    private class GProxy
    extends GraphicsProxy {
        private Graphics _g;

        public GProxy() {
            super(null);
        }

        public Graphics getGraphics() {
            return this._g;
        }

        public void setColor(Color color) {
            if (color == ColorScheme.__sControlText) {
                UIDefaults uIDefaults = OracleUIUtils.getUIDefaults(OracleMenuUI.this.getComponent());
                color = uIDefaults.getColor("controlText");
            }
            super.setColor(color);
        }

        public void setGraphics(Graphics graphics) {
            this._g = graphics;
        }
    }
}

