/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.ewt.olaf;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.GridLayout;
import java.awt.Image;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.IOException;
import java.text.Collator;
import java.text.NumberFormat;
import java.util.Arrays;
import java.util.EventObject;
import java.util.Locale;
import java.util.ResourceBundle;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.AbstractListModel;
import javax.swing.Action;
import javax.swing.Box;
import javax.swing.ButtonGroup;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultCellEditor;
import javax.swing.DefaultListCellRenderer;
import javax.swing.DefaultListSelectionModel;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JRootPane;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.JToggleButton;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.UIDefaults;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.filechooser.FileFilter;
import javax.swing.filechooser.FileSystemView;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicDirectoryModel;
import javax.swing.plaf.basic.BasicFileChooserUI;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.DefaultTableColumnModel;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;
import oracle.bali.ewt.border.GrayPane;
import oracle.bali.ewt.border.UIBorderFactory;
import oracle.bali.ewt.button.DialogButtonBar;
import oracle.bali.ewt.button.PushButton;
import oracle.bali.ewt.graphics.IconStrip;
import oracle.bali.ewt.graphics.ImageUtils;
import oracle.bali.ewt.olaf.OracleUIUtils;
import oracle.bali.ewt.olaf.ShellUtils;
import oracle.bali.ewt.util.WindowUtils;
import oracle.bali.share.nls.LocaleUtils;
import oracle.bali.share.nls.StringUtils;

public class OracleFileChooserUI
extends BasicFileChooserUI
implements PropertyChangeListener {
    private static final String _KEY_NAME = "FILECHOOSER.NAME";
    private static final String _KEY_SIZE = "FILECHOOSER.SIZE";
    private static final String _KEY_TYPE = "FILECHOOSER.TYPE";
    private static final String _KEY_OPEN = "FILECHOOSER.OPEN";
    private static final String _KEY_SAVE = "FILECHOOSER.SAVE";
    private static final String _KEY_HELP = "COMMON.HELP";
    private static final String _KEY_CANCEL = "COMMON.CANCEL";
    private static final String _KEY_LOOKIN = "FILECHOOSER.LOOKIN";
    private static final String _KEY_FILETYPES = "FILECHOOSER.FILETYPES";
    private static final String _KEY_UP = "FILECHOOSER.UP";
    private static final String _KEY_HOME = "FILECHOOSER.HOME";
    private static final String _KEY_FOLDER = "FILECHOOSER.FOLDER";
    private static final String _KEY_PREVIEW = "FILECHOOSER.PREVIEW";
    private static final String _KEY_LIST = "FILECHOOSER.LIST";
    private static final String _KEY_DETAILS = "FILECHOOSER.DETAILS";
    private static final String _KEY_FILENAME = "FILECHOOSER.FILENAME";
    private static final String _KEY_FILES = "FILECHOOSER.FILES";
    private static final String _KEY_PREVIEW_LABEL = "FILECHOOSER.PREVIEW_LABEL";
    private static final int _ICON_BORDER = 3;
    private static final long KB = 1024L;
    private static final long MB = 0x100000L;
    private static final Dimension _vstrut6 = new Dimension(1, 6);
    private static final Insets _emptyMargin = new Insets(0, 0, 0, 0);
    private static final int _LIST_MIN_WIDTH = 300;
    private static final int _LIST_MIN_HEIGHT = 50;
    private static final int _PREVIEW_HEIGHT = 128;
    private static final int _PREVIEW_WIDTH = 128;
    static final int _INDENT_SPACE = 10;
    private static final int __editWidth = 200;
    int __lastIndex = -1;
    boolean __editing = false;
    int __editX = 20;
    JTextField __editCell;
    JList _list;
    private DirectoryComboBoxModel _directoryComboBoxModel;
    private Action _directoryComboBoxAction = new DirectoryComboBoxAction();
    private FilterComboBoxModel _filterComboBoxModel;
    private JTextField _filenameTextField;
    private JButton _approveButton;
    private JButton _cancelButton;
    private JButton _helpButton;
    private JLabel _lookInLabel;
    private JLabel _fileNameLabel;
    private JLabel _fileTypesLabel;
    private JLabel _filesLabel;
    private JLabel _previewLabel;
    private JButton _up;
    private JButton _home;
    private JButton _newFolder;
    private JToggleButton _listView;
    private JToggleButton _detailsView;
    private JPanel _previewPanel;
    private JCheckBox _previewButton;
    private JPanel _viewPanel;
    private JPanel _listPanel;
    private JComponent _detailsPanel;
    private JTable _table;
    private JScrollPane _tableScrollPane;
    private OracleDirectoryModel _model;
    private Window _parent = null;
    private int _startWidth = -1;
    private int _startHeight = -1;
    private int _lastWidth = -1;
    private int _lastHeight = -1;
    private static boolean _sShellFolderAvailable = ShellUtils.isShellFolderAvailable();
    boolean useShellFolder = false;
    static /* synthetic */ Class class$oracle$bali$ewt$olaf$OracleFileChooserUI;

    public static ComponentUI createUI(JComponent jComponent) {
        return new OracleFileChooserUI((JFileChooser)jComponent);
    }

    public void installComponents(JFileChooser jFileChooser) {
        Object object;
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout());
        jPanel.setBorder(new EmptyBorder(6, 6, 6, 6));
        UIDefaults uIDefaults = OracleUIUtils.getUIDefaults(jFileChooser);
        Color color = uIDefaults.getColor("FileChooser.background");
        jFileChooser.setBackground(color);
        this._previewPanel = new JPanel(new BorderLayout(3, 3));
        this._previewPanel.setBorder(new EmptyBorder(6, 0, 6, 6));
        this._previewPanel.setPreferredSize(new Dimension(128, 128));
        JPanel jPanel2 = new JPanel(new BorderLayout(0, 0));
        jPanel2.add("Center", jPanel);
        jPanel2.add("East", this._previewPanel);
        jFileChooser.setLayout(new BorderLayout(6, 6));
        jFileChooser.setBorder(new EmptyBorder(6, 6, 6, 6));
        jFileChooser.add("Center", new GrayPane(jPanel2));
        this._lookInLabel = new JLabel();
        this._fileTypesLabel = new JLabel();
        NonNullSelComboBox nonNullSelComboBox = new NonNullSelComboBox();
        this._lookInLabel.setLabelFor(nonNullSelComboBox);
        this._directoryComboBoxModel = new DirectoryComboBoxModel();
        nonNullSelComboBox.setModel(this._directoryComboBoxModel);
        nonNullSelComboBox.addActionListener(this._directoryComboBoxAction);
        nonNullSelComboBox.setRenderer(new DirectoryComboBoxRenderer());
        nonNullSelComboBox.setAlignmentX(0.0f);
        nonNullSelComboBox.setAlignmentY(0.5f);
        this._filterComboBoxModel = new FilterComboBoxModel();
        jFileChooser.addPropertyChangeListener(this._filterComboBoxModel);
        NonNullSelComboBox nonNullSelComboBox2 = new NonNullSelComboBox();
        nonNullSelComboBox2.setModel(this._filterComboBoxModel);
        this._fileTypesLabel.setLabelFor(nonNullSelComboBox2);
        nonNullSelComboBox2.setRenderer(new FilterComboBoxRenderer());
        this._fileNameLabel = new JLabel();
        this._filesLabel = new JLabel();
        this._filesLabel.setAlignmentY(1.0f);
        this._up = OracleFileChooserUI._createButton(this.upFolderIcon, this.getChangeToParentDirectoryAction());
        this._home = OracleFileChooserUI._createButton(this.homeFolderIcon, this.getGoHomeAction());
        this._newFolder = OracleFileChooserUI._createButton(this.newFolderIcon, this.getNewFolderAction());
        this._newFolder.setAlignmentY(0.5f);
        this._newFolder.setMargin(_emptyMargin);
        ViewSwitch viewSwitch = new ViewSwitch();
        this._listView = new JToggleButton(this.listViewIcon);
        this._listView.setSelected(true);
        this._listView.setAlignmentY(0.5f);
        this._listView.setMargin(_emptyMargin);
        this._listView.addItemListener(viewSwitch);
        this._detailsView = new JToggleButton(this.detailsViewIcon);
        this._detailsView.setAlignmentY(0.5f);
        this._detailsView.setMargin(_emptyMargin);
        this._detailsView.addItemListener(viewSwitch);
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(this._listView);
        buttonGroup.add(this._detailsView);
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout(new BorderLayout(6, 6));
        JPanel jPanel4 = new JPanel(new BorderLayout(6, 6));
        jPanel4.add("North", this._lookInLabel);
        jPanel4.add("Center", this._fileTypesLabel);
        jPanel4.add("South", this._filesLabel);
        jPanel3.add("West", jPanel4);
        JPanel jPanel5 = new JPanel(new BorderLayout(6, 6));
        jPanel5.add("North", nonNullSelComboBox);
        JPanel jPanel6 = new JPanel(new BorderLayout());
        jPanel6.add("North", nonNullSelComboBox2);
        jPanel5.add("Center", jPanel6);
        jPanel3.add("Center", jPanel5);
        JPanel jPanel7 = new JPanel();
        jPanel7.setLayout(new GridLayout(3, 3, 2, 0));
        jPanel7.add(this._up);
        jPanel7.add(this._home);
        jPanel7.add(Box.createHorizontalGlue());
        jPanel7.add(Box.createHorizontalGlue());
        jPanel7.add(Box.createHorizontalGlue());
        jPanel7.add(Box.createHorizontalGlue());
        jPanel7.add(this._newFolder);
        jPanel7.add(this._listView);
        jPanel7.add(this._detailsView);
        JPanel jPanel8 = new JPanel(new BorderLayout(3, 3));
        jPanel8.add("Center", jPanel3);
        JPanel jPanel9 = new JPanel(new BorderLayout());
        jPanel9.add("North", jPanel7);
        jPanel8.add("East", jPanel9);
        jPanel.add("North", jPanel8);
        JPanel jPanel10 = new JPanel();
        jPanel10.setBorder(new EmptyBorder(2, 0, 0, 0));
        jPanel10.setLayout(new BorderLayout());
        JCheckBox jCheckBox = new JCheckBox();
        jCheckBox.addActionListener(this._getShowPreviewAction());
        jCheckBox.setSelected(true);
        this._previewButton = jCheckBox;
        JPanel jPanel11 = this.getAccessoryPanel();
        jPanel11.setOpaque(true);
        jPanel11.setBackground(Color.white);
        jPanel11.setBorder(UIBorderFactory.getRaisedBevelBorder());
        JComponent jComponent = jFileChooser.getAccessory();
        boolean bl = jComponent != null;
        this._previewButton.setVisible(bl);
        File[] fileArray = jFileChooser.getFileSystemView().getRoots();
        if (fileArray != null && fileArray.length == 1 && _sShellFolderAvailable && (object = ShellUtils.getRoots()) != null && ((File[])object).length > 0 && fileArray[0] == object[0]) {
            this.useShellFolder = true;
        }
        this._listPanel = this._createList(jFileChooser);
        this._listPanel.setMinimumSize(new Dimension(300, 50));
        this._filesLabel.setLabelFor(this._list);
        this._viewPanel = new JPanel(new BorderLayout());
        this._viewPanel.add("Center", this._listPanel);
        jPanel10.add("Center", this._viewPanel);
        this._filenameTextField = new JTextField();
        this._fileNameLabel.setLabelFor(this._filenameTextField);
        this._filenameTextField.addActionListener(this.getApproveSelectionAction());
        object = jFileChooser.getSelectedFile();
        if (object != null) {
            this.setFileName(jFileChooser.getName((File)object));
        }
        JPanel jPanel12 = new JPanel();
        jPanel12.setBorder(new EmptyBorder(6, 0, 0, 0));
        jPanel12.setLayout(new BorderLayout(3, 3));
        jPanel12.add("West", this._fileNameLabel);
        jPanel12.add("Center", this._filenameTextField);
        JPanel jPanel13 = new JPanel(new BorderLayout(6, 6));
        jPanel13.add("North", jPanel12);
        JPanel jPanel14 = new JPanel(new BorderLayout());
        jPanel14.add("West", this._previewButton);
        jPanel13.add("Center", jPanel14);
        jPanel10.add("South", jPanel13);
        jPanel.add("Center", jPanel10);
        JPanel jPanel15 = new JPanel();
        jPanel15.setLayout(new BorderLayout());
        DialogButtonBar dialogButtonBar = new DialogButtonBar();
        this._approveButton = new JButton();
        this._approveButton.addActionListener(this.getApproveSelectionAction());
        dialogButtonBar.add((Component)this._approveButton, DialogButtonBar.CONSTRAINT_YES);
        this._cancelButton = new JButton();
        this._cancelButton.addActionListener(this.getCancelSelectionAction());
        dialogButtonBar.add((Component)this._cancelButton, DialogButtonBar.CONSTRAINT_CANCEL);
        this._previewLabel = new JLabel();
        this._previewPanel.add("North", this._previewLabel);
        this._previewPanel.add((Component)jPanel11, "Center");
        this._previewPanel.setVisible(bl);
        if (jComponent != null) {
            jPanel11.add(jComponent);
        }
        this._helpButton = new JButton();
        this._helpButton.setVisible(false);
        dialogButtonBar.add((Component)this._helpButton, DialogButtonBar.CONSTRAINT_HELP);
        jPanel15.add("South", dialogButtonBar);
        jPanel15.setBorder(new EmptyBorder(0, 10, 0, 10));
        jFileChooser.add("South", jPanel15);
    }

    public void uninstallComponents(JFileChooser jFileChooser) {
        if (this._table != null) {
            TableListener tableListener = (TableListener)this._table.getModel();
            this.getModel().removeListDataListener(tableListener);
        }
    }

    public void paint(Graphics graphics, JComponent jComponent) {
        OracleUIUtils.fillBackground(graphics, jComponent);
    }

    public void ensureFileIsVisible(JFileChooser jFileChooser, File file) {
        if (this.getModel().contains(file)) {
            int n = this.getModel().indexOf(file);
            this._list.ensureIndexIsVisible(n);
        }
    }

    public void rescanCurrentDirectory(JFileChooser jFileChooser) {
        this.getModel().invalidateFileCache();
        this.getModel().validateFileCache();
    }

    public String getFileName() {
        if (this._filenameTextField != null) {
            return this._filenameTextField.getText();
        }
        return null;
    }

    public void setFileName(String string) {
        if (this._filenameTextField != null) {
            this._filenameTextField.setText(string);
        }
    }

    public String getDirectoryName() {
        return null;
    }

    public void setDirectoryName(String string) {
    }

    public void uninstallUI(JComponent jComponent) {
        jComponent.removePropertyChangeListener(this._filterComboBoxModel);
        this._cancelButton.removeActionListener(this.getCancelSelectionAction());
        this._approveButton.removeActionListener(this.getApproveSelectionAction());
        this._filenameTextField.removeActionListener(this.getApproveSelectionAction());
        super.uninstallUI(jComponent);
    }

    public PropertyChangeListener createPropertyChangeListener(JFileChooser jFileChooser) {
        return this;
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        String string = propertyChangeEvent.getPropertyName();
        if (string.equals("SelectedFileChangedProperty")) {
            this.cancelEdit();
            File file = (File)propertyChangeEvent.getNewValue();
            if (file != null) {
                this.setFileName(this.getFileChooser().getName(file));
            } else {
                this.setFileName(null);
            }
            this.setFileSelected();
        } else if (string.equals("directoryChanged")) {
            this.cancelEdit();
            this.resetEditIndex();
            this.clearIconCache();
            this._list.clearSelection();
            this._clearTable();
            File file = this.getFileChooser().getCurrentDirectory();
            if (file != null) {
                this._directoryComboBoxModel.addItem(file);
                this._up.setEnabled(!this.getFileChooser().getFileSystemView().isRoot(file));
                this.getNewFolderAction().setEnabled(file.canWrite());
            }
        } else if (string.equals("fileFilterChanged") || string.equals("fileSelectionChanged")) {
            this.cancelEdit();
            this.resetEditIndex();
            this.clearIconCache();
            this._list.clearSelection();
            this._clearTable();
        } else if (string.equals("AccessoryChangedProperty")) {
            if (this.getAccessoryPanel() != null) {
                JComponent jComponent;
                if (propertyChangeEvent.getOldValue() != null) {
                    this.getAccessoryPanel().remove((JComponent)propertyChangeEvent.getOldValue());
                }
                if ((jComponent = (JComponent)propertyChangeEvent.getNewValue()) != null) {
                    this.getAccessoryPanel().add((Component)jComponent, "Center");
                }
                boolean bl = jComponent != null;
                this._previewButton.setVisible(bl);
                this._previewPanel.setVisible(bl);
            }
        } else if (string.equals("ApproveButtonTextChangedProperty") || string.equals("DialogTypeChangedProperty")) {
            JFileChooser jFileChooser = this.getFileChooser();
            this._approveButton.setText(this.getApproveButtonText(jFileChooser));
            this._approveButton.setToolTipText(this.getApproveButtonToolTipText(jFileChooser));
            this._approveButton.setMnemonic(this.getApproveButtonMnemonic(jFileChooser));
        } else if (string.equals("ApproveButtonMnemonicChangedProperty")) {
            this._approveButton.setMnemonic(this.getApproveButtonMnemonic(this.getFileChooser()));
        } else if (string.equals("ancestor") && propertyChangeEvent.getNewValue() != null) {
            this._installStrings();
            JRootPane jRootPane = this.getFileChooser().getRootPane();
            if (jRootPane != null && jRootPane.getDefaultButton() == null) {
                jRootPane.setDefaultButton(this._approveButton);
            }
        }
    }

    protected void createModel() {
        super.createModel();
        this._model = new OracleDirectoryModel(this.getFileChooser());
    }

    public BasicDirectoryModel getModel() {
        return this._model;
    }

    protected void installListeners(JFileChooser jFileChooser) {
        super.installListeners(jFileChooser);
        jFileChooser.addPropertyChangeListener(this._model);
    }

    protected void uninstallListeners(JFileChooser jFileChooser) {
        super.uninstallListeners(jFileChooser);
        jFileChooser.removePropertyChangeListener(this._model);
    }

    protected void installIcons(JFileChooser jFileChooser) {
        Image image = ImageUtils.getImageResource(class$oracle$bali$ewt$olaf$OracleFileChooserUI == null ? (class$oracle$bali$ewt$olaf$OracleFileChooserUI = OracleFileChooserUI.class$("oracle.bali.ewt.olaf.OracleFileChooserUI")) : class$oracle$bali$ewt$olaf$OracleFileChooserUI, "icons/fileStrip.gif");
        IconStrip iconStrip = new IconStrip(image, 15);
        this.directoryIcon = iconStrip.getIcon(5);
        this.fileIcon = iconStrip.getIcon(9);
        this.computerIcon = iconStrip.getIcon(7);
        this.hardDriveIcon = iconStrip.getIcon(10);
        this.floppyDriveIcon = iconStrip.getIcon(13);
        this.newFolderIcon = iconStrip.getIcon(2);
        this.upFolderIcon = iconStrip.getIcon(0);
        this.homeFolderIcon = iconStrip.getIcon(1);
        this.detailsViewIcon = iconStrip.getIcon(4);
        this.listViewIcon = iconStrip.getIcon(3);
    }

    protected JButton getApproveButton(JFileChooser jFileChooser) {
        return this._approveButton;
    }

    void cancelEdit() {
        this.__editing = false;
        if (this.__editCell != null) {
            this._list.remove(this.__editCell);
        }
        if (this._table != null && this._table.isEditing()) {
            this._table.getCellEditor().cancelCellEditing();
        }
    }

    void setFileSelected() {
        File file = this.getFileChooser().getSelectedFile();
        if (file != null && this.getModel().contains(file)) {
            int n = this.getModel().indexOf(file);
            if (this._listView.isSelected()) {
                this._list.setSelectedIndex(n);
                this._list.ensureIndexIsVisible(n);
            } else {
                this._table.setColumnSelectionInterval(0, 0);
                this._table.setRowSelectionInterval(n, n);
            }
        } else {
            this._list.clearSelection();
            this._clearTable();
        }
    }

    private void _clearTable() {
        if (this._table == null) {
            return;
        }
        this._table.clearSelection();
    }

    private JPanel _createList(JFileChooser jFileChooser) {
        JPanel jPanel = new JPanel(new BorderLayout());
        this._list = new JList();
        this._list.setCellRenderer(new FileRenderer());
        this._list.setModel(this.getModel());
        this._list.addListSelectionListener(this.createListSelectionListener(jFileChooser));
        this._list.addMouseListener(this.createDoubleClickListener(jFileChooser, this._list));
        this._list.addMouseListener(new SingleClickListener(this._list));
        KeyStroke keyStroke = KeyStroke.getKeyStroke(27, 0);
        String string = "cancelListEdit";
        this._list.getInputMap(1).put(keyStroke, string);
        this._list.getActionMap().put(string, new ListEditCancel());
        JScrollPane jScrollPane = new JScrollPane(this._list);
        jPanel.add((Component)jScrollPane, "Center");
        return jPanel;
    }

    private JComponent _createTable(JFileChooser jFileChooser) {
        ResourceBundle resourceBundle = ResourceBundle.getBundle("oracle.bali.ewt.olaf.resource.OLAFBundle", jFileChooser.getLocale());
        DefaultTableColumnModel defaultTableColumnModel = new DefaultTableColumnModel();
        defaultTableColumnModel.setSelectionModel(new ColumnSelection());
        TableColumn tableColumn = new TableColumn(0);
        tableColumn.setHeaderValue(resourceBundle.getString(_KEY_NAME));
        tableColumn.setCellRenderer(new NameRenderer());
        tableColumn.setCellEditor(new NameEditor());
        tableColumn.setIdentifier("name");
        DefaultTableCellRenderer defaultTableCellRenderer = new DefaultTableCellRenderer();
        defaultTableCellRenderer.setHorizontalAlignment(4);
        TableColumn tableColumn2 = new TableColumn(1);
        tableColumn2.setHeaderValue(resourceBundle.getString(_KEY_SIZE));
        tableColumn2.setCellRenderer(defaultTableCellRenderer);
        tableColumn2.setIdentifier("size");
        TableColumn tableColumn3 = new TableColumn(2);
        tableColumn3.setHeaderValue(resourceBundle.getString(_KEY_TYPE));
        tableColumn3.setIdentifier("type");
        defaultTableColumnModel.addColumn(tableColumn);
        defaultTableColumnModel.addColumn(tableColumn2);
        defaultTableColumnModel.addColumn(tableColumn3);
        TableListener tableListener = new TableListener();
        this._table = new JTable(tableListener, defaultTableColumnModel);
        KeyStroke keyStroke = KeyStroke.getKeyStroke(9, 0);
        this._table.unregisterKeyboardAction(keyStroke);
        keyStroke = KeyStroke.getKeyStroke(9, 1);
        this._table.unregisterKeyboardAction(keyStroke);
        keyStroke = KeyStroke.getKeyStroke(10, 0);
        this._table.unregisterKeyboardAction(keyStroke);
        keyStroke = KeyStroke.getKeyStroke(10, 1);
        this._table.unregisterKeyboardAction(keyStroke);
        this._table.setAutoResizeMode(0);
        this._table.setShowGrid(false);
        this._table.setColumnSelectionAllowed(false);
        this._table.setRowSelectionAllowed(false);
        this._table.setCellSelectionEnabled(true);
        this._table.getTableHeader().setReorderingAllowed(false);
        this._table.getSelectionModel().addListSelectionListener(tableListener);
        Font font = jFileChooser.getFont();
        this._table.setRowHeight(((Component)jFileChooser).getFontMetrics(font).getHeight() + 4);
        this._table.setSelectionMode(0);
        this._tableScrollPane = new JScrollPane(this._table);
        this._tableScrollPane.addComponentListener(tableListener);
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.add("Center", this._tableScrollPane);
        return jPanel;
    }

    private void setEditIndex(int n) {
        this.__lastIndex = n;
    }

    private void resetEditIndex() {
        this.__lastIndex = -1;
    }

    private void _installStrings() {
        JFileChooser jFileChooser = this.getFileChooser();
        ResourceBundle resourceBundle = ResourceBundle.getBundle("oracle.bali.ewt.olaf.resource.OLAFBundle", jFileChooser.getLocale());
        int n = jFileChooser.getDialogType();
        String string = jFileChooser.getApproveButtonText();
        int n2 = jFileChooser.getApproveButtonMnemonic();
        if (string == null) {
            if (n == 0) {
                string = resourceBundle.getString(_KEY_OPEN);
            } else if (n == 1) {
                string = resourceBundle.getString(_KEY_SAVE);
            }
            OracleFileChooserUI._setButtonText(this._approveButton, string);
        } else {
            OracleFileChooserUI._setButtonText(this._approveButton, string, n2);
        }
        string = jFileChooser.getApproveButtonToolTipText();
        if (string == null) {
            // empty if block
        }
        this._approveButton.setToolTipText(string);
        OracleFileChooserUI._setButtonText(this._cancelButton, resourceBundle.getString(_KEY_CANCEL));
        OracleFileChooserUI._setButtonText(this._helpButton, resourceBundle.getString(_KEY_HELP));
        OracleFileChooserUI._setLabelText(this._lookInLabel, resourceBundle.getString(_KEY_LOOKIN));
        OracleFileChooserUI._setLabelText(this._fileNameLabel, resourceBundle.getString(_KEY_FILENAME));
        OracleFileChooserUI._setLabelText(this._fileTypesLabel, resourceBundle.getString(_KEY_FILETYPES));
        OracleFileChooserUI._setLabelText(this._filesLabel, resourceBundle.getString(_KEY_FILES));
        OracleFileChooserUI._setLabelText(this._previewLabel, resourceBundle.getString(_KEY_PREVIEW_LABEL));
        string = resourceBundle.getString(_KEY_UP);
        this._up.setToolTipText(string);
        OracleFileChooserUI._setAccessibleName(this._up, string);
        string = resourceBundle.getString(_KEY_HOME);
        this._home.setToolTipText(string);
        OracleFileChooserUI._setAccessibleName(this._home, string);
        string = resourceBundle.getString(_KEY_FOLDER);
        this._newFolder.setToolTipText(string);
        OracleFileChooserUI._setAccessibleName(this._newFolder, string);
        string = resourceBundle.getString(_KEY_LIST);
        this._listView.setToolTipText(string);
        OracleFileChooserUI._setAccessibleName(this._listView, string);
        string = resourceBundle.getString(_KEY_DETAILS);
        this._detailsView.setToolTipText(string);
        OracleFileChooserUI._setAccessibleName(this._detailsView, string);
        OracleFileChooserUI._setButtonText(this._previewButton, resourceBundle.getString(_KEY_PREVIEW));
    }

    private OracleFileChooserUI(JFileChooser jFileChooser) {
        super(jFileChooser);
    }

    private ActionListener _getShowPreviewAction() {
        return new ShowPreviewAction();
    }

    private void _switchToListView() {
        if (this._detailsPanel != null) {
            this._viewPanel.remove(this._detailsPanel);
        }
        this._viewPanel.add("Center", this._listPanel);
        this.getFileChooser().revalidate();
        this.getFileChooser().repaint();
        this._filesLabel.setLabelFor(this._list);
    }

    private void _switchToDetailsView() {
        boolean bl = false;
        if (this._detailsPanel == null) {
            this._detailsPanel = this._createTable(this.getFileChooser());
            this._detailsPanel.setMinimumSize(new Dimension(300, 50));
            bl = true;
        }
        this._viewPanel.remove(this._listPanel);
        this._viewPanel.add("Center", this._detailsPanel);
        if (bl) {
            OracleFileChooserUI._resizeTable(this._table, true);
        }
        this._filesLabel.setLabelFor(this._table);
        this.getFileChooser().revalidate();
        this.getFileChooser().repaint();
    }

    private void _renameFile(File file, String string) {
        File file2;
        if (string == null) {
            string = "";
        }
        if (!(string = string.trim()).equals(this.getFileChooser().getName(file)) && file.renameTo(file2 = this.getFileChooser().getFileSystemView().createFileObject(this.getFileChooser().getCurrentDirectory(), string))) {
            this.rescanCurrentDirectory(this.getFileChooser());
        }
    }

    public Dimension getPreferredSize(JComponent jComponent) {
        Dimension dimension;
        if (this._lastWidth != -1) {
            dimension = new Dimension(this._lastWidth, this._lastHeight);
        } else {
            LayoutManager layoutManager = jComponent.getLayout();
            if (layoutManager == null) {
                return null;
            }
            dimension = layoutManager.preferredLayoutSize(jComponent);
            Window window = SwingUtilities.getWindowAncestor(jComponent);
            Insets insets = window == null ? new Insets(0, 0, 0, 0) : window.getInsets();
            int n = insets.left + insets.right;
            int n2 = insets.top + insets.bottom;
            int n3 = dimension.width + n;
            int n4 = dimension.height + n2;
            if (n3 > WindowUtils.DIALOG_MAXIMUM_WIDTH) {
                dimension.width = WindowUtils.DIALOG_MAXIMUM_WIDTH - n;
            }
            if (n4 > WindowUtils.DIALOG_MAXIMUM_HEIGHT) {
                dimension.height = WindowUtils.DIALOG_MAXIMUM_HEIGHT - n2;
            }
        }
        return dimension;
    }

    private static void _resizeTable(JTable jTable, boolean bl) {
        int n = jTable.getColumnCount();
        int n2 = jTable.getParent() == null ? jTable.getWidth() : jTable.getParent().getWidth();
        int n3 = 0;
        TableColumnModel tableColumnModel = jTable.getColumnModel();
        int n4 = 0;
        while (n4 < n) {
            if (n4 == n - 1 && (n3 += bl ? OracleFileChooserUI._resizeColumn(jTable, n4) : tableColumnModel.getColumn(n4).getWidth()) < n2) {
                TableColumn tableColumn = jTable.getColumnModel().getColumn(n4);
                int n5 = n2 - n3 + tableColumn.getWidth();
                tableColumn.setWidth(n5);
                tableColumn.setPreferredWidth(n5);
            }
            ++n4;
        }
    }

    private static int _resizeColumn(JTable jTable, int n) {
        Dimension dimension;
        Component component;
        TableCellRenderer tableCellRenderer;
        TableModel tableModel = jTable.getModel();
        TableColumnModel tableColumnModel = jTable.getColumnModel();
        TableColumn tableColumn = tableColumnModel.getColumn(n);
        int n2 = jTable.getRowCount();
        int n3 = 0;
        int n4 = 0;
        while (n4 < n2) {
            tableCellRenderer = jTable.getCellRenderer(n4, n);
            Object object = tableModel.getValueAt(n4, n);
            component = tableCellRenderer.getTableCellRendererComponent(jTable, object, false, false, n4, n);
            dimension = component.getPreferredSize();
            if (dimension.width > n3) {
                n3 = dimension.width;
            }
            ++n4;
        }
        tableCellRenderer = tableColumn.getHeaderRenderer();
        if (tableCellRenderer == null) {
            tableCellRenderer = jTable.getTableHeader().getDefaultRenderer();
        }
        if (tableCellRenderer != null) {
            component = tableCellRenderer.getTableCellRendererComponent(jTable, tableColumn.getHeaderValue(), false, false, n, 0);
            dimension = component.getPreferredSize();
            if (dimension.width > n3) {
                n3 = dimension.width;
            }
        }
        tableColumn.setWidth(n3 += 10);
        tableColumn.setPreferredWidth(n3);
        return n3;
    }

    private static void _setLabelText(JLabel jLabel, String string) {
        jLabel.setDisplayedMnemonic(StringUtils.getMnemonicKeyCode(string));
        jLabel.setText(StringUtils.stripMnemonic(string));
    }

    private static void _setButtonText(AbstractButton abstractButton, String string) {
        OracleFileChooserUI._setButtonText(abstractButton, StringUtils.stripMnemonic(string), StringUtils.getMnemonicKeyCode(string));
    }

    private static void _setButtonText(AbstractButton abstractButton, String string, int n) {
        abstractButton.setText(string);
        abstractButton.setMnemonic(n);
    }

    private static void _setAccessibleName(JComponent jComponent, String string) {
        jComponent.getAccessibleContext().setAccessibleName(string);
    }

    private static JButton _createButton(Icon icon, Action action) {
        PushButton pushButton = new PushButton(icon);
        pushButton.addActionListener(action);
        pushButton.setLeftmost(false);
        pushButton.setRightmost(false);
        return pushButton;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private class NonNullSelComboBox
    extends JComboBox {
        public void setSelectedItem(Object object) {
            if (object != null) {
                super.setSelectedItem(object);
            }
        }
    }

    private class ColumnSelection
    extends DefaultListSelectionModel {
        private ColumnSelection() {
        }

        public void addSelectionInterval(int n, int n2) {
            super.addSelectionInterval(0, 0);
        }

        public void setAnchorSelectionIndex(int n) {
            super.setAnchorSelectionIndex(0);
        }

        public void setLeadSelectionIndex(int n) {
            super.setLeadSelectionIndex(0);
        }

        public void setSelectionInterval(int n, int n2) {
            super.setSelectionInterval(0, 0);
        }
    }

    private class NameEditor
    extends DefaultCellEditor {
        public NameEditor() {
            super(new JTextField());
        }

        public boolean isCellEditable(EventObject eventObject) {
            if (!(eventObject instanceof MouseEvent)) {
                return false;
            }
            MouseEvent mouseEvent = (MouseEvent)eventObject;
            if (mouseEvent.getID() != 501) {
                return false;
            }
            Point point = new Point(mouseEvent.getX(), mouseEvent.getY());
            int n = OracleFileChooserUI.this._table.rowAtPoint(point);
            if (mouseEvent.getClickCount() == 1) {
                if (OracleFileChooserUI.this.__lastIndex == n && !OracleFileChooserUI.this._table.isEditing()) {
                    mouseEvent.consume();
                    OracleFileChooserUI.this.resetEditIndex();
                    OracleFileChooserUI.this._table.setRowSelectionInterval(n, n);
                    OracleFileChooserUI.this._table.setColumnSelectionInterval(0, 0);
                    return true;
                }
                OracleFileChooserUI.this._table.setRowSelectionInterval(n, n);
                OracleFileChooserUI.this._table.setColumnSelectionInterval(0, 0);
                OracleFileChooserUI.this.setEditIndex(n);
            } else if (mouseEvent.getClickCount() == 2) {
                OracleFileChooserUI.this._table.setRowSelectionInterval(n, n);
                OracleFileChooserUI.this._table.setColumnSelectionInterval(0, 0);
                OracleFileChooserUI.this.resetEditIndex();
                File file = (File)OracleFileChooserUI.this.getModel().getElementAt(n);
                if (OracleFileChooserUI.this.getFileChooser().isTraversable(file)) {
                    OracleFileChooserUI.this._clearTable();
                    OracleFileChooserUI.this.getFileChooser().setCurrentDirectory(file);
                } else {
                    OracleFileChooserUI.this.getFileChooser().approveSelection();
                }
                mouseEvent.consume();
            } else {
                OracleFileChooserUI.this.resetEditIndex();
            }
            return false;
        }

        public boolean shouldSelectCell(EventObject eventObject) {
            return true;
        }

        public Component getTableCellEditorComponent(JTable jTable, Object object, boolean bl, int n, int n2) {
            if (object instanceof IconAndString) {
                object = ((IconAndString)object).string;
            }
            return super.getTableCellEditorComponent(jTable, object, bl, n, n2);
        }
    }

    private class NameRenderer
    extends DefaultTableCellRenderer {
        private NameRenderer() {
        }

        protected void setValue(Object object) {
            if (object instanceof IconAndString) {
                IconAndString iconAndString = (IconAndString)object;
                this.setText(iconAndString.string);
                this.setIcon(iconAndString.icon);
            } else {
                super.setValue(object);
            }
        }
    }

    private class IconAndString {
        public final Icon icon;
        public final String string;

        public IconAndString(Icon icon, String string) {
            this.icon = icon;
            this.string = string;
        }

        public String toString() {
            return this.string;
        }
    }

    private class TableListener
    extends AbstractTableModel
    implements ListDataListener,
    ListSelectionListener,
    ComponentListener {
        private DefaultTableModel _store;
        private NumberFormat _format;

        public TableListener() {
            OracleFileChooserUI.this.getModel().addListDataListener(this);
            this._format = NumberFormat.getNumberInstance(OracleFileChooserUI.this.getFileChooser().getLocale());
            this._store = new DefaultTableModel(OracleFileChooserUI.this.getModel().getSize(), 3);
        }

        public int getColumnCount() {
            return this._store.getColumnCount();
        }

        public int getRowCount() {
            return this._store.getRowCount();
        }

        public Object getValueAt(int n, int n2) {
            Object object = null;
            if (n >= OracleFileChooserUI.this.getModel().getSize()) {
                return null;
            }
            object = this._store.getValueAt(n, n2);
            if (object == null) {
                Object object2 = OracleFileChooserUI.this.getModel().getElementAt(n);
                File file = (File)object2;
                switch (n2) {
                    case 0: {
                        object = new IconAndString(OracleFileChooserUI.this.getFileChooser().getIcon(file), OracleFileChooserUI.this.getFileChooser().getName(file));
                        break;
                    }
                    case 1: {
                        if (file.isDirectory()) {
                            object = null;
                            break;
                        }
                        long l = file.length();
                        if (l < 1024L) {
                            object = l + " bytes";
                            break;
                        }
                        if (l < 0x100000L) {
                            double d = (double)l / 1024.0;
                            this._format.setMaximumFractionDigits(0);
                            object = this._format.format(d) + " KB";
                            break;
                        }
                        double d = (double)l / 1048576.0;
                        this._format.setMinimumFractionDigits(2);
                        this._format.setMaximumFractionDigits(2);
                        object = this._format.format(d) + " MB";
                        break;
                    }
                    case 2: {
                        object = OracleFileChooserUI.this.getFileChooser().getTypeDescription(file);
                    }
                }
                this._store.setValueAt(object, n, n2);
            }
            return object;
        }

        public void setValueAt(Object object, int n, int n2) {
            String string = object == null ? null : object.toString();
            File file = (File)OracleFileChooserUI.this.getModel().getElementAt(n);
            OracleFileChooserUI.this._renameFile(file, string);
        }

        public boolean isCellEditable(int n, int n2) {
            return n2 == 0;
        }

        public void intervalAdded(ListDataEvent listDataEvent) {
            int n = listDataEvent.getIndex0();
            while (n <= listDataEvent.getIndex1()) {
                this._store.insertRow(n, (Object[])null);
                ++n;
            }
            this.fireTableRowsInserted(listDataEvent.getIndex0(), listDataEvent.getIndex1());
        }

        public void intervalRemoved(ListDataEvent listDataEvent) {
            int n = listDataEvent.getIndex0();
            while (n <= listDataEvent.getIndex1()) {
                this._store.removeRow(n);
                ++n;
            }
            this.fireTableRowsDeleted(listDataEvent.getIndex0(), listDataEvent.getIndex1());
        }

        public void contentsChanged(ListDataEvent listDataEvent) {
            int n = OracleFileChooserUI.this.getModel().getSize();
            int n2 = this._store.getRowCount();
            int n3 = n - n2;
            if (n2 != 0) {
                this._store.setNumRows(0);
            }
            if (n != 0) {
                this._store.setNumRows(n);
            }
            if (n3 > 0) {
                this.fireTableRowsInserted(0, n3);
            } else if (n3 < 0) {
                this.fireTableRowsDeleted(0, -n3);
            }
            if (n != 0) {
                this.fireTableRowsUpdated(0, n);
            }
        }

        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            if (listSelectionEvent.getValueIsAdjusting()) {
                return;
            }
            int n = OracleFileChooserUI.this._table.getSelectedRow();
            if (n == -1 || n >= OracleFileChooserUI.this.getModel().getSize()) {
                return;
            }
            File file = (File)OracleFileChooserUI.this.getModel().getElementAt(n);
            if (file != null && (OracleFileChooserUI.this.getFileChooser().isDirectorySelectionEnabled() || !OracleFileChooserUI.this.getFileChooser().isTraversable(file))) {
                OracleFileChooserUI.this.getFileChooser().setSelectedFile(file);
            }
        }

        public void componentResized(ComponentEvent componentEvent) {
            OracleFileChooserUI._resizeTable(OracleFileChooserUI.this._table, false);
        }

        public void componentMoved(ComponentEvent componentEvent) {
        }

        public void componentShown(ComponentEvent componentEvent) {
            OracleFileChooserUI._resizeTable(OracleFileChooserUI.this._table, false);
        }

        public void componentHidden(ComponentEvent componentEvent) {
        }
    }

    private class ViewSwitch
    implements ItemListener {
        private ViewSwitch() {
        }

        public void itemStateChanged(ItemEvent itemEvent) {
            if (itemEvent.getStateChange() == 1) {
                if (itemEvent.getSource() == OracleFileChooserUI.this._listView) {
                    OracleFileChooserUI.this._switchToListView();
                } else if (itemEvent.getSource() == OracleFileChooserUI.this._detailsView) {
                    OracleFileChooserUI.this._switchToDetailsView();
                }
            }
        }
    }

    private class OracleDirectoryModel
    extends BasicDirectoryModel {
        private Collator _compare;

        public OracleDirectoryModel(JFileChooser jFileChooser) {
            super(jFileChooser);
            Locale locale = LocaleUtils.getDefaultableLocale(jFileChooser);
            this._compare = Collator.getInstance(locale);
            this._compare.setStrength(0);
        }

        protected boolean lt(File file, File file2) {
            String string;
            String string2 = file.getName();
            return this._compare.compare(string2, string = file2.getName()) < 0;
        }
    }

    private class DirectoryComboBoxAction
    extends AbstractAction {
        protected DirectoryComboBoxAction() {
            super("DirectoryComboBoxAction");
        }

        public void actionPerformed(ActionEvent actionEvent) {
            OracleFileChooserUI.this.getFileChooser().setCurrentDirectory((File)((JComboBox)actionEvent.getSource()).getSelectedItem());
        }
    }

    private class ShowPreviewAction
    extends AbstractAction {
        protected ShowPreviewAction() {
            super("ShowPreviewAction");
        }

        public void actionPerformed(ActionEvent actionEvent) {
            OracleFileChooserUI.this._previewPanel.setVisible(!OracleFileChooserUI.this._previewPanel.isVisible());
        }
    }

    private class FilterComboBoxModel
    extends AbstractListModel
    implements ComboBoxModel,
    PropertyChangeListener,
    ComponentListener {
        private FileFilter[] _filters;

        public FilterComboBoxModel() {
            this._filters = OracleFileChooserUI.this.getFileChooser().getChoosableFileFilters();
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            String string = propertyChangeEvent.getPropertyName();
            if (string == "ChoosableFileFilterChangedProperty") {
                this._filters = (FileFilter[])propertyChangeEvent.getNewValue();
                this.fireContentsChanged(this, -1, -1);
            } else if (string == "fileFilterChanged") {
                this.fireContentsChanged(this, -1, -1);
            } else if ("ancestor".equals(string)) {
                if (OracleFileChooserUI.this._parent != null) {
                    OracleFileChooserUI.this._parent.removeComponentListener(this);
                }
                OracleFileChooserUI.this._parent = null;
                OracleFileChooserUI.this._startWidth = -1;
                OracleFileChooserUI.this._startHeight = -1;
                if (propertyChangeEvent.getNewValue() != null) {
                    OracleFileChooserUI.this._parent = WindowUtils.getWindow((Component)propertyChangeEvent.getSource());
                    if (OracleFileChooserUI.this._parent != null) {
                        OracleFileChooserUI.this._parent.addComponentListener(this);
                    }
                }
            }
        }

        public void componentResized(ComponentEvent componentEvent) {
            if (OracleFileChooserUI.this._startWidth == -1) {
                return;
            }
            Component component = componentEvent.getComponent();
            int n = component.getWidth();
            int n2 = component.getHeight();
            if (n < OracleFileChooserUI.this._startWidth || n2 < OracleFileChooserUI.this._startHeight) {
                if (n < OracleFileChooserUI.this._startWidth) {
                    n = OracleFileChooserUI.this._startWidth;
                }
                if (n2 < OracleFileChooserUI.this._startHeight) {
                    n2 = OracleFileChooserUI.this._startHeight;
                }
                component.setSize(n, n2);
            }
        }

        public void componentShown(ComponentEvent componentEvent) {
            Component component = componentEvent.getComponent();
            OracleFileChooserUI.this._startWidth = component.getWidth();
            OracleFileChooserUI.this._startHeight = component.getHeight();
        }

        public void componentHidden(ComponentEvent componentEvent) {
            Container container = (Container)componentEvent.getComponent();
            Insets insets = container.getInsets();
            OracleFileChooserUI.this._lastWidth = container.getWidth();
            OracleFileChooserUI.this._lastHeight = container.getHeight();
            if (insets != null) {
                OracleFileChooserUI.this._lastWidth -= insets.left + insets.right;
                OracleFileChooserUI.this._lastHeight -= insets.top + insets.bottom;
            }
        }

        public void componentMoved(ComponentEvent componentEvent) {
        }

        public void setSelectedItem(Object object) {
            if (object != null) {
                OracleFileChooserUI.this.getFileChooser().setFileFilter((FileFilter)object);
                this.fireContentsChanged(this, -1, -1);
            }
        }

        public Object getSelectedItem() {
            FileFilter fileFilter = OracleFileChooserUI.this.getFileChooser().getFileFilter();
            boolean bl = false;
            if (fileFilter != null) {
                int n = 0;
                while (n < this._filters.length) {
                    if (this._filters[n] == fileFilter) {
                        bl = true;
                    }
                    ++n;
                }
                if (!bl) {
                    OracleFileChooserUI.this.getFileChooser().addChoosableFileFilter(fileFilter);
                }
            }
            return OracleFileChooserUI.this.getFileChooser().getFileFilter();
        }

        public int getSize() {
            if (this._filters != null) {
                return this._filters.length;
            }
            return 0;
        }

        public Object getElementAt(int n) {
            if (n > this.getSize() - 1) {
                return OracleFileChooserUI.this.getFileChooser().getFileFilter();
            }
            if (this._filters != null) {
                return this._filters[n];
            }
            return null;
        }
    }

    private class FilterComboBoxRenderer
    extends DefaultListCellRenderer {
        private FilterComboBoxRenderer() {
        }

        public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
            super.getListCellRendererComponent((JList<?>)jList, object, n, bl, bl2);
            FileFilter fileFilter = (FileFilter)object;
            if (fileFilter != null) {
                this.setText(fileFilter.getDescription());
            }
            return this;
        }
    }

    private class DirectoryComboBoxModel
    extends AbstractListModel
    implements ComboBoxModel {
        private Vector _directories = new Vector();
        private int[] _depths = null;
        private File _selectedDirectory = null;
        private FileSystemView _fsv = OracleFileChooserUI.this.getFileChooser().getFileSystemView();

        public DirectoryComboBoxModel() {
            File file = OracleFileChooserUI.this.getFileChooser().getCurrentDirectory();
            if (file != null) {
                this.addItem(file);
            }
        }

        private void addItem(File file) {
            if (file == null) {
                return;
            }
            this._directories.clear();
            File[] fileArray = null;
            fileArray = OracleFileChooserUI.this.useShellFolder ? ShellUtils.getRoots() : this._fsv.getRoots();
            this._directories.addAll(Arrays.asList(fileArray));
            File file2 = null;
            try {
                file2 = file.getCanonicalFile();
            }
            catch (IOException iOException) {
                file2 = file;
            }
            File file3 = null;
            if (OracleFileChooserUI.this.useShellFolder) {
                file3 = ShellUtils.getShellFolder(file2);
            } else {
                try {
                    file3 = this._fsv.createFileObject(file.getCanonicalPath());
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            File file4 = file3;
            Vector<File> vector = new Vector<File>(10);
            while (file4 != null) {
                vector.addElement(file4);
                file4 = file4.getParentFile();
            }
            int n = vector.size();
            int n2 = 0;
            while (n2 < n) {
                file4 = (File)vector.get(n2);
                if (this._directories.contains(file4)) {
                    int n3 = this._directories.indexOf(file4);
                    int n4 = n2 - 1;
                    while (n4 >= 0) {
                        this._directories.insertElementAt(vector.get(n4), n3 + n2 - n4);
                        --n4;
                    }
                    break;
                }
                ++n2;
            }
            this.calculateDepths();
            this.setSelectedItem(file3);
        }

        private void calculateDepths() {
            this._depths = new int[this._directories.size()];
            int n = 0;
            while (n < this._depths.length) {
                File file = (File)this._directories.get(n);
                File file2 = file.getParentFile();
                this._depths[n] = 0;
                if (file2 != null) {
                    int n2 = n - 1;
                    while (n2 >= 0) {
                        if (file2.equals((File)this._directories.get(n2))) {
                            this._depths[n] = this._depths[n2] + 1;
                            break;
                        }
                        --n2;
                    }
                }
                ++n;
            }
        }

        public int getDepth(int n) {
            return this._depths != null && n >= 0 && n < this._depths.length ? this._depths[n] : 0;
        }

        public void setSelectedItem(Object object) {
            this._selectedDirectory = (File)object;
            this.fireContentsChanged(this, -1, -1);
        }

        public Object getSelectedItem() {
            return this._selectedDirectory;
        }

        public int getSize() {
            return this._directories.size();
        }

        public Object getElementAt(int n) {
            return this._directories.elementAt(n);
        }
    }

    private class DirectoryComboBoxRenderer
    extends DefaultListCellRenderer
    implements Icon {
        private Icon _icon;
        private int _depth;

        private DirectoryComboBoxRenderer() {
        }

        public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
            super.getListCellRendererComponent((JList<?>)jList, object, n, bl, bl2);
            File file = (File)object;
            if (file == null) {
                this.setText("");
                return this;
            }
            String string = OracleFileChooserUI.this.getFileChooser().getName(file);
            this.setText(string);
            this._icon = OracleFileChooserUI.this.getFileChooser().getIcon(file);
            this._depth = OracleFileChooserUI.this._directoryComboBoxModel.getDepth(n);
            this.setIcon(this);
            return this;
        }

        public void paintIcon(Component component, Graphics graphics, int n, int n2) {
            this._icon.paintIcon(component, graphics, n + this._depth * 10, n2);
        }

        public int getIconWidth() {
            return this._icon.getIconWidth() + this._depth * 10;
        }

        public int getIconHeight() {
            return this._icon.getIconHeight();
        }

        protected String paramString() {
            return "";
        }
    }

    private class FileRenderer
    extends DefaultListCellRenderer {
        private FileRenderer() {
        }

        public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
            super.getListCellRendererComponent((JList<?>)jList, object, n, bl, bl2);
            File file = (File)object;
            String string = OracleFileChooserUI.this.getFileChooser().getName(file);
            this.setText(string);
            Icon icon = OracleFileChooserUI.this.getFileChooser().getIcon(file);
            this.setIcon(icon);
            if (bl) {
                OracleFileChooserUI.this.__editX = icon.getIconWidth() + 4;
            }
            return this;
        }
    }

    private class SingleClickListener
    extends MouseAdapter
    implements ActionListener {
        private JList _list;

        public SingleClickListener(JList jList) {
            this._list = jList;
            OracleFileChooserUI.this.__editCell = new JTextField();
            OracleFileChooserUI.this.__editCell.addActionListener(this);
        }

        public void mouseClicked(MouseEvent mouseEvent) {
            if (mouseEvent.getClickCount() == 1) {
                int n = this._list.locationToIndex(mouseEvent.getPoint());
                if (n >= 0 && OracleFileChooserUI.this.__lastIndex == n && !OracleFileChooserUI.this.__editing) {
                    File file = (File)this._list.getSelectedValue();
                    if (file != null) {
                        OracleFileChooserUI.this.__editing = true;
                        Rectangle rectangle = this._list.getCellBounds(n, n);
                        this._list.add(OracleFileChooserUI.this.__editCell);
                        OracleFileChooserUI.this.__editCell.setText(OracleFileChooserUI.this.getFileChooser().getName(file));
                        OracleFileChooserUI.this.__editCell.setFont(this._list.getFont());
                        OracleFileChooserUI.this.__editCell.setBounds(OracleFileChooserUI.this.__editX + rectangle.x, rectangle.y, 200, rectangle.height);
                        OracleFileChooserUI.this.__editCell.selectAll();
                    }
                } else {
                    if (n >= 0) {
                        OracleFileChooserUI.this.setEditIndex(n);
                    } else {
                        OracleFileChooserUI.this.resetEditIndex();
                    }
                    OracleFileChooserUI.this.cancelEdit();
                }
            } else {
                OracleFileChooserUI.this.resetEditIndex();
                OracleFileChooserUI.this.cancelEdit();
            }
            this._list.repaint();
        }

        public void actionPerformed(ActionEvent actionEvent) {
            JTextField jTextField = (JTextField)actionEvent.getSource();
            File file = (File)this._list.getSelectedValue();
            String string = jTextField.getText();
            OracleFileChooserUI.this._renameFile(file, string);
            OracleFileChooserUI.this.cancelEdit();
            this._list.repaint();
        }
    }

    private class ListEditCancel
    extends AbstractAction {
        private ListEditCancel() {
        }

        public boolean isEnabled() {
            return OracleFileChooserUI.this.__editCell == null ? false : OracleFileChooserUI.this.__editCell.isShowing();
        }

        public void actionPerformed(ActionEvent actionEvent) {
            OracleFileChooserUI.this.cancelEdit();
            OracleFileChooserUI.this.resetEditIndex();
            OracleFileChooserUI.this._list.requestFocus();
            OracleFileChooserUI.this._list.repaint();
        }
    }
}

