/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.ewt.olaf;

import java.awt.Rectangle;
import java.awt.event.FocusEvent;
import java.awt.event.MouseEvent;
import javax.swing.BoundedRangeModel;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.plaf.UIResource;
import javax.swing.text.JTextComponent;
import oracle.bali.ewt.olaf.OracleCaret;

class OracleFieldCaret
extends OracleCaret
implements UIResource {
    private transient boolean _temporaryLoss;
    private transient int _tempDot;
    private transient int _tempMark;

    OracleFieldCaret() {
    }

    public void mousePressed(MouseEvent mouseEvent) {
        if (SwingUtilities.isLeftMouseButton(mouseEvent)) {
            this.positionCaret(mouseEvent);
            JTextComponent jTextComponent = this.getComponent();
            if (jTextComponent.isEnabled() && !jTextComponent.hasFocus()) {
                if (jTextComponent.isEditable()) {
                    this._tempDot = this.getDot();
                    this._tempMark = this.getMark();
                    jTextComponent.requestFocus();
                    this.setDot(this._tempMark);
                    this.moveDot(this._tempDot);
                } else {
                    jTextComponent.requestFocus();
                }
            }
        }
    }

    public void focusGained(FocusEvent focusEvent) {
        super.focusGained(focusEvent);
        int n = this.getComponent().getDocument().getLength();
        if (!this._temporaryLoss) {
            this.setDot(0);
            this.moveDot(n);
        } else {
            this.setDot(Math.min(this._tempMark, n));
            this.moveDot(Math.min(this._tempDot, n));
            this._temporaryLoss = false;
        }
    }

    public void focusLost(FocusEvent focusEvent) {
        if (focusEvent != null) {
            this._temporaryLoss = focusEvent.isTemporary();
            if (this._temporaryLoss) {
                this._tempDot = this.getDot();
                this._tempMark = this.getMark();
            }
        } else {
            this._temporaryLoss = false;
        }
        this.setDot(this.getDot());
        this.setVisible(false);
    }

    protected void adjustVisibility(Rectangle rectangle) {
        JTextField jTextField = (JTextField)this.getComponent();
        BoundedRangeModel boundedRangeModel = jTextField.getHorizontalVisibility();
        int n = rectangle.x + boundedRangeModel.getValue();
        int n2 = boundedRangeModel.getExtent() / 4;
        if (n < boundedRangeModel.getValue()) {
            boundedRangeModel.setValue(n - n2);
        } else if (n > boundedRangeModel.getValue() + boundedRangeModel.getExtent()) {
            boundedRangeModel.setValue(n - 3 * n2);
        }
    }
}

