/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.ewt.olaf;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.InputMap;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JScrollBar;
import javax.swing.JViewport;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.plaf.basic.BasicComboPopup;
import javax.swing.text.JTextComponent;
import oracle.bali.ewt.olaf.OracleComboBoxButton;

class OracleComboPopup
extends BasicComboPopup {
    private OracleComboBoxButton _button;
    private Object _enterAction;

    public OracleComboPopup(JComboBox jComboBox, OracleComboBoxButton oracleComboBoxButton) {
        super(jComboBox);
        KeyStroke keyStroke = KeyStroke.getKeyStroke(10, 0);
        InputMap inputMap = this.comboBox.getInputMap(1);
        this._enterAction = inputMap.get(keyStroke);
        inputMap.remove(keyStroke);
        this._button = oracleComboBoxButton;
    }

    void hackEscape() {
        ActionMap actionMap = this.getComboBox().getActionMap();
        actionMap.put("hidePopup", new AbstractAction(){

            public void actionPerformed(ActionEvent actionEvent) {
                OracleComboPopup.this.hide();
            }

            public boolean isEnabled() {
                return OracleComboPopup.this.isVisible();
            }
        });
    }

    protected MouseListener createListMouseListener() {
        return new MouseHandler();
    }

    protected KeyListener createKeyListener() {
        return new ComboPopupKeyHandler();
    }

    void _updateSelectedIndex() {
        this.comboBox.setSelectedIndex(this.list.getSelectedIndex());
    }

    protected JComboBox getComboBox() {
        return this.comboBox;
    }

    public void setVisible(boolean bl) {
        JComboBox jComboBox = this.getComboBox();
        if (bl && !jComboBox.isEditable() && (jComboBox.getItemCount() == 0 || jComboBox.getItemCount() == 1 && jComboBox.getSelectedItem() == jComboBox.getItemAt(0))) {
            return;
        }
        super.setVisible(bl);
        this.comboBox.repaint();
    }

    public void show() {
        InputMap inputMap = this.getComboBox().getInputMap(1);
        inputMap.put(KeyStroke.getKeyStroke(10, 0), this._enterAction);
        super.show();
    }

    public void hide() {
        super.hide();
        InputMap inputMap = this.getComboBox().getInputMap(1);
        inputMap.remove(KeyStroke.getKeyStroke(10, 0));
    }

    public void reshape(int n, int n2, int n3, int n4) {
        int n5 = this.getMaximumSize().width;
        if (n3 > n5) {
            n3 = n5;
        }
        super.reshape(n, n2, n3, n4);
    }

    protected Rectangle computePopupBounds(int n, int n2, int n3, int n4) {
        boolean bl;
        JScrollBar jScrollBar;
        Rectangle rectangle = super.computePopupBounds(n, n2, n3, n4);
        JViewport jViewport = this.scroller.getViewport();
        int n5 = (jViewport != null ? jViewport.getPreferredSize().width : 0) + ((jScrollBar = this.scroller.getVerticalScrollBar()) != null ? jScrollBar.getPreferredSize().width : 0);
        if (rectangle.width < n5) {
            rectangle.width = n5;
        }
        Container container = this.comboBox.getParent();
        while (container != null && !(container instanceof Dialog) && !(container instanceof Window)) {
            container = container.getParent();
        }
        boolean bl2 = bl = container instanceof Dialog && ((Dialog)container).isModal();
        if (bl) {
            Dialog dialog = (Dialog)container;
            Rectangle rectangle2 = dialog instanceof JDialog ? ((JDialog)dialog).getRootPane().getBounds() : dialog.getBounds();
            Rectangle rectangle3 = this.comboBox.getBounds();
            Insets insets = dialog instanceof JDialog ? ((JDialog)dialog).getRootPane().getInsets() : dialog.getInsets();
            Insets insets2 = this.comboBox.getInsets();
            rectangle3 = SwingUtilities.convertRectangle(this.comboBox.getParent(), rectangle3, dialog);
            int n6 = rectangle2.x + insets.left + rectangle2.width + insets.right - (insets2.left + rectangle3.x + insets2.right);
            rectangle.width = Math.min(n6, rectangle.width);
        }
        return rectangle;
    }

    class ComboPopupKeyHandler
    extends BasicComboPopup.InvocationKeyHandler {
        ComboPopupKeyHandler() {
            super(OracleComboPopup.this);
        }

        public void keyReleased(KeyEvent keyEvent) {
            if (!OracleComboPopup.this.getComboBox().isEditable()) {
                super.keyReleased(keyEvent);
            }
        }
    }

    class MouseHandler
    extends MouseAdapter {
        MouseHandler() {
        }

        public void mouseReleased(MouseEvent mouseEvent) {
            OracleComboPopup.this._updateSelectedIndex();
            OracleComboPopup.this.hide();
            Component component = OracleComboPopup.this.getComboBox().getEditor().getEditorComponent();
            if (OracleComboPopup.this.getComboBox().isEditable() && component instanceof JTextComponent) {
                ((JTextComponent)component).selectAll();
            }
        }
    }
}

