/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.ewt.olaf;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.ComboBoxEditor;
import javax.swing.InputMap;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JPopupMenu;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.ListCellRenderer;
import javax.swing.UIDefaults;
import javax.swing.border.Border;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import javax.swing.plaf.ColorUIResource;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.UIResource;
import javax.swing.plaf.basic.BasicComboBoxEditor;
import javax.swing.plaf.basic.BasicComboBoxUI;
import javax.swing.plaf.basic.ComboPopup;
import javax.swing.text.JTextComponent;
import oracle.bali.ewt.graphics.SynthesizingImageSet;
import oracle.bali.ewt.olaf.OracleComboBoxBorderPainter;
import oracle.bali.ewt.olaf.OracleComboBoxButton;
import oracle.bali.ewt.olaf.OracleComboPopup;
import oracle.bali.ewt.olaf.OracleFocusPainter;
import oracle.bali.ewt.olaf.OracleUIUtils;
import oracle.bali.ewt.painter.JPaintContext;
import oracle.bali.ewt.plaf.BorderAdapter;
import oracle.bali.ewt.util.ImmInsets;

public class OracleComboBoxUI
extends BasicComboBoxUI
implements FocusListener {
    private OracleComboBoxButton _button;
    private int _columnWidth;
    private Dimension _cachedMaximumSize;
    private Dimension _cachedPreferredSize;
    private static final Border _sBorder = new BorderAdapter(new OracleComboBoxBorderPainter());
    static final int __ARROW_WIDTH = 14;
    private EnterHack _enterHack;

    private OracleComboBoxUI() {
    }

    public void installUI(JComponent jComponent) {
        super.installUI(jComponent);
        jComponent.setOpaque(false);
        jComponent.setBorder(_sBorder);
        OracleUIUtils.putPaintContext(jComponent, new PaintCtxt(jComponent));
        this._setEditableColors();
        this._updateButton(false);
    }

    public void uninstallUI(JComponent jComponent) {
        super.uninstallUI(jComponent);
        jComponent.setOpaque(true);
        jComponent.setBorder(null);
        OracleUIUtils.removePaintContext(jComponent);
    }

    public static Object instantiate(UIDefaults uIDefaults, Object object, String string) {
        if (object.equals("ComboBox.arrowSet")) {
            SynthesizingImageSet synthesizingImageSet = new SynthesizingImageSet(OracleUIUtils.getColorizedImage("choice.gif", OracleUIUtils.getColorScheme()), 1);
            return synthesizingImageSet;
        }
        return null;
    }

    protected void uninstallComponents() {
        super.uninstallComponents();
        this._button = null;
    }

    protected void configureEditor() {
        super.configureEditor();
        this.editor.addFocusListener(this);
        this.editor.setEnabled(this.comboBox.isEnabled());
        if (this.keyListener != null) {
            this.editor.addKeyListener(this.keyListener);
        }
        this._setEditableColors();
        this._hackTextField();
    }

    protected void unconfigureEditor() {
        super.unconfigureEditor();
        this.editor.removeFocusListener(this);
        if (this.keyListener != null) {
            this.editor.removeKeyListener(this.keyListener);
        }
        this._unhackTextField();
    }

    public void focusGained(FocusEvent focusEvent) {
        if (focusEvent.getSource() == this.editor && this.editor instanceof JTextComponent) {
            ((JTextComponent)this.editor).selectAll();
        }
    }

    public void focusLost(FocusEvent focusEvent) {
        if (!focusEvent.isTemporary()) {
            this.getComboBox().hidePopup();
        }
    }

    public static ComponentUI createUI(JComponent jComponent) {
        return new OracleComboBoxUI();
    }

    protected LayoutManager createLayoutManager() {
        return new Layout();
    }

    public Dimension getPreferredSize(JComponent jComponent) {
        if (!this.isMinimumSizeDirty && this._cachedPreferredSize != null) {
            return new Dimension(this._cachedPreferredSize);
        }
        Integer n = (Integer)jComponent.getClientProperty("preferredColumns");
        if (n != null) {
            Dimension dimension = super.getPreferredSize(jComponent);
            int n2 = n;
            if (n2 > 0) {
                dimension.width = this._getWidthForColumns(n2);
            }
            this._cachedPreferredSize = this._addStandardInsets(dimension);
            this._cachedPreferredSize = this._addOracleInsets(this._cachedPreferredSize);
            return new Dimension(this._cachedPreferredSize);
        }
        return super.getPreferredSize(jComponent);
    }

    public Dimension getMinimumSize(JComponent jComponent) {
        if (!this.isMinimumSizeDirty && this.cachedMinimumSize != null) {
            return new Dimension(this.cachedMinimumSize);
        }
        Integer n = (Integer)jComponent.getClientProperty("minimumColumns");
        if (n != null) {
            Dimension dimension = super.getMinimumSize(jComponent);
            int n2 = n;
            if (n2 > 0) {
                dimension.width = this._getWidthForColumns(n2);
            }
            this.cachedMinimumSize = this._addStandardInsets(dimension);
            this.cachedMinimumSize = this._addOracleInsets(this.cachedMinimumSize);
            return new Dimension(this.cachedMinimumSize);
        }
        return super.getMinimumSize(jComponent);
    }

    public Dimension getMaximumSize(JComponent jComponent) {
        if (!this.isMinimumSizeDirty && this._cachedMaximumSize != null) {
            return new Dimension(this._cachedMaximumSize);
        }
        Integer n = (Integer)jComponent.getClientProperty("maximumColumns");
        if (n != null) {
            Dimension dimension = super.getMaximumSize(jComponent);
            int n2 = n;
            if (n2 > 0) {
                dimension.width = this._getWidthForColumns(n2);
            }
            this._cachedMaximumSize = this._addStandardInsets(dimension);
            this._cachedMaximumSize = this._addOracleInsets(this._cachedMaximumSize);
            return new Dimension(this._cachedMaximumSize);
        }
        return super.getMaximumSize(jComponent);
    }

    protected Dimension getDisplaySize() {
        Dimension dimension = super.getDisplaySize();
        return this._addOracleInsets(dimension);
    }

    protected void selectNextPossibleValue() {
        super.selectNextPossibleValue();
    }

    protected void selectPreviousPossibleValue() {
        super.selectPreviousPossibleValue();
    }

    protected void installKeyboardActions() {
        super.installKeyboardActions();
        final JComboBox<Object> jComboBox = this.comboBox;
        JButton jButton = this.arrowButton;
        AbstractAction abstractAction = new AbstractAction(){

            public void actionPerformed(ActionEvent actionEvent) {
                OracleComboBoxUI.this.selectNextPossibleValue();
            }

            public boolean isEnabled() {
                return jComboBox.isEnabled();
            }
        };
        this.comboBox.registerKeyboardAction(abstractAction, KeyStroke.getKeyStroke(40, 0), 1);
        AbstractAction abstractAction2 = new AbstractAction(){

            public void actionPerformed(ActionEvent actionEvent) {
                OracleComboBoxUI.this.selectPreviousPossibleValue();
            }

            public boolean isEnabled() {
                return jComboBox.isEnabled();
            }
        };
        this.comboBox.registerKeyboardAction(abstractAction2, KeyStroke.getKeyStroke(38, 0), 1);
        this.comboBox.unregisterKeyboardAction(KeyStroke.getKeyStroke(27, 0));
        OracleComboPopup oracleComboPopup = (OracleComboPopup)this.getPopup();
        if (oracleComboPopup != null) {
            oracleComboPopup.hackEscape();
        }
    }

    protected void uninstallKeyboardActions() {
        super.uninstallKeyboardActions();
        this.comboBox.unregisterKeyboardAction(KeyStroke.getKeyStroke(40, 0));
        this.comboBox.unregisterKeyboardAction(KeyStroke.getKeyStroke(38, 0));
    }

    protected ListDataListener createListDataListener() {
        return new ModelListener();
    }

    protected ComboBoxEditor createEditor() {
        return new OracleComboBoxEditor();
    }

    ComboPopup __getPopup() {
        return this.popup;
    }

    JList __getList() {
        return this.listBox;
    }

    JComboBox __getComboBox() {
        return this.comboBox;
    }

    Component __getEditor() {
        return this.editor;
    }

    private void _hackTextField() {
        Component component = this.comboBox.getEditor().getEditorComponent();
        if (!(component instanceof JTextField)) {
            return;
        }
        JTextField jTextField = (JTextField)this.comboBox.getEditor().getEditorComponent();
        ActionMap actionMap = jTextField.getActionMap();
        actionMap.put("notify-field-accept", new AbstractAction(){

            public void actionPerformed(ActionEvent actionEvent) {
            }

            public boolean isEnabled() {
                return false;
            }
        });
        InputMap inputMap = jTextField.getInputMap();
        inputMap.put(KeyStroke.getKeyStroke(10, 0), "notify-field-accept");
        this._enterHack = new EnterHack();
        jTextField.addKeyListener(this._enterHack);
    }

    private void _unhackTextField() {
        Component component;
        if (this._enterHack != null && (component = this.comboBox.getEditor().getEditorComponent()) instanceof JTextField) {
            component.removeKeyListener(this._enterHack);
        }
    }

    protected ComboPopup createPopup() {
        OracleComboPopup oracleComboPopup = new OracleComboPopup(this.comboBox, (OracleComboBoxButton)this.createArrowButton());
        this._button.setList(oracleComboPopup.getList());
        ((JPopupMenu)oracleComboPopup).getAccessibleContext().setAccessibleParent(this.comboBox);
        UIDefaults uIDefaults = OracleUIUtils.getUIDefaults(this.comboBox);
        oracleComboPopup.setBorder(uIDefaults.getBorder("PopupMenu.border"));
        return oracleComboPopup;
    }

    protected KeyListener createKeyListener() {
        return new OracleKeyHandler();
    }

    protected PropertyChangeListener createPropertyChangeListener() {
        return new OraclePropertyChangeHandler();
    }

    void layoutComboBox(Container container, Layout layout) {
        if (this.comboBox.isEditable()) {
            JComboBox jComboBox = (JComboBox)container;
            int n = jComboBox.getWidth();
            int n2 = jComboBox.getHeight();
            Insets insets = this.getInsets();
            int n3 = n2 - (insets.top + insets.bottom);
            int n4 = this.arrowButton.getPreferredSize().width;
            if (this.arrowButton != null) {
                this.arrowButton.setBounds(n - (insets.right + n4), insets.top, n4, n3);
            }
            if (this.editor != null) {
                this.editor.setBounds(this.rectangleForCurrentValue());
            }
        } else if (this.arrowButton != null) {
            Insets insets = this.comboBox.getInsets();
            int n = this.comboBox.getWidth();
            int n5 = this.comboBox.getHeight();
            this.arrowButton.setBounds(insets.left, insets.top, n - (insets.left + insets.right), n5 - (insets.top + insets.bottom));
        }
    }

    JComboBox getComboBox() {
        return this.comboBox;
    }

    JButton getArrowButton() {
        return this.arrowButton;
    }

    Component getEditor() {
        return this.editor;
    }

    ComboPopup getPopup() {
        return this.popup;
    }

    protected JButton createArrowButton() {
        if (this._button == null) {
            this._button = new OracleComboBoxButton(this.comboBox, this.currentValuePane);
            this._button.setIconOnly(this.comboBox.isEditable());
        }
        return this._button;
    }

    private Dimension _addStandardInsets(Dimension dimension) {
        Insets insets = this.getInsets();
        int n = dimension.height - (insets.top + insets.bottom);
        dimension.width += insets.left + insets.right + n;
        return dimension;
    }

    private Dimension _addOracleInsets(Dimension dimension) {
        ImmInsets immInsets = OracleFocusPainter.getFocusInsets();
        dimension.width += immInsets.left + immInsets.right;
        dimension.height += immInsets.top + immInsets.bottom;
        dimension.height -= 4;
        return dimension;
    }

    private int _getColumnWidth() {
        if (this._columnWidth == 0) {
            FontMetrics fontMetrics = this.editor.getFontMetrics(this.editor.getFont());
            this._columnWidth = fontMetrics.charWidth('m');
        }
        return this._columnWidth;
    }

    private int _getWidthForColumns(int n) {
        int n2 = 0;
        if (this.comboBox.isEditable()) {
            n2 = n * this._getColumnWidth();
        } else {
            StringBuffer stringBuffer = new StringBuffer(n);
            int n3 = 0;
            while (n3 < n) {
                stringBuffer.append("m");
                ++n3;
            }
            String string = stringBuffer.toString();
            ListCellRenderer<Object> listCellRenderer = this.comboBox.getRenderer();
            Component component = listCellRenderer.getListCellRendererComponent(this.listBox, string, -1, false, false);
            this.currentValuePane.add(component);
            component.setFont(this.comboBox.getFont());
            n2 = component.getPreferredSize().width;
            this.currentValuePane.remove(component);
        }
        return n2;
    }

    private void _dirtyMinimumSize() {
        this.isMinimumSizeDirty = true;
    }

    private void _setEditableColors() {
        UIDefaults uIDefaults = OracleUIUtils.getUIDefaults(this.comboBox);
        if (this.editor != null) {
            if (this.editor instanceof JComponent) {
                ((JComponent)this.editor).setOpaque(true);
            }
            this.editor.setBackground(this.comboBox.isEnabled() ? new ColorUIResource(uIDefaults.getColor("text")) : new ColorUIResource(uIDefaults.getColor("control")));
        }
        if (this.popup != null) {
            JList<Object> jList = this.popup.getList();
            jList.setBackground(this.comboBox.isEditable() ? new ColorUIResource(uIDefaults.getColor("text")) : new ColorUIResource(uIDefaults.getColor("control")));
        }
    }

    private void _updateButton(boolean bl) {
        this.arrowButton.setEnabled(this.comboBox.isEnabled() && (this.comboBox.getItemCount() > 1 || this.comboBox.getItemCount() == 1 && this.comboBox.getSelectedItem() != this.comboBox.getItemAt(0)));
        if (bl) {
            this.getPopup().hide();
        }
    }

    private class ModelListener
    extends BasicComboBoxUI.ListDataHandler {
        private ModelListener() {
            super(OracleComboBoxUI.this);
        }

        public void intervalAdded(ListDataEvent listDataEvent) {
            super.intervalAdded(listDataEvent);
            OracleComboBoxUI.this._updateButton(false);
        }

        public void intervalRemoved(ListDataEvent listDataEvent) {
            super.intervalRemoved(listDataEvent);
            OracleComboBoxUI.this._updateButton(false);
        }

        public void contentsChanged(ListDataEvent listDataEvent) {
            super.contentsChanged(listDataEvent);
            OracleComboBoxUI.this._updateButton(false);
        }
    }

    private class PaintCtxt
    extends JPaintContext {
        public PaintCtxt(JComponent jComponent) {
            super(jComponent);
        }

        public int getPaintState() {
            int n = super.getPaintState();
            if (OracleComboBoxUI.this.getComboBox().isPopupVisible()) {
                n |= 2;
            }
            return n;
        }
    }

    private class Layout
    extends BasicComboBoxUI.ComboBoxLayoutManager {
        private Layout() {
            super(OracleComboBoxUI.this);
        }

        public void layoutContainer(Container container) {
            OracleComboBoxUI.this.layoutComboBox(container, this);
        }

        public void superLayout(Container container) {
            super.layoutContainer(container);
        }
    }

    protected class OraclePropertyChangeHandler
    extends BasicComboBoxUI.PropertyChangeHandler {
        protected OraclePropertyChangeHandler() {
            super(OracleComboBoxUI.this);
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            String string = propertyChangeEvent.getPropertyName();
            if (string.equals("font")) {
                OracleComboBoxUI.this._columnWidth = 0;
            }
            super.propertyChange(propertyChangeEvent);
            if (string.equals("editable")) {
                if (OracleComboBoxUI.this.getArrowButton() instanceof OracleComboBoxButton) {
                    ((OracleComboBoxButton)OracleComboBoxUI.this.getArrowButton()).setIconOnly(OracleComboBoxUI.this.getComboBox().isEditable());
                }
            } else if (string.equals("enabled")) {
                OracleComboBoxUI.this._setEditableColors();
                if (OracleComboBoxUI.this.getEditor() != null) {
                    OracleComboBoxUI.this.getEditor().setEnabled(OracleComboBoxUI.this.getComboBox().isEnabled());
                }
                OracleComboBoxUI.this._updateButton(true);
            } else if ("model".equals(string)) {
                OracleComboBoxUI.this._updateButton(false);
            } else if (string.equals("maximumColumns") || string.equals("mimimumColumns") || string.equals("preferredColumns")) {
                OracleComboBoxUI.this._dirtyMinimumSize();
            }
        }
    }

    public class OracleKeyHandler
    extends BasicComboBoxUI.KeyHandler {
        public OracleKeyHandler() {
            super(OracleComboBoxUI.this);
        }

        public void keyPressed(KeyEvent keyEvent) {
            JComboBox jComboBox = OracleComboBoxUI.this.getComboBox();
            ComboPopup comboPopup = OracleComboBoxUI.this.getPopup();
            if (keyEvent.getKeyCode() == 115 && keyEvent.getModifiers() == 0) {
                if (comboPopup.isVisible()) {
                    comboPopup.hide();
                } else {
                    comboPopup.show();
                }
                keyEvent.consume();
            } else if (keyEvent.isAltDown() && keyEvent.getKeyCode() != 18) {
                if (keyEvent.getKeyCode() == 38 || keyEvent.getKeyCode() == 40) {
                    if (comboPopup.isVisible()) {
                        comboPopup.hide();
                    } else {
                        comboPopup.show();
                    }
                    keyEvent.consume();
                }
            } else if (!jComboBox.isEditable() || comboPopup.isVisible()) {
                super.keyPressed(keyEvent);
            }
        }

        public void keyTyped(KeyEvent keyEvent) {
            if (OracleComboBoxUI.this.getComboBox().isEditable() && OracleComboBoxUI.this.getPopup().isVisible()) {
                keyEvent.consume();
            }
        }
    }

    class OracleComboTextField
    extends JTextField {
        public OracleComboTextField(String string, int n) {
            super(string, n);
            this.setOpaque(true);
        }

        public void setBorder(Border border) {
        }

        public void setOpaque(boolean bl) {
            if (bl) {
                super.setOpaque(bl);
            }
        }
    }

    private class EnterHack
    extends KeyAdapter {
        private EnterHack() {
        }

        public void keyPressed(KeyEvent keyEvent) {
            JTextField jTextField = (JTextField)OracleComboBoxUI.this.__getEditor();
            if (keyEvent.getKeyCode() == 10) {
                if (OracleComboBoxUI.this.__getPopup().isVisible()) {
                    Object object = OracleComboBoxUI.this.__getComboBox().getClientProperty("JComboBox.lightweightKeyboardNavigation");
                    if ("Lightweight".equals(object)) {
                        OracleComboBoxUI.this.__getComboBox().setSelectedIndex(OracleComboBoxUI.this.__getList().getSelectedIndex());
                    }
                    keyEvent.consume();
                }
                jTextField.postActionEvent();
            }
        }
    }

    private class OracleComboBoxEditor
    extends BasicComboBoxEditor
    implements UIResource {
        public OracleComboBoxEditor() {
            this.editor = new OracleComboTextField("", 9);
            this.editor.addFocusListener(this);
        }
    }
}

