/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.ewt.olaf;

import java.awt.Color;
import javax.swing.UIDefaults;
import javax.swing.plaf.ColorUIResource;
import oracle.bali.ewt.LookAndFeel;
import oracle.bali.ewt.olaf.BrowserColorScheme;
import oracle.bali.ewt.olaf.ClassInstantiator;
import oracle.bali.ewt.olaf.ColorScheme;
import oracle.bali.ewt.olaf.OracleLookAndFeel;
import oracle.bali.ewt.plaf.StringInstantiator;

public class BrowserLookAndFeel
extends OracleLookAndFeel {
    private static Color _sLightBeige = new ColorUIResource(new Color(-52));
    private static Color _sDarkBeige = new ColorUIResource(new Color(-3355495));
    private static Color _sDarkestBeige = new ColorUIResource(new Color(-6710938));
    private static Color _sDarkestBlue = new ColorUIResource(new Color(-16764058));
    private static Color _sDarkBlue = new ColorUIResource(new Color(-13408615));
    private static Color _sLightBlue = new ColorUIResource(new Color(-10053172));
    private static Color _sLightestBlue = new ColorUIResource(new Color(-6697729));
    private static Color _sTextFieldChoiceHighlightColor = new ColorUIResource(new Color(-863993728));
    private static BrowserColorScheme _sDefaultScheme;
    private static BrowserColorScheme _sCurrentScheme;
    private static BrowserColorScheme[] _sAvailableSchemes;

    public String getName() {
        return "Oracle Browser Look and Feel";
    }

    public String getID() {
        return "Browser";
    }

    public String getDescription() {
        return "The Oracle Browser Look and Feel";
    }

    public boolean isNativeLookAndFeel() {
        return false;
    }

    public boolean isSupportedLookAndFeel() {
        return true;
    }

    public static ColorScheme getColorScheme() {
        return _sCurrentScheme;
    }

    public static void setColorScheme(Color color) {
        _sCurrentScheme = (BrowserColorScheme)OracleLookAndFeel.__getColorScheme((ColorScheme[])_sAvailableSchemes, color);
    }

    public static void setColorScheme(String string) {
        BrowserColorScheme browserColorScheme = (BrowserColorScheme)OracleLookAndFeel.__getColorScheme((ColorScheme[])_sAvailableSchemes, string);
        if (browserColorScheme == null) {
            browserColorScheme = _sDefaultScheme;
        }
        _sCurrentScheme = browserColorScheme;
    }

    public static ColorScheme[] getAvailableColorSchemes() {
        return (ColorScheme[])_sAvailableSchemes.clone();
    }

    protected void initClassDefaults(UIDefaults uIDefaults) {
        super.initClassDefaults(uIDefaults);
        Object[] objectArray = new String[]{"PanelUI", "oracle.bali.ewt.olaf.BrowserPanelUI"};
        uIDefaults.putDefaults(objectArray);
        ClassInstantiator.putInstantiators(uIDefaults, (String[])objectArray);
        uIDefaults.put("UIDefaults.light", (Object)null);
    }

    protected void initComponentDefaults(UIDefaults uIDefaults) {
        super.initComponentDefaults(uIDefaults);
        String string = "oracle.bali.ewt.olaf.OracleUIUtils#imageInst|";
        uIDefaults.put("checkboxStrip", new StringInstantiator(string + "browserCheckboxStrip.gif"));
        uIDefaults.put("radioButtonStrip", new StringInstantiator(string + "browserRadioButtonStrip.gif"));
    }

    protected void installColors(UIDefaults uIDefaults) {
        Color color = _sCurrentScheme.getDefiningColor();
        ColorUIResource colorUIResource = new ColorUIResource(Color.black);
        ColorUIResource colorUIResource2 = new ColorUIResource(Color.white);
        uIDefaults.put("BrowserLookAndFeel.SAND", color);
        uIDefaults.put(LookAndFeel.ACTIVE_CAPTION, _sDarkBlue);
        uIDefaults.put(LookAndFeel.ACTIVE_CAPTION_TEXT, colorUIResource2);
        uIDefaults.put(LookAndFeel.INACTIVE_CAPTION_BORDER, colorUIResource);
        uIDefaults.put(LookAndFeel.INFO, new Color(255, 255, 225));
        uIDefaults.put(LookAndFeel.ACTIVE_CAPTION_BORDER, _sDarkestBeige);
        uIDefaults.put(LookAndFeel.INACTIVE_CAPTION, _sLightBlue);
        uIDefaults.put(LookAndFeel.INACTIVE_CAPTION_TEXT, color);
        uIDefaults.put(LookAndFeel.WINDOW_TEXT, colorUIResource);
        uIDefaults.put(LookAndFeel.MENU, color);
        uIDefaults.put(LookAndFeel.MENU_TEXT, colorUIResource);
        uIDefaults.put(LookAndFeel.TEXT, colorUIResource2);
        uIDefaults.put(LookAndFeel.TEXT_TEXT, colorUIResource);
        uIDefaults.put(LookAndFeel.TEXT_HIGHLIGHT, new Color(255));
        uIDefaults.put(LookAndFeel.TEXT_HIGHLIGHT_TEXT, colorUIResource2);
        uIDefaults.put(LookAndFeel.TEXT_INACTIVE_TEXT, _sDarkestBeige);
        uIDefaults.put(LookAndFeel.CONTROL, color);
        uIDefaults.put(LookAndFeel.CONTROL_TEXT, colorUIResource);
        uIDefaults.put(LookAndFeel.CONTROL_LT_HIGHLIGHT, color);
        uIDefaults.put(LookAndFeel.NORMAL_INTENSITY, _sDarkBeige);
        uIDefaults.put(LookAndFeel.CONTROL_SHADOW, _sDarkBeige);
        uIDefaults.put(LookAndFeel.CONTROL_DK_SHADOW, _sDarkestBeige);
        uIDefaults.put(ColorScheme.CONTROL_SHADOW_DARK, _sDarkestBeige);
        uIDefaults.put(LookAndFeel.DARK_INTENSITY, _sTextFieldChoiceHighlightColor);
        uIDefaults.put(LookAndFeel.CONTROL_HIGHLIGHT, _sDarkBeige);
        uIDefaults.put(LookAndFeel.SCROLLBAR, _sDarkBeige);
        uIDefaults.put(LookAndFeel.INFO_TEXT, colorUIResource);
        uIDefaults.put(LookAndFeel.CONTROL_INACTIVE_TEXT, _sDarkestBeige);
        uIDefaults.put(LookAndFeel.SECONDARY_TEXT_HIGHLIGHT, _sDarkBeige);
        uIDefaults.put(LookAndFeel.LIGHT_INTENSITY, _sLightBeige);
        uIDefaults.put(LookAndFeel.VERY_DARK_INTENSITY, _sDarkestBeige);
        uIDefaults.put(LookAndFeel.LIGHT_LOOK, color);
        uIDefaults.put(LookAndFeel.DARK_LOOK, color);
        uIDefaults.put(LookAndFeel.VERY_DARK_LOOK, _sDarkestBeige);
        uIDefaults.put(LookAndFeel.DESKTOP, colorUIResource2);
    }

    protected Object[] getColorComponentDefaults(UIDefaults uIDefaults) {
        Color color;
        ColorUIResource colorUIResource = new ColorUIResource(Color.white);
        ColorUIResource colorUIResource2 = new ColorUIResource(Color.black);
        Color color2 = color = uIDefaults.getColor("BrowserLookAndFeel.SAND");
        ColorUIResource colorUIResource3 = new ColorUIResource(new Color(-857480244));
        Object[] objectArray = new Object[]{"Panel.background", null, "Button.background", colorUIResource3, "Button.foreground", uIDefaults.get("controlText"), "Button.lightBorder", _sTextFieldChoiceHighlightColor, "Button.darkBorder", new Color(-10079488), "ToggleButton.background", colorUIResource3, "ToggleButton.foreground", uIDefaults.get("controlText"), "ToggleButton.darkBorder", colorUIResource2, "ToggleButton.lightBorder", colorUIResource, "RadioButton.background", null, "CheckBox.background", null, "MenuBar.background", colorUIResource, "Menu.foreground", uIDefaults.get("controlText"), "Menu.background", colorUIResource, "MenuItem.background", colorUIResource, "RadioButtonMenuItem.background", colorUIResource, "CheckBoxMenuItem.background", colorUIResource, "Label.background", null, "Label.foreground", uIDefaults.get("controlText"), "List.selectionBackground", uIDefaults.get("textHighlight"), "List.selectionForeground", uIDefaults.get("textHighlightText"), "List.background", uIDefaults.get("text"), "List.foreground", uIDefaults.get("textText"), "ComboBox.background", uIDefaults.get("control"), "ComboBox.foreground", uIDefaults.get("controlText"), "ComboBox.selectedBackground", uIDefaults.get("textHighlight"), "ComboBox.selectedForeground", uIDefaults.get("textHighlightText"), "ComboBox.disabledBackground", uIDefaults.get("control"), "ComboBox.disabledForeground", uIDefaults.get("textInactiveText"), "InternalFrame.background", color, "FileChooser.background", color2, "DesktopIcon.background", uIDefaults.get("control"), "TextField.caretForeground", uIDefaults.get("textText"), "TextField.inactiveForeground", uIDefaults.get("textInactiveText"), "TextField.selectionBackground", uIDefaults.get("textHighlight"), "TextField.selectionForeground", uIDefaults.get("textHighlightText"), "TextField.background", uIDefaults.get("text"), "TextField.foreground", uIDefaults.get("textText"), "PasswordField.caretForeground", uIDefaults.get("textText"), "PasswordField.inactiveForeground", uIDefaults.get("textInactiveText"), "PasswordField.selectionBackground", uIDefaults.get("textHighlight"), "PasswordField.selectionForeground", uIDefaults.get("textHighlightText"), "PasswordField.background", uIDefaults.get("text"), "PasswordField.foreground", uIDefaults.get("textText"), "TextArea.caretForeground", uIDefaults.get("textText"), "TextArea.inactiveForeground", uIDefaults.get("textInactiveText"), "TextArea.selectionBackground", uIDefaults.get("textHighlight"), "TextArea.selectionForeground", uIDefaults.get("textHighlightText"), "TextArea.background", uIDefaults.get("text"), "TextArea.foreground", uIDefaults.get("textText"), "TextPane.caretForeground", uIDefaults.get("textText"), "TextPane.inactiveForeground", uIDefaults.get("textInactiveText"), "TextPane.selectionBackground", uIDefaults.get("textHighlight"), "TextPane.selectionForeground", uIDefaults.get("textHighlightText"), "TextPane.background", uIDefaults.get("text"), "TextPane.foreground", uIDefaults.get("textText"), "EditorPane.caretForeground", uIDefaults.get("textText"), "EditorPane.inactiveForeground", uIDefaults.get("textInactiveText"), "EditorPane.selectionBackground", uIDefaults.get("textHighlight"), "EditorPane.selectionForeground", uIDefaults.get("textHighlightText"), "EditorPane.background", uIDefaults.get("text"), "EditorPane.foreground", uIDefaults.get("textText"), "ScrollBar.background", uIDefaults.get("scrollbar"), "ScrollBar.foreground", uIDefaults.get("controlDkShadow"), "ScrollBar.track", uIDefaults.get("scrollbar"), "ScrollBar.trackHighlight", uIDefaults.get("controlDkShadow"), "ScrollBar.thumb", uIDefaults.get("control"), "ScrollBar.thumbHighlight", uIDefaults.get("controlHighlight"), "ScrollBar.thumbDarkShadow", uIDefaults.get("controlDkShadow"), "ScrollBar.thumbLightShadow", uIDefaults.get("controlShadow"), "TitledBorder.titleColor", colorUIResource2, "TitledBorder.lineColor", _sDarkBlue, "ToolBar.background", color, "ToolBar.foreground", uIDefaults.get("controlText"), "ToolBar.dockingColor", uIDefaults.get("control"), "ToolBar.floatingColor", uIDefaults.get("control"), "ToolBar.lightBorder", _sDarkBeige, "ToolTip.background", uIDefaults.get("info"), "ToolTip.foreground", uIDefaults.get("infoText"), "ScrollPane.background", null, "SplitPane.background", null, "SplitPane.border", null, "Slider.foreground", uIDefaults.get("controlText"), "Slider.background", null, "Slider.sliderColor", color, "Tree.background", uIDefaults.get("text"), "Tree.hash", uIDefaults.get("controlShadow"), "Tree.textSelectionColor", uIDefaults.get("textHighlightText"), "Tree.textNonSelectionColor", uIDefaults.get("textText"), "Tree.borderSelectionColor", uIDefaults.get("textText"), "Tree.backgroundSelectionColor", uIDefaults.get("textHighlight"), "Tree.backgroundNonSelectionColor", null, "ProgressBar.foreground", uIDefaults.get("textHighlight"), "ProgressBar.background", uIDefaults.get("text"), "ProgressBar.textSelectionColor", uIDefaults.get("textHighlightText"), "ProgressBar.textNonSelectionColor", uIDefaults.get("textText"), "TabbedPane.background", color, "TabbedPane.lightHighlight", _sDarkBlue, "TabbedPane.shadow", _sDarkBlue, "TabbedPane.darkShadow", _sDarkBlue, "TabbedPane.notSelectedColor", _sDarkBeige, "TabbedPane.selectedColor", _sDarkBlue, "TabbedPane.inactiveSelectedColor", _sLightBlue, "TabbedPane.lightBorder", _sDarkBlue, "TabbedPane.normalColor", _sDarkBlue, "TabbedPane.selectedTextColor", colorUIResource, "TabbedPane.changeCornerColor", Boolean.FALSE, "TabbedPane.cornerPixel", colorUIResource, "OptionPane.background", color2, "Table.background", uIDefaults.get("text"), "Table.gridColor", uIDefaults.get("controlShadow"), "Table.focusCellBackground", uIDefaults.get("text"), "Table.focusCellForeground", uIDefaults.get("controlText"), "TableHeader.foreground", _sDarkBlue, "TableHeader.background", _sDarkBeige, "Separator.background", null, "Separator.foreground", uIDefaults.get("controlShadowDark"), "PopupMenuSeparator.background", colorUIResource, "PopupMenuSeparator.foreground", uIDefaults.get(ColorScheme.NORMAL_INTENSITY), "Window.lightBorder", _sDarkBeige, "EWTGrayPane.background", color, "EWTGrayPane.lightBorder", _sDarkBeige, "EWTDialog.background", color2};
        return objectArray;
    }

    protected String[] getSystemColors() {
        String[] stringArray = new String[]{"textHighlight", "#0000FF", "selectedFocus", "#FFFFFF", "windowBorder", "#000000", "info", "#FFFFCC", "desktop", "#f7f7e7"};
        return stringArray;
    }

    static {
        _sCurrentScheme = _sDefaultScheme = new BrowserColorScheme();
        _sAvailableSchemes = new BrowserColorScheme[]{_sDefaultScheme};
    }
}

