/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.ewt.olaf;

import java.awt.Color;
import javax.swing.AbstractButton;
import javax.swing.ButtonModel;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JMenuItem;
import javax.swing.JRootPane;
import javax.swing.SwingConstants;
import javax.swing.SwingUtilities;
import oracle.bali.ewt.olaf.AlignedPainterJoiner;
import oracle.bali.ewt.olaf.OracleUIUtils;
import oracle.bali.ewt.olaf.ViewPainter;
import oracle.bali.ewt.painter.JPaintContext;
import oracle.bali.ewt.painter.MarginBorderPainter;
import oracle.bali.ewt.painter.PaintContext;
import oracle.bali.share.util.IntegerUtils;

class AbstractButtonPaintContext
extends JPaintContext
implements SwingConstants {
    private AbstractButton _ab;
    private boolean _interior;
    private static JButton _sFocusedButton;

    public AbstractButtonPaintContext(AbstractButton abstractButton) {
        this(abstractButton, false);
    }

    public AbstractButtonPaintContext(AbstractButton abstractButton, boolean bl) {
        super(abstractButton);
        this._ab = abstractButton;
        this._interior = bl;
    }

    public Color getSurroundingColor() {
        if (this._interior) {
            return this.getPaintBackground();
        }
        return super.getSurroundingColor();
    }

    public int getPaintState() {
        int n = super.getPaintState();
        n &= 0xFFFFFFFE;
        AbstractButton abstractButton = this._ab;
        ButtonModel buttonModel = abstractButton.getModel();
        boolean bl = buttonModel.isEnabled();
        if (!bl) {
            n |= 1;
        }
        if (abstractButton.isRolloverEnabled() && buttonModel.isRollover()) {
            n |= 0x10;
        }
        if (buttonModel.isSelected()) {
            n |= 8;
        }
        if (buttonModel.isArmed() && (abstractButton instanceof JMenuItem || buttonModel.isPressed())) {
            n |= 2;
        }
        if (abstractButton instanceof JButton) {
            if (abstractButton.hasFocus()) {
                n |= 0x80;
            } else {
                JButton jButton;
                JRootPane jRootPane = SwingUtilities.getRootPane(abstractButton);
                if (jRootPane != null && jRootPane.getDefaultButton() == abstractButton && ((jButton = AbstractButtonPaintContext._getFocusedButton()) == null || SwingUtilities.getRootPane(jButton) != jRootPane)) {
                    n |= 0x80;
                }
            }
        }
        if (!abstractButton.isFocusPainted()) {
            n &= 0xFFFFFFBF;
        }
        if (!abstractButton.isContentAreaFilled()) {
            n |= 0x100;
        }
        return n;
    }

    public Object getPaintData(Object object) {
        AbstractButton abstractButton = this._ab;
        if (PaintContext.LABEL_KEY.equals(object)) {
            return abstractButton.getText();
        }
        if (PaintContext.ICON_KEY.equals(object)) {
            boolean bl;
            Icon icon = null;
            int n = this.getPaintState();
            boolean bl2 = bl = (n & 8) != 0;
            if ((n & 1) != 0) {
                if (bl) {
                    icon = abstractButton.getDisabledSelectedIcon();
                }
                if (icon == null) {
                    icon = abstractButton.getDisabledIcon();
                }
                if (icon != null) {
                    return icon;
                }
            }
            if ((n & 2) != 0) {
                icon = abstractButton.getPressedIcon();
            }
            if (icon == null && (n & 0x10) != 0) {
                if (bl && (icon = abstractButton.getRolloverSelectedIcon()) == null) {
                    icon = abstractButton.getSelectedIcon();
                }
                if (icon == null) {
                    icon = abstractButton.getRolloverIcon();
                }
            }
            if (icon == null && bl) {
                icon = abstractButton.getSelectedIcon();
            }
            if (icon == null) {
                icon = abstractButton.getIcon();
            }
            return icon;
        }
        if (ViewPainter.VIEW_KEY.equals(object)) {
            return ViewPainter.getHTMLView(abstractButton);
        }
        if (AlignedPainterJoiner.HORIZONTAL_TEXT_POSITION.equals(object)) {
            return IntegerUtils.getInteger(abstractButton.getHorizontalTextPosition());
        }
        if (AlignedPainterJoiner.VERTICAL_TEXT_POSITION.equals(object)) {
            return IntegerUtils.getInteger(abstractButton.getVerticalTextPosition());
        }
        if (PaintContext.MNEMONIC_INDEX_KEY.equals(object)) {
            return JPaintContext.getMnemonicIndex(abstractButton.getText(), abstractButton.getMnemonic());
        }
        if (MarginBorderPainter.MARGIN_KEY.equals(object)) {
            return abstractButton.getMargin();
        }
        return null;
    }

    public float getInteriorAlignmentX() {
        int n = OracleUIUtils.getActualHorizontalAlignment(this, this._ab.getHorizontalAlignment());
        return n == 2 ? 0.0f : (n == 4 ? 1.0f : 0.5f);
    }

    public float getInteriorAlignmentY() {
        int n = this._ab.getVerticalAlignment();
        return n == 1 ? 0.0f : (n == 3 ? 1.0f : 0.5f);
    }

    static void __setFocusedButton(AbstractButton abstractButton) {
        if (!(abstractButton instanceof JButton)) {
            abstractButton = null;
        }
        if (abstractButton == null) {
            AbstractButtonPaintContext._repaintRealDefault(_sFocusedButton);
        } else {
            AbstractButtonPaintContext._repaintRealDefault(abstractButton);
        }
        _sFocusedButton = (JButton)abstractButton;
    }

    private static void _repaintRealDefault(AbstractButton abstractButton) {
        JButton jButton;
        JRootPane jRootPane;
        if (abstractButton != null && (jRootPane = SwingUtilities.getRootPane(abstractButton)) != null && (jButton = jRootPane.getDefaultButton()) != null) {
            jButton.repaint();
        }
    }

    private static JButton _getFocusedButton() {
        JButton jButton = _sFocusedButton;
        if (jButton != null && !jButton.hasFocus()) {
            jButton = null;
            _sFocusedButton = null;
        }
        return jButton;
    }
}

