/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.ewt.model;

import java.text.Collator;
import oracle.bali.ewt.model.AbstractTwoDModel;
import oracle.bali.ewt.model.ArrayOneDModel;
import oracle.bali.ewt.model.RowComparator;
import oracle.bali.ewt.model.Sortable;
import oracle.bali.share.sort.Comparator;
import oracle.bali.share.sort.Sort;
import oracle.bali.share.sort.StringComparator;

public class SortableTwoDModel
extends AbstractTwoDModel
implements Sortable {
    private int _columns;
    private int _rows;
    private ArrayOneDModel _data;
    private ArrayOneDModel _comparators;
    private Comparator _defaultComparator;
    private RowComparator _sorter;

    public SortableTwoDModel() {
        this(0, 0);
    }

    public SortableTwoDModel(int n, int n2) {
        this._columns = n;
        this._rows = n2;
        this._data = new ArrayOneDModel(this._rows);
        this._sorter = new RowComparator();
    }

    public void addColumns(int n, int n2) {
        if (n2 == 0) {
            return;
        }
        int n3 = 0;
        while (n3 < this.getRowCount()) {
            ArrayOneDModel arrayOneDModel = (ArrayOneDModel)this._data.getData(n3);
            if (arrayOneDModel != null) {
                arrayOneDModel.addItems(n, n2);
            }
            ++n3;
        }
        if (this._comparators != null) {
            this._comparators.addItems(n, n2);
        }
        this._columns += n2;
        this.fireModelEvent(2001, n, n2);
    }

    public void removeColumns(int n, int n2) {
        if (n2 == 0) {
            return;
        }
        int n3 = 0;
        while (n3 < this.getRowCount()) {
            ArrayOneDModel arrayOneDModel = (ArrayOneDModel)this._data.getData(n3);
            if (arrayOneDModel != null) {
                arrayOneDModel.removeItems(n, n2);
            }
            ++n3;
        }
        if (this._comparators != null) {
            this._comparators.removeItems(n, n2);
        }
        this._columns -= n2;
        this.fireModelEvent(2002, n, n2);
    }

    public void addRows(int n, int n2) {
        if (n2 == 0) {
            return;
        }
        this._data.addItems(n, n2);
        this._rows += n2;
        this.fireModelEvent(2004, n, n2);
    }

    public void removeRows(int n, int n2) {
        if (n2 == 0) {
            return;
        }
        this._data.removeItems(n, n2);
        this._rows -= n2;
        this.fireModelEvent(2005, n, n2);
    }

    public int getColumnCount() {
        return this._columns;
    }

    public int getRowCount() {
        return this._rows;
    }

    public Object getData(int n, int n2) {
        ArrayOneDModel arrayOneDModel = (ArrayOneDModel)this._data.getData(n2);
        if (arrayOneDModel == null) {
            return null;
        }
        return arrayOneDModel.getData(n);
    }

    public void setData(int n, int n2, Object object) {
        ArrayOneDModel arrayOneDModel = (ArrayOneDModel)this._data.getData(n2);
        if (arrayOneDModel == null) {
            arrayOneDModel = new ArrayOneDModel(this.getColumnCount());
            this._data.setData(n2, arrayOneDModel);
        }
        arrayOneDModel.setData(n, object);
        this.fireModelEvent(2007, n, 1, n2, 1);
    }

    public void setColumnComparator(int n, Comparator comparator) {
        if (this._comparators == null) {
            this._comparators = new ArrayOneDModel(this.getColumnCount());
        }
        this._comparators.setData(n, comparator);
    }

    public Comparator getColumnComparator(int n) {
        Comparator comparator;
        if (this._comparators != null && (comparator = (Comparator)this._comparators.getData(n)) != null) {
            return comparator;
        }
        return this.getDefaultComparator();
    }

    public Comparator getDefaultComparator() {
        if (this._defaultComparator == null) {
            this._defaultComparator = new StringComparator(Collator.getInstance());
        }
        return this._defaultComparator;
    }

    public void setDefaultComparator(Comparator comparator) {
        this._defaultComparator = comparator;
    }

    public void sort(int n, boolean bl) {
        int n2 = this._rows;
        if (n2 == 0) {
            return;
        }
        Comparator comparator = this.getColumnComparator(n);
        this._sorter.setComparisonData(n, comparator, bl);
        Object[] objectArray = new Object[n2];
        int n3 = 0;
        while (n3 < n2) {
            objectArray[n3] = this._data.getData(n3);
            ++n3;
        }
        Sort.qSort(objectArray, objectArray.length, this._sorter);
        this._data.removeItems(0, n2);
        this._data.addItems(0, objectArray);
        this.fireModelEvent(2007, 0, this._columns, 0, this._rows);
    }
}

