/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.ewt.model;

import oracle.bali.ewt.model.AbstractTwoDModel;

public class ArrayTwoDModel
extends AbstractTwoDModel {
    private int _columns;
    private int _rows;
    private Object[][] _data;
    private static int _ROWS_ALLOCATED_AHEAD = 20;

    public ArrayTwoDModel(int n, int n2) {
        this._columns = n;
        this._rows = n2;
    }

    public ArrayTwoDModel(Object[][] objectArray) {
        int n;
        int n2;
        if (objectArray != null && (n2 = objectArray.length) != 0 && (n = objectArray[0].length) != 0) {
            Object[][] objectArray2 = new Object[n2][n];
            System.arraycopy(objectArray, 0, objectArray2, 0, n2);
            int n3 = 0;
            while (n3 < n2) {
                Object[] objectArray3 = new Object[n];
                System.arraycopy(objectArray[n3], 0, objectArray3, 0, n);
                objectArray2[n3] = objectArray3;
                ++n3;
            }
            this._data = objectArray2;
            this._rows = n2;
            this._columns = n;
        }
    }

    public void addRows(int n, int n2) {
        this._addRowsToArray(n, n2);
        this._rows += n2;
        this.fireModelEvent(2004, n, n2);
    }

    public void removeRows(int n, int n2) {
        this._removeRowsFromArray(n, n2);
        this._rows -= n2;
        this.fireModelEvent(2005, n, n2);
    }

    public void addColumns(int n, int n2) {
        this._addColumnsToArray(n, n2);
        this._columns += n2;
        this.fireModelEvent(2001, n, n2);
    }

    public void removeColumns(int n, int n2) {
        this._removeColumnsFromArray(n, n2);
        this._columns -= n2;
        this.fireModelEvent(2002, n, n2);
    }

    public int getColumnCount() {
        return this._columns;
    }

    public int getRowCount() {
        return this._rows;
    }

    public Object getData(int n, int n2) {
        if (n2 >= this._rows || n >= this._columns) {
            throw new ArrayIndexOutOfBoundsException();
        }
        if (this._data == null) {
            return null;
        }
        Object[] objectArray = this._data[n2];
        if (objectArray == null) {
            return null;
        }
        return objectArray[n];
    }

    public void setData(int n, int n2, Object object) {
        Object[] objectArray;
        if (n2 >= this._rows || n >= this._columns) {
            throw new ArrayIndexOutOfBoundsException();
        }
        if (this._data == null) {
            this._data = new Object[this._rows][];
        }
        if ((objectArray = this._data[n2]) == null) {
            objectArray = new Object[this._columns];
            this._data[n2] = objectArray;
        }
        objectArray[n] = object;
        this.fireModelEvent(2007, n, 1, n2, 1);
    }

    private void _addRowsToArray(int n, int n2) {
        Object[][] objectArray;
        Object[][] objectArray2 = this._data;
        if (objectArray2 == null) {
            return;
        }
        int n3 = this._rows;
        if (objectArray2.length >= n3 + n2) {
            objectArray = objectArray2;
        } else {
            objectArray = new Object[n3 + n2 + _ROWS_ALLOCATED_AHEAD][];
            System.arraycopy(objectArray2, 0, objectArray, 0, n);
            this._data = objectArray;
        }
        System.arraycopy(objectArray2, n, objectArray, n + n2, n3 - n);
        if (objectArray == objectArray2) {
            int n4 = n;
            int n5 = 0;
            while (n5 < n2) {
                objectArray2[n4++] = null;
                ++n5;
            }
        }
    }

    private void _removeRowsFromArray(int n, int n2) {
        Object[][] objectArray;
        Object[][] objectArray2 = this._data;
        if (objectArray2 == null) {
            return;
        }
        int n3 = this._rows;
        if (n3 - n2 + _ROWS_ALLOCATED_AHEAD < objectArray2.length / 2) {
            objectArray = new Object[n3 - n2 + _ROWS_ALLOCATED_AHEAD][];
            System.arraycopy(objectArray2, 0, objectArray, 0, n);
            this._data = objectArray;
        } else {
            objectArray = objectArray2;
        }
        System.arraycopy(objectArray2, n + n2, objectArray, n, n3 - n - n2);
        if (objectArray == objectArray2) {
            int n4 = n3;
            int n5 = 0;
            while (n5 < n2) {
                objectArray2[--n4] = null;
                ++n5;
            }
        }
    }

    private void _addColumnsToArray(int n, int n2) {
        Object[][] objectArray = this._data;
        if (objectArray == null) {
            return;
        }
        int n3 = this._columns;
        int n4 = n3 + n2;
        int n5 = n + n2;
        int n6 = n3 - n;
        int n7 = 0;
        while (n7 < this._rows) {
            Object[] objectArray2 = objectArray[n7];
            if (objectArray2 != null) {
                Object[] objectArray3 = new Object[n4];
                System.arraycopy(objectArray2, 0, objectArray3, 0, n);
                System.arraycopy(objectArray2, n, objectArray3, n5, n6);
                objectArray[n7] = objectArray3;
            }
            ++n7;
        }
    }

    private void _removeColumnsFromArray(int n, int n2) {
        Object[][] objectArray = this._data;
        if (objectArray == null) {
            return;
        }
        int n3 = this._columns;
        int n4 = n3 - n2;
        int n5 = n + n2;
        int n6 = n3 - n - n2;
        int n7 = 0;
        while (n7 < this._rows) {
            Object[] objectArray2 = objectArray[n7];
            if (objectArray2 != null) {
                Object[] objectArray3 = new Object[n4];
                System.arraycopy(objectArray2, 0, objectArray3, 0, n);
                System.arraycopy(objectArray2, n5, objectArray3, n, n6);
                objectArray[n7] = objectArray3;
            }
            ++n7;
        }
    }
}

