/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.ewt.model;

import oracle.bali.ewt.model.AbstractOneDModel;

public class ArrayOneDModel
extends AbstractOneDModel {
    private int _itemCount;
    private Object[] _items;

    public ArrayOneDModel(int n) {
        this._itemCount = n;
    }

    public ArrayOneDModel(Object[] objectArray) {
        if (objectArray != null) {
            this._itemCount = objectArray.length;
            this._items = new Object[this._itemCount];
            System.arraycopy(objectArray, 0, this._items, 0, this._itemCount);
        }
    }

    public int getItemCount() {
        return this._itemCount;
    }

    public void addItems(int n, Object[] objectArray) {
        if (objectArray != null && objectArray.length > 0) {
            this._addToArray(n, objectArray.length);
            System.arraycopy(objectArray, 0, this._items, n, objectArray.length);
            this.fireModelEvent(2001, n, objectArray.length);
        }
    }

    public void addItems(int n, int n2) {
        if (this._items == null) {
            this._itemCount += n2;
        } else {
            this._addToArray(n, n2);
        }
        this.fireModelEvent(2001, n, n2);
    }

    public void removeItems(int n, int n2) {
        this._removeFromArray(n, n2);
        this.fireModelEvent(2002, n, n2);
    }

    public Object getData(int n) {
        if (this._items == null) {
            return null;
        }
        return this._items[n];
    }

    public void setData(int n, Object object) {
        if (this._items == null) {
            this._items = new Object[this._itemCount];
        }
        this._items[n] = object;
        this.fireModelEvent(2003, n, 1);
    }

    private void _addToArray(int n, int n2) {
        Object[] objectArray = this._items;
        int n3 = 0;
        if (objectArray != null) {
            n3 = objectArray.length;
        }
        Object[] objectArray2 = new Object[n3 + n2];
        if (n != 0) {
            System.arraycopy(objectArray, 0, objectArray2, 0, n);
        }
        if (n != n3) {
            System.arraycopy(objectArray, n, objectArray2, n + n2, n3 - n);
        }
        this._items = objectArray2;
        this._itemCount = this._items.length;
    }

    private void _removeFromArray(int n, int n2) {
        Object[] objectArray = this._items;
        if (objectArray == null) {
            this._itemCount -= n2;
            return;
        }
        int n3 = objectArray.length;
        Object[] objectArray2 = new Object[n3 - n2];
        if (n != 0) {
            System.arraycopy(objectArray, 0, objectArray2, 0, n);
        }
        if (n3 - n2 != n) {
            System.arraycopy(objectArray, n + n2, objectArray2, n, n3 - (n + n2));
        }
        int n4 = n;
        while (n4 < n + n2) {
            this._items[n4] = null;
            ++n4;
        }
        this._items = objectArray2;
        this._itemCount = this._items.length;
    }
}

