/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.ewt.layout;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.util.Enumeration;
import oracle.bali.ewt.layout.ChildEnumeration;

public abstract class EqualLayout
implements LayoutManager {
    public static final int ALIGN_START = 0;
    public static final int ALIGN_CENTER = 1;
    public static final int ALIGN_END = 2;
    private int _interiorGap;
    private int _layoutAlignment;
    private int _perpendicularAlignment;

    public EqualLayout() {
        this(0);
    }

    public EqualLayout(int n) {
        this(n, 1, 1);
    }

    public EqualLayout(int n, int n2, int n3) {
        this.setInteriorGap(n);
        this.setLayoutAlignment(n2);
        this.setPerpendicularAlignment(n3);
    }

    public abstract void layoutContainer(Container var1);

    public void addLayoutComponent(String string, Component component) {
    }

    public void removeLayoutComponent(Component component) {
    }

    public Dimension preferredLayoutSize(Container container) {
        return this.getLayoutSize(container, true);
    }

    public Dimension minimumLayoutSize(Container container) {
        return this.getLayoutSize(container, false);
    }

    public void setInteriorGap(int n) {
        this._interiorGap = n;
    }

    public int getInteriorGap() {
        return this._interiorGap;
    }

    public void setLayoutAlignment(int n) {
        this._layoutAlignment = n;
    }

    public int getLayoutAlignment() {
        return this._layoutAlignment;
    }

    public void setPerpendicularAlignment(int n) {
        this._perpendicularAlignment = n;
    }

    public int getPerpendicularAlignment() {
        return this._perpendicularAlignment;
    }

    public static int getNumberVisibleChildren(Container container) {
        int n = container.getComponentCount();
        int n2 = 0;
        int n3 = 0;
        while (n3 < n) {
            if (container.getComponent(n3).isVisible()) {
                ++n2;
            }
            ++n3;
        }
        return n2;
    }

    protected Enumeration getComponentEnumeration(Container container) {
        return new ChildEnumeration(container);
    }

    protected Dimension getCellSize(Container container, boolean bl) {
        int n = 0;
        int n2 = 0;
        int n3 = container.getComponentCount();
        int n4 = 0;
        while (n4 < n3) {
            Component component = container.getComponent(n4);
            if (component.isVisible()) {
                Dimension dimension;
                Dimension dimension2 = dimension = bl ? component.getPreferredSize() : component.getMinimumSize();
                if (n2 < dimension.height) {
                    n2 = dimension.height;
                }
                if (n < dimension.width) {
                    n = dimension.width;
                }
            }
            ++n4;
        }
        return new Dimension(n, n2);
    }

    protected abstract Dimension getInsetLayoutSize(Container var1, boolean var2);

    protected Dimension getLayoutSize(Container container, boolean bl) {
        Dimension dimension = this.getInsetLayoutSize(container, bl);
        Insets insets = container.getInsets();
        dimension.width += insets.left + insets.right;
        dimension.height += insets.top + insets.bottom;
        return dimension;
    }
}

