/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.ewt.imageCanvas;

import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Point;
import javax.accessibility.Accessible;
import javax.accessibility.AccessibleContext;
import javax.swing.JComponent;
import oracle.bali.ewt.painter.AbstractWrappingPainter;
import oracle.bali.ewt.painter.AlignmentPainter;
import oracle.bali.ewt.painter.ImagePainter;
import oracle.bali.ewt.painter.PaintContext;
import oracle.bali.ewt.painter.Painter;
import oracle.bali.ewt.scrolling.ScrollableComponent;
import oracle.bali.share.thread.Task;
import oracle.bali.share.thread.TaskEvent;
import oracle.bali.share.thread.TaskScheduler;

public class ImageCanvas
extends ScrollableComponent
implements Accessible {
    public static final int DONT_SCALE = 0;
    public static final int PRESERVE_ASPECT_RATIO = 1;
    public static final int SCALE_TO_FIT = 2;
    private LoadingTask _loadingTask;
    private Image _image;
    private float _yAlign = 0.0f;
    private float _xAlign = 0.0f;
    private double _xScale;
    private double _yScale;
    private double _xAdjust;
    private double _yAdjust;
    private int _scalingMode = 0;
    private Painter _painter;
    private Painter _scaler;
    private static final int _DEFAULT_SCALING = 0;
    private static final Painter _sPainter = ImageCanvas._createImagePainter(0);
    private static final int _MINIMUM_WIDTH = 10;
    private static final int _MINIMUM_HEIGHT = 10;

    public ImageCanvas() {
        this(null);
    }

    public ImageCanvas(Image image) {
        this._image = image;
        this.setOpaque(true);
        this._xScale = 1.0;
        this._xAdjust = 1.0;
        this._yScale = 1.0;
        this._yAdjust = 1.0;
    }

    public Image getImage() {
        return this._image;
    }

    public void setImage(Image image) {
        Image image2 = this._image;
        this._image = image;
        this.invalidateCanvas();
        AccessibleContext accessibleContext = this.accessibleContext;
        if (accessibleContext != null) {
            accessibleContext.firePropertyChange("AccessibleVisibleData", image2, this._image);
        }
    }

    public void setScalingMode(int n) {
        if (n != this._scalingMode) {
            this._scalingMode = n;
            this._painter = n == 0 ? null : ImageCanvas._createImagePainter(n);
            this.repaint();
        }
    }

    public int getScalingMode() {
        return this._scalingMode;
    }

    public void setInteriorAlignmentX(float f) {
        if (this._xAlign != f) {
            this._xAlign = f;
            this.repaint();
        }
    }

    public float getInteriorAlignmentX() {
        return this._xAlign;
    }

    public void setInteriorAlignmentY(float f) {
        if (this._yAlign != f) {
            this._yAlign = f;
            this.repaint();
        }
    }

    public float getInteriorAlignmentY() {
        return this._yAlign;
    }

    public double getXScalingFactor() {
        return this._xScale;
    }

    public void setXScalingFactor(double d) {
        this._xAdjust *= d / this._xScale;
        this._xScale = d;
        this._createScalingPainter();
        this.invalidateCanvas();
    }

    public double getYScalingFactor() {
        return this._yScale;
    }

    public void setYScalingFactor(double d) {
        this._yAdjust *= d / this._yScale;
        this._yScale = d;
        this._createScalingPainter();
        this.invalidateCanvas();
    }

    public final float getAlignmentX() {
        return this.getInteriorAlignmentX();
    }

    public final float getAlignmentY() {
        return this.getInteriorAlignmentY();
    }

    public final boolean isHScrollable() {
        return true;
    }

    public final boolean isVScrollable() {
        return true;
    }

    public boolean imageUpdate(Image image, int n, int n2, int n3, int n4, int n5) {
        if ((n & 3) != 0) {
            this.invalidateCanvas();
        } else if ((n & 0x38) != 0) {
            if (this._loadingTask == null) {
                this._loadingTask = new LoadingTask();
            }
            this._loadingTask.schedule();
        }
        return (n & 0xA0) == 0;
    }

    public Dimension getPreferredScrollableViewportSize() {
        int n = 0;
        int n2 = 0;
        if (this._image != null) {
            n = (int)((double)this._image.getWidth(this) * this._xScale);
            n2 = (int)((double)this._image.getHeight(this) * this._yScale);
        }
        return this.convertInnerToOuterSize(n, n2);
    }

    public boolean getScrollableTracksViewportWidth() {
        return this.getScalingMode() != 0;
    }

    public boolean getScrollableTracksViewportHeight() {
        return this.getScalingMode() != 0;
    }

    public Dimension layoutCanvas() {
        Dimension dimension = this.getInnerSize();
        if (this.getScalingMode() == 0 && this._image != null) {
            int n = this._image.getWidth(this);
            dimension.width = Math.max(dimension.width, (int)((double)n * this._xScale));
            int n2 = this._image.getHeight(this);
            dimension.height = Math.max(dimension.height, (int)((double)n2 * this._yScale));
        }
        return dimension;
    }

    public AccessibleContext getAccessibleContext() {
        if (this.accessibleContext == null) {
            this.accessibleContext = new AccessibleImageCanvas();
        }
        return this.accessibleContext;
    }

    protected void paintCanvasInterior(Graphics graphics) {
        Dimension dimension = this.getCanvasSize();
        this.getPainter().paint(this.getPaintContext(), graphics, 0, 0, dimension.width, dimension.height);
    }

    protected Object getPaintData(Object object) {
        if (PaintContext.IMAGE_KEY.equals(object)) {
            return this._image;
        }
        return super.getPaintData(object);
    }

    protected Painter getPainter() {
        Painter painter = this._painter;
        if (painter == null && (painter = this._scaler) == null) {
            painter = _sPainter;
        }
        return painter;
    }

    public void setCanvasSize(int n, int n2) {
        Point point = this.getCanvasOrigin();
        super.setCanvasSize(n, n2);
        Dimension dimension = this.getInnerSize();
        if (this._xAdjust != 1.0) {
            point.x = Math.max((int)((double)point.x * this._xAdjust), Math.min(0, dimension.width - n));
            this._xAdjust = 1.0;
        }
        if (this._yAdjust != 1.0) {
            point.y = Math.max((int)((double)point.y * this._yAdjust), Math.min(0, dimension.height - n2));
            this._yAdjust = 1.0;
        }
        this.setCanvasOrigin(point.x, point.y);
    }

    private void _createScalingPainter() {
        if (this._scaler == null) {
            this._scaler = new AlignmentPainter(new Scaler());
        }
    }

    private static Painter _createImagePainter(int n) {
        ImagePainter imagePainter = new ImagePainter(PaintContext.IMAGE_KEY, n);
        imagePainter.setProgressiveLoading(true);
        return new AlignmentPainter(imagePainter);
    }

    private class Scaler
    extends AbstractWrappingPainter {
        public Scaler() {
            super(new ImagePainter(2));
        }

        public Dimension getSize(PaintContext paintContext, int n, int n2) {
            Dimension dimension = this.getPreferredSize(paintContext);
            dimension.width = (int)((double)dimension.width * ImageCanvas.this.getXScalingFactor());
            dimension.height = (int)((double)dimension.height * ImageCanvas.this.getYScalingFactor());
            return dimension;
        }
    }

    private class LoadingTask
    implements Task {
        private boolean _scheduled;

        private LoadingTask() {
        }

        public synchronized void schedule() {
            if (!this._scheduled) {
                this._scheduled = true;
                TaskScheduler.getDefaultTaskScheduler().schedule(this, 100);
            }
        }

        public synchronized void runTask(TaskEvent taskEvent) {
            ImageCanvas.this.repaint();
            this._scheduled = false;
        }
    }

    protected class AccessibleImageCanvas
    extends JComponent.AccessibleJComponent {
        protected AccessibleImageCanvas() {
            super(ImageCanvas.this);
        }
    }
}

