/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.ewt.header;

import java.awt.AWTEvent;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Point;
import java.awt.PrintGraphics;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.print.PrinterGraphics;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyVetoException;
import java.beans.VetoableChangeListener;
import java.text.MessageFormat;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.Locale;
import java.util.ResourceBundle;
import javax.accessibility.Accessible;
import javax.accessibility.AccessibleComponent;
import javax.accessibility.AccessibleContext;
import javax.accessibility.AccessibleRole;
import javax.accessibility.AccessibleSelection;
import javax.accessibility.AccessibleState;
import javax.accessibility.AccessibleStateSet;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JToolTip;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.ToolTipManager;
import javax.swing.UIManager;
import javax.swing.plaf.UIResource;
import oracle.bali.ewt.elaf.EWTHeaderUI;
import oracle.bali.ewt.geometry.GeneralGeometryManager;
import oracle.bali.ewt.geometry.GeometryEvent;
import oracle.bali.ewt.geometry.GeometryListener;
import oracle.bali.ewt.geometry.GeometryManager;
import oracle.bali.ewt.geometry.ReversedGeometryManager;
import oracle.bali.ewt.graphics.Appearance;
import oracle.bali.ewt.graphics.ImageSet;
import oracle.bali.ewt.header.AutoScroller;
import oracle.bali.ewt.header.GeneralHeaderSelectionManager;
import oracle.bali.ewt.header.HeaderEvent;
import oracle.bali.ewt.header.HeaderItemInputHandler;
import oracle.bali.ewt.header.HeaderKeyHandler;
import oracle.bali.ewt.header.HeaderMoveListener;
import oracle.bali.ewt.header.HeaderResizeListener;
import oracle.bali.ewt.header.HeaderSelectionManager;
import oracle.bali.ewt.header.HeaderToolTipManager;
import oracle.bali.ewt.header.HeaderValidateEvent;
import oracle.bali.ewt.header.Mover;
import oracle.bali.ewt.header.NullInputHandler;
import oracle.bali.ewt.header.SelectionAutoScroller;
import oracle.bali.ewt.header.StandardHeaderKeyHandler;
import oracle.bali.ewt.model.ArrayOneDModel;
import oracle.bali.ewt.model.EmptyOneDModel;
import oracle.bali.ewt.model.OneDModel;
import oracle.bali.ewt.model.OneDModelEvent;
import oracle.bali.ewt.model.OneDModelListener;
import oracle.bali.ewt.painter.BorderPainter;
import oracle.bali.ewt.painter.PaintContext;
import oracle.bali.ewt.painter.PaintContextProxy;
import oracle.bali.ewt.painter.Painter;
import oracle.bali.ewt.print.PrinterUtils;
import oracle.bali.ewt.scrolling.ScrollableComponent;
import oracle.bali.ewt.selection.OneDSelection;
import oracle.bali.ewt.text.MultiLineToolTip;
import oracle.bali.ewt.util.ImmInsets;
import oracle.bali.ewt.util.LocaleUtils;
import oracle.bali.share.collection.Range;
import oracle.bali.share.event.ListenerManager;
import oracle.bali.share.util.IntegerUtils;

public class Header
extends ScrollableComponent
implements Accessible {
    public static final Object KEY_APPEARANCE = "header.Appearance";
    public static final Object KEY_DRAW_RAISED = "header.drawRaised";
    public static final String PROPERTY_SELECTION = "selection";
    public static final String PROPERTY_SELECTION_MANAGER = "headerSelectionManager";
    public static final String PROPERTY_MODEL = "model";
    public static final String PROPERTY_GEOMETRY_MANAGER = "geometryManager";
    public static final String PROPERTY_FOCUS_ITEM = "focusItem";
    public static final Object DISPLAY_FOCUS_ITEM = "header.dispFocus";
    private static final String _IMAGE = "GRID_IMAGE";
    private static final String _UNKNOWN = "UNKNOWN";
    private static final String _RESOURCE = "oracle.bali.ewt.resource.AccessibilityBundle";
    private static final String _KEY_COLUMN = "SPREADTABLE.COLUMN";
    private static final String _KEY_ROW = "SPREADTABLE.ROW";
    private static final String _MOVE_LEFT = "move.left";
    private static final String _MOVE_RIGHT = "move.right";
    private static final String _RESIZE_LEFT = "resize.left";
    private static final String _RESIZE_RIGHT = "resize.right";
    private static final String _MOVE_UP = "move.up";
    private static final String _MOVE_DOWN = "move.down";
    private static final String _RESIZE_UP = "resize.up";
    private static final String _RESIZE_DOWN = "resize.down";
    private static final String _ROWHEADER = "HEADER.ROW";
    private static final String _COLHEADER = "HEADER.COLUMN";
    private static final char _NONE = '\u0000';
    private static final char _RESIZE = '\u0001';
    private static final char _MOVE = '\u0002';
    private static final char _CANCEL = '\u0003';
    private static final int _TARGET = 5;
    private boolean _firstEdge;
    private boolean _lastEdge;
    private Painter _defaultPainter;
    private KeyboardActionListener _keyboardListener;
    private BorderPainter _borderPainter;
    private BorderPainter _firstBorderPainter;
    private BorderPainter _lastBorderPainter;
    private HeaderItemInputHandler _inputHandler;
    private ArrayOneDModel _itemGraphics;
    private ArrayOneDModel _painters;
    private ArrayOneDModel _notmovable;
    private OneDModel _ds;
    private DSListen _dsListener;
    private GeometryManager _gm;
    private Appearance _appearanceObject;
    private HeaderKeyHandler _keyHandler;
    private int _prefSize = -1;
    private int _mouseItem = -1;
    private int _moveItem = -1;
    private int _anchorItem = -1;
    private int _armedItem = -1;
    private int _focusItem = -1;
    private char _state = '\u0000';
    private int _orientation;
    private boolean _drawSelected;
    private boolean _drawRaised;
    private boolean _canMove;
    private boolean _canResize;
    private int _redrawInfo = -1;
    private int _outlinePosition = -1;
    private int _outlineOffset = -1;
    private HeaderSelectionManager _headerSelection;
    private boolean _scrollByItem;
    private ListenerManager _resizeListeners;
    private ListenerManager _moveListeners;
    private GeometryChangeListener _geometryChangeListener;
    private SelectionListener _selectionListener;
    private int _firstItem = -1;
    private boolean _ignoreSelectionRepaints = false;
    private HeaderToolTipManager _toolTipManager;

    public Header() {
        this(null);
    }

    public Header(OneDModel oneDModel) {
        this(oneDModel, 0);
    }

    public Header(OneDModel oneDModel, int n) {
        if (oneDModel == null) {
            oneDModel = EmptyOneDModel.getOneDModel();
        }
        this._orientation = n;
        this._ds = oneDModel;
        this._dsListener = new DSListen();
        this._ds.addModelListener(this._dsListener);
        this._canMove = true;
        this._canResize = true;
        this._drawSelected = true;
        this._drawRaised = true;
        this._scrollByItem = true;
        long l = 60L;
        this.enableEvents(l);
        this._registerKeyboardActions();
        this.updateUI();
    }

    public void dispose() {
        this._outlinePosition = -1;
        this._outlineOffset = -1;
        this._firstItem = -1;
        this._mouseItem = -1;
        this._moveItem = -1;
        this._anchorItem = -1;
        this._armedItem = -1;
        this._focusItem = -1;
        this.setToolTipManager(null);
        this._defaultPainter = null;
        this._borderPainter = null;
        this._firstBorderPainter = null;
        this._lastBorderPainter = null;
        this._inputHandler = null;
        this._appearanceObject = null;
        if (this._itemGraphics != null && this._itemGraphics.getItemCount() != 0) {
            this._itemGraphics.removeItems(0, this._itemGraphics.getItemCount());
        }
        this._itemGraphics = null;
        if (this._painters != null && this._painters.getItemCount() != 0) {
            this._painters.removeItems(0, this._painters.getItemCount());
        }
        this._painters = null;
        if (this._notmovable != null && this._notmovable.getItemCount() != 0) {
            this._notmovable.removeItems(0, this._notmovable.getItemCount());
        }
        this._notmovable = null;
        this._resizeListeners = null;
        this._moveListeners = null;
        this._keyHandler = null;
        this._gm.removeGeometryListener(this._geometryChangeListener);
        this._geometryChangeListener = null;
        this._gm = null;
        if (this._headerSelection != null) {
            this._headerSelection.removeVetoableChangeListener(this._selectionListener);
            this._headerSelection.removePropertyChangeListener(this._selectionListener);
        }
        this._headerSelection = null;
        this._selectionListener = null;
        this._ds.removeModelListener(this._dsListener);
        this._dsListener = null;
        this._ds = null;
        this._unregisterKeyboardActions();
        this.setUI(null);
    }

    public String getUIClassID() {
        return "EWTHeaderUI";
    }

    public int getOrientation() {
        return this._orientation;
    }

    public BorderPainter getHeaderItemBorderPainter() {
        if (this._borderPainter == null) {
            EWTHeaderUI eWTHeaderUI = this.getUI();
            this._borderPainter = eWTHeaderUI.getHeaderItemBorderPainter(this);
        }
        return this._borderPainter;
    }

    public void setHeaderItemBorderPainter(BorderPainter borderPainter) {
        if (this._borderPainter != borderPainter) {
            this._borderPainter = borderPainter;
            this.revalidate();
            this.repaint();
        }
    }

    public BorderPainter getFirstItemBorderPainter() {
        if (this._firstBorderPainter == null) {
            EWTHeaderUI eWTHeaderUI = this.getUI();
            this._firstBorderPainter = eWTHeaderUI.getFirstItemBorderPainter(this);
        }
        return this._firstBorderPainter;
    }

    public void setFirstItemBorderPainter(BorderPainter borderPainter) {
        if (this._firstBorderPainter != borderPainter) {
            this._firstBorderPainter = borderPainter;
            this.revalidate();
            this.repaint();
        }
    }

    public BorderPainter getLastItemBorderPainter() {
        if (this._lastBorderPainter == null) {
            EWTHeaderUI eWTHeaderUI = this.getUI();
            this._lastBorderPainter = eWTHeaderUI.getLastItemBorderPainter(this);
        }
        return this._lastBorderPainter;
    }

    public void setLastItemBorderPainter(BorderPainter borderPainter) {
        if (this._lastBorderPainter != borderPainter) {
            this._lastBorderPainter = borderPainter;
            this.revalidate();
            this.repaint();
        }
    }

    public void setFirstEdge(boolean bl) {
        if (bl != this._firstEdge) {
            this._firstEdge = bl;
            this.revalidate();
            this.repaint();
        }
    }

    public boolean isFirstEdge() {
        return this._firstEdge;
    }

    public void setLastEdge(boolean bl) {
        if (this._lastEdge != bl) {
            this._lastEdge = bl;
            this.revalidate();
            this.repaint();
        }
    }

    public boolean isLastEdge() {
        return this._lastEdge;
    }

    public synchronized void addResizeListener(HeaderResizeListener headerResizeListener) {
        if (this._resizeListeners == null) {
            this._resizeListeners = new ListenerManager();
        }
        this._resizeListeners.addListener(headerResizeListener);
    }

    public synchronized void removeResizeListener(HeaderResizeListener headerResizeListener) {
        if (this._resizeListeners != null) {
            this._resizeListeners.removeListener(headerResizeListener);
        }
    }

    public synchronized void addMoveListener(HeaderMoveListener headerMoveListener) {
        if (this._moveListeners == null) {
            this._moveListeners = new ListenerManager();
        }
        this._moveListeners.addListener(headerMoveListener);
    }

    public synchronized void removeMoveListener(HeaderMoveListener headerMoveListener) {
        if (this._moveListeners != null) {
            this._moveListeners.removeListener(headerMoveListener);
        }
    }

    public void setToolTipManager(HeaderToolTipManager headerToolTipManager) {
        this._toolTipManager = headerToolTipManager;
        ToolTipManager toolTipManager = ToolTipManager.sharedInstance();
        if (this._toolTipManager == null) {
            toolTipManager.unregisterComponent(this);
        } else {
            toolTipManager.registerComponent(this);
        }
    }

    public HeaderToolTipManager getToolTipManager() {
        return this._toolTipManager;
    }

    public JToolTip createToolTip() {
        return new MultiLineToolTip();
    }

    public String getToolTipText(MouseEvent mouseEvent) {
        if (this._toolTipManager == null) {
            return null;
        }
        int n = this.getItemAt(mouseEvent.getX(), mouseEvent.getY());
        if (n == -1) {
            return null;
        }
        return this._toolTipManager.getItemToolTipValue(this, n);
    }

    public int getItemCount() {
        return this._ds.getItemCount();
    }

    public boolean getDrawSelected() {
        return this._drawSelected;
    }

    public void setDrawSelected(boolean bl) {
        if (this.getDrawSelected() != bl) {
            this._drawSelected = bl;
            this.repaintInterior();
        }
    }

    public boolean getDrawRaised() {
        return this._drawRaised;
    }

    public void setDrawRaised(boolean bl) {
        if (bl != this.getDrawRaised()) {
            this._drawRaised = bl;
            this.repaintInterior();
        }
    }

    public void setHeaderSelectionManager(HeaderSelectionManager headerSelectionManager) {
        if (headerSelectionManager == null) {
            headerSelectionManager = GeneralHeaderSelectionManager.getNullHeaderSelectionManager();
        }
        if (headerSelectionManager != this._headerSelection) {
            SelectionListener selectionListener = this._getSelectionListener();
            if (this._headerSelection != null) {
                this._headerSelection.removeVetoableChangeListener(selectionListener);
                this._headerSelection.removePropertyChangeListener(selectionListener);
            }
            HeaderSelectionManager headerSelectionManager2 = this._headerSelection;
            this._headerSelection = headerSelectionManager;
            this._headerSelection.addVetoableChangeListener(selectionListener);
            this._headerSelection.addPropertyChangeListener(selectionListener);
            this.repaintInterior();
            this.firePropertyChange(PROPERTY_SELECTION_MANAGER, headerSelectionManager2, this._headerSelection);
        }
    }

    public HeaderSelectionManager getHeaderSelectionManager() {
        if (this._headerSelection == null) {
            this.setHeaderSelectionManager(new GeneralHeaderSelectionManager());
        }
        return this._headerSelection;
    }

    public int getOnScreenItemCount() {
        int n;
        int n2 = this.getFirstItemOnScreen();
        int n3 = this.getItemCount();
        if (n3 == 0 || n2 == -1) {
            return 0;
        }
        Point point = this.getCanvasOrigin();
        Dimension dimension = this.getCanvasSize();
        Dimension dimension2 = this.getInnerSize();
        int n4 = 0;
        point.x = -point.x;
        point.y = -point.y;
        if (this._isHorizontal()) {
            n = point.x + dimension2.width;
            if (n > dimension.width) {
                n = dimension.width;
            }
        } else {
            n = point.y + dimension2.height;
            if (n > dimension.height) {
                n = dimension.height;
            }
        }
        GeometryManager geometryManager = this._getGeometryManager();
        int n5 = geometryManager.getItemVisibleIndex(n2);
        while (n5 < n3) {
            int n6 = geometryManager.visibleIndexToIndex(n5);
            ++n5;
            if (!geometryManager.isItemVisible(n6)) continue;
            int n7 = geometryManager.getItemPosition(n6);
            if (n7 >= n) break;
            ++n4;
        }
        return n4;
    }

    private int _getLastItemOnScreen() {
        Point point = this.getCanvasOrigin();
        Dimension dimension = this.getInnerSize();
        GeometryManager geometryManager = this._getGeometryManager();
        if (this._isHorizontal()) {
            return geometryManager.getItemAt(-point.x + dimension.width);
        }
        return geometryManager.getItemAt(-point.y + dimension.height);
    }

    public void setFirstItemOnScreen(int n) {
        GeometryManager geometryManager = this._getGeometryManager();
        if (n < 0 || n >= this.getItemCount() || !geometryManager.isItemVisible(n)) {
            throw new IllegalArgumentException();
        }
        if (this._isHorizontal()) {
            if (this.getCanvasWidth() == 0) {
                this._firstItem = n;
                return;
            }
        } else if (this.getCanvasHeight() == 0) {
            this._firstItem = n;
            return;
        }
        this._firstItem = -1;
        Point point = this.getCanvasOrigin();
        int n2 = -geometryManager.getItemPosition(n);
        if (this._isHorizontal()) {
            this.setCanvasOrigin(n2, point.y);
        } else {
            this.setCanvasOrigin(point.x, n2);
        }
    }

    public int getFirstItemOnScreen() {
        GeometryManager geometryManager = this._getGeometryManager();
        if (this._firstItem != -1) {
            return this._firstItem;
        }
        Point point = this.getCanvasOrigin();
        if (this._isHorizontal()) {
            return geometryManager.getItemAt(-point.x);
        }
        return geometryManager.getItemAt(-point.y);
    }

    public boolean getCanResizeItems() {
        return this._canResize;
    }

    public void setCanResizeItems(boolean bl) {
        this._canResize = bl;
    }

    public boolean getCanMoveItems() {
        return this._canMove;
    }

    public void setCanMoveItems(boolean bl) {
        this._canMove = bl;
    }

    public boolean isItemMovable(int n) {
        if (!this.getCanMoveItems()) {
            return false;
        }
        if (this._notmovable == null) {
            return true;
        }
        Object object = this._notmovable.getData(n);
        return !Boolean.TRUE.equals(object);
    }

    public void setItemMovable(int n, boolean bl) {
        if (this._notmovable == null) {
            this._notmovable = new ArrayOneDModel(this.getItemCount());
        }
        Boolean bl2 = bl ? Boolean.FALSE : Boolean.TRUE;
        this._notmovable.setData(n, bl2);
    }

    public void setHeaderKeyHandler(HeaderKeyHandler headerKeyHandler) {
        this._keyHandler = headerKeyHandler;
    }

    public HeaderKeyHandler getHeaderKeyHandler() {
        if (this._keyHandler == null) {
            this._keyHandler = StandardHeaderKeyHandler.getHeaderKeyHandler();
        }
        return this._keyHandler;
    }

    public int getFocusItem() {
        return this._focusItem;
    }

    public boolean setFocusItem(int n) {
        if (n != this._focusItem) {
            this.freezeRepaints();
            try {
                Integer n2 = IntegerUtils.getInteger(this._focusItem);
                Integer n3 = IntegerUtils.getInteger(n);
                try {
                    this.fireVetoableChange(PROPERTY_FOCUS_ITEM, n2, n3);
                }
                catch (PropertyVetoException propertyVetoException) {
                    boolean bl = false;
                    Object var7_7 = null;
                    this.unfreezeRepaints();
                    return bl;
                }
                int n4 = this._focusItem;
                if (n4 != -1) {
                    this.paintItem(n4);
                }
                this._focusItem = n;
                if (this._focusItem != -1) {
                    this.paintItem(this._focusItem);
                }
                if (this.getArmedItem() != -1) {
                    this.setArmedItem(-1);
                }
                this.firePropertyChange(PROPERTY_FOCUS_ITEM, n2, n3);
                Object var7_8 = null;
                this.unfreezeRepaints();
            }
            catch (Throwable throwable) {
                Object var7_9 = null;
                this.unfreezeRepaints();
                throw throwable;
            }
        }
        return true;
    }

    public void setCanvasSize(int n, int n2) {
        int n3;
        int n4 = this.getCanvasSize().width;
        super.setCanvasSize(n, n2);
        if (this._isHorizontal() && this.getActualReadingDirection() == 2 && (n3 = this.getInnerSize().width) != 0) {
            int n5 = this.getCanvasSize().width;
            Point point = this.getCanvasOrigin();
            point.x = n4 == 0 ? n3 - n5 : (point.x += n4 - n5);
            this.setCanvasOrigin(point.x, point.y);
        }
    }

    public void setCanvasOrigin(int n, int n2) {
        int n3 = this.getCanvasSize().width;
        int n4 = this.getCanvasSize().height;
        int n5 = this.getInnerSize().width;
        int n6 = this.getInnerSize().height;
        if (this._isHorizontal()) {
            if (n3 != 0 && n3 > n5 && n + n3 < n5) {
                n = -(n3 - n5);
            }
        } else if (n4 != 0 && n4 > n6 && n2 + n4 < n6) {
            n2 = -(n4 - n6);
        }
        super.setCanvasOrigin(n, n2);
    }

    public boolean isHScrollable() {
        return this._isHorizontal();
    }

    public boolean isVScrollable() {
        return !this._isHorizontal();
    }

    public void setScrollByItem(boolean bl) {
        if (bl != this.getScrollByItem()) {
            this._scrollByItem = bl;
            this.revalidate();
        }
    }

    public boolean getScrollByItem() {
        return this._scrollByItem;
    }

    public void setItemInputHandler(HeaderItemInputHandler headerItemInputHandler) {
        this._inputHandler = headerItemInputHandler;
    }

    public HeaderItemInputHandler getItemInputHandler() {
        if (this._inputHandler == null) {
            this._inputHandler = NullInputHandler.getHeaderItemInputHandler();
        }
        return this._inputHandler;
    }

    public void setDefaultPainter(Painter painter) {
        if (painter != this._defaultPainter) {
            this._defaultPainter = painter;
            this.repaintInterior();
        }
    }

    public Painter getDefaultPainter() {
        if (this._defaultPainter == null) {
            this._defaultPainter = (Painter)UIManager.get("Header.DefaultHeaderPainter");
        }
        return this._defaultPainter;
    }

    public Painter getPainter(int n) {
        Object object;
        if (this._painters != null && (object = this._painters.getData(n)) != null) {
            return (Painter)object;
        }
        return this.getDefaultPainter();
    }

    public void setPainter(int n, Painter painter) {
        if (this._painters == null) {
            this._painters = new ArrayOneDModel(this.getItemCount());
        }
        this._painters.setData(n, painter);
    }

    public void setAppearance(Appearance appearance) {
        this._appearanceObject = appearance.copy();
        this.repaintInterior();
    }

    public Appearance getAppearance() {
        return this._getAppearance().copy();
    }

    public Appearance getItemAppearance(int n) {
        return this._getItemAppearance(n).copy();
    }

    public void setItemAppearance(int n, Appearance appearance) {
        if (this._itemGraphics == null) {
            this._itemGraphics = new ArrayOneDModel(this.getItemCount());
        }
        this._itemGraphics.setData(n, appearance.copy());
    }

    public boolean isItemOnScreen(int n) {
        GeometryManager geometryManager = this._getGeometryManager();
        if (!geometryManager.isItemVisible(n)) {
            return false;
        }
        Point point = this.getCanvasOrigin();
        Dimension dimension = this.getInnerSize();
        int n2 = geometryManager.getItemPosition(n);
        int n3 = geometryManager.getItemSize(n);
        point.x = -point.x;
        point.y = -point.y;
        if (this._isHorizontal()) {
            return n2 + n3 >= point.x && n2 < point.x + dimension.width;
        }
        return n2 + n3 >= point.y && n2 < point.y + dimension.height;
    }

    public final int getItemAt(int n, int n2) {
        Point point = this.convertOuterToCanvas(n, n2);
        int n3 = this._isHorizontal() ? point.x : point.y;
        return this._getGeometryManager().getItemAt(n3);
    }

    public int getPreferredHeaderSize() {
        Font font;
        if (this._prefSize == -1 && (font = this.getFont()) != null) {
            FontMetrics fontMetrics = ((Component)this).getFontMetrics(font);
            this._prefSize = this._isHorizontal() ? fontMetrics.getHeight() + 4 : fontMetrics.stringWidth("eeeee");
        }
        return this._prefSize;
    }

    public void setPreferredHeaderSize(int n) {
        if (this._prefSize != n) {
            this._prefSize = n;
            this.revalidate();
        }
    }

    private int _getDefaultItemSize() {
        FontMetrics fontMetrics;
        Font font = this.getFont();
        if (font != null && (fontMetrics = ((Component)this).getFontMetrics(font)) != null) {
            return this._isHorizontal() ? fontMetrics.stringWidth("eeeee") : fontMetrics.getHeight() + 4;
        }
        return -1;
    }

    public void addNotify() {
        super.addNotify();
        GeometryManager geometryManager = this._getGeometryManager();
        if (geometryManager.getDefaultItemSize() != 0) {
            return;
        }
        int n = this._getDefaultItemSize();
        if (n != -1) {
            geometryManager.setDefaultItemSize(n);
        }
    }

    public void removeNotify() {
        AutoScroller.getAutoScroller().cancel(this);
        SelectionAutoScroller.getSelectionAutoScroller().cancel(this);
        super.removeNotify();
    }

    public void paintItem(int n) {
        if (n >= this.getItemCount()) {
            return;
        }
        GeometryManager geometryManager = this._getGeometryManager();
        if (!geometryManager.isItemVisible(n)) {
            return;
        }
        this.validate();
        int n2 = geometryManager.getItemPosition(n);
        int n3 = geometryManager.getItemSize(n);
        Dimension dimension = this.getInnerSize();
        if (this._isHorizontal()) {
            this.paintImmediateCanvas(n2, 0, n3, dimension.height);
        } else {
            this.paintImmediateCanvas(0, n2, dimension.width, n3);
        }
    }

    public boolean isFocusTraversable() {
        return true;
    }

    public Dimension getPreferredScrollableViewportSize() {
        Dimension dimension = this._calculateCanvasSize();
        int n = 0;
        int n2 = 0;
        GeometryManager geometryManager = this._getGeometryManager();
        int n3 = geometryManager.getVisibleItemCount();
        int n4 = geometryManager.getTotalSize();
        int n5 = n4 == 0 ? geometryManager.getDefaultItemSize() : n4;
        if (this._isHorizontal()) {
            n = n5;
            n2 = this.getPreferredHeaderSize();
        } else {
            n = this.getPreferredHeaderSize();
            n2 = n5;
        }
        return this.convertInnerToOuterSize(n, n2);
    }

    public Dimension getMinimumSize() {
        this.validate();
        int n = 0;
        int n2 = 0;
        GeometryManager geometryManager = this._getGeometryManager();
        int n3 = geometryManager.getVisibleItemCount();
        int n4 = geometryManager.getTotalSize();
        int n5 = n3 == 0 ? geometryManager.getDefaultItemSize() : n4 / n3;
        Font font = this.getFont();
        if (font != null) {
            FontMetrics fontMetrics = ((Component)this).getFontMetrics(font);
            if (this._isHorizontal()) {
                n2 = fontMetrics.getHeight() + 4;
            } else {
                n = fontMetrics.stringWidth("eeeee");
            }
        }
        if (this._isHorizontal()) {
            n = n5;
        } else {
            n2 = n5;
        }
        return this.convertInnerToOuterSize(n, n2);
    }

    public OneDModel getModel() {
        return this._ds;
    }

    public void setModel(OneDModel oneDModel) {
        OneDModel oneDModel2;
        if (oneDModel == null) {
            oneDModel = EmptyOneDModel.getOneDModel();
        }
        if (oneDModel != (oneDModel2 = this.getModel())) {
            this.freezeRepaints();
            try {
                try {
                    this.deselectAll();
                }
                catch (PropertyVetoException propertyVetoException) {
                    // empty catch block
                }
                if (oneDModel2 != null) {
                    oneDModel2.removeModelListener(this._dsListener);
                }
                oneDModel.addModelListener(this._dsListener);
                this._ds = oneDModel;
                GeometryManager geometryManager = this._getGeometryManager();
                geometryManager.resetAll(this._ds.getItemCount());
                this._itemGraphics = null;
                this._painters = null;
                this._notmovable = null;
                this._mouseItem = -1;
                this._moveItem = -1;
                this._anchorItem = -1;
                this.setArmedItem(-1);
                this.setFocusItem(-1);
                this._firstItem = Math.min(this._firstItem, this.getItemCount() - 1);
                this.firePropertyChange(PROPERTY_MODEL, oneDModel2, this._ds);
                Object var5_5 = null;
                this.unfreezeRepaints();
            }
            catch (Throwable throwable) {
                Object var5_6 = null;
                this.unfreezeRepaints();
                throw throwable;
            }
            this.invalidateCanvas();
        }
    }

    public void setSelection(OneDSelection oneDSelection) throws PropertyVetoException {
        this.getHeaderSelectionManager().setSelection(oneDSelection, -1);
    }

    public OneDSelection getSelection() {
        return this.getHeaderSelectionManager().getSelection();
    }

    public void selectAll() throws PropertyVetoException {
        int n = this.getNextVisibleItem(-1);
        int n2 = this.getPreviousVisibleItem(this.getItemCount());
        GeometryManager geometryManager = this.getGeometryManager();
        OneDSelection oneDSelection = this._newModelRangeSelection(n, n2);
        this.setSelection(oneDSelection);
    }

    public void deselectAll() throws PropertyVetoException {
        this.setSelection(OneDSelection.getEmptySelection());
    }

    public void setGeometryManager(GeometryManager geometryManager) {
        if (geometryManager == null) {
            throw new NullPointerException();
        }
        GeometryListener geometryListener = this._getGeometryChangeListener();
        if (this._gm != null) {
            this._gm.removeGeometryListener(geometryListener);
        }
        if (this._isHorizontal() && this.getActualReadingDirection() == 2) {
            geometryManager = new ReversedGeometryManager(geometryManager);
        }
        GeometryManager geometryManager2 = this._gm;
        this._gm = geometryManager;
        this._gm.resetAll(this.getItemCount());
        this._gm.addGeometryListener(geometryListener);
        this.firePropertyChange(PROPERTY_GEOMETRY_MANAGER, geometryManager2, this._gm);
    }

    public GeometryManager getGeometryManager() {
        GeometryManager geometryManager = this._getGeometryManager();
        if (geometryManager instanceof ReversedGeometryManager) {
            return ((ReversedGeometryManager)geometryManager).getWrappedGeometryManager();
        }
        return geometryManager;
    }

    public final void setDefaultItemSize(int n) {
        this._getGeometryManager().setDefaultItemSize(n);
    }

    public final int getDefaultItemSize() {
        return this._getGeometryManager().getDefaultItemSize();
    }

    public final void setItemSize(int n, int n2) {
        this._getGeometryManager().setItemSize(n, n2);
    }

    public final int getItemSize(int n) {
        return this._getGeometryManager().getItemSize(n);
    }

    public final boolean isItemResizable(int n) {
        return this._getGeometryManager().isItemResizable(n);
    }

    public final void setItemVisibleIndex(int n, int n2) {
        this._getGeometryManager().setItemVisibleIndex(n, n2);
    }

    public final int getItemVisibleIndex(int n) {
        return this._getGeometryManager().getItemVisibleIndex(n);
    }

    public final void setItemVisible(int n, boolean bl) {
        this._getGeometryManager().setItemVisible(n, bl);
    }

    public final boolean isItemVisible(int n) {
        return this._getGeometryManager().isItemVisible(n);
    }

    public final int getItemPosition(int n) {
        return this._getGeometryManager().getItemPosition(n);
    }

    private GeometryManager _getGeometryManager() {
        if (this._gm == null) {
            GeneralGeometryManager generalGeometryManager = new GeneralGeometryManager();
            int n = this._getDefaultItemSize();
            if (n != -1) {
                generalGeometryManager.setDefaultItemSize(n);
            }
            this.setGeometryManager(generalGeometryManager);
        }
        return this._gm;
    }

    public void updateUI() {
        if (this._appearanceObject instanceof UIResource) {
            this._appearanceObject = null;
        }
        this.setUI((EWTHeaderUI)UIManager.getUI(this));
    }

    public PaintContext getItemPaintContext(int n) {
        return new ItemPaintContext(this.getPaintContext(), n);
    }

    public void printPage(PaintContext paintContext, Dictionary dictionary, Graphics graphics) {
        boolean bl = PrinterUtils.getPrinterProperty(dictionary, DISPLAY_FOCUS_ITEM, true);
        this._paintHeader(graphics, paintContext, bl);
    }

    public void setArmedItem(int n) {
        if (this._armedItem != n) {
            if (this._armedItem != -1) {
                int n2 = this._armedItem;
                this._armedItem = -1;
                this._repaintIfNeeded(n2);
            }
            this._armedItem = n;
            if (this._armedItem != -1) {
                this._repaintIfNeeded(this._armedItem);
            }
        }
    }

    public int getArmedItem() {
        return this._armedItem;
    }

    public AccessibleHeader getAccessibleHeader() {
        return (AccessibleHeader)this.accessibleContext;
    }

    protected Object getPaintData(Object object) {
        if (KEY_DRAW_RAISED.equals(object)) {
            return this.getDrawRaised() ? Boolean.TRUE : Boolean.FALSE;
        }
        return super.getPaintData(object);
    }

    protected Object getItemPaintData(int n, Object object) {
        return null;
    }

    protected int getItemPaintState(int n, int n2) {
        return n;
    }

    protected EWTHeaderUI getUI() {
        return (EWTHeaderUI)this.ui;
    }

    protected void processEventImpl(AWTEvent aWTEvent) {
        if (aWTEvent instanceof HeaderEvent) {
            switch (aWTEvent.getID()) {
                case 2005: 
                case 2006: {
                    this.processResizeEvent((HeaderEvent)aWTEvent);
                    break;
                }
                case 2007: 
                case 2008: {
                    this.processMoveEvent((HeaderEvent)aWTEvent);
                }
            }
        } else {
            super.processEventImpl(aWTEvent);
        }
    }

    protected void processResizeEvent(HeaderEvent headerEvent) {
        if (this._resizeListeners == null) {
            return;
        }
        Enumeration enumeration = this._resizeListeners.getListeners();
        if (enumeration == null) {
            return;
        }
        switch (headerEvent.getID()) {
            case 2005: {
                while (enumeration.hasMoreElements()) {
                    ((HeaderResizeListener)enumeration.nextElement()).itemResizing(headerEvent);
                }
                break;
            }
            case 2006: {
                while (enumeration.hasMoreElements()) {
                    ((HeaderResizeListener)enumeration.nextElement()).itemResized(headerEvent);
                }
                break;
            }
        }
    }

    protected void processMoveEvent(HeaderEvent headerEvent) {
        int n = headerEvent.getID();
        if (this._moveListeners == null) {
            return;
        }
        Enumeration enumeration = this._moveListeners.getListeners();
        if (enumeration == null) {
            return;
        }
        switch (headerEvent.getID()) {
            case 2007: {
                while (enumeration.hasMoreElements()) {
                    ((HeaderMoveListener)enumeration.nextElement()).itemMoving(headerEvent);
                }
                break;
            }
            case 2008: {
                while (enumeration.hasMoreElements()) {
                    ((HeaderMoveListener)enumeration.nextElement()).itemMoved(headerEvent);
                }
                break;
            }
        }
    }

    protected void processComponentKeyEvent(KeyEvent keyEvent) {
        super.processComponentKeyEvent(keyEvent);
        if (keyEvent.isConsumed() || !this.isEnabled()) {
            return;
        }
        HeaderKeyHandler headerKeyHandler = this.getHeaderKeyHandler();
        headerKeyHandler.handleKeyEvent(this, keyEvent);
    }

    protected void processFocusEvent(FocusEvent focusEvent) {
        super.processFocusEvent(focusEvent);
        if (focusEvent.getID() == 1004) {
            if (this.getFocusItem() != -1) {
                this._fireActiveEvent(-1, this.getFocusItem());
            } else {
                int n = this.getNextVisibleItem(-1);
                this.setFocusItem(n);
            }
        }
        if (this.getFocusItem() != -1) {
            this.paintItem(this.getFocusItem());
        }
    }

    protected void processMouseEvent(MouseEvent mouseEvent) {
        super.processMouseEvent(mouseEvent);
        if (mouseEvent.isConsumed()) {
            if (mouseEvent.getID() == 502) {
                AutoScroller.getAutoScroller().cancel();
                SelectionAutoScroller.getSelectionAutoScroller().cancel();
                Mover.getMover().cancel(this);
                this._resetFeedback();
                this._state = '\u0000';
                this.resetCursor();
                this.setArmedItem(-1);
            }
            return;
        }
        if (!this.isEnabled() || this.getItemCount() == 0) {
            return;
        }
        switch (mouseEvent.getID()) {
            case 501: {
                this._handleMousePressed(mouseEvent);
                break;
            }
            case 502: {
                AutoScroller.getAutoScroller().cancel();
                SelectionAutoScroller.getSelectionAutoScroller().cancel();
                this._handleMouseReleased(mouseEvent);
                break;
            }
            case 500: {
                this._handleMouseClicked(mouseEvent);
                break;
            }
            case 504: {
                this._handleMouseEntered(mouseEvent);
                break;
            }
            case 505: {
                this._handleMouseExited(mouseEvent);
            }
        }
    }

    protected void processMouseMotionEvent(MouseEvent mouseEvent) {
        super.processMouseMotionEvent(mouseEvent);
        if (mouseEvent.isConsumed() || !this.isEnabled() || this.getItemCount() == 0) {
            Mover.getMover().cancel(this);
            return;
        }
        switch (mouseEvent.getID()) {
            case 506: {
                this._handleMouseDragged(mouseEvent);
                break;
            }
            case 503: {
                this._handleMouseMoved(mouseEvent);
            }
        }
    }

    public void reshape(int n, int n2, int n3, int n4) {
        int n5 = this.getInnerSize().width;
        if (n3 < 0) {
            n3 = 0;
        }
        if (n4 < 0) {
            n4 = 0;
        }
        boolean bl = n3 != this.getWidth() || n4 != this.getHeight();
        super.reshape(n, n2, n3, n4);
        if (!bl) {
            return;
        }
        Dimension dimension = this.getCanvasSize();
        this.setCanvasSize(dimension.width, dimension.height);
        this._checkForFirstItem(dimension);
        if (this._isHorizontal() && this.getActualReadingDirection() == 2) {
            int n6 = dimension.width;
            int n7 = this.getInnerSize().width;
            Point point = this.getCanvasOrigin();
            int n8 = point.x;
            if (n5 <= 0) {
                n8 = n7 - n6;
            } else if (n5 != n7 && (n8 = point.x + n7 - n5) > 0) {
                if (n6 > n7) {
                    n8 = 0;
                } else if (n8 + n6 > n7) {
                    n8 = n7 - n6;
                }
            }
            this.setCanvasOrigin(n8, point.y);
        }
        GeometryManager geometryManager = this._getGeometryManager();
        if (this._isHorizontal()) {
            geometryManager.setTotalSize(n3);
        } else {
            geometryManager.setTotalSize(n4);
        }
    }

    protected int getHMaximum() {
        if (this._isHorizontal()) {
            if (!this.getScrollByItem()) {
                return super.getHMaximum();
            }
            return this._getGeometryManager().getVisibleItemCount();
        }
        return 0;
    }

    protected int getHValueOfOffset(int n) {
        if (this._isHorizontal()) {
            if (!this.getScrollByItem()) {
                return super.getHValueOfOffset(n);
            }
            GeometryManager geometryManager = this._gm;
            int n2 = geometryManager.getItemAt(-n);
            int n3 = geometryManager.getItemVisibleIndex(n2);
            if (n2 >= 0 && geometryManager.getItemPosition(n2) < -n) {
                ++n3;
            }
            return n3;
        }
        return 0;
    }

    protected int getHOffsetOfValue(int n) {
        if (this._isHorizontal()) {
            if (!this.getScrollByItem()) {
                return super.getHOffsetOfValue(n);
            }
            int n2 = this._convertVisibleIndexToIndex(n);
            GeometryManager geometryManager = this._getGeometryManager();
            n2 = geometryManager.visibleIndexToIndex(n2);
            int n3 = geometryManager.getItemPosition(n2);
            int n4 = this.getCanvasSize().width;
            int n5 = this.getInnerSize().width;
            int n6 = 0;
            if (n4 > n5 && n4 != 0 && n5 != 0) {
                n6 = n5 - n4 + 1;
            }
            if (-n3 < n6) {
                n3 = -n6;
            }
            return -n3;
        }
        return 0;
    }

    protected int getVMaximum() {
        if (!this._isHorizontal()) {
            if (!this.getScrollByItem()) {
                return super.getVMaximum();
            }
            return this._getGeometryManager().getVisibleItemCount();
        }
        return 0;
    }

    protected int getVValueOfOffset(int n) {
        if (!this._isHorizontal()) {
            if (!this.getScrollByItem()) {
                return super.getVValueOfOffset(n);
            }
            GeometryManager geometryManager = this._getGeometryManager();
            int n2 = geometryManager.getItemAt(-n);
            return geometryManager.getItemVisibleIndex(n2);
        }
        return 0;
    }

    protected int getVOffsetOfValue(int n) {
        if (!this._isHorizontal()) {
            if (!this.getScrollByItem()) {
                return super.getVOffsetOfValue(n);
            }
            GeometryManager geometryManager = this._getGeometryManager();
            int n2 = this._convertVisibleIndexToIndex(n);
            n2 = geometryManager.visibleIndexToIndex(n2);
            int n3 = geometryManager.getItemPosition(n2);
            return -n3;
        }
        return 0;
    }

    protected Dimension layoutCanvas() {
        Dimension dimension = this._calculateCanvasSize();
        if (this._state != '\u0001') {
            this._checkForFirstItem(dimension);
        }
        return dimension;
    }

    protected void paintExtraCanvas(Graphics graphics, PaintContext paintContext, int n, int n2, int n3, int n4) {
        graphics.setColor(this.getAppearance().getBackground());
        graphics.fillRect(n, n2, n3, n4);
        graphics.setColor(Color.black);
        EWTHeaderUI eWTHeaderUI = this.getUI();
        Painter painter = eWTHeaderUI.getExtraCanvasPainter(this);
        painter.paint(paintContext, graphics, n, n2, n3, n4);
    }

    protected void firePropertyChange(String string, Object object, Object object2) {
        super.firePropertyChange(string, object, object2);
    }

    protected void fireVetoableChange(String string, Object object, Object object2) throws PropertyVetoException {
        super.fireVetoableChange(string, object, object2);
    }

    protected void paintCanvasInterior(Graphics graphics) {
        this._paintHeader(graphics, this.getPaintContext(), true);
    }

    protected void setMoveCursor() {
        if (!this.getCanMoveItems() || this._state == '\u0001') {
            return;
        }
        Cursor cursor = Cursor.getPredefinedCursor(13);
        Cursor cursor2 = this.getCursor();
        if (cursor2 != cursor) {
            this.setCursor(cursor);
        }
    }

    protected void setResizeCursor() {
        if (this._state == '\u0002') {
            return;
        }
        Cursor cursor = this._isHorizontal() ? Cursor.getPredefinedCursor(10) : Cursor.getPredefinedCursor(9);
        Cursor cursor2 = this.getCursor();
        if (cursor2 != cursor) {
            this.setCursor(cursor);
        }
    }

    protected void resetCursor() {
        if (this._state == '\u0001' || this._state == '\u0002') {
            return;
        }
        Cursor cursor = Cursor.getDefaultCursor();
        Cursor cursor2 = this.getCursor();
        if (cursor2 != cursor) {
            this.setCursor(cursor);
        }
    }

    protected void scrollItemIntoView(int n) {
        if (this._isItemCompletelyOnScreen(n)) {
            return;
        }
        GeometryManager geometryManager = this._getGeometryManager();
        int n2 = -1;
        int n3 = geometryManager.getItemVisibleIndex(n);
        int n4 = this.getFirstItemOnScreen();
        int n5 = (n4 = geometryManager.getItemVisibleIndex(n4)) + this.getOnScreenItemCount() - 1;
        if (n5 >= this.getItemCount()) {
            n5 = this.getItemCount() - 1;
        }
        n5 = geometryManager.getItemVisibleIndex(n5);
        if (n3 < n4) {
            n2 = n;
        } else if (n3 >= n5) {
            Dimension dimension = this.getInnerSize();
            int n6 = this._isHorizontal() ? dimension.width : dimension.height;
            int n7 = n3;
            while (n7 >= 0) {
                int n8 = geometryManager.visibleIndexToIndex(n7);
                if (geometryManager.isItemVisible(n8) && (n6 -= geometryManager.getItemSize(n8)) < 0) {
                    ++n7;
                    break;
                }
                --n7;
            }
            if (n7 < 0) {
                n7 = 0;
            }
            n2 = n7 = geometryManager.visibleIndexToIndex(n7);
        }
        if (n2 == -1) {
            return;
        }
        this.setFirstItemOnScreen(n2);
    }

    /*
     * Unable to fully structure code
     */
    public int getPreviousVisibleItem(int var1_1) {
        var2_2 = this._getGeometryManager();
        var4_3 = var1_1 < this.getItemCount() ? var2_2.getItemVisibleIndex(var1_1) : var1_1;
        var5_4 = var4_3 - 1;
        if (var5_4 >= 0) ** GOTO lbl10
        return -1;
lbl-1000:
        // 1 sources

        {
            var3_5 = var2_2.visibleIndexToIndex(var5_4);
            if (var2_2.isItemVisible(var3_5)) {
                return var3_5;
            }
            --var5_4;
lbl10:
            // 2 sources

            ** while (var5_4 >= 0)
        }
lbl11:
        // 1 sources

        return -1;
    }

    public int getNextVisibleItem(int n) {
        GeometryManager geometryManager = this._getGeometryManager();
        int n2 = n >= 0 ? geometryManager.getItemVisibleIndex(n) : n;
        int n3 = n2 + 1;
        int n4 = this.getItemCount();
        while (n3 < n4) {
            int n5 = geometryManager.visibleIndexToIndex(n3);
            if (geometryManager.isItemVisible(n5)) {
                return n5;
            }
            ++n3;
        }
        return -1;
    }

    public final void fireEvent(int n, int n2) {
        HeaderEvent headerEvent = new HeaderEvent(this, n, n2);
        this.processEvent(headerEvent);
    }

    public final boolean fireCancelableEvent(int n, int n2) {
        HeaderValidateEvent headerValidateEvent = new HeaderValidateEvent(this, n, n2);
        this.processEvent(headerValidateEvent);
        return headerValidateEvent.isCancelled();
    }

    void internalItemsAdded(OneDModelEvent oneDModelEvent) {
        boolean bl;
        Object object;
        int n = oneDModelEvent.getStartIndex();
        int n2 = oneDModelEvent.getItemCount();
        HeaderSelectionManager headerSelectionManager = this.getHeaderSelectionManager();
        if (headerSelectionManager != null && (object = headerSelectionManager.getOneDModelListener()) != null) {
            this._ignoreSelectionRepaints = true;
            object.itemsAdded(oneDModelEvent);
            this._ignoreSelectionRepaints = false;
        }
        if (this._gm != null && (object = this._gm.getOneDModelListener()) != null) {
            object.itemsAdded(new OneDModelEvent(this, 2001, n, n2));
        }
        if (this._itemGraphics != null) {
            this._itemGraphics.addItems(n, n2);
        }
        if (this._painters != null) {
            this._painters.addItems(n, n2);
        }
        if (this._notmovable != null) {
            this._notmovable.addItems(n, n2);
        }
        object = this.layoutCanvas();
        this.setCanvasSize(((Dimension)object).width, ((Dimension)object).height);
        int n3 = n;
        if (n3 == this.getItemCount()) {
            --n3;
        }
        if (bl = this.isItemOnScreen(n3)) {
            this.repaintInterior();
        }
    }

    void internalItemsRemoved(OneDModelEvent oneDModelEvent) {
        Object object;
        int n = oneDModelEvent.getStartIndex();
        int n2 = oneDModelEvent.getItemCount();
        int n3 = this.getFirstItemOnScreen();
        int n4 = n3 + this.getOnScreenItemCount();
        boolean bl = false;
        if (n >= n3 && n <= n4) {
            bl = true;
        } else if (n < n3 && n + n2 > n) {
            bl = true;
        }
        HeaderSelectionManager headerSelectionManager = this.getHeaderSelectionManager();
        if (headerSelectionManager != null && (object = headerSelectionManager.getOneDModelListener()) != null) {
            this._ignoreSelectionRepaints = true;
            object.itemsRemoved(oneDModelEvent);
            this._ignoreSelectionRepaints = false;
        }
        if (this._gm != null && (object = this._gm.getOneDModelListener()) != null) {
            object.itemsRemoved(new OneDModelEvent(this, 2002, n, n2));
        }
        this._anchorItem = -1;
        this._armedItem = -1;
        this._moveItem = -1;
        this._mouseItem = -1;
        if (this._itemGraphics != null) {
            this._itemGraphics.removeItems(n, n2);
        }
        if (this._painters != null) {
            this._painters.removeItems(n, n2);
        }
        if (this._notmovable != null) {
            this._notmovable.removeItems(n, n2);
        }
        object = this.layoutCanvas();
        this.setCanvasSize(((Dimension)object).width, ((Dimension)object).height);
        if (bl) {
            this.repaintInterior();
        }
    }

    void internalInvalidateItems(OneDModelEvent oneDModelEvent) {
        int n;
        int n2;
        int n3;
        int n4;
        int n5 = oneDModelEvent.getStartIndex();
        int n6 = n5 + oneDModelEvent.getItemCount() - 1;
        Dimension dimension = this.getInnerSize();
        GeometryManager geometryManager = this._getGeometryManager();
        if (this._isHorizontal()) {
            n4 = geometryManager.getItemPosition(n5);
            n3 = 0;
            n2 = geometryManager.getItemPosition(n6) + geometryManager.getItemSize(n6);
            n = dimension.height;
        } else {
            n4 = 0;
            n3 = geometryManager.getItemPosition(n5);
            n2 = dimension.width;
            n = geometryManager.getItemPosition(n6) + geometryManager.getItemSize(n6);
        }
        this.repaintCanvas(n4, n3, n2, n);
    }

    int getAnchorItem() {
        return this._anchorItem;
    }

    void setAnchorItem(int n) {
        this._anchorItem = n;
    }

    final void growItemSelection(int n) {
        if (this._mouseItem == -1) {
            return;
        }
        try {
            this.freezeRepaints();
            HeaderSelectionManager headerSelectionManager = this.getHeaderSelectionManager();
            try {
                GeometryManager geometryManager = this.getGeometryManager();
                OneDSelection oneDSelection = this._newModelRangeSelection(this._mouseItem, n);
                headerSelectionManager.setSelection(oneDSelection, n);
            }
            catch (PropertyVetoException propertyVetoException) {
            }
            Object var6_6 = null;
            this.unfreezeRepaints();
        }
        catch (Throwable throwable) {
            Object var6_7 = null;
            this.unfreezeRepaints();
            throw throwable;
        }
    }

    void startMoving(int n, int n2) {
        if (this.isItemMovable(n) && !this.fireCancelableEvent(2007, n)) {
            this._state = (char)2;
            this._outlineOffset = n2 - this._getGeometryManager().getItemPosition(n);
            this._outlinePosition = n2;
            this.setMoveCursor();
            this.paintImmediateInterior();
        }
    }

    boolean _isHorizontal() {
        return this.getOrientation() == 0;
    }

    private void _paintHeader(Graphics graphics, PaintContext paintContext, boolean bl) {
        if (this.getItemCount() == 0) {
            Dimension dimension = this.getInnerSize();
            this.paintExtraCanvas(graphics, paintContext, 0, 0, dimension.width, dimension.height);
            return;
        }
        if (this._isHorizontal()) {
            this._paintHorizontalHeader(graphics, paintContext);
        } else {
            this._paintVerticalHeader(graphics, paintContext);
        }
        if (bl) {
            this.paintFocusItem(paintContext, graphics);
        }
        this._drawFeedback(graphics);
        this._drawOutline(graphics);
    }

    private Dimension _calculateCanvasSize() {
        GeometryManager geometryManager = this._getGeometryManager();
        Dimension dimension = new Dimension();
        if (this._isHorizontal()) {
            dimension.width = geometryManager.getTotalSize();
            dimension.height = this.getPreferredHeaderSize();
        } else {
            dimension.width = this.getPreferredHeaderSize();
            dimension.height = geometryManager.getTotalSize();
        }
        return dimension;
    }

    private void _handleMousePressed(MouseEvent mouseEvent) {
        int n;
        this.requestFocus();
        Point point = this.convertOuterToCanvas(mouseEvent.getX(), mouseEvent.getY());
        int n2 = this._isHorizontal() ? point.x : point.y;
        GeometryManager geometryManager = this._getGeometryManager();
        this._mouseItem = geometryManager.getItemAt(n2);
        if (this._mouseItem == -1) {
            return;
        }
        boolean bl = SwingUtilities.isLeftMouseButton(mouseEvent);
        int n3 = this.isResizing(this._mouseItem, n2);
        if (bl && n3 != -1) {
            this._mouseItem = n3;
            if (!this.fireCancelableEvent(2005, this._mouseItem)) {
                this._state = '\u0001';
                geometryManager.setResizing(true);
                this.setResizeCursor();
            } else {
                this._state = (char)3;
                this.resetCursor();
            }
            return;
        }
        if (this._isHorizontal()) {
            n = -geometryManager.getItemPosition(this._mouseItem);
            mouseEvent.translatePoint(n, 0);
        } else {
            n = -geometryManager.getItemPosition(this._mouseItem);
            mouseEvent.translatePoint(0, n);
        }
        this.setFocusItem(this._mouseItem);
        this.getItemInputHandler().mousePressed(mouseEvent, this, this._mouseItem);
        if (this._isHorizontal()) {
            mouseEvent.translatePoint(-n, 0);
        } else {
            mouseEvent.translatePoint(0, -n);
        }
        if (mouseEvent.isConsumed() || !bl) {
            this.resetCursor();
            return;
        }
        this.setArmedItem(this._mouseItem);
        Mover.getMover().schedule(this, this._mouseItem, n2);
        try {
            block21: {
                try {
                    this.freezeRepaints();
                    HeaderSelectionManager headerSelectionManager = this.getHeaderSelectionManager();
                    if (mouseEvent.isShiftDown()) {
                        if (this.getAnchorItem() == -1) {
                            this.setAnchorItem(this._mouseItem);
                        }
                        OneDSelection oneDSelection = this._newModelRangeSelection(this._mouseItem, this.getAnchorItem());
                        if (mouseEvent.isControlDown()) {
                            headerSelectionManager.addSelection(oneDSelection);
                        } else {
                            headerSelectionManager.setSelection(oneDSelection, -1);
                        }
                        break block21;
                    }
                    OneDSelection oneDSelection = new OneDSelection(this._mouseItem);
                    boolean bl2 = true;
                    if (mouseEvent.isControlDown()) {
                        if (headerSelectionManager.getSelection().contains(this._mouseItem)) {
                            headerSelectionManager.removeSelection(oneDSelection);
                        } else {
                            headerSelectionManager.addSelection(oneDSelection);
                        }
                    } else {
                        headerSelectionManager.setSelection(oneDSelection, -1);
                    }
                    this.setAnchorItem(this._mouseItem);
                }
                catch (PropertyVetoException propertyVetoException) {
                    Object var13_14 = null;
                    this.unfreezeRepaints();
                }
            }
            Object var13_13 = null;
            this.unfreezeRepaints();
        }
        catch (Throwable throwable) {
            Object var13_15 = null;
            this.unfreezeRepaints();
            throw throwable;
        }
    }

    private void _handleMouseReleased(MouseEvent mouseEvent) {
        int n;
        int n2;
        GeometryManager geometryManager = this._getGeometryManager();
        Mover.getMover().cancel(this);
        this._resetFeedback();
        Point point = this.convertOuterToCanvas(mouseEvent.getX(), mouseEvent.getY());
        int n3 = n2 = this._isHorizontal() ? point.x : point.y;
        if (this._state == '\u0001') {
            geometryManager.setResizing(false);
            this._resizeItemByMouse(mouseEvent);
            this.fireEvent(2006, this._mouseItem);
        } else if (this._state == '\u0002') {
            n = geometryManager.getItemAt(n2);
            n = n == -1 ? (n2 < 0 ? 0 : this.getItemCount() - 1) : geometryManager.getItemVisibleIndex(n);
            geometryManager.setItemVisibleIndex(this._mouseItem, n);
            this.fireEvent(2008, this._mouseItem);
        }
        if (this._mouseItem != -1) {
            if (this._isHorizontal()) {
                n = -geometryManager.getItemPosition(this._mouseItem);
                mouseEvent.translatePoint(n, 0);
            } else {
                n = -geometryManager.getItemPosition(this._mouseItem);
                mouseEvent.translatePoint(0, n);
            }
            this.getItemInputHandler().mouseReleased(mouseEvent, this, this._mouseItem);
            if (this._isHorizontal()) {
                mouseEvent.translatePoint(-n, 0);
            } else {
                mouseEvent.translatePoint(0, -n);
            }
            this.setArmedItem(-1);
            this._mouseItem = -1;
        }
        this._state = '\u0000';
        this.resetCursor();
    }

    private void _handleMouseClicked(MouseEvent mouseEvent) {
        int n;
        Point point = this.convertOuterToCanvas(mouseEvent.getX(), mouseEvent.getY());
        GeometryManager geometryManager = this._getGeometryManager();
        int n2 = geometryManager.getItemAt(n = this._isHorizontal() ? point.x : point.y);
        if (n2 != -1) {
            int n3;
            if (this._isHorizontal()) {
                n3 = -geometryManager.getItemPosition(n2);
                mouseEvent.translatePoint(n3, 0);
            } else {
                n3 = -geometryManager.getItemPosition(n2);
                mouseEvent.translatePoint(0, n3);
            }
            this.getItemInputHandler().mouseClicked(mouseEvent, this, n2);
            if (this._isHorizontal()) {
                mouseEvent.translatePoint(-n3, 0);
            } else {
                mouseEvent.translatePoint(0, -n3);
            }
        }
    }

    private void _handleMouseMoved(MouseEvent mouseEvent) {
        Point point = this.convertOuterToCanvas(mouseEvent.getX(), mouseEvent.getY());
        GeometryManager geometryManager = this._getGeometryManager();
        int n = this._isHorizontal() ? point.x : point.y;
        int n2 = geometryManager.getItemAt(n);
        HeaderItemInputHandler headerItemInputHandler = this.getItemInputHandler();
        if (n2 != this._moveItem) {
            MouseEvent mouseEvent2;
            Point point2;
            if (this._moveItem != -1) {
                point2 = this._isHorizontal() ? new Point(point.x - geometryManager.getItemPosition(this._moveItem), point.y) : new Point(point.x, point.y - geometryManager.getItemPosition(this._moveItem));
                mouseEvent2 = new MouseEvent(this, 505, mouseEvent.getWhen(), mouseEvent.getModifiers(), point2.x, point2.y, mouseEvent.getClickCount(), mouseEvent.isPopupTrigger());
                headerItemInputHandler.mouseExited(mouseEvent2, this, this._moveItem);
            }
            if (n2 != -1) {
                point2 = this._isHorizontal() ? new Point(point.x - geometryManager.getItemPosition(n2), point.y) : new Point(point.x, point.y - geometryManager.getItemPosition(n2));
                mouseEvent2 = new MouseEvent(this, 504, mouseEvent.getWhen(), mouseEvent.getModifiers(), point2.x, point2.y, mouseEvent.getClickCount(), mouseEvent.isPopupTrigger());
                headerItemInputHandler.mouseEntered(mouseEvent2, this, n2);
            }
            this._moveItem = n2;
        }
        if (this._moveItem != -1) {
            int n3;
            if (this._isHorizontal()) {
                n3 = -geometryManager.getItemPosition(this._moveItem);
                mouseEvent.translatePoint(n3, 0);
            } else {
                n3 = -geometryManager.getItemPosition(this._moveItem);
                mouseEvent.translatePoint(0, n3);
            }
            headerItemInputHandler.mouseMoved(mouseEvent, this, this._moveItem);
            if (this._isHorizontal()) {
                mouseEvent.translatePoint(-n3, 0);
            } else {
                mouseEvent.translatePoint(0, -n3);
            }
        }
        if (this.isResizing(this._moveItem, n) != -1) {
            this.setResizeCursor();
        } else {
            this.resetCursor();
        }
    }

    private void _handleMouseDragged(MouseEvent mouseEvent) {
        AutoScroller autoScroller;
        int n;
        int n2;
        if (this._mouseItem == -1) {
            return;
        }
        GeometryManager geometryManager = this._getGeometryManager();
        Point point = this.convertOuterToCanvas(mouseEvent.getX(), mouseEvent.getY());
        int n3 = this._isHorizontal() ? point.x : point.y;
        if (n3 < (n2 = Mover.getMover().getPoint()) - 3 || n3 > n2 + 3) {
            Mover.getMover().cancel(this);
        }
        int n4 = this.getItemAt(mouseEvent.getX(), mouseEvent.getY());
        boolean bl = SwingUtilities.isLeftMouseButton(mouseEvent);
        if (this._state == '\u0001') {
            this._resizeItemByMouse(mouseEvent);
        } else if (this._state == '\u0002') {
            if (n4 != -1) {
                n = geometryManager.getItemPosition(n4);
                if (geometryManager.getItemVisibleIndex(n4) > geometryManager.getItemVisibleIndex(this._mouseItem)) {
                    n += geometryManager.getItemSize(n4);
                }
            } else {
                int n5 = this.getPreviousVisibleItem(this.getItemCount());
                n = geometryManager.getItemPosition(n5) + geometryManager.getItemSize(n5) + 1;
            }
            if (this._redrawInfo != n) {
                this._redrawInfo = n;
            }
            this._outlinePosition = n3;
            this.paintImmediateInterior();
            autoScroller = AutoScroller.getAutoScroller();
            this._checkScroller(autoScroller, mouseEvent);
        } else if (bl) {
            n = (n4 == this._mouseItem ? 1 : 0) & this.contains(mouseEvent.getX(), mouseEvent.getY());
            this.setArmedItem(n != 0 ? this._mouseItem : -1);
        }
        if (this._isHorizontal()) {
            n = -geometryManager.getItemPosition(this._mouseItem);
            mouseEvent.translatePoint(n, 0);
        } else {
            n = -geometryManager.getItemPosition(this._mouseItem);
            mouseEvent.translatePoint(0, n);
        }
        this.getItemInputHandler().mouseDragged(mouseEvent, this, this._mouseItem);
        if (this._isHorizontal()) {
            mouseEvent.translatePoint(-n, 0);
        } else {
            mouseEvent.translatePoint(0, -n);
        }
        if (this._state != '\u0000' || n4 == -1 || mouseEvent.isConsumed() || mouseEvent.isControlDown() || mouseEvent.isShiftDown() || mouseEvent.isMetaDown()) {
            return;
        }
        HeaderSelectionManager headerSelectionManager = this.getHeaderSelectionManager();
        try {
            headerSelectionManager.setSelection(this._newModelRangeSelection(this._mouseItem, n4), n4);
        }
        catch (PropertyVetoException propertyVetoException) {
            // empty catch block
        }
        if (!headerSelectionManager.getSelection().isEmpty()) {
            autoScroller = SelectionAutoScroller.getSelectionAutoScroller();
            this._checkScroller(autoScroller, mouseEvent);
        }
    }

    private OneDSelection _newModelRangeSelection(int n, int n2) {
        GeometryManager geometryManager = this.getGeometryManager();
        int n3 = geometryManager.getItemVisibleIndex(n);
        int n4 = geometryManager.getItemVisibleIndex(n2);
        if (n4 < n3) {
            int n5 = n4;
            n4 = n3;
            n3 = n5;
        }
        Range[] rangeArray = new Range[]{new Range(n3, n4)};
        return new OneDSelection(geometryManager.visibleRangesToRanges(rangeArray));
    }

    private void _repaintIfNeeded(int n) {
        ItemPaintContext itemPaintContext;
        BorderPainter borderPainter = this.getHeaderItemBorderPainter();
        if ((borderPainter.getRepaintFlags(itemPaintContext = new ItemPaintContext(this.getPaintContext(), n)) & 2) != 0) {
            this.paintItem(n);
        }
    }

    private void _checkScroller(AutoScroller autoScroller, MouseEvent mouseEvent) {
        int n;
        int n2;
        if (this._isHorizontal()) {
            n2 = mouseEvent.getX() + this.getCanvasOriginX();
            n = this.getInnerSize().width;
        } else {
            n2 = mouseEvent.getY() + this.getCanvasOriginY();
            n = this.getInnerSize().height;
        }
        int n3 = this._getGeometryManager().getTotalSize() / this.getItemCount();
        if (n2 < (n3 /= 2)) {
            autoScroller.schedule(this, true);
        } else if (n2 > n - n3) {
            autoScroller.schedule(this, false);
        } else {
            autoScroller.cancel();
        }
    }

    private void _resizeItemByMouse(MouseEvent mouseEvent) {
        int n = this._mouseItem;
        GeometryManager geometryManager = this._getGeometryManager();
        Point point = this.convertOuterToCanvas(mouseEvent.getX(), mouseEvent.getY());
        int n2 = this._isHorizontal() ? point.x : point.y;
        Dimension dimension = this.getInnerSize();
        int n3 = this._isHorizontal() ? dimension.width : dimension.height;
        int n4 = geometryManager.getItemPosition(n);
        int n5 = geometryManager.getItemSize(n);
        int n6 = this._isHorizontal() && this.getActualReadingDirection() == 2 ? (n2 > n4 + n5 ? 2 : n5 + n4 - n2) : (n2 < n4 ? 2 : n2 - n4);
        if (this.getScrollByItem() && n6 > n3 && n5 <= n3 && geometryManager.getVisibleItemCount() > 1) {
            n6 = n3;
        }
        geometryManager.setItemSize(n, n6);
    }

    private void _handleMouseEntered(MouseEvent mouseEvent) {
        GeometryManager geometryManager = this._getGeometryManager();
        this._moveItem = this.getItemAt(mouseEvent.getX(), mouseEvent.getY());
        if (this._moveItem != -1) {
            int n;
            if (this._isHorizontal()) {
                n = -geometryManager.getItemPosition(this._moveItem);
                mouseEvent.translatePoint(n, 0);
            } else {
                n = -geometryManager.getItemPosition(this._moveItem);
                mouseEvent.translatePoint(0, n);
            }
            this.getItemInputHandler().mouseEntered(mouseEvent, this, this._moveItem);
            if (this._isHorizontal()) {
                mouseEvent.translatePoint(-n, 0);
            } else {
                mouseEvent.translatePoint(0, -n);
            }
        }
    }

    private void _handleMouseExited(MouseEvent mouseEvent) {
        GeometryManager geometryManager = this._getGeometryManager();
        this.resetCursor();
        if (this._moveItem != -1) {
            int n;
            if (this._isHorizontal()) {
                n = -geometryManager.getItemPosition(this._moveItem);
                mouseEvent.translatePoint(n, 0);
            } else {
                n = -geometryManager.getItemPosition(this._moveItem);
                mouseEvent.translatePoint(0, n);
            }
            this.getItemInputHandler().mouseExited(mouseEvent, this, this._moveItem);
            if (this._isHorizontal()) {
                mouseEvent.translatePoint(n, 0);
            } else {
                mouseEvent.translatePoint(0, n);
            }
        }
    }

    private int _convertVisibleIndexToIndex(int n) {
        GeometryManager geometryManager = this._getGeometryManager();
        if (geometryManager.getVisibleItemCount() == this.getItemCount()) {
            return n;
        }
        int n2 = 0;
        int n3 = -1;
        while (n3 < n) {
            int n4 = geometryManager.visibleIndexToIndex(n2);
            if (geometryManager.isItemVisible(n4)) {
                ++n3;
            }
            ++n2;
        }
        return n2 - 1;
    }

    private void _drawOutline(Graphics graphics) {
        if (this._outlinePosition == -1) {
            return;
        }
        int n = this._mouseItem;
        if (n == -1) {
            return;
        }
        Dimension dimension = this.getInnerSize();
        int n2 = this._getGeometryManager().getItemSize(n);
        graphics.setColor(Color.black);
        if (this._isHorizontal()) {
            graphics.drawRect(this._outlinePosition - this._outlineOffset + 2, 2, n2 - 5, dimension.height - 5);
        } else {
            graphics.drawRect(2, this._outlinePosition - this._outlineOffset + 2, dimension.width - 5, n2 - 5);
        }
    }

    private void _resetFeedback() {
        if (this._redrawInfo != -1) {
            this.repaint();
        }
        this._redrawInfo = -1;
        this._outlineOffset = -1;
        this._outlinePosition = -1;
    }

    private void _drawFeedback(Graphics graphics) {
        if (this._redrawInfo == -1) {
            return;
        }
        Dimension dimension = this.getInnerSize();
        graphics.setColor(Color.black);
        if (this._isHorizontal()) {
            graphics.fillRect(this._redrawInfo, 0, 4, dimension.height);
        } else {
            graphics.fillRect(0, this._redrawInfo, dimension.width, 4);
        }
    }

    private void _paintVerticalHeader(Graphics graphics, PaintContext paintContext) {
        int n;
        GeometryManager geometryManager = this._getGeometryManager();
        Rectangle rectangle = graphics.getClipBounds();
        if (rectangle.y < 0) {
            rectangle.height += rectangle.y;
            rectangle.y = 0;
        }
        if ((n = geometryManager.getItemAt(rectangle.y)) == -1) {
            this._finishVerticalHeader(graphics, paintContext, this.getInnerSize());
            return;
        }
        n = geometryManager.getItemVisibleIndex(n);
        int n2 = geometryManager.getItemAt(rectangle.y + rectangle.height);
        if (n2 == -1) {
            n2 = this.getPreviousVisibleItem(this.getItemCount());
        }
        n2 = geometryManager.getItemVisibleIndex(n2);
        Dimension dimension = this.getInnerSize();
        boolean bl = graphics instanceof PrintGraphics || graphics instanceof PrinterGraphics;
        int n3 = bl ? 0 : -this.getCanvasOrigin().y;
        Shape shape = graphics.getClip();
        int n4 = rectangle.y + rectangle.height;
        ItemPaintContext itemPaintContext = new ItemPaintContext(paintContext, 0);
        BorderPainter borderPainter = this.getHeaderItemBorderPainter();
        BorderPainter borderPainter2 = this.getFirstItemBorderPainter();
        BorderPainter borderPainter3 = this.getLastItemBorderPainter();
        ImmInsets immInsets = borderPainter.getInsets(paintContext);
        int n5 = this.getFirstItemOnScreen();
        int n6 = this._getLastItemOnScreen();
        int n7 = this.getItemCount();
        int n8 = n;
        while (n8 <= n2) {
            int n9 = geometryManager.visibleIndexToIndex(n8);
            if (n9 >= 0 && n9 < n7 && geometryManager.isItemVisible(n9)) {
                BorderPainter borderPainter4 = n9 == n5 ? borderPainter2 : (n9 == n6 ? borderPainter3 : borderPainter);
                int n10 = geometryManager.getItemPosition(n9);
                int n11 = geometryManager.getItemSize(n9);
                Object object = this._ds.getData(n9);
                graphics.setClip(shape);
                graphics.clipRect(0, n10, dimension.width, n11);
                itemPaintContext.setItem(n9);
                Painter painter = this.getPainter(n9);
                graphics.setColor(itemPaintContext.getPaintBackground());
                graphics.fillRect(0, n10, dimension.width, n11);
                borderPainter4.paint(itemPaintContext, graphics, 0, n10, dimension.width, n11);
                graphics.setColor(itemPaintContext.getPaintForeground());
                graphics.setFont(itemPaintContext.getPaintFont());
                ImmInsets immInsets2 = itemPaintContext.getAppearance().getInsets();
                painter.paint(itemPaintContext, graphics, immInsets.left + immInsets2.left, n10 + immInsets.top + immInsets2.top, dimension.width - immInsets.left - immInsets.right - (immInsets2.left + immInsets2.right), n11 - immInsets.top - immInsets.bottom - (immInsets2.top + immInsets2.bottom));
            }
            ++n8;
        }
        graphics.setClip(shape);
        this._finishVerticalHeader(graphics, paintContext, dimension);
    }

    private void _finishVerticalHeader(Graphics graphics, PaintContext paintContext, Dimension dimension) {
        Shape shape = graphics.getClip();
        Dimension dimension2 = this.getCanvasSize();
        int n = dimension2.height;
        if (n < dimension.height) {
            graphics.setClip(shape);
            graphics.clipRect(0, n, dimension.width, dimension.height - n);
            this.paintExtraCanvas(graphics, paintContext, 0, n, dimension.width, dimension.height - n);
        } else {
            Point point = this.getCanvasOrigin();
            int n2 = dimension2.height + point.y;
            int n3 = dimension.height - n2;
            if (n3 > 0) {
                graphics.setClip(shape);
                graphics.clipRect(0, n, dimension2.width, n3);
                this.paintExtraCanvas(graphics, paintContext, 0, n, dimension2.width, n3);
            }
        }
        graphics.setClip(shape);
    }

    private void _paintHorizontalHeader(Graphics graphics, PaintContext paintContext) {
        int n;
        GeometryManager geometryManager = this._getGeometryManager();
        Rectangle rectangle = graphics.getClipBounds();
        if (rectangle.x < 0) {
            rectangle.width += rectangle.x;
            rectangle.x = 0;
        }
        if ((n = geometryManager.getItemAt(rectangle.x)) == -1) {
            this._finishHorizontalHeader(graphics, paintContext, this.getInnerSize());
            return;
        }
        n = geometryManager.getItemVisibleIndex(n);
        int n2 = geometryManager.getItemAt(rectangle.x + rectangle.width);
        if (n2 == -1) {
            n2 = this.getPreviousVisibleItem(this.getItemCount());
        }
        n2 = geometryManager.getItemVisibleIndex(n2);
        boolean bl = graphics instanceof PrintGraphics || graphics instanceof PrinterGraphics;
        int n3 = bl ? 0 : -this.getCanvasOrigin().x;
        Dimension dimension = this.getInnerSize();
        Shape shape = graphics.getClip();
        int n4 = rectangle.x + rectangle.width;
        ItemPaintContext itemPaintContext = new ItemPaintContext(paintContext, 0);
        BorderPainter borderPainter = this.getHeaderItemBorderPainter();
        BorderPainter borderPainter2 = this.getFirstItemBorderPainter();
        BorderPainter borderPainter3 = this.getLastItemBorderPainter();
        ImmInsets immInsets = borderPainter.getInsets(paintContext);
        int n5 = this.getFirstItemOnScreen();
        int n6 = this._getLastItemOnScreen();
        int n7 = this.getItemCount();
        int n8 = n;
        while (n8 <= n2) {
            int n9 = geometryManager.visibleIndexToIndex(n8);
            if (n9 >= 0 && n9 < n7 && geometryManager.isItemVisible(n9)) {
                BorderPainter borderPainter4 = n9 == n5 ? borderPainter2 : (n9 == n6 ? borderPainter3 : borderPainter);
                int n10 = geometryManager.getItemPosition(n9);
                int n11 = geometryManager.getItemSize(n9);
                graphics.setClip(shape);
                graphics.clipRect(n10, 0, n11, dimension.height);
                itemPaintContext.setItem(n9);
                Painter painter = this.getPainter(n9);
                graphics.setColor(itemPaintContext.getPaintBackground());
                graphics.fillRect(n10, 0, n11, dimension.height);
                borderPainter4.paint(itemPaintContext, graphics, n10, 0, n11, dimension.height);
                graphics.setColor(itemPaintContext.getPaintForeground());
                graphics.setFont(itemPaintContext.getPaintFont());
                ImmInsets immInsets2 = itemPaintContext.getAppearance().getInsets();
                painter.paint(itemPaintContext, graphics, n10 + immInsets.left + immInsets2.left, immInsets.top + immInsets2.top, n11 - (immInsets.left + immInsets.right) - (immInsets2.left + immInsets2.right), dimension.height - (immInsets.top + immInsets.bottom) - (immInsets2.top + immInsets2.bottom));
            }
            ++n8;
        }
        graphics.setClip(shape);
        this._finishHorizontalHeader(graphics, paintContext, dimension);
    }

    private void _finishHorizontalHeader(Graphics graphics, PaintContext paintContext, Dimension dimension) {
        boolean bl;
        Shape shape = graphics.getClip();
        Dimension dimension2 = this.getCanvasSize();
        int n = dimension2.width;
        int n2 = dimension.height;
        boolean bl2 = bl = this.getActualReadingDirection() == 1;
        if (n < dimension.width) {
            graphics.setClip(shape);
            int n3 = bl ? n : n - dimension.width;
            graphics.clipRect(n3, 0, dimension.width - n, n2);
            this.paintExtraCanvas(graphics, paintContext, n3, 0, dimension.width - n, n2);
        } else {
            Point point = this.getCanvasOrigin();
            int n4 = dimension2.width + point.x;
            int n5 = dimension.width - n4;
            if (n5 > 0) {
                int n6 = bl ? n : 0;
                graphics.setClip(shape);
                graphics.clipRect(n6, 0, n5, n2);
                this.paintExtraCanvas(graphics, paintContext, n6, 0, n5, n2);
            }
        }
        graphics.setClip(shape);
    }

    private Appearance _createAppearance() {
        return (Appearance)UIManager.get("Header.DefaultAppearance");
    }

    private Appearance _getAppearance() {
        if (this._appearanceObject == null) {
            this._appearanceObject = this._createAppearance();
        }
        return this._appearanceObject;
    }

    Appearance _getItemAppearance(int n) {
        Object object;
        if (this._itemGraphics != null && (object = this._itemGraphics.getData(n)) != null) {
            return (Appearance)object;
        }
        return this._getAppearance();
    }

    private int isResizing(int n, int n2) {
        int n3 = this.pointInResize(n, n2);
        if (n3 == -1) {
            return -1;
        }
        return this.getCanResizeItems() && this._getGeometryManager().isItemResizable(n3) ? n3 : -1;
    }

    private int pointInResize(int n, int n2) {
        boolean bl;
        boolean bl2;
        int n3;
        if (n == -1) {
            return -1;
        }
        GeometryManager geometryManager = this._getGeometryManager();
        int n4 = geometryManager.getItemPosition(n);
        boolean bl3 = n2 >= n4 + (n3 = geometryManager.getItemSize(n)) - 5;
        boolean bl4 = bl2 = n2 >= n4 && n2 <= n4 + 5;
        if (!bl3 && !bl2) {
            return -1;
        }
        boolean bl5 = bl = !this._isHorizontal() || this.getActualReadingDirection() == 1;
        if (bl3) {
            if (bl) {
                return n;
            }
            return this.getNextVisibleItem(n);
        }
        if (bl2) {
            if (bl) {
                return this.getPreviousVisibleItem(n);
            }
            return n;
        }
        return -1;
    }

    private boolean _isItemCompletelyOnScreen(int n) {
        Point point = this.getCanvasOrigin();
        Dimension dimension = this.getInnerSize();
        GeometryManager geometryManager = this._getGeometryManager();
        int n2 = geometryManager.getItemPosition(n);
        int n3 = geometryManager.getItemSize(n);
        point.x = -point.x;
        point.y = -point.y;
        if (this._isHorizontal()) {
            return n2 >= point.x && (n2 + n3 < point.x + dimension.width || n3 > dimension.width);
        }
        return n2 >= point.y && (n2 + n3 < point.y + dimension.height || n3 > dimension.height);
    }

    private void _checkForFirstItem(Dimension dimension) {
        int n;
        Dimension dimension2 = this.getInnerSize();
        GeometryManager geometryManager = this._getGeometryManager();
        if (this._firstItem != -1) {
            if (this._isHorizontal() && dimension.width != 0 || !this._isHorizontal() && dimension.height != 0) {
                int n2 = -geometryManager.getItemPosition(this._firstItem);
                if (this._isHorizontal()) {
                    this.setCanvasOrigin(n2, this.getCanvasOriginY());
                } else {
                    this.setCanvasOrigin(this.getCanvasOriginX(), n2);
                }
                this._firstItem = -1;
            }
        } else if ((this._isHorizontal() && dimension2.width >= dimension.width && dimension.width != 0 || !this._isHorizontal() && dimension2.height >= dimension.height && dimension.height != 0) && (n = this.getNextVisibleItem(-1)) != -1) {
            int n3 = -geometryManager.getItemPosition(n);
            if (this._isHorizontal()) {
                this.setCanvasOrigin(n3, this.getCanvasOriginY());
            } else {
                this.setCanvasOrigin(this.getCanvasOriginX(), n3);
            }
        }
    }

    protected Rectangle getCellBoundsForItem(int n) {
        Rectangle rectangle = new Rectangle();
        Dimension dimension = this.getInnerSize();
        if (this._isHorizontal()) {
            rectangle.x = this.getItemPosition(n);
            rectangle.y = 0;
            rectangle.width = this.getItemSize(n);
            rectangle.height = dimension.height;
        } else {
            rectangle.x = 0;
            rectangle.y = this.getItemPosition(n);
            rectangle.width = dimension.width;
            rectangle.height = this.getItemSize(n);
        }
        return rectangle;
    }

    private SelectionListener _getSelectionListener() {
        if (this._selectionListener == null) {
            this._selectionListener = new SelectionListener();
        }
        return this._selectionListener;
    }

    private GeometryListener _getGeometryChangeListener() {
        if (this._geometryChangeListener == null) {
            this._geometryChangeListener = new GeometryChangeListener();
        }
        return this._geometryChangeListener;
    }

    private void _paintSelections(OneDSelection oneDSelection, OneDSelection oneDSelection2) {
        OneDSelection oneDSelection3 = oneDSelection.add(oneDSelection2);
        Range[] rangeArray = oneDSelection3.getRanges();
        this._paintRanges(rangeArray);
    }

    private void _paintRanges(Range[] rangeArray) {
        if (rangeArray == null) {
            return;
        }
        GeometryManager geometryManager = this.getGeometryManager();
        rangeArray = geometryManager.rangesToVisibleRanges(rangeArray);
        int n = rangeArray.length;
        int n2 = 0;
        while (n2 < n) {
            int n3 = rangeArray[n2].getLowerLimit();
            while (n3 <= rangeArray[n2].getUpperLimit()) {
                this.paintItem(geometryManager.visibleIndexToIndex(n3));
                ++n3;
            }
            ++n2;
        }
    }

    private void _registerKeyboardActions() {
        this._keyboardListener = new KeyboardActionListener();
        if (this._isHorizontal()) {
            KeyStroke keyStroke = KeyStroke.getKeyStroke(37, 10);
            this.registerKeyboardAction(this._keyboardListener, _MOVE_LEFT, keyStroke, 0);
            keyStroke = KeyStroke.getKeyStroke(39, 10);
            this.registerKeyboardAction(this._keyboardListener, _MOVE_RIGHT, keyStroke, 0);
            keyStroke = KeyStroke.getKeyStroke(37, 8);
            this.registerKeyboardAction(this._keyboardListener, _RESIZE_LEFT, keyStroke, 0);
            keyStroke = KeyStroke.getKeyStroke(39, 8);
            this.registerKeyboardAction(this._keyboardListener, _RESIZE_RIGHT, keyStroke, 0);
        } else {
            KeyStroke keyStroke = KeyStroke.getKeyStroke(38, 10);
            this.registerKeyboardAction(this._keyboardListener, _MOVE_UP, keyStroke, 0);
            keyStroke = KeyStroke.getKeyStroke(40, 10);
            this.registerKeyboardAction(this._keyboardListener, _MOVE_DOWN, keyStroke, 0);
            keyStroke = KeyStroke.getKeyStroke(38, 8);
            this.registerKeyboardAction(this._keyboardListener, _RESIZE_UP, keyStroke, 0);
            keyStroke = KeyStroke.getKeyStroke(40, 8);
            this.registerKeyboardAction(this._keyboardListener, _RESIZE_DOWN, keyStroke, 0);
        }
    }

    private void _unregisterKeyboardActions() {
        if (this._isHorizontal()) {
            KeyStroke keyStroke = KeyStroke.getKeyStroke(37, 2);
            this.unregisterKeyboardAction(keyStroke);
            keyStroke = KeyStroke.getKeyStroke(39, 2);
            this.unregisterKeyboardAction(keyStroke);
            keyStroke = KeyStroke.getKeyStroke(37, 10);
            this.unregisterKeyboardAction(keyStroke);
            keyStroke = KeyStroke.getKeyStroke(39, 10);
            this.unregisterKeyboardAction(keyStroke);
        } else {
            KeyStroke keyStroke = KeyStroke.getKeyStroke(38, 2);
            this.unregisterKeyboardAction(keyStroke);
            keyStroke = KeyStroke.getKeyStroke(40, 2);
            this.unregisterKeyboardAction(keyStroke);
            keyStroke = KeyStroke.getKeyStroke(38, 10);
            this.unregisterKeyboardAction(keyStroke);
            keyStroke = KeyStroke.getKeyStroke(40, 10);
            this.unregisterKeyboardAction(keyStroke);
        }
    }

    public final AccessibleContext getAccessibleContext() {
        if (this.accessibleContext == null) {
            this.accessibleContext = this.createAccessibleHeader();
        }
        return this.accessibleContext;
    }

    protected AccessibleHeader createAccessibleHeader() {
        return new AccessibleHeader();
    }

    protected void paintFocusItem(PaintContext paintContext, Graphics graphics) {
        if (this.getFocusItem() != -1 && this.hasFocus()) {
            Rectangle rectangle = this.__getItemRect(paintContext, this.getFocusItem());
            if (rectangle == null) {
                return;
            }
            EWTHeaderUI eWTHeaderUI = this.getUI();
            BorderPainter borderPainter = eWTHeaderUI.getFocusItemPainter(this);
            if (borderPainter != null) {
                borderPainter.paint(paintContext, graphics, rectangle.x, rectangle.y, rectangle.width, rectangle.height);
            }
        }
    }

    Rectangle __getItemRect(PaintContext paintContext, int n) {
        if (!this.isItemOnScreen(n)) {
            return null;
        }
        Rectangle rectangle = new Rectangle();
        if (this._isHorizontal()) {
            rectangle.x = this.getItemPosition(n);
            rectangle.y = 0;
            rectangle.width = this.getItemSize(n);
            rectangle.height = this.getInnerHeight();
        } else {
            rectangle.x = 0;
            rectangle.y = this.getItemPosition(n);
            rectangle.width = this.getInnerWidth();
            rectangle.height = this.getItemSize(n);
        }
        ++rectangle.x;
        ++rectangle.y;
        rectangle.width -= 2;
        rectangle.height -= 2;
        return rectangle;
    }

    void _fireActiveEvent(int n, int n2) {
        AccessibleContext accessibleContext = this.accessibleContext;
        if (accessibleContext != null) {
            accessibleContext.firePropertyChange("AccessibleActiveDescendant", accessibleContext.getAccessibleChild(n), accessibleContext.getAccessibleChild(n2));
        }
    }

    public class AccessibleHeader
    extends JComponent.AccessibleJComponent
    implements AccessibleSelection,
    PropertyChangeListener,
    GeometryListener,
    OneDModelListener {
        public AccessibleHeader() {
            super(Header.this);
            Header.this.addPropertyChangeListener(this);
            Header.this.getModel().addModelListener(this);
            Header.this.getGeometryManager().addGeometryListener(this);
        }

        public String getAccessibleName() {
            String string;
            AccessibleContext accessibleContext;
            Accessible accessible;
            String string2 = super.getAccessibleName();
            if (string2 == null && (accessible = ((Component.AccessibleAWTComponent)this).getAccessibleParent()) != null && (accessibleContext = accessible.getAccessibleContext()) != null && accessibleContext.getAccessibleRole() == AccessibleRole.TABLE && (string = accessibleContext.getAccessibleName()) != null) {
                ResourceBundle resourceBundle = ResourceBundle.getBundle(Header._RESOURCE, ((Component.AccessibleAWTComponent)this).getLocale());
                String string3 = resourceBundle.getString(Header.this.getOrientation() == 0 ? Header._COLHEADER : Header._ROWHEADER);
                MessageFormat messageFormat = new MessageFormat(string3);
                Object[] objectArray = new Object[]{string};
                return messageFormat.format(objectArray);
            }
            return string2;
        }

        public String getAccessibleName(int n) {
            Object object = Header.this.getModel().getData(n);
            String string = this.getAccessibleName(n, object);
            return this.getAccessibleNameForTable(n, object, string);
        }

        public String getAccessibleDescription(int n) {
            HeaderToolTipManager headerToolTipManager = Header.this.getToolTipManager();
            if (headerToolTipManager == null) {
                return null;
            }
            return headerToolTipManager.getItemToolTipValue(Header.this, n);
        }

        public AccessibleRole getAccessibleRole() {
            return Header.this._isHorizontal() ? AccessibleRole.COLUMN_HEADER : AccessibleRole.ROW_HEADER;
        }

        public Accessible getAccessibleAt(Point point) {
            int n = Header.this.getItemAt(point.x, point.y);
            return this.getAccessibleChild(n);
        }

        public int getAccessibleChildrenCount() {
            return Header.this.getModel() == null ? 0 : Header.this.getItemCount();
        }

        public Accessible getAccessibleChild(int n) {
            if (n < 0 || n >= this.getAccessibleChildrenCount()) {
                return null;
            }
            return new AccessibleItem(n);
        }

        public AccessibleSelection getAccessibleSelection() {
            return this;
        }

        public int getAccessibleSelectionCount() {
            return Header.this.getSelection().getSelectedItemCount();
        }

        public Accessible getAccessibleSelection(int n) {
            OneDSelection oneDSelection = Header.this.getSelection();
            int n2 = oneDSelection.getSelectedItemAtIndex(n);
            if (n2 != -1) {
                return this.getAccessibleChild(n2);
            }
            return null;
        }

        public boolean isAccessibleChildSelected(int n) {
            return Header.this.getSelection().contains(n);
        }

        public void addAccessibleSelection(int n) {
            OneDSelection oneDSelection = Header.this.getSelection();
            try {
                Header.this.setSelection(oneDSelection.add(n));
            }
            catch (PropertyVetoException propertyVetoException) {
                // empty catch block
            }
        }

        public void removeAccessibleSelection(int n) {
            OneDSelection oneDSelection = Header.this.getSelection();
            try {
                Header.this.setSelection(oneDSelection.subtract(n));
            }
            catch (PropertyVetoException propertyVetoException) {
                // empty catch block
            }
        }

        public void clearAccessibleSelection() {
            try {
                Header.this.deselectAll();
            }
            catch (PropertyVetoException propertyVetoException) {
                // empty catch block
            }
        }

        public void selectAllAccessibleSelection() {
            try {
                Header.this.selectAll();
            }
            catch (PropertyVetoException propertyVetoException) {
                // empty catch block
            }
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            String string = propertyChangeEvent.getPropertyName();
            Object object = propertyChangeEvent.getOldValue();
            Object object2 = propertyChangeEvent.getNewValue();
            if (Header.PROPERTY_MODEL.equals(string)) {
                if (object != null) {
                    ((OneDModel)object).removeModelListener(this);
                }
                if (object2 != null) {
                    ((OneDModel)object2).addModelListener(this);
                }
            } else if (Header.PROPERTY_GEOMETRY_MANAGER.equals(string)) {
                if (object != null) {
                    ((GeometryManager)object).removeGeometryListener(this);
                }
                if (object2 != null) {
                    ((GeometryManager)object2).addGeometryListener(this);
                }
            } else if (Header.PROPERTY_SELECTION.equals(string)) {
                this.firePropertyChange("AccessibleSelection", Boolean.TRUE, Boolean.FALSE);
            } else if (Header.PROPERTY_FOCUS_ITEM.equals(string)) {
                int n = object == null ? -1 : (Integer)object;
                int n2 = object2 == null ? -1 : (Integer)object2;
                Header.this._fireActiveEvent(n, n2);
            }
        }

        public void itemsAdded(OneDModelEvent oneDModelEvent) {
            this.firePropertyChange("AccessibleVisibleData", null, null);
        }

        public void itemsRemoved(OneDModelEvent oneDModelEvent) {
            this.firePropertyChange("AccessibleVisibleData", null, null);
        }

        public void invalidateItems(OneDModelEvent oneDModelEvent) {
            this.firePropertyChange("AccessibleVisibleData", null, null);
        }

        public void geometryChanged(GeometryEvent geometryEvent) {
            this.firePropertyChange("AccessibleVisibleData", null, null);
        }

        protected String getAccessibleName(int n, Object object) {
            String string = null;
            string = object == null ? null : (object instanceof String ? (String)object : (object instanceof ImageIcon ? ((ImageIcon)object).getDescription() : (object instanceof Image || object instanceof ImageSet || object instanceof Icon ? this._getTranslatedString(Header._IMAGE) : this._getTranslatedString(Header._UNKNOWN))));
            return string;
        }

        protected String getAccessibleNameForTable(int n, Object object, String string) {
            Accessible accessible = ((Component.AccessibleAWTComponent)this).getAccessibleParent();
            if (accessible == null) {
                return string;
            }
            AccessibleContext accessibleContext = accessible.getAccessibleContext();
            if (accessibleContext.getAccessibleRole() != AccessibleRole.TABLE) {
                return string;
            }
            if (string == null) {
                string = IntegerUtils.getString(n);
            }
            String string2 = Header.this._isHorizontal() ? Header._KEY_COLUMN : Header._KEY_ROW;
            String string3 = this._getTranslatedString(string2);
            MessageFormat messageFormat = new MessageFormat(string3);
            Object[] objectArray = new Object[]{string};
            string = messageFormat.format(objectArray);
            return string;
        }

        private String _getTranslatedString(String string) {
            ResourceBundle resourceBundle = ResourceBundle.getBundle(Header._RESOURCE, ((Component.AccessibleAWTComponent)this).getLocale());
            return resourceBundle.getString(string);
        }

        private class AccessibleItem
        extends AccessibleContext
        implements Accessible,
        AccessibleComponent {
            private int _position;

            public AccessibleItem(int n) {
                this._position = n;
                this.setAccessibleParent(Header.this);
            }

            public AccessibleContext getAccessibleContext() {
                return this;
            }

            public String getAccessibleName() {
                if (this.accessibleName != null && this.accessibleName != "") {
                    return this.accessibleName;
                }
                return AccessibleHeader.this.getAccessibleName(this._position);
            }

            public String getAccessibleDescription() {
                if (this.accessibleDescription != null && this.accessibleDescription != "") {
                    return this.accessibleDescription;
                }
                return AccessibleHeader.this.getAccessibleDescription(this._position);
            }

            public AccessibleStateSet getAccessibleStateSet() {
                AccessibleStateSet accessibleStateSet = new AccessibleStateSet();
                if (this.isVisible()) {
                    accessibleStateSet.add(AccessibleState.VISIBLE);
                    if (this.isShowing()) {
                        accessibleStateSet.add(AccessibleState.SHOWING);
                    }
                }
                accessibleStateSet.add(AccessibleState.FOCUSABLE);
                if (Header.this.getFocusItem() == this._position) {
                    accessibleStateSet.add(AccessibleState.FOCUSED);
                }
                accessibleStateSet.add(AccessibleState.TRANSIENT);
                if (Header.this.isEnabled()) {
                    accessibleStateSet.add(AccessibleState.ENABLED);
                }
                if (Header.this.isItemResizable(this._position)) {
                    accessibleStateSet.add(AccessibleState.RESIZABLE);
                }
                accessibleStateSet.add(AccessibleState.SELECTABLE);
                if (Header.this.getSelection().contains(this._position)) {
                    accessibleStateSet.add(AccessibleState.SELECTED);
                }
                return accessibleStateSet;
            }

            public Accessible getAccessibleAt(Point point) {
                return null;
            }

            public int getAccessibleIndexInParent() {
                return this._position;
            }

            public Accessible getAccessibleChild(int n) {
                return null;
            }

            public Locale getLocale() {
                return Header.this.getLocale();
            }

            public AccessibleComponent getAccessibleComponent() {
                return this;
            }

            public Color getBackground() {
                Color color = Header.this._getItemAppearance(this._position).getBackground();
                if (color == null) {
                    return Header.this.getBackground();
                }
                return color;
            }

            public void setBackground(Color color) {
                Appearance appearance = Header.this.getItemAppearance(this._position);
                appearance.setBackground(color);
                Header.this.setItemAppearance(this._position, appearance);
            }

            public Font getFont() {
                Font font = Header.this._getItemAppearance(this._position).getFont();
                if (font == null) {
                    return Header.this.getFont();
                }
                return font;
            }

            public void setFont(Font font) {
                Appearance appearance = Header.this.getItemAppearance(this._position);
                appearance.setFont(font);
                Header.this.setItemAppearance(this._position, appearance);
            }

            public FontMetrics getFontMetrics(Font font) {
                return ((Component)Header.this).getFontMetrics(font);
            }

            public boolean isEnabled() {
                return true;
            }

            public void setEnabled(boolean bl) {
            }

            public Color getForeground() {
                Color color = Header.this._getItemAppearance(this._position).getForeground();
                if (color == null) {
                    return Header.this.getForeground();
                }
                return color;
            }

            public void setForeground(Color color) {
                Appearance appearance = Header.this.getItemAppearance(this._position);
                appearance.setForeground(color);
                Header.this.setItemAppearance(this._position, appearance);
            }

            public Cursor getCursor() {
                return Header.this.getCursor();
            }

            public void setCursor(Cursor cursor) {
            }

            public boolean isVisible() {
                return Header.this.isItemVisible(this._position);
            }

            public void setVisible(boolean bl) {
                Header.this.setItemVisible(this._position, bl);
            }

            public boolean isShowing() {
                return this.isVisible();
            }

            public boolean contains(Point point) {
                return this.getBounds().contains(point);
            }

            public Point getLocationOnScreen() {
                Point point = Header.this.getLocationOnScreen();
                Point point2 = this.getLocation();
                point2.translate(point.x, point.y);
                return point2;
            }

            public Point getLocation() {
                return this.getBounds().getLocation();
            }

            public void setLocation(Point point) {
            }

            public Rectangle getBounds() {
                return Header.this.getCellBoundsForItem(this._position);
            }

            public void setBounds(Rectangle rectangle) {
            }

            public Dimension getSize() {
                return this.getBounds().getSize();
            }

            public void setSize(Dimension dimension) {
            }

            public int getAccessibleChildrenCount() {
                return 0;
            }

            public AccessibleRole getAccessibleRole() {
                return AccessibleRole.LABEL;
            }

            public boolean isFocusTraversable() {
                return false;
            }

            public void requestFocus() {
            }

            public void addFocusListener(FocusListener focusListener) {
            }

            public void removeFocusListener(FocusListener focusListener) {
            }
        }
    }

    private class GeometryChangeListener
    implements GeometryListener {
        private GeometryChangeListener() {
        }

        public void geometryChanged(GeometryEvent geometryEvent) {
            switch (geometryEvent.getID()) {
                case 2005: {
                    GeometryManager geometryManager = Header.this._getGeometryManager();
                    int n = geometryEvent.getItem();
                    Header.this.freezeRepaints();
                    try {
                        Dimension dimension = Header.this.layoutCanvas();
                        Header.this.setCanvasSize(dimension.width, dimension.height);
                        if (Header.this.isItemOnScreen(n)) {
                            dimension = Header.this.getInnerSize();
                            Point point = Header.this.getCanvasOrigin();
                            int n2 = geometryManager.getItemPosition(n);
                            if (Header.this._isHorizontal()) {
                                if (n2 < -point.x) {
                                    n2 = -point.x;
                                }
                                Header.this.repaintCanvas(n2, -point.y, dimension.width, dimension.height);
                            } else {
                                if (n2 < -point.y) {
                                    n2 = -point.y;
                                }
                                Header.this.repaintCanvas(-point.x, n2, dimension.width, dimension.height);
                            }
                        }
                        Object var8_7 = null;
                        Header.this.unfreezeRepaints();
                        break;
                    }
                    catch (Throwable throwable) {
                        Object var8_8 = null;
                        Header.this.unfreezeRepaints();
                        throw throwable;
                    }
                }
                default: {
                    Header.this.invalidateCanvas();
                }
            }
        }
    }

    private class SelectionListener
    implements VetoableChangeListener,
    PropertyChangeListener {
        private SelectionListener() {
        }

        public void vetoableChange(PropertyChangeEvent propertyChangeEvent) throws PropertyVetoException {
            Header.this.fireVetoableChange(propertyChangeEvent.getPropertyName(), propertyChangeEvent.getOldValue(), propertyChangeEvent.getNewValue());
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            if (!Header.this._ignoreSelectionRepaints) {
                Header.this._paintSelections((OneDSelection)propertyChangeEvent.getOldValue(), (OneDSelection)propertyChangeEvent.getNewValue());
            }
            Header.this.firePropertyChange(propertyChangeEvent.getPropertyName(), propertyChangeEvent.getOldValue(), propertyChangeEvent.getNewValue());
        }
    }

    private class KeyboardActionListener
    implements ActionListener {
        private KeyboardActionListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            String string = actionEvent.getActionCommand();
            int n = Header.this.getFocusItem();
            if (n == -1) {
                return;
            }
            if (Header._MOVE_LEFT.equals(string) || Header._MOVE_RIGHT.equals(string) || Header._MOVE_UP.equals(string) || Header._MOVE_DOWN.equals(string)) {
                if (Header.this.isItemMovable(n)) {
                    int n2 = Header.this.getItemVisibleIndex(n);
                    if (Header._MOVE_LEFT.equals(string) || Header._MOVE_UP.equals(string)) {
                        if (n2 != 0 && !Header.this.fireCancelableEvent(2007, n)) {
                            Header.this.setItemVisibleIndex(n, n2 - 1);
                            Header.this.fireEvent(2008, n);
                        }
                    } else if ((Header._MOVE_RIGHT.equals(string) || Header._MOVE_DOWN.equals(string)) && n2 != Header.this.getItemCount() - 1 && !Header.this.fireCancelableEvent(2007, n)) {
                        Header.this.setItemVisibleIndex(n, n2 + 1);
                        Header.this.fireEvent(2008, n);
                    }
                }
            } else if ((Header._RESIZE_LEFT.equals(string) || Header._RESIZE_RIGHT.equals(string) || Header._RESIZE_UP.equals(string) || Header._RESIZE_DOWN.equals(string)) && Header.this.isItemResizable(n)) {
                int n3 = Header.this.getItemSize(n);
                if (Header._RESIZE_LEFT.equals(string) || Header._RESIZE_UP.equals(string)) {
                    if (n3 != 0 && !Header.this.fireCancelableEvent(2005, n)) {
                        Header.this.setItemSize(n, n3 - 1);
                        Header.this.fireEvent(2006, n);
                    }
                } else if ((Header._RESIZE_RIGHT.equals(string) || Header._RESIZE_DOWN.equals(string)) && !Header.this.fireCancelableEvent(2005, n)) {
                    Header.this.setItemSize(n, n3 + 1);
                    Header.this.fireEvent(2006, n);
                }
            }
        }
    }

    private class ItemPaintContext
    extends PaintContextProxy {
        private int _item;
        private PaintContext _context;

        public ItemPaintContext(PaintContext paintContext, int n) {
            this._context = paintContext;
            this.setItem(n);
        }

        public void setItem(int n) {
            this._item = n;
        }

        protected PaintContext getPaintContext() {
            return this._context;
        }

        public int getPaintState() {
            int n = super.getPaintState();
            int n2 = this._item;
            HeaderSelectionManager headerSelectionManager = Header.this.getHeaderSelectionManager();
            if (headerSelectionManager.getSelection().contains(n2) && Header.this.getDrawSelected()) {
                n |= 0x20;
            }
            if (Header.this.getArmedItem() == n2) {
                n |= 2;
            }
            return Header.this.getItemPaintState(n, n2);
        }

        public Color getPaintForeground() {
            int n = this.getPaintState();
            if ((n & 0x20) == 0) {
                Color color = this.getAppearance().getForeground();
                if (color == null) {
                    color = super.getPaintForeground();
                }
                return color;
            }
            return this.getAppearance().getSelectForeground();
        }

        public Color getPaintBackground() {
            boolean bl;
            int n = this.getPaintState();
            Color color = null;
            boolean bl2 = bl = (n & 0x20) != 0;
            if (bl) {
                color = this.getAppearance().getSelectBackground();
            }
            if (color == null) {
                color = this.getAppearance().getBackground();
            }
            if (color == null) {
                color = super.getPaintBackground();
            }
            return color;
        }

        public Font getPaintFont() {
            int n = this.getPaintState();
            Font font = null;
            if ((n & 0x20) != 0) {
                font = this.getAppearance().getSelectFont();
            }
            if (font == null) {
                font = this.getAppearance().getFont();
            }
            if (font == null) {
                font = super.getPaintFont();
            }
            return font;
        }

        public float getInteriorAlignmentX() {
            float f;
            Appearance appearance = this.getAppearance();
            int n = appearance.getHorizontalJustify();
            if (n == 0) {
                int n2 = appearance.getReadingDirection();
                switch (n2) {
                    case 0: {
                        return super.getInteriorAlignmentX();
                    }
                }
                n = LocaleUtils.getAlignmentForReadingDirection(n2);
            }
            switch (n) {
                case 3: {
                    f = 0.5f;
                    break;
                }
                case 2: {
                    f = 1.0f;
                    break;
                }
                default: {
                    f = 0.0f;
                }
            }
            return f;
        }

        public float getInteriorAlignmentY() {
            int n = this.getAppearance().getVerticalJustify();
            float f = 0.0f;
            switch (n) {
                case 1: {
                    f = 0.5f;
                    break;
                }
                case 0: {
                    f = 0.0f;
                    break;
                }
                case 2: {
                    f = 1.0f;
                }
            }
            return f;
        }

        public int getReadingDirection() {
            int n = this.getAppearance().getReadingDirection();
            if (n == 0) {
                n = super.getReadingDirection();
            }
            return n;
        }

        public Object getPaintData(Object object) {
            Object object2 = Header.this.getItemPaintData(this._item, object);
            if (object2 != null) {
                return object2;
            }
            if (object == PaintContext.MNEMONIC_INDEX_KEY) {
                return null;
            }
            if (KEY_APPEARANCE.equals(object)) {
                return this.getAppearance();
            }
            if (KEY_DRAW_RAISED.equals(object)) {
                return new Boolean(Header.this.getDrawRaised());
            }
            Object object3 = super.getPaintData(object);
            if (object3 == null) {
                try {
                    object3 = Header.this.getModel().getData(this._item);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            return object3;
        }

        public Appearance getAppearance() {
            return Header.this._getItemAppearance(this._item);
        }
    }

    private class DSListen
    implements OneDModelListener {
        private DSListen() {
        }

        public void itemsAdded(OneDModelEvent oneDModelEvent) {
            Header.this.internalItemsAdded(oneDModelEvent);
        }

        public void itemsRemoved(OneDModelEvent oneDModelEvent) {
            Header.this.internalItemsRemoved(oneDModelEvent);
        }

        public void invalidateItems(OneDModelEvent oneDModelEvent) {
            Header.this.internalInvalidateItems(oneDModelEvent);
        }
    }
}

