/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.ewt.grid.hGrid;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import javax.accessibility.Accessible;
import javax.accessibility.AccessibleState;
import javax.swing.Icon;
import javax.swing.UIManager;
import oracle.bali.ewt.graphics.Appearance;
import oracle.bali.ewt.grid.CellInputHandler;
import oracle.bali.ewt.grid.Grid;
import oracle.bali.ewt.grid.NullInputHandler;
import oracle.bali.ewt.grid.ProxyInputHandler;
import oracle.bali.ewt.model.TwoDModel;
import oracle.bali.ewt.painter.NullPainter;
import oracle.bali.ewt.painter.PaintContext;
import oracle.bali.ewt.painter.PaintContextProxy;
import oracle.bali.ewt.painter.Painter;
import oracle.bali.ewt.selection.Cell;
import oracle.bali.ewt.util.ImmInsets;

public abstract class AbstractCellHandler
extends ProxyInputHandler
implements Painter {
    private Context _contextProxy;
    private int _indentWidth;
    private Painter _painter;
    private Icon _expandedIcon;
    private Icon _collapsedIcon;
    private boolean _consumeMouseEvents;
    private boolean _expandedIconDefaulted;
    private boolean _collapsedIconDefaulted;
    private static final int _DEFAULT_INDENT_WIDTH = 18;
    private static final int _BUTTON_MARGIN = 2;
    private static final int _DEFAULT_BUTTON_SIZE = 11;

    protected AbstractCellHandler() {
        this((Painter)UIManager.get("Grid.DefaultCellPainter"));
    }

    protected AbstractCellHandler(Painter painter) {
        this(painter, NullInputHandler.getCellInputHandler());
    }

    protected AbstractCellHandler(CellInputHandler cellInputHandler) {
        this((Painter)UIManager.get("Grid.DefaultCellPainter"), cellInputHandler);
    }

    protected AbstractCellHandler(Painter painter, CellInputHandler cellInputHandler) {
        super(cellInputHandler);
        if (painter == null) {
            painter = NullPainter.getPainter();
        }
        this._painter = painter;
        this._indentWidth = 18;
        this._contextProxy = new Context();
    }

    public Painter getPainter() {
        return this._painter;
    }

    public void updateUI() {
        if (this._expandedIconDefaulted) {
            this._expandedIcon = null;
        }
        if (this._collapsedIconDefaulted) {
            this._collapsedIcon = null;
        }
    }

    public void setIndentWidth(int n) {
        this._indentWidth = n;
    }

    public int getIndentWidth() {
        return this._indentWidth;
    }

    public Icon getExpandedIcon() {
        return this._expandedIcon;
    }

    public void setExpandedIcon(Icon icon) {
        this._expandedIcon = icon;
        this._expandedIconDefaulted = false;
    }

    public Icon getCollapsedIcon() {
        return this._collapsedIcon;
    }

    public void setCollapsedIcon(Icon icon) {
        this._collapsedIcon = icon;
        this._collapsedIconDefaulted = false;
    }

    public void mousePressed(MouseEvent mouseEvent, Grid grid, int n, int n2) {
        if (!mouseEvent.isConsumed()) {
            this.processButtonMousePressed(mouseEvent, grid, n, n2);
        }
        if (!mouseEvent.isConsumed()) {
            super.mousePressed(mouseEvent, grid, n, n2);
        } else {
            this._consumeMouseEvents = true;
        }
    }

    public void mouseDragged(MouseEvent mouseEvent, Grid grid, int n, int n2) {
        if (this._consumeMouseEvents) {
            mouseEvent.consume();
        } else {
            super.mouseDragged(mouseEvent, grid, n, n2);
        }
    }

    public void mouseReleased(MouseEvent mouseEvent, Grid grid, int n, int n2) {
        if (this._consumeMouseEvents) {
            mouseEvent.consume();
            this._consumeMouseEvents = false;
        } else {
            super.mouseReleased(mouseEvent, grid, n, n2);
        }
    }

    public void keyPressed(KeyEvent keyEvent, Grid grid, int n, int n2) {
        super.keyPressed(keyEvent, grid, n, n2);
        if (keyEvent.isConsumed()) {
            return;
        }
        int n3 = keyEvent.getKeyCode();
        if (n3 == 37 || n3 == 39) {
            boolean bl = n3 == 39;
            boolean bl2 = this.setCellExpansionState(grid.getModel(), n, n2, bl);
            Grid.AccessibleGrid accessibleGrid = grid.getAccessibleGrid();
            if (accessibleGrid != null) {
                AccessibleState accessibleState;
                AccessibleState accessibleState2;
                if (bl) {
                    accessibleState2 = AccessibleState.COLLAPSED;
                    accessibleState = AccessibleState.EXPANDED;
                } else {
                    accessibleState2 = AccessibleState.EXPANDED;
                    accessibleState = AccessibleState.COLLAPSED;
                }
                int n4 = accessibleGrid.getAccessibleIndexAt(n, n2);
                Accessible accessible = accessibleGrid.getAccessibleChild(n4);
                accessibleGrid.firePropertyChange("AccessibleState", accessibleState2, accessibleState);
                accessible.getAccessibleContext().firePropertyChange("AccessibleState", accessibleState2, accessibleState);
            }
            if (bl2) {
                keyEvent.consume();
            }
        }
    }

    public Rectangle getEditControlBounds(Grid grid, int n, int n2) {
        Rectangle rectangle = super.getEditControlBounds(grid, n, n2);
        int n3 = this._getIndentAt(grid, n, n2);
        if (n3 != 0) {
            if (rectangle == null) {
                int n4 = grid.getRowHeight(n2);
                int n5 = grid.getColumnWidth(n);
                rectangle = new Rectangle(0, 0, n5, n4);
            }
            rectangle.x += n3;
            rectangle.width -= n3;
        }
        return rectangle;
    }

    public Object getWrappedData(Object object) {
        return object;
    }

    public void startEdit(Grid grid, int n, int n2, Object object) {
        super.startEdit(grid, n, n2, this.getWrappedData(object));
    }

    public Dimension getSize(PaintContext paintContext, int n, int n2) {
        return new Dimension(n, n2);
    }

    public Dimension getPreferredSize(PaintContext paintContext) {
        Context context = this._contextProxy;
        context.setPaintContext(paintContext);
        return this._addIndentDepth(this._painter.getPreferredSize(context), paintContext);
    }

    public Dimension getMinimumSize(PaintContext paintContext) {
        Context context = this._contextProxy;
        context.setPaintContext(paintContext);
        return this._addIndentDepth(this._painter.getMinimumSize(context), paintContext);
    }

    public Dimension getMaximumSize(PaintContext paintContext) {
        Context context = this._contextProxy;
        context.setPaintContext(paintContext);
        return this._addIndentDepth(this._painter.getMaximumSize(context), paintContext);
    }

    protected boolean isBackgroundUsed() {
        return true;
    }

    private Dimension _addIndentDepth(Dimension dimension, PaintContext paintContext) {
        TwoDModel twoDModel = (TwoDModel)paintContext.getPaintData("Model");
        Cell cell = (Cell)paintContext.getPaintData("Cell");
        int n = this.getCellDepth(twoDModel, cell.column, cell.row);
        int n2 = this._getIndentAtDepth(paintContext, n);
        dimension.width += n2;
        return dimension;
    }

    public void paint(PaintContext paintContext, Graphics graphics, int n, int n2, int n3, int n4) {
        Object object;
        TwoDModel twoDModel = (TwoDModel)paintContext.getPaintData("Model");
        Cell cell = (Cell)paintContext.getPaintData("Cell");
        int n5 = this.getCellDepth(twoDModel, cell.column, cell.row);
        boolean bl = this.cellHasChildren(twoDModel, cell.column, cell.row);
        Object object2 = this.getWrappedData(paintContext.getPaintData(null));
        Context context = this._contextProxy;
        int n6 = this._getIndentAtDepth(paintContext, n5);
        n += n6;
        n3 -= n6;
        Appearance appearance = null;
        Color color = graphics.getColor();
        int n7 = paintContext.getPaintState();
        if ((n7 & 1) == 0 && (n7 & 0x20) != 0 && this.isBackgroundUsed() && (appearance = (Appearance)paintContext.getPaintData("Appearance")) != null) {
            object = appearance.getInsets();
            graphics.setColor(appearance.getBackground());
            graphics.fillRect(n - n6 - ((ImmInsets)object).left, n2 - ((ImmInsets)object).top, n6 + ((ImmInsets)object).left, n4 + ((ImmInsets)object).top + ((ImmInsets)object).bottom);
            graphics.setColor(color);
        }
        if (bl) {
            Object object3 = object = this.isCellExpanded(twoDModel, cell.column, cell.row) ? this._getExpandedIcon(paintContext) : this._getCollapsedIcon(paintContext);
            if (object != null) {
                int n8 = n - 2 - object.getIconWidth();
                int n9 = n2 + (n4 - object.getIconHeight()) / 2;
                object.paintIcon(paintContext.getComponent(), graphics, n8, n9);
                graphics.setColor(color);
            }
        }
        object = context;
        synchronized (object) {
            context.setPaintContext(paintContext);
            this._painter.paint(context, graphics, n, n2, n3, n4);
        }
    }

    public final boolean contains(PaintContext paintContext, int n, int n2, int n3, int n4) {
        return this.getPainterAt(paintContext, n, n2, n3, n4, null) != null;
    }

    public Painter getPainterAt(PaintContext paintContext, int n, int n2, int n3, int n4, Painter painter) {
        if (n3 >= 0 && n4 >= 0 && n3 < n && n4 < n2) {
            return this;
        }
        return null;
    }

    public boolean isTransparent(PaintContext paintContext) {
        return true;
    }

    public int getRepaintFlags(PaintContext paintContext) {
        return this._painter.getRepaintFlags(paintContext);
    }

    public int getInvalidateFlags(PaintContext paintContext) {
        return this._painter.getInvalidateFlags(paintContext);
    }

    protected abstract boolean setCellExpansionState(TwoDModel var1, int var2, int var3, boolean var4);

    protected abstract boolean cellHasChildren(TwoDModel var1, int var2, int var3);

    protected abstract int getCellDepth(TwoDModel var1, int var2, int var3);

    protected abstract boolean isCellExpanded(TwoDModel var1, int var2, int var3);

    protected void processButtonMousePressed(MouseEvent mouseEvent, Grid grid, int n, int n2) {
        TwoDModel twoDModel = grid.getModel();
        if (this.cellHasChildren(twoDModel, n, n2)) {
            int n3;
            int n4;
            int n5 = grid.getRowHeight(n2);
            int n6 = grid.getColumnWidth(n);
            int n7 = mouseEvent.getX();
            if (n7 <= (n4 = this._getButtonX(n3 = this.getCellDepth(twoDModel, n, n2))) + this._getButtonWidth(grid.getPaintContext())) {
                mouseEvent.consume();
                boolean bl = this.isCellExpanded(twoDModel, n, n2);
                this.setCellExpansionState(twoDModel, n, n2, !bl);
            }
        }
    }

    protected void translateMouseEvent(MouseEvent mouseEvent, Grid grid, int n, int n2, boolean bl) {
        int n3 = this._getIndentAt(grid, n, n2);
        if (bl) {
            n3 = -n3;
        }
        mouseEvent.translatePoint(n3, 0);
    }

    private int _getButtonWidth(PaintContext paintContext) {
        return this._getExpandedIcon(paintContext).getIconWidth();
    }

    private int _getIndentAt(Grid grid, int n, int n2) {
        return this._getIndentAtDepth(grid.getPaintContext(), this.getCellDepth(grid.getModel(), n, n2));
    }

    private int _getIndentAtDepth(PaintContext paintContext, int n) {
        return this._getButtonX(n) + this._getButtonWidth(paintContext) + 2;
    }

    private int _getButtonX(int n) {
        return n * this.getIndentWidth() + 2;
    }

    private Icon _getExpandedIcon(PaintContext paintContext) {
        Icon icon = this.getExpandedIcon();
        if (icon == null) {
            this._expandedIcon = icon = paintContext.getPaintUIDefaults().getIcon("Tree.expandedIcon");
            this._expandedIconDefaulted = true;
        }
        return icon;
    }

    private Icon _getCollapsedIcon(PaintContext paintContext) {
        Icon icon = this.getCollapsedIcon();
        if (icon == null) {
            icon = paintContext.getPaintUIDefaults().getIcon("Tree.collapsedIcon");
            this._collapsedIconDefaulted = true;
            this._collapsedIcon = icon;
        }
        return icon;
    }

    private class Context
    extends PaintContextProxy {
        private PaintContext _context;

        private Context() {
        }

        public void setPaintContext(PaintContext paintContext) {
            this._context = paintContext;
        }

        protected PaintContext getPaintContext() {
            return this._context;
        }

        public Object getPaintData(Object object) {
            return AbstractCellHandler.this.getWrappedData(super.getPaintData(object));
        }
    }
}

