/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.ewt.grid.bigCell;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.PrintGraphics;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.print.PrinterGraphics;
import javax.swing.UIManager;
import oracle.bali.ewt.graphics.Appearance;
import oracle.bali.ewt.graphics.GraphicsProxy;
import oracle.bali.ewt.grid.Grid;
import oracle.bali.ewt.grid.bigCell.AbstractBigCell;
import oracle.bali.ewt.painter.AbstractPainter;
import oracle.bali.ewt.painter.PaintContext;
import oracle.bali.ewt.painter.PaintContextProxy;
import oracle.bali.ewt.painter.Painter;
import oracle.bali.ewt.util.ImmInsets;

public class BigCellPainter
extends AbstractPainter {
    public static final String BIG_CELL_KEY = "BigCell";
    private boolean _horizontalSeparatorsVisible;
    private boolean _verticalSeparatorsVisible;
    private Painter _painter;
    private boolean _keepCellsVisible = false;

    public BigCellPainter() {
        this(null);
    }

    public BigCellPainter(Painter painter) {
        this._painter = painter;
        this._horizontalSeparatorsVisible = true;
        this._verticalSeparatorsVisible = true;
    }

    public void setPainter(Painter painter) {
        if (this._painter != painter) {
            this._painter = painter;
        }
    }

    public Painter getPainter() {
        if (this._painter == null) {
            Object object = UIManager.get("Grid.DefaultCellPainter");
            this._painter = object instanceof Painter ? (Painter)object : null;
        }
        return this._painter;
    }

    public boolean getHorizontalSeparatorsVisible() {
        return this._horizontalSeparatorsVisible;
    }

    public void setHorizontalSeparatorsVisible(boolean bl) {
        this._horizontalSeparatorsVisible = bl;
    }

    public boolean getVerticalSeparatorsVisible() {
        return this._verticalSeparatorsVisible;
    }

    public void setVerticalSeparatorsVisible(boolean bl) {
        this._verticalSeparatorsVisible = bl;
    }

    public void paint(PaintContext paintContext, Graphics graphics, int n, int n2, int n3, int n4) {
        Object object;
        int n5;
        int n6;
        int n7;
        int n8;
        int n9;
        boolean bl;
        Grid grid = (Grid)paintContext.getPaintData("Grid");
        if (grid == null) {
            return;
        }
        Appearance appearance = (Appearance)paintContext.getPaintData("Appearance");
        ImmInsets immInsets = appearance.getInsets();
        n -= immInsets.left;
        n2 -= immInsets.top;
        n3 += immInsets.left + immInsets.right;
        n4 += immInsets.top + immInsets.bottom;
        boolean bl2 = paintContext.getReadingDirection() == 1;
        Shape shape = graphics.getClip();
        int n10 = n;
        int n11 = n2;
        int n12 = n3;
        int n13 = n4;
        AbstractBigCell abstractBigCell = null;
        Object object2 = paintContext.getPaintData(null);
        Painter painter = null;
        boolean bl3 = bl = graphics instanceof PrintGraphics || graphics instanceof PrinterGraphics;
        if (object2 instanceof AbstractBigCell) {
            Rectangle rectangle;
            abstractBigCell = (AbstractBigCell)object2;
            n9 = abstractBigCell.getColumn();
            int n14 = abstractBigCell.getRow();
            n8 = abstractBigCell.getColumnCount();
            n7 = abstractBigCell.getRowCount();
            int n15 = grid.getNextVisibleColumn(n9 - 1);
            if (n15 >= n9 + n8) {
                return;
            }
            n6 = grid.getNextVisibleRow(n14 - 1);
            if (n6 >= n14 + n7) {
                return;
            }
            n10 = grid.getColumnPosition(n15);
            n11 = grid.getRowPosition(n6);
            if (!bl2) {
                n10 = grid.getColumnPosition(n9 + n8 - 1);
            }
            paintContext = !bl ? grid.getCellPaintContext(n9, n14) : grid.getCellPrintPaintContext(graphics, n9, n14);
            paintContext = new Proxy(grid, paintContext, abstractBigCell, abstractBigCell.getData());
            n12 = 0;
            int n16 = 0;
            while (n16 < n8) {
                n5 = n16 + n9;
                if (grid.isColumnVisible(n5)) {
                    n12 += grid.getColumnWidth(n5);
                }
                ++n16;
            }
            n13 = 0;
            n5 = 0;
            while (n5 < n7) {
                int n17 = n5 + n14;
                if (grid.isRowVisible(n17)) {
                    n13 += grid.getRowHeight(n17);
                }
                ++n5;
            }
            if (!bl) {
                object = grid.convertCanvasToOuter(n10, n11);
                rectangle = new Rectangle(((Point)object).x, ((Point)object).y, n12, n13);
                rectangle = rectangle.intersection(grid.getVisibleRect());
                object = grid.convertOuterToCanvas(rectangle.x, rectangle.y);
                rectangle.x = ((Point)object).x;
                rectangle.y = ((Point)object).y;
                graphics.setClip(rectangle);
            } else {
                rectangle = new Rectangle(n10, n11, n12, n13);
                if (graphics instanceof GraphicsProxy && (object = ((GraphicsProxy)graphics).get("grid.clipRect")) instanceof Rectangle) {
                    rectangle = rectangle.intersection((Rectangle)object);
                    graphics.setClip(rectangle);
                }
            }
            if (this._keepCellsVisible) {
                n10 = rectangle.x;
                n11 = rectangle.y;
                n12 = rectangle.width;
                n13 = rectangle.height;
            }
            appearance = grid.getAppearanceManager().getCellPaintingAppearance(n15, n6);
            painter = appearance.getBorderPainter();
            immInsets = appearance.getInsets();
        }
        n9 = this.getHorizontalSeparatorsVisible();
        Painter painter2 = grid.getHorizontalSeparatorPainter();
        n8 = n9 != 0 ? painter2.getPreferredSize((PaintContext)paintContext).height : 0;
        n7 = this.getVerticalSeparatorsVisible();
        Painter painter3 = grid.getVerticalSeparatorPainter();
        n6 = n7 != 0 ? painter3.getPreferredSize((PaintContext)paintContext).width : 0;
        n12 -= n6;
        n13 -= n8;
        Color color = paintContext.getPaintBackground();
        if (color != null) {
            graphics.setColor(color);
            graphics.fillRect(n10, n11, n12, n13);
        }
        if (grid.isEnabled() && appearance.getBackground() == null) {
            n5 = 0;
            int n18 = paintContext.getPaintState();
            if ((n18 & 0x20) != 0) {
                if ((n18 & 4) == 0 && appearance.getSelectBackground() == null) {
                    n5 = 1;
                }
            } else {
                n5 = 1;
            }
            if (n5 != 0 && (object = grid.getFill()) != null) {
                object.paint(paintContext, graphics, 0, 0, grid.getWidth(), grid.getHeight());
            }
        }
        graphics.setColor(paintContext.getPaintForeground());
        graphics.setFont(paintContext.getPaintFont());
        Painter painter4 = this.getPainter();
        if (painter != null) {
            painter.paint(paintContext, graphics, n10, n11, n12, n13);
            ImmInsets immInsets2 = painter.getInsets(paintContext);
            if (painter4 != null) {
                painter4.paint(paintContext, graphics, n10 + immInsets2.left + immInsets.left, n11 + immInsets2.top + immInsets.top, n12 - (immInsets2.left + immInsets2.right) - (immInsets.left + immInsets.right), n13 - (immInsets2.top + immInsets2.bottom) - (immInsets.top + immInsets.bottom));
            }
        } else if (painter4 != null) {
            painter4.paint(paintContext, graphics, n10 + immInsets.left, n11 + immInsets.top, n12 - (immInsets.left + immInsets.right), n13 - (immInsets.top + immInsets.bottom));
        }
        if (n9 != 0) {
            painter2.paint(paintContext, graphics, n10, n11 + n13, n12 + n6, n8);
        }
        if (n7 != 0) {
            painter3.paint(paintContext, graphics, n10 + n12, n11, n6, n13 + n8);
        }
        graphics.setClip(shape);
    }

    public void setKeepCellsVisible(boolean bl) {
        this._keepCellsVisible = bl;
    }

    public boolean isKeepCellsVisible() {
        return this._keepCellsVisible;
    }

    public Dimension getMinimumSize(PaintContext paintContext) {
        if (this.getPainter() != null) {
            return this.getPainter().getMinimumSize(paintContext);
        }
        return new Dimension(0, 0);
    }

    public int getRepaintFlags(PaintContext paintContext) {
        return 0;
    }

    private class Proxy
    extends PaintContextProxy {
        private Grid _grid;
        private PaintContext _toProxy;
        private Object _realData;
        private Object _bigCell;

        public Proxy(Grid grid, PaintContext paintContext, AbstractBigCell abstractBigCell, Object object) {
            this._grid = grid;
            this._toProxy = paintContext;
            this._bigCell = abstractBigCell;
            this._realData = object;
        }

        public Object getPaintData(Object object) {
            Object object2;
            if (BigCellPainter.BIG_CELL_KEY.equals(object)) {
                return this._bigCell;
            }
            if ("Cell".equals(object)) {
                return super.getPaintData(object);
            }
            if ("Appearance".equals(object)) {
                return super.getPaintData(object);
            }
            if ("Grid".equals(object)) {
                return super.getPaintData(object);
            }
            if ("Model".equals(object)) {
                return super.getPaintData(object);
            }
            if (object != null && (object2 = super.getPaintData(object)) != this._bigCell) {
                return object2;
            }
            return this._realData;
        }

        protected PaintContext getPaintContext() {
            return this._toProxy;
        }
    }
}

