/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.ewt.grid.bigCell;

import java.awt.event.KeyEvent;
import oracle.bali.ewt.grid.Grid;
import oracle.bali.ewt.grid.GridKeyHandler;
import oracle.bali.ewt.grid.StandardGridKeyHandler;
import oracle.bali.ewt.grid.bigCell.AbstractBigCell;
import oracle.bali.ewt.selection.Cell;

public class BigCellGridKeyHandler
extends StandardGridKeyHandler {
    private static StandardGridKeyHandler _sManager;

    public static GridKeyHandler getGridKeyHandler() {
        if (_sManager == null) {
            _sManager = new BigCellGridKeyHandler();
        }
        return _sManager;
    }

    protected Cell left(Grid grid, Cell cell, KeyEvent keyEvent) {
        cell = this._checkForNull(grid, cell);
        AbstractBigCell abstractBigCell = AbstractBigCell.getBigCell(grid, cell.column, cell.row);
        Cell cell2 = super.left(grid, cell, keyEvent);
        if (cell2 != null && (abstractBigCell = AbstractBigCell.getBigCell(grid, cell2.column, cell2.row)) != null) {
            cell2.column = abstractBigCell.getColumn();
            cell2.row = abstractBigCell.getRow();
        }
        return cell2;
    }

    protected Cell right(Grid grid, Cell cell, KeyEvent keyEvent) {
        Cell cell2;
        cell = this._checkForNull(grid, cell);
        AbstractBigCell abstractBigCell = AbstractBigCell.getBigCell(grid, cell.column, cell.row);
        if (abstractBigCell != null) {
            cell.column = abstractBigCell.getColumn() + abstractBigCell.getColumnCount() - 1;
        }
        if ((cell2 = super.right(grid, cell, keyEvent)) != null && (abstractBigCell = AbstractBigCell.getBigCell(grid, cell2.column, cell2.row)) != null) {
            cell2.column = abstractBigCell.getColumn();
            cell2.row = abstractBigCell.getRow();
        }
        return cell2;
    }

    protected Cell up(Grid grid, Cell cell, KeyEvent keyEvent) {
        Cell cell2;
        cell = this._checkForNull(grid, cell);
        AbstractBigCell abstractBigCell = AbstractBigCell.getBigCell(grid, cell.column, cell.row);
        if (abstractBigCell != null) {
            cell.row = abstractBigCell.getRow();
        }
        if ((cell2 = super.up(grid, cell, keyEvent)) != null && (abstractBigCell = AbstractBigCell.getBigCell(grid, cell2.column, cell2.row)) != null) {
            cell2.column = abstractBigCell.getColumn();
            cell2.row = abstractBigCell.getRow();
        }
        return cell2;
    }

    protected Cell down(Grid grid, Cell cell, KeyEvent keyEvent) {
        Cell cell2;
        cell = this._checkForNull(grid, cell);
        AbstractBigCell abstractBigCell = AbstractBigCell.getBigCell(grid, cell.column, cell.row);
        if (abstractBigCell != null) {
            cell.row = abstractBigCell.getRow() + abstractBigCell.getRowCount() - 1;
        }
        if ((cell2 = super.down(grid, cell, keyEvent)) != null && (abstractBigCell = AbstractBigCell.getBigCell(grid, cell2.column, cell2.row)) != null) {
            cell2.column = abstractBigCell.getColumn();
            cell2.row = abstractBigCell.getRow();
        }
        return cell2;
    }

    protected Cell pageUp(Grid grid, Cell cell, KeyEvent keyEvent) {
        cell = this._checkForNull(grid, cell);
        AbstractBigCell abstractBigCell = AbstractBigCell.getBigCell(grid, cell.column, cell.row);
        if (abstractBigCell != null) {
            cell.row = abstractBigCell.getRow();
        }
        return super.pageUp(grid, cell, keyEvent);
    }

    protected Cell pageDown(Grid grid, Cell cell, KeyEvent keyEvent) {
        cell = this._checkForNull(grid, cell);
        AbstractBigCell abstractBigCell = AbstractBigCell.getBigCell(grid, cell.column, cell.row);
        if (abstractBigCell != null) {
            cell.row = abstractBigCell.getRow() + abstractBigCell.getRowCount() - 1;
        }
        return super.pageDown(grid, cell, keyEvent);
    }

    protected Cell home(Grid grid, Cell cell, KeyEvent keyEvent) {
        Cell cell2 = super.home(grid, cell, keyEvent);
        AbstractBigCell abstractBigCell = AbstractBigCell.getBigCell(grid, cell2.column, cell2.row);
        if (abstractBigCell != null) {
            cell2.column = abstractBigCell.getColumn();
            cell2.row = abstractBigCell.getRow();
        }
        return cell2;
    }

    protected Cell end(Grid grid, Cell cell, KeyEvent keyEvent) {
        Cell cell2 = super.end(grid, cell, keyEvent);
        AbstractBigCell abstractBigCell = AbstractBigCell.getBigCell(grid, cell2.column, cell2.row);
        if (abstractBigCell != null) {
            cell2.column = abstractBigCell.getColumn();
            cell2.row = abstractBigCell.getRow();
        }
        return cell2;
    }

    private Cell _checkForNull(Grid grid, Cell cell) {
        if (cell == null) {
            cell = new Cell(grid.getNextVisibleColumn(-1), grid.getNextVisibleRow(-1));
        }
        return cell;
    }
}

