/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.ewt.grid;

import java.awt.AWTEvent;
import java.awt.Component;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.border.EmptyBorder;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.plaf.UIResource;
import oracle.bali.ewt.grid.CellInputHandler;
import oracle.bali.ewt.grid.Grid;
import oracle.bali.ewt.selection.Cell;
import oracle.bali.ewt.util.FocusUtils;

public class TextFieldInputHandler
extends CellInputHandler {
    boolean _dirty;
    private JTextField _textField;
    private static TextFieldInputHandler _sInputHandler;

    public final JTextField getJTextField() {
        return (JTextField)this.getEditControl(null, -1, -1);
    }

    public void updateUI() {
        if (this._textField != null) {
            SwingUtilities.updateComponentTreeUI(this._textField);
        }
    }

    public void focusGained(AWTEvent aWTEvent, Grid grid, int n, int n2) {
        if (aWTEvent instanceof MouseEvent) {
            grid.startCellEdit(n, n2);
        }
    }

    public void mousePressed(MouseEvent mouseEvent, Grid grid, int n, int n2) {
        super.mousePressed(mouseEvent, grid, n, n2);
        Cell cell = grid.getFocusCell();
        if (cell != null && cell.column == n && cell.row == n2 && SwingUtilities.isLeftMouseButton(mouseEvent)) {
            grid.startCellEdit(n, n2);
        }
    }

    public void keyTyped(KeyEvent keyEvent, Grid grid, int n, int n2) {
        super.keyTyped(keyEvent, grid, n, n2);
        JTextField jTextField = this.getJTextField();
        if (jTextField.isEditable()) {
            char c = keyEvent.getKeyChar();
            if (c == '\b') {
                jTextField.setText("");
            } else {
                jTextField.setText(String.valueOf(c));
                if (jTextField.getText().length() == 1) {
                    jTextField.select(1, 1);
                }
            }
        } else {
            jTextField.selectAll();
        }
        keyEvent.consume();
    }

    public synchronized Component getEditControl(Grid grid, int n, int n2) {
        if (this._textField == null) {
            this._textField = this.createTextField();
            this._initTextField(this._textField);
        }
        return this._textField;
    }

    public boolean isDirty(Grid grid, int n, int n2) {
        return this._dirty;
    }

    public void startEdit(Grid grid, int n, int n2, Object object) {
        JTextField jTextField = this.getJTextField();
        jTextField.setText((String)object);
        if (object != null) {
            jTextField.selectAll();
        }
        this._dirty = false;
    }

    public synchronized Object commitEdit(Grid grid, int n, int n2) {
        JTextField jTextField = this.getJTextField();
        String string = jTextField.getText();
        return string;
    }

    public static CellInputHandler getCellInputHandler() {
        if (_sInputHandler == null) {
            _sInputHandler = TextFieldInputHandler.createTextFieldInputHandler();
        }
        return _sInputHandler;
    }

    public static TextFieldInputHandler createTextFieldInputHandler() {
        return new TextFieldInputHandler();
    }

    public static TextFieldInputHandler createTextFieldInputHandler(JTextField jTextField) {
        return new TextFieldInputHandler(jTextField);
    }

    protected TextFieldInputHandler() {
        this(null);
    }

    protected TextFieldInputHandler(JTextField jTextField) {
        if (jTextField != null) {
            this._textField = jTextField;
            this._initTextField(jTextField);
        }
    }

    protected JTextField createTextField() {
        return new JTextField();
    }

    private void _initTextField(JTextField jTextField) {
        KeyStroke keyStroke = KeyStroke.getKeyStroke(10, 0);
        Dirty dirty = new Dirty();
        jTextField.getKeymap().removeKeyStrokeBinding(keyStroke);
        jTextField.getDocument().addDocumentListener(dirty);
        if (jTextField.getBorder() instanceof UIResource) {
            jTextField.setBorder(new EmptyBorder(0, 2, 0, 0));
        }
        if (FocusUtils.areNewFocusAPIsAvailable()) {
            jTextField.addFocusListener(dirty);
        }
    }

    private class Dirty
    extends FocusAdapter
    implements DocumentListener {
        private Dirty() {
        }

        public void insertUpdate(DocumentEvent documentEvent) {
            TextFieldInputHandler.this._dirty = true;
        }

        public void removeUpdate(DocumentEvent documentEvent) {
            TextFieldInputHandler.this._dirty = true;
        }

        public void changedUpdate(DocumentEvent documentEvent) {
        }

        public void focusGained(FocusEvent focusEvent) {
            JTextField jTextField = (JTextField)focusEvent.getSource();
            if (jTextField.getText().length() == 1) {
                jTextField.select(1, 1);
            }
        }
    }
}

