/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.ewt.grid;

import java.awt.Dimension;
import java.awt.Point;
import oracle.bali.ewt.graphics.Appearance;
import oracle.bali.ewt.grid.Grid;
import oracle.bali.ewt.grid.GridToolTipManager;
import oracle.bali.ewt.model.TwoDModel;
import oracle.bali.ewt.painter.BorderPainter;
import oracle.bali.ewt.painter.FormatPainter;
import oracle.bali.ewt.painter.PaintContext;
import oracle.bali.ewt.painter.Painter;
import oracle.bali.ewt.util.ImmInsets;

public class GridDataToolTipManager
implements GridToolTipManager {
    public String getCellToolTipValue(Grid grid, int n, int n2) {
        Object object = this.getCellToolTipData(grid, n, n2);
        if (object == null) {
            return null;
        }
        if (!this.shouldDisplay(grid, object, n, n2)) {
            return null;
        }
        if (object instanceof String) {
            return (String)object;
        }
        return null;
    }

    public Object getCellToolTipData(Grid grid, int n, int n2) {
        Object object = null;
        TwoDModel twoDModel = grid.getModel();
        if (twoDModel != null) {
            object = twoDModel.getData(n, n2);
            Painter painter = grid.getColumnPainter(n);
            if (painter instanceof FormatPainter && object != null) {
                object = ((FormatPainter)painter).getFormat().format(object);
            }
        }
        return object;
    }

    protected boolean shouldDisplay(Grid grid, Object object, int n, int n2) {
        BorderPainter borderPainter;
        int n3 = grid.getColumnPosition(n);
        int n4 = grid.getRowPosition(n2);
        int n5 = grid.getColumnWidth(n);
        int n6 = grid.getRowHeight(n2);
        Point point = grid.getCanvasOrigin();
        Dimension dimension = grid.getInnerSize();
        Painter painter = grid.getColumnPainter(n);
        Appearance appearance = grid.getAppearanceManager().getCellPaintingAppearance(n, n2);
        ImmInsets immInsets = appearance.getInsets();
        PaintContext paintContext = grid.getCellPaintContext(n, n2);
        Dimension dimension2 = painter.getPreferredSize(paintContext);
        if (immInsets != null) {
            dimension2.width += immInsets.left + immInsets.right;
        }
        if ((borderPainter = appearance.getBorderPainter()) != null && (immInsets = borderPainter.getInsets(paintContext)) != null) {
            dimension2.width += immInsets.left + immInsets.right;
        }
        return dimension2.width > n5 || dimension2.height > n6 || -point.x > n3 || -point.y > n4 || -point.x + dimension.width < n3 + n5 || -point.y + dimension.height < n4 + n6;
    }
}

