/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.ewt.grid;

import javax.swing.UIManager;
import javax.swing.plaf.UIResource;
import oracle.bali.ewt.graphics.Appearance;
import oracle.bali.ewt.grid.AppearanceManager;
import oracle.bali.ewt.grid.Grid;
import oracle.bali.ewt.model.ArrayOneDModel;
import oracle.bali.ewt.model.ArrayTwoDModel;
import oracle.bali.ewt.model.TwoDModelEvent;
import oracle.bali.ewt.model.TwoDModelListener;

public class ComplexAppearanceManager
implements AppearanceManager {
    private Grid _grid;
    private int _columnCount;
    private int _rowCount;
    private ArrayOneDModel _rows;
    private ArrayOneDModel _columns;
    private ArrayTwoDModel _cells;
    private Appearance _appearance;
    private GeometryChangeListener _listener;

    public void setGrid(Grid grid) {
        this._columns = null;
        this._rows = null;
        this._cells = null;
        this._grid = grid;
        this._columnCount = grid == null ? 0 : this._grid.getColumnCount();
        this._rowCount = grid == null ? 0 : this._grid.getRowCount();
    }

    public Appearance getCellPaintingAppearance(int n, int n2) {
        Object object = null;
        if (this._cells != null) {
            object = this._cells.getData(n, n2);
        }
        if (object == null && this._columns != null) {
            object = this._columns.getData(n);
        }
        if (object == null && this._rows != null) {
            object = this._rows.getData(n2);
        }
        if (object != null) {
            return (Appearance)object;
        }
        return this._getAppearance();
    }

    public Appearance getAppearance() {
        return this._getAppearance().copy();
    }

    public void setAppearance(Appearance appearance) {
        this._appearance = appearance.copy();
        if (this._grid != null) {
            this._grid.repaint();
        }
    }

    public Appearance getColumnAppearance(int n) {
        Object object;
        if (this._columns != null && (object = this._columns.getData(n)) != null) {
            return ((Appearance)object).copy();
        }
        return this.getAppearance();
    }

    public void setColumnAppearance(int n, Appearance appearance) {
        if (this._columns == null) {
            this._columns = new ArrayOneDModel(this._columnCount);
        }
        if (appearance != null) {
            appearance = appearance.copy();
        }
        this._columns.setData(n, appearance);
        if (this._grid != null) {
            this._grid.repaintColumn(n);
        }
    }

    public Appearance getRowAppearance(int n) {
        Object object;
        if (this._rows != null && (object = this._rows.getData(n)) != null) {
            return ((Appearance)object).copy();
        }
        return this.getAppearance();
    }

    public void setRowAppearance(int n, Appearance appearance) {
        if (this._rows == null) {
            this._rows = new ArrayOneDModel(this._rowCount);
        }
        if (appearance != null) {
            appearance = appearance.copy();
        }
        this._rows.setData(n, appearance);
        if (this._grid != null) {
            this._grid.repaintRow(n);
        }
    }

    public Appearance getCellAppearance(int n, int n2) {
        Appearance appearance = this.getCellPaintingAppearance(n, n2);
        if (appearance != null) {
            appearance = appearance.copy();
        }
        return appearance;
    }

    public void setCellAppearance(int n, int n2, Appearance appearance) {
        if (this._cells == null) {
            this._cells = new ArrayTwoDModel(this._columnCount, this._rowCount);
        }
        if (appearance != null) {
            appearance = appearance.copy();
        }
        this._cells.setData(n, n2, appearance);
        if (this._grid != null) {
            this._grid.repaintCell(n, n2);
        }
    }

    public TwoDModelListener getTwoDModelListener() {
        if (this._listener == null) {
            this._listener = new GeometryChangeListener();
        }
        return this._listener;
    }

    public void rowsAdded(int n, int n2) {
        if (this._rows != null) {
            this._rows.addItems(n, n2);
        }
        if (this._cells != null) {
            this._cells.addRows(n, n2);
        }
        this._rowCount += n2;
    }

    public void rowsRemoved(int n, int n2) {
        if (this._rows != null) {
            this._rows.removeItems(n, n2);
        }
        if (this._cells != null) {
            this._cells.removeRows(n, n2);
        }
        this._rowCount -= n2;
    }

    public void columnsAdded(int n, int n2) {
        if (this._columns != null) {
            this._columns.addItems(n, n2);
        }
        if (this._cells != null) {
            this._cells.addColumns(n, n2);
        }
        this._columnCount += n2;
    }

    public void columnsRemoved(int n, int n2) {
        if (this._columns != null) {
            this._columns.removeItems(n, n2);
        }
        if (this._cells != null) {
            this._cells.removeColumns(n, n2);
        }
        this._columnCount -= n2;
    }

    public void updateUI() {
        if (this._appearance instanceof UIResource) {
            this._appearance = null;
        }
    }

    private Appearance _getAppearance() {
        if (this._appearance == null) {
            this._appearance = this._createAppearance();
        }
        return this._appearance;
    }

    private Appearance _createAppearance() {
        return (Appearance)UIManager.get("Grid.DefaultAppearance");
    }

    private class GeometryChangeListener
    implements TwoDModelListener {
        private GeometryChangeListener() {
        }

        public void rowsAdded(TwoDModelEvent twoDModelEvent) {
            int n = twoDModelEvent.getRowStartIndex();
            int n2 = twoDModelEvent.getRowCount();
            ComplexAppearanceManager.this.rowsAdded(n, n2);
        }

        public void rowsRemoved(TwoDModelEvent twoDModelEvent) {
            int n = twoDModelEvent.getRowStartIndex();
            int n2 = twoDModelEvent.getRowCount();
            ComplexAppearanceManager.this.rowsRemoved(n, n2);
        }

        public void invalidateRows(TwoDModelEvent twoDModelEvent) {
        }

        public void columnsAdded(TwoDModelEvent twoDModelEvent) {
            int n = twoDModelEvent.getColumnStartIndex();
            int n2 = twoDModelEvent.getColumnCount();
            ComplexAppearanceManager.this.columnsAdded(n, n2);
        }

        public void columnsRemoved(TwoDModelEvent twoDModelEvent) {
            int n = twoDModelEvent.getColumnStartIndex();
            int n2 = twoDModelEvent.getColumnCount();
            ComplexAppearanceManager.this.columnsRemoved(n, n2);
        }

        public void invalidateColumns(TwoDModelEvent twoDModelEvent) {
        }

        public void invalidateCells(TwoDModelEvent twoDModelEvent) {
        }
    }
}

