/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.ewt.graphics;

import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.image.ImageObserver;
import oracle.bali.ewt.graphics.HitTestMask;
import oracle.bali.ewt.graphics.ImageLoader;
import oracle.bali.ewt.graphics.ImageSet;
import oracle.bali.ewt.graphics.ImageUtils;
import oracle.bali.ewt.graphics.TransparencyTester;

public class SynthesizingImageSet
implements ImageSet {
    private static final int _COMPUTING_TRANSPARENCY = -1;
    private static final int _IS_NOT_TRANSPARENT = 0;
    private static final int _IS_TRANSPARENT = 1;
    private transient boolean _imageLoaded;
    private transient int _width;
    private transient int _height;
    private transient Image[] _images = new Image[64];
    private transient int _isTransparent = -1;
    private transient HitTestMask _hitTester;
    private int _synthMask;

    public SynthesizingImageSet(Image image) {
        this(image, 63);
    }

    public SynthesizingImageSet(Image image, int n) {
        if (image == null) {
            throw new IllegalArgumentException();
        }
        this._images[0] = image;
        this._synthMask = n;
    }

    public Dimension getSize() {
        this._loadImageIfNecessary();
        return new Dimension(this._width, this._height);
    }

    public void paintImage(int n, Graphics graphics, int n2, int n3, ImageObserver imageObserver) {
        this._loadImageIfNecessary();
        graphics.drawImage(this._getImage(n), n2, n3, imageObserver);
    }

    public boolean contains(int n, int n2) {
        if (n >= 0 && n2 >= 0 && n < this._width && n2 < this._height) {
            if (this.isTransparent()) {
                if (this._hitTester == null) {
                    this._hitTester = new HitTestMask(this._images[0]);
                }
                return this._hitTester.contains(n, n2);
            }
            return true;
        }
        return false;
    }

    public boolean isTransparent() {
        if (this._isTransparent == -1) {
            TransparencyTester transparencyTester = new TransparencyTester(this._images[0]);
            this._isTransparent = transparencyTester.isTransparent() ? 1 : 0;
        }
        return this._isTransparent != 0;
    }

    public int getAvailableImageFlags() {
        return this._synthMask;
    }

    private Image _getImage(int n) {
        Image image = this._images[n];
        if (image == null) {
            int n2 = n & this._synthMask;
            image = this._images[n2];
            if (image == null) {
                image = this._images[0];
                if ((n2 & 1) != 0) {
                    image = ImageUtils.createDisabledImage(image);
                }
            }
            this._images[n] = image;
        }
        return image;
    }

    private void _loadImageIfNecessary() {
        if (!this._imageLoaded) {
            Image image = this._images[0];
            ImageLoader imageLoader = new ImageLoader(image);
            imageLoader.start();
            this._imageLoaded = imageLoader.waitFor();
            this._width = image.getWidth(imageLoader);
            this._height = image.getHeight(imageLoader);
        }
    }
}

