/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.ewt.graphics;

import java.awt.Color;

public class ColorUtils {
    public static final double NTSC_WEIGHT_RED = 0.299;
    public static final double NTSC_WEIGHT_GREEN = 0.587;
    public static final double NTSC_WEIGHT_BLUE = 0.144;
    public static final int DEFAULT_LIGHTER_CHANGE = 51;
    private static final int _LIGHT_LUMINANCE = 229;
    private static final int _DARK_LUMINANCE = 51;

    public static int getApproximateLuminance(Color color) {
        return (color.getRed() >> 2) + (color.getGreen() >> 1) + (color.getBlue() >> 2);
    }

    public static double getNTSCLuminance(Color color) {
        return (double)color.getRed() * 0.299 + (double)color.getGreen() * 0.587 + (double)color.getBlue() * 0.144;
    }

    public static Color shadeColor(Color color, int n) {
        int n2;
        if (n < -255 || n > 255) {
            throw new IllegalArgumentException();
        }
        int n3 = ColorUtils.getApproximateLuminance(color);
        if (n > 0) {
            n2 = n3 > 229 ? -n >> 1 : (n3 < 51 ? n + (n >> 2) : n);
        } else if (n3 < 51) {
            n2 = -n >> 1;
            n2 += n2 >> 1;
        } else {
            n2 = n;
        }
        if (n2 < 0) {
            return new Color(ColorUtils._darkenComponent(color.getRed(), n2), ColorUtils._darkenComponent(color.getGreen(), n2), ColorUtils._darkenComponent(color.getBlue(), n2));
        }
        return new Color(ColorUtils._lightenComponent(color.getRed(), n2), ColorUtils._lightenComponent(color.getGreen(), n2), ColorUtils._lightenComponent(color.getBlue(), n2));
    }

    public static final Color lighterShadeColor(Color color) {
        return ColorUtils.shadeColor(color, 51);
    }

    public static final Color darkerShadeColor(Color color) {
        return ColorUtils.shadeColor(color, -51);
    }

    public static Color cmyToColor(int n, int n2, int n3) {
        int n4 = (int)((double)(100 - n) * 2.55);
        int n5 = (int)((double)(100 - n2) * 2.55);
        int n6 = (int)((double)(100 - n3) * 2.55);
        return new Color(n4, n5, n6);
    }

    public static Color hsbToColor(double d, double d2, double d3) {
        if (d > 360.0 || d < 0.0 || d2 > 100.0 || d2 < 0.0 || d3 > 100.0 || d3 < 0.0) {
            throw new IllegalArgumentException("Invalid input value");
        }
        return Color.getHSBColor((float)d / 360.0f, (float)d2 / 100.0f, (float)d3 / 100.0f);
    }

    public static Color hslToColor(double d, double d2, double d3) {
        if (d > 360.0 || d < 0.0 || d2 > 100.0 || d2 < 0.0 || d3 > 100.0 || d3 < 0.0) {
            throw new IllegalArgumentException("Invalid input value");
        }
        int[] nArray = ColorUtils.hslToRGB(d, d2, d3);
        return new Color(nArray[0], nArray[1], nArray[2]);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static Color htmlToColor(String string) {
        int n = 0;
        int n2 = string.length() - 1;
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        if (string == null || string.length() == 0) {
            return new Color(n3, n5, n4);
        }
        if (string.charAt(n) == '\'') {
            if (string.charAt(n2) != '\'') throw new IllegalArgumentException("Invalid input syntax");
            ++n;
            --n2;
        } else if (string.charAt(n) == '\"') {
            if (string.charAt(n2) != '\"') throw new IllegalArgumentException("Invalid input syntax");
            ++n;
            --n2;
        } else if (string.charAt(n) == '#') {
            ++n;
        }
        switch (n2 - n) {
            case 4: {
                string = new StringBuffer(string).insert(++n2, '0').toString();
            }
            case 5: {
                n4 = Integer.parseInt(string.substring(--n2, 2 + n2--), 16);
            }
            case 3: {
                n5 = Integer.parseInt(string.substring(--n2, 2 + n2--), 16);
                n3 = Integer.parseInt(string.substring(--n2, 2 + n2--), 16);
                return new Color(n3, n5, n4);
            }
            case 2: {
                n4 = Integer.parseInt(string.substring(n2, 1 + n2--), 16);
            }
            case 1: {
                n5 = Integer.parseInt(string.substring(n2, 1 + n2--), 16);
            }
            case 0: {
                n3 = Integer.parseInt(string.substring(n2, 1 + n2--), 16);
                return new Color(n3, n5, n4);
            }
        }
        return new Color(n3, n5, n4);
    }

    public static Color rgbToColor(int n, int n2, int n3) {
        if (n > 255 || n < 0 || n2 > 255 || n2 < 0 || n3 > 255 || n3 < 0) {
            throw new IllegalArgumentException("Invalid input value");
        }
        return new Color(n, n2, n3);
    }

    public static int[] colorToCMY(Color color) {
        int n = color.getRed();
        int n2 = color.getGreen();
        int n3 = color.getBlue();
        int n4 = (int)(100.0 - (double)n / 2.55);
        int n5 = (int)(100.0 - (double)n2 / 2.55);
        int n6 = (int)(100.0 - (double)n3 / 2.55);
        int[] nArray = new int[]{n4, n5, n6};
        return nArray;
    }

    public static double[] colorToHSB(Color color) {
        float[] fArray = null;
        double[] dArray = new double[3];
        fArray = Color.RGBtoHSB(color.getRed(), color.getGreen(), color.getBlue(), fArray);
        dArray[0] = (double)fArray[0] * 360.0;
        dArray[1] = (double)fArray[1] * 100.0;
        dArray[2] = (double)fArray[2] * 100.0;
        return dArray;
    }

    public static double[] colorToHSL(Color color) {
        return ColorUtils.rgbToHSL(color.getRed(), color.getGreen(), color.getBlue());
    }

    public static String colorToHTML(Color color) {
        return "#" + Integer.toHexString(color.getRGB()).substring(2);
    }

    public static int[] colorToRGB(Color color) {
        int[] nArray = new int[]{color.getRed(), color.getGreen(), color.getBlue()};
        return nArray;
    }

    public static double[] rgbToHSL(int n, int n2, int n3) {
        double d;
        double d2 = (double)n / 255.0;
        double d3 = (double)n2 / 255.0;
        double d4 = (double)n3 / 255.0;
        double d5 = 0.0;
        double d6 = Math.max(d2, Math.max(d3, d4));
        double d7 = Math.min(d2, Math.min(d3, d4));
        double d8 = (d6 + d7) / 2.0;
        if (d6 == d7) {
            d = 0.0;
            d5 = 0.0;
        } else {
            d = d8 <= 0.5 ? (d6 - d7) / (d6 + d7) : (d6 - d7) / (2.0 - d6 - d7);
            double d9 = d6 - d7;
            if (d2 == d6) {
                d5 = (d3 - d4) / d9;
            } else if (d3 == d6) {
                d5 = 2.0 + (d4 - d2) / d9;
            } else if (d4 == d6) {
                d5 = 4.0 + (d2 - d3) / d9;
            }
            d5 *= 60.0;
            if (d5 < 0.0) {
                d5 += 360.0;
            }
        }
        return new double[]{d5, d * 100.0, d8 * 100.0};
    }

    public static int[] hslToRGB(double d, double d2, double d3) {
        int n;
        int n2;
        int n3;
        d3 /= 100.0;
        if ((d2 /= 100.0) == 0.0) {
            n2 = n3 = (int)d3 * 255;
            n = n3;
        } else {
            n3 = 0;
            n2 = 0;
            n = 0;
            double d4 = d3 <= 0.5 ? d3 * (1.0 + d2) : d3 + d2 + d3 * d2;
            double d5 = 2.0 * d3 - d4;
            n = Math.max(0, Math.min(255, (int)(ColorUtils._getValue(d5, d4, d + 120.0) * 255.0)));
            n2 = Math.max(0, Math.min(255, (int)(ColorUtils._getValue(d5, d4, d) * 255.0)));
            n3 = Math.max(0, Math.min(255, (int)(ColorUtils._getValue(d5, d4, d - 120.0) * 255.0)));
        }
        int[] nArray = new int[]{n, n2, n3};
        return nArray;
    }

    private static double _getValue(double d, double d2, double d3) {
        if (d3 > 360.0) {
            d3 -= 360.0;
        } else if (d3 < 0.0) {
            d3 += 360.0;
        }
        if (d3 < 60.0) {
            return d + (d2 - d) * d3 / 60.0;
        }
        if (d3 < 180.0) {
            return d2;
        }
        if (d3 < 240.0) {
            return d + (d2 - d) * (240.0 - d3) / 60.0;
        }
        return d;
    }

    private static final int _darkenComponent(int n, int n2) {
        int n3 = n + n2;
        if (n3 < 0) {
            n3 = 0;
        }
        return n3;
    }

    private static final int _lightenComponent(int n, int n2) {
        int n3 = n + n2;
        if (n3 > 255) {
            n3 = 255;
        }
        return n3;
    }
}

