/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.ewt.geometry;

import oracle.bali.ewt.geometry.AbstractGeometryManager;
import oracle.bali.share.collection.Range;

public class GeneralGeometryManager
extends AbstractGeometryManager {
    private int[] _itemPositions;
    private int[] _itemSizes;
    private int[] _modelToVisible;
    private int[] _visibleToModel;
    private boolean[] _notResizable;
    private int[] _minimumSizes;
    private int[] _maximumSizes;
    private int _items = 0;
    private int _visibleItems = 0;
    private int _itemSize;
    private int _defaultSize;
    private int _defaultMinimumSize = 20;
    private int _defaultMaximumSize = Integer.MAX_VALUE;
    private int _separatorSize;
    private boolean _needsLayout = true;
    private boolean _layingOut;
    private boolean _isDynamic = false;

    public void resetAll(int n) {
        this._items = n;
        this._visibleItems = n;
        this._needsLayout = true;
        this._itemPositions = null;
        this._itemSizes = null;
        this._modelToVisible = null;
        this._visibleToModel = null;
        this._notResizable = null;
        this._minimumSizes = null;
        this._maximumSizes = null;
        this.fireGeometryEvent(2001, -1, -1);
    }

    public int getItemPosition(int n) {
        this.layout();
        if (this._itemPositions == null) {
            if (this._defaultSize == 0) {
                return 0;
            }
            int n2 = n * (this._defaultSize + this._separatorSize);
            return n2;
        }
        return this._itemPositions[n];
    }

    public int getItemAt(int n) {
        this.layout();
        if (n > this._itemSize || n < 0) {
            return -1;
        }
        if (this._itemPositions == null) {
            int n2 = this._defaultSize + this._separatorSize;
            if (n2 == 0) {
                return -1;
            }
            int n3 = n / n2;
            if (n3 < this._items) {
                return n3;
            }
            return this._items - 1;
        }
        int n4 = this._separatorSize;
        int n5 = 0;
        while (n5 < this._items) {
            int n6 = this.visibleIndexToIndex(n5);
            if (this.isItemVisible(n6)) {
                int n7 = this._itemPositions[n6];
                int n8 = this.getItemSize(n6);
                if (n >= n7 && n < n7 + n8 + n4) {
                    return n6;
                }
            }
            ++n5;
        }
        return -1;
    }

    public void setTotalSize(int n) {
    }

    public int getTotalSize() {
        this.layout();
        return this._itemSize;
    }

    public void setDefaultItemSize(int n) {
        this._defaultSize = n;
        this._needsLayout = true;
        this.fireGeometryEvent(2007, -1, n);
    }

    public int getDefaultItemSize() {
        return this._defaultSize;
    }

    public void itemsAdded(int n, int n2) {
        int n3;
        if (this._itemPositions != null) {
            this._itemPositions = this._addToArray(this._itemPositions, n, n2);
        }
        if (this._itemSizes != null) {
            this._itemSizes = this._addToArray(this._itemSizes, n, n2);
            n3 = n;
            while (n3 < n + n2) {
                this._itemSizes[n3] = -1;
                ++n3;
            }
        }
        if (this._modelToVisible != null) {
            this._modelToVisible = null;
            this._visibleToModel = null;
        }
        if (this._minimumSizes != null) {
            this._minimumSizes = this._addToArray(this._minimumSizes, n, n2);
            n3 = n;
            while (n3 < n + n2) {
                this._minimumSizes[n3] = -1;
                ++n3;
            }
        }
        if (this._maximumSizes != null) {
            this._maximumSizes = this._addToArray(this._maximumSizes, n, n2);
            n3 = n;
            while (n3 < n + n2) {
                this._maximumSizes[n3] = -1;
                ++n3;
            }
        }
        if (this._notResizable != null) {
            this._notResizable = this._addToArray(this._notResizable, n, n2);
        }
        this._items += n2;
        this._visibleItems += n2;
        this._needsLayout = true;
    }

    public void itemsRemoved(int n, int n2) {
        if (this._itemPositions != null) {
            this._itemPositions = this._removeFromArray(this._itemPositions, n, n2);
        }
        if (this._itemSizes != null) {
            this._itemSizes = this._removeFromArray(this._itemSizes, n, n2);
        }
        if (this._minimumSizes != null) {
            this._minimumSizes = this._removeFromArray(this._minimumSizes, n, n2);
        }
        if (this._maximumSizes != null) {
            this._maximumSizes = this._removeFromArray(this._maximumSizes, n, n2);
        }
        if (this._notResizable != null) {
            this._notResizable = this._removeFromArray(this._notResizable, n, n2);
        }
        this._items -= n2;
        this._visibleItems = 0;
        int n3 = 0;
        while (n3 < this._items) {
            if (this.isItemVisible(n3)) {
                ++this._visibleItems;
            }
            ++n3;
        }
        if (this._modelToVisible != null) {
            this._modelToVisible = null;
            this._visibleToModel = null;
        }
        this._needsLayout = true;
    }

    public void setItemVisible(int n, boolean bl) {
        this.layout();
        if (this.isItemVisible(n) == bl) {
            return;
        }
        if (this._itemPositions == null) {
            this._createItemPositions();
        }
        if (!bl) {
            this._itemPositions[n] = -1;
            --this._visibleItems;
        } else {
            this._itemPositions[n] = 0;
            ++this._visibleItems;
        }
        this._needsLayout = true;
        this.fireGeometryEvent(2003, n, bl ? 1 : 0);
    }

    public boolean isItemVisible(int n) {
        if (n < 0 || n >= this.getItemCount()) {
            return false;
        }
        this.layout();
        if (this._itemPositions == null) {
            return true;
        }
        return this._itemPositions[n] != -1;
    }

    public void setItemVisibleIndex(int n, int n2) {
        int n3;
        int n4;
        this.layout();
        if (this._visibleToModel == null) {
            if (n == n2) {
                return;
            }
            this._visibleToModel = new int[this._items];
            this._modelToVisible = new int[this._items];
            n4 = 0;
            while (n4 < this._items) {
                this._visibleToModel[n4] = n4;
                this._modelToVisible[n4] = n4;
                ++n4;
            }
            if (this._itemPositions == null) {
                this._createItemPositions();
            }
        }
        if ((n3 = this._modelToVisible[n]) == n2) {
            return;
        }
        if (n3 > n2) {
            n4 = n2;
            int n5 = n3 - n4;
            System.arraycopy(this._visibleToModel, n4, this._visibleToModel, n4 + 1, n5);
        } else {
            n4 = n3 + 1;
            int n6 = n2 - n3;
            System.arraycopy(this._visibleToModel, n4, this._visibleToModel, n4 - 1, n6);
        }
        this._visibleToModel[n2] = n;
        this._updateModelToVisible();
        this._needsLayout = true;
        this.fireGeometryEvent(2004, n, n2);
    }

    public void setItemSize(int n, int n2) {
        n2 = this._constrainSize(n, n2);
        if (this.isResizing() && this.getItemSize(n) == n2) {
            return;
        }
        this.layout();
        if (this._itemSizes == null && n2 == -1) {
            return;
        }
        if (this._itemSizes == null) {
            this._createItemSizes();
        }
        if (n >= 0 && n < this._items) {
            this._itemSizes[n] = n2;
        }
        this._needsLayout = true;
        if (this.isDynamic() || !this.isResizing()) {
            this.fireGeometryEvent(2005, n, n2);
        }
    }

    public int getItemSize(int n) {
        this.layout();
        if (this._itemSizes == null) {
            return this._defaultSize;
        }
        if (n < 0 || n >= this._items) {
            return -1;
        }
        int n2 = this._itemSizes[n];
        return n2 == -1 ? this._defaultSize : n2;
    }

    public int getSeparatorSize() {
        return this._separatorSize;
    }

    public void setSeparatorSize(int n) {
        this._separatorSize = n;
        this._needsLayout = true;
        this.fireGeometryEvent(2006, -1, n);
    }

    public int getVisibleItemCount() {
        return this._visibleItems;
    }

    public int getItemVisibleIndex(int n) {
        if (this._modelToVisible == null) {
            return n;
        }
        return this._modelToVisible[n];
    }

    public int visibleIndexToIndex(int n) {
        if (this._visibleToModel == null) {
            return n;
        }
        return this._visibleToModel[n];
    }

    public Range[] visibleRangesToRanges(Range[] rangeArray) {
        if (this._visibleToModel == null) {
            return rangeArray;
        }
        return super.visibleRangesToRanges(rangeArray);
    }

    public Range[] rangesToVisibleRanges(Range[] rangeArray) {
        if (this._modelToVisible == null) {
            return rangeArray;
        }
        return super.rangesToVisibleRanges(rangeArray);
    }

    public void setItemResizable(int n, boolean bl) {
        if (this._notResizable == null && bl) {
            return;
        }
        if (this._notResizable == null) {
            this._notResizable = new boolean[this.getItemCount()];
        }
        this._notResizable[n] = !bl;
    }

    public boolean isItemResizable(int n) {
        return this._notResizable == null || !this._notResizable[n];
    }

    public void setDefaultMinimumItemSize(int n) {
        this._defaultMinimumSize = n;
    }

    public int getDefaultMinimumItemSize() {
        return this._defaultMinimumSize;
    }

    public void setMinimumItemSize(int n, int n2) {
        if (this._minimumSizes != null || n2 != this.getDefaultMinimumItemSize()) {
            int n3;
            int n4;
            int n5 = this.getItemCount();
            if (this._minimumSizes == null) {
                this._minimumSizes = new int[n5];
                n4 = 0;
                while (n4 < n5) {
                    this._minimumSizes[n4] = -1;
                    ++n4;
                }
            }
            this._minimumSizes[n] = n2;
            n4 = this.getItemSize(n);
            if (n2 > n4) {
                this.setItemSize(n, n2);
            }
            if (n2 > (n3 = this.getMaximumItemSize(n))) {
                this.setMaximumItemSize(n, n2);
            }
        }
    }

    public int getMinimumItemSize(int n) {
        int n2;
        int n3 = n2 = this._minimumSizes != null ? this._minimumSizes[n] : -1;
        if (n2 == -1) {
            n2 = this.getDefaultMinimumItemSize();
        }
        return n2;
    }

    public void setDefaultMaximumItemSize(int n) {
        this._defaultMaximumSize = n;
    }

    public int getDefaultMaximumItemSize() {
        return this._defaultMaximumSize;
    }

    public void setMaximumItemSize(int n, int n2) {
        if (this._maximumSizes != null || n2 != this.getDefaultMaximumItemSize()) {
            int n3;
            int n4;
            int n5 = this.getItemCount();
            if (this._maximumSizes == null) {
                this._maximumSizes = new int[n5];
                n4 = 0;
                while (n4 < n5) {
                    this._maximumSizes[n4] = -1;
                    ++n4;
                }
            }
            this._maximumSizes[n] = n2;
            n4 = this.getItemSize(n);
            if (n2 < n4) {
                this.setItemSize(n, n2);
            }
            if (n2 < (n3 = this.getMinimumItemSize(n))) {
                this.setMinimumItemSize(n, n2);
            }
        }
    }

    public int getMaximumItemSize(int n) {
        int n2;
        int n3 = n2 = this._maximumSizes != null ? this._maximumSizes[n] : -1;
        if (n2 == -1) {
            n2 = this.getDefaultMaximumItemSize();
        }
        return n2;
    }

    public boolean isDynamic() {
        return this._isDynamic;
    }

    public void setDynamic(boolean bl) {
        this._isDynamic = bl;
    }

    private int[] _addToArray(int[] nArray, int n, int n2) {
        int n3 = nArray.length;
        int[] nArray2 = new int[n3 + n2];
        if (n != 0) {
            System.arraycopy(nArray, 0, nArray2, 0, n);
        }
        if (n != n3) {
            System.arraycopy(nArray, n, nArray2, n + n2, n3 - n);
        }
        return nArray2;
    }

    private int[] _removeFromArray(int[] nArray, int n, int n2) {
        int n3 = nArray.length;
        int[] nArray2 = new int[n3 - n2];
        if (n != 0) {
            System.arraycopy(nArray, 0, nArray2, 0, n);
        }
        if (n3 - n2 != n) {
            System.arraycopy(nArray, n + n2, nArray2, n, n3 - (n + n2));
        }
        return nArray2;
    }

    private boolean[] _addToArray(boolean[] blArray, int n, int n2) {
        int n3 = blArray.length;
        boolean[] blArray2 = new boolean[n3 + n2];
        if (n != 0) {
            System.arraycopy(blArray, 0, blArray2, 0, n);
        }
        if (n != n3) {
            System.arraycopy(blArray, n, blArray2, n + n2, n3 - n);
        }
        return blArray2;
    }

    private boolean[] _removeFromArray(boolean[] blArray, int n, int n2) {
        int n3 = blArray.length;
        boolean[] blArray2 = new boolean[n3 - n2];
        if (n != 0) {
            System.arraycopy(blArray, 0, blArray2, 0, n);
        }
        if (n3 - n2 != n) {
            System.arraycopy(blArray, n + n2, blArray2, n, n3 - (n + n2));
        }
        return blArray2;
    }

    private void _updateModelToVisible() {
        int n = 0;
        while (n < this._items) {
            int n2 = this._visibleToModel[n];
            if (n2 >= 0) {
                this._modelToVisible[n2] = n;
            }
            ++n;
        }
    }

    private void _createItemSizes() {
        this._itemSizes = new int[this._items];
        int n = 0;
        while (n < this._items) {
            this._itemSizes[n] = -1;
            ++n;
        }
    }

    private void _createItemPositions() {
        this._itemPositions = new int[this._items];
    }

    protected void layout() {
        if (this._needsLayout && !this._layingOut) {
            this._layingOut = true;
            int n = 0;
            if (this._itemSizes == null && this._itemPositions == null) {
                n = this._defaultSize == 0 ? 0 : (this._defaultSize + this._separatorSize) * this._visibleItems;
            } else {
                if (this._itemPositions == null) {
                    this._createItemPositions();
                }
                int n2 = 0;
                int n3 = this._separatorSize;
                int n4 = 0;
                while (n4 < this._items) {
                    int n5 = this.visibleIndexToIndex(n4);
                    if (!this.isItemVisible(n5)) {
                        this._itemPositions[n5] = -1;
                    } else {
                        this._itemPositions[n5] = n2;
                        n2 += this.getItemSize(n5);
                        n2 += n3;
                    }
                    ++n4;
                }
                n = n2;
            }
            this._itemSize = n;
            this._layingOut = false;
            this._needsLayout = false;
        }
    }

    public int getItemCount() {
        return this._items;
    }

    private int _constrainSize(int n, int n2) {
        if (n2 == -1) {
            return n2;
        }
        int n3 = this.getMinimumItemSize(n);
        int n4 = this.getMaximumItemSize(n);
        if (n2 < n3) {
            return n3;
        }
        if (n2 > n4) {
            return n4;
        }
        return n2;
    }
}

