/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.ewt.geometry;

import oracle.bali.ewt.geometry.AbstractWrappingGeometryManager;
import oracle.bali.ewt.geometry.GeometryEvent;
import oracle.bali.ewt.geometry.GeometryListener;
import oracle.bali.ewt.geometry.GeometryManager;

public class FixedSizeGeometryManager
extends AbstractWrappingGeometryManager {
    public static final int RESIZE_REMAINING = 0;
    public static final int RESIZE_NEXT = 1;
    private int _method;
    private float[] _cachedMinProportions;
    private float[] _cachedMaxProportions;

    public FixedSizeGeometryManager(GeometryManager geometryManager) {
        this(geometryManager, 0);
    }

    public FixedSizeGeometryManager(GeometryManager geometryManager, int n) {
        super(geometryManager);
        this._method = n;
    }

    protected GeometryListener createGeometryListener() {
        return new ListenerAdapter();
    }

    public void setTotalSize(int n) {
        int n2 = this.getTotalSize();
        this._cachedMinProportions = this._cacheMinProportions();
        this._cachedMaxProportions = this._cacheMaxProportions();
        int n3 = this._resize(-1, n);
        this._cachedMinProportions = null;
        this._cachedMaxProportions = null;
        this.fireGeometryEvent(2002, -1, this.getTotalSize());
    }

    public void setItemSize(int n, int n2) {
        int n3;
        int n4 = this.getMinimumItemSize(n);
        if (n2 < n4) {
            n2 = n4;
        }
        if (n2 > (n3 = this.getMaximumItemSize(n))) {
            n2 = n3;
        }
        int n5 = this.getItemVisibleIndex(n);
        if (this._method == 1 && n5 + 1 < this.getVisibleItemCount()) {
            int n6 = this.getItemSize(n);
            int n7 = this.visibleIndexToIndex(n5 + 1);
            int n8 = this.getItemSize(n7);
            int n9 = n6 + n8;
            super.setItemSize(n7, n9 - n2);
            n8 = this.getItemSize(n7);
            super.setItemSize(n, n9 - n8);
        } else {
            if (this._cachedMinProportions == null) {
                this._cachedMinProportions = this._cacheMinProportions();
            }
            if (this._cachedMaxProportions == null) {
                this._cachedMaxProportions = this._cacheMaxProportions();
            }
            int n10 = this.getTotalSize() - this.getItemPosition(n) - n2;
            super.setItemSize(n, n2 -= this._resize(n5, n10));
            if (!this.isResizing()) {
                this._cachedMinProportions = null;
                this._cachedMaxProportions = null;
            }
        }
        this.fireGeometryEvent(2005, n, this.getItemSize(n));
    }

    private float[] _cacheMinProportions() {
        int n;
        int n2 = this.getVisibleItemCount();
        float[] fArray = new float[n2];
        int n3 = 0;
        int n4 = 0;
        while (n4 < n2) {
            n = this.visibleIndexToIndex(n4);
            n3 += this.getItemSize(n) - this.getMinimumItemSize(n);
            ++n4;
        }
        n4 = 0;
        while (n4 < n2) {
            if (n3 == 0) {
                fArray[n4] = 1.0f / (float)n2;
            } else {
                n = this.visibleIndexToIndex(n4);
                fArray[n4] = (float)(this.getItemSize(n) - this.getMinimumItemSize(n)) / (float)n3;
            }
            ++n4;
        }
        return fArray;
    }

    private float[] _cacheMaxProportions() {
        int n;
        int n2 = this.getVisibleItemCount();
        float[] fArray = new float[n2];
        int n3 = 0;
        int n4 = 0;
        while (n4 < n2) {
            n = this.visibleIndexToIndex(n4);
            n3 += this.getMaximumItemSize(n) - this.getItemSize(n);
            ++n4;
        }
        n4 = 0;
        while (n4 < n2) {
            n = this.visibleIndexToIndex(n4);
            fArray[n4] = (float)(this.getMaximumItemSize(n) - this.getItemSize(n)) / (float)n3;
            ++n4;
        }
        return fArray;
    }

    private int _resize(int n, int n2) {
        int n3;
        int n4;
        int n5 = 0;
        int n6 = this.getVisibleItemCount();
        int n7 = n + 1;
        while (n7 < n6) {
            n4 = this.visibleIndexToIndex(n7);
            int n8 = this.getItemSize(n4);
            n5 += n8;
            ++n7;
        }
        if (n5 > n2) {
            int n9;
            int n10;
            int n11 = n5 - n2;
            int n12 = 0;
            n7 = n + 1;
            while (n7 < n6) {
                n4 = this.visibleIndexToIndex(n7);
                if (this.isItemResizable(n4)) {
                    n10 = this.getMinimumItemSize(n4);
                    n9 = this.getItemSize(n4);
                    float f = (float)n11 * this._cachedMinProportions[n7];
                    int n13 = n9 - (int)f;
                    super.setItemSize(n4, n13);
                    n13 = this.getItemSize(n4);
                    n12 += n13;
                }
                ++n7;
            }
            n3 = n12 - n2;
            n10 = 1;
            n7 = n + 1;
            while (n10 != 0 && n3 > 0) {
                n10 = 0;
                while (n7 < n6 && n3 > 0) {
                    n4 = this.visibleIndexToIndex(n7);
                    n9 = this.getItemSize(n4);
                    super.setItemSize(n4, n9 - 1);
                    if (this.getItemSize(n4) != n9) {
                        --n3;
                        n10 = 1;
                    }
                    ++n7;
                }
                n7 = n + 1;
            }
        } else if (n5 < n2) {
            int n14;
            int n15;
            int n16 = n2 - n5;
            int n17 = 0;
            n7 = n + 1;
            while (n7 < n6) {
                n4 = this.visibleIndexToIndex(n7);
                if (this.isItemResizable(n4)) {
                    n15 = this.getMaximumItemSize(n4);
                    n14 = this.getItemSize(n4);
                    int n18 = n14 + (int)((float)n16 * this._cachedMaxProportions[n7]);
                    super.setItemSize(n4, n18);
                    n18 = this.getItemSize(n4);
                    n17 += n18;
                }
                ++n7;
            }
            n3 = n17 - n2;
            n15 = 1;
            n7 = n + 1;
            while (n15 != 0 && n3 < 0) {
                n15 = 0;
                while (n7 < n6 && n3 < 0) {
                    n4 = this.visibleIndexToIndex(n7);
                    n14 = this.getItemSize(n4);
                    super.setItemSize(n4, n14 + 1);
                    if (this.getItemSize(n4) != n14) {
                        ++n3;
                        n15 = 1;
                    }
                    ++n7;
                }
                n7 = n + 1;
            }
        } else {
            n3 = 0;
        }
        return n3;
    }

    private class ListenerAdapter
    implements GeometryListener {
        private ListenerAdapter() {
        }

        public void geometryChanged(GeometryEvent geometryEvent) {
            int n = geometryEvent.getID();
            if (n == 2002 || n == 2005 || n == 2006 || n == 2007) {
                return;
            }
            FixedSizeGeometryManager.this.fireGeometryEvent(n, geometryEvent.getItem(), geometryEvent.getSize());
        }
    }
}

