/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.ewt.elaf.windows;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.util.Enumeration;
import javax.swing.JComponent;
import javax.swing.plaf.ComponentUI;
import oracle.bali.ewt.elaf.basic.BasicEWTShuttleUI;
import oracle.bali.ewt.layout.EqualLayout;
import oracle.bali.ewt.shuttle.Shuttle;

public class WindowsEWTShuttleUI
extends BasicEWTShuttleUI {
    private static WindowsEWTShuttleUI _sInstance = new WindowsEWTShuttleUI();

    public static ComponentUI createUI(JComponent jComponent) {
        return _sInstance;
    }

    public LayoutManager getHorizontalButtonLayout(JComponent jComponent) {
        return new ButtonLayout(this.getComponentGap(jComponent), (Shuttle)jComponent, true);
    }

    public LayoutManager getVerticalButtonLayout(JComponent jComponent) {
        return new ButtonLayout(this.getComponentGap(jComponent), (Shuttle)jComponent, false);
    }

    private class ButtonLayout
    extends EqualLayout {
        private Shuttle _shuttle;
        private boolean _horizontal;

        ButtonLayout(int n, Shuttle shuttle, boolean bl) {
            super(n);
            this._shuttle = shuttle;
            this._horizontal = bl;
        }

        protected Dimension getInsetLayoutSize(Container container, boolean bl) {
            if (this._horizontal) {
                return this._getHorizontalLayoutSize(container, bl);
            }
            return this._getVerticalLayoutSize(container, bl);
        }

        public void layoutContainer(Container container) {
            if (this._horizontal) {
                this._layoutHorizontal(container);
            } else {
                this._layoutVertical(container);
            }
        }

        private Dimension _getHorizontalLayoutSize(Container container, boolean bl) {
            int n = EqualLayout.getNumberVisibleChildren(container);
            Dimension dimension = this.getCellSize(container, bl);
            int n2 = (dimension.height + 1) * n;
            int n3 = n - 1;
            if (this._shuttle.isMoveAllAllowed() && this._shuttle.isMoveAllowed()) {
                n3 -= 2;
            }
            if (n3 < 0) {
                n3 = 0;
            }
            if (n3 > 0) {
                n2 += this.getInteriorGap() * n3;
            }
            return new Dimension(dimension.width, n2 += 2);
        }

        private Dimension _getVerticalLayoutSize(Container container, boolean bl) {
            int n = EqualLayout.getNumberVisibleChildren(container);
            Dimension dimension = this.getCellSize(container, bl);
            dimension.width -= 2;
            int n2 = dimension.width * n;
            int n3 = n - 1;
            if (this._shuttle.isMoveAllAllowed() && this._shuttle.isMoveAllowed()) {
                n3 -= 2;
            }
            if (n3 < 0) {
                n3 = 0;
            }
            if (n3 > 0) {
                n2 += this.getInteriorGap() * n3;
            }
            return new Dimension(n2 += 2, dimension.height);
        }

        private void _layoutHorizontal(Container container) {
            int n;
            int n2 = EqualLayout.getNumberVisibleChildren(container);
            Insets insets = container.getInsets();
            Dimension dimension = container.getSize();
            int n3 = dimension.width;
            int n4 = dimension.height;
            int n5 = EqualLayout.getNumberVisibleChildren(container);
            Dimension dimension2 = this.getCellSize(container, true);
            int n6 = dimension2.height;
            int n7 = n5 - 1;
            if (this._shuttle.isMoveAllAllowed() && this._shuttle.isMoveAllowed()) {
                n7 -= 2;
            }
            if (n7 < 0) {
                n7 = 0;
            }
            Dimension dimension3 = this.getCellSize(container, true);
            if (n6 > dimension3.height) {
                n6 = dimension3.height;
            }
            if ((n = n3 - insets.left - insets.right) > dimension3.width) {
                n = dimension3.width;
            }
            int n8 = insets.top;
            int n9 = (n6 - 2) * n5;
            if (n5 > 1) {
                n9 += this.getInteriorGap() * n7;
            }
            int n10 = this.getPerpendicularAlignment();
            Enumeration enumeration = this.getComponentEnumeration(container);
            int n11 = 0;
            while (enumeration.hasMoreElements()) {
                Component component = (Component)enumeration.nextElement();
                if (component.isVisible()) {
                    int n12 = insets.left;
                    if (n10 != 0) {
                        n12 = n10 == 2 ? n3 - insets.right - n : (n12 += n3 - insets.left - insets.right - n >> 1);
                    }
                    component.setBounds(n12, n8, n, n6);
                    n8 += n6 + 1;
                    if (!this._shuttle.isMoveAllAllowed() || !this._shuttle.isMoveAllowed() || n11 != 0 && n11 != n2 - 2) {
                        n8 += this.getInteriorGap();
                    }
                }
                ++n11;
            }
        }

        private void _layoutVertical(Container container) {
            int n;
            int n2 = EqualLayout.getNumberVisibleChildren(container);
            Insets insets = container.getInsets();
            Dimension dimension = container.getSize();
            int n3 = dimension.width;
            int n4 = dimension.height;
            int n5 = EqualLayout.getNumberVisibleChildren(container);
            Dimension dimension2 = this.getCellSize(container, true);
            int n6 = dimension2.width;
            int n7 = n5 - 1;
            if (this._shuttle.isMoveAllAllowed() && this._shuttle.isMoveAllowed()) {
                n7 -= 2;
            }
            if (n7 < 0) {
                n7 = 0;
            }
            Dimension dimension3 = this.getCellSize(container, true);
            if (n6 > dimension3.width) {
                n6 = dimension3.width;
            }
            if ((n = n4 - insets.top - insets.bottom) > dimension3.height) {
                n = dimension3.height;
            }
            int n8 = insets.left;
            int n9 = (n6 - 2) * n5;
            if (n5 > 1) {
                n9 += this.getInteriorGap() * n7;
            }
            int n10 = this.getPerpendicularAlignment();
            Enumeration enumeration = this.getComponentEnumeration(container);
            int n11 = 0;
            while (enumeration.hasMoreElements()) {
                Component component = (Component)enumeration.nextElement();
                if (component.isVisible()) {
                    int n12 = insets.top;
                    if (n10 != 0) {
                        n12 = n10 == 2 ? n4 - insets.bottom - n : (n12 += n4 - insets.top - insets.bottom - n >> 1);
                    }
                    component.setBounds(n8, n12, n6, n);
                    n8 += n6 - 2;
                    if (!this._shuttle.isMoveAllAllowed() || !this._shuttle.isMoveAllowed() || n11 != 0 && n11 != n2 - 2) {
                        n8 += this.getInteriorGap();
                    }
                }
                ++n11;
            }
        }
    }
}

