/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.ewt.elaf.windows;

import com.sun.java.swing.plaf.windows.WindowsButtonUI;
import java.awt.Color;
import java.awt.Image;
import java.awt.Insets;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.plaf.BorderUIResource;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.UIResource;
import oracle.bali.ewt.border.BorderAdapter;
import oracle.bali.ewt.drawer.Drawer;
import oracle.bali.ewt.elaf.EWTDrawerUI;
import oracle.bali.ewt.elaf.basic.BasicUIUtils;
import oracle.bali.ewt.elaf.basic.DrawerBorderPainter;
import oracle.bali.ewt.elaf.basic.WhiteFilter;
import oracle.bali.ewt.graphics.ImageUtils;
import oracle.bali.ewt.painter.FilledRectPainter;
import oracle.bali.ewt.painter.FixedBorderPainter;
import oracle.bali.ewt.painter.FixedColorPainter;
import oracle.bali.ewt.painter.FixedImagePainter;
import oracle.bali.ewt.painter.InnerEdgeBorderPainterJoiner;
import oracle.bali.ewt.painter.PainterStacker;

public class WindowsEWTDrawerUI
extends WindowsButtonUI
implements EWTDrawerUI {
    private Border _outerBorder;
    private static Border[] _sBorders = new Border[4];
    private static Image[] _sArrowImages = new Image[4];

    public static ComponentUI createUI(JComponent jComponent) {
        return new WindowsEWTDrawerUI();
    }

    public void installUI(JComponent jComponent) {
        super.installUI(jComponent);
        this._outerBorder = UIManager.getBorder("Button.border");
        Border border = jComponent.getBorder();
        if (border == null || border instanceof UIResource) {
            jComponent.setBorder(this.getBorder(jComponent));
        }
    }

    public Border getDrawerBorder(JComponent jComponent) {
        int n = WindowsEWTDrawerUI.getOrientation(jComponent);
        return DrawerBorderPainter.getDrawerBorder(n);
    }

    public JButton getPopUpArrowButton(JComponent jComponent) {
        int n = (WindowsEWTDrawerUI.getOrientation(jComponent) + 1) % 4 + 1;
        Image image = WindowsEWTDrawerUI.getArrowImage(n);
        JButton jButton = new JButton(new ImageIcon(image));
        jButton.setBackground(Color.black);
        jButton.setBorder(null);
        jButton.setMargin(new Insets(1, 1, 1, 1));
        jButton.setHorizontalAlignment(2);
        jButton.setVerticalAlignment(1);
        return jButton;
    }

    public Border getBorder(JComponent jComponent) {
        int n = WindowsEWTDrawerUI.getOrientation(jComponent);
        int n2 = n - 1;
        Border border = _sBorders[n2];
        if (border == null) {
            int n3;
            PainterStacker painterStacker = new PainterStacker(new FixedColorPainter(FilledRectPainter.getPainter(), Color.black), new FixedImagePainter(WindowsEWTDrawerUI.getArrowImage(n), 0));
            switch (n) {
                case 2: {
                    n3 = 3;
                    break;
                }
                case 4: {
                    n3 = 0;
                    break;
                }
                case 3: {
                    n3 = 2;
                    break;
                }
                default: {
                    n3 = 1;
                }
            }
            InnerEdgeBorderPainterJoiner innerEdgeBorderPainterJoiner = new InnerEdgeBorderPainterJoiner(null, null, new FixedBorderPainter(painterStacker, -1, -3, -1, -3), n3);
            border = new BorderAdapter(innerEdgeBorderPainterJoiner);
            WindowsEWTDrawerUI._sBorders[n2] = border = new BorderUIResource.CompoundBorderUIResource(this._outerBorder, border);
        }
        return border;
    }

    protected static int getOrientation(JComponent jComponent) {
        return ((Drawer)jComponent).getOrientation();
    }

    public int getPopUpOverlap(JComponent jComponent) {
        return WindowsEWTDrawerUI.getArrowImage(4).getWidth(null) + 1;
    }

    public int getPerpendicularInsets(JComponent jComponent) {
        return 0;
    }

    protected static Image getArrowImage(int n) {
        Image image = _sArrowImages[n - 1];
        if (image == null) {
            image = BasicUIUtils.getArrow(n);
            WindowsEWTDrawerUI._sArrowImages[n - 1] = image = ImageUtils.createFilteredImage(image, new WhiteFilter());
        }
        return image;
    }

    protected String getPropertyPrefix() {
        return "EWTDrawer.";
    }

    protected WindowsEWTDrawerUI() {
    }
}

