/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.ewt.elaf.oracle;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Shape;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JComponent;
import javax.swing.UIDefaults;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.UIResource;
import oracle.bali.ewt.dateEditor.DateEditor;
import oracle.bali.ewt.elaf.EWTDateEditorUI;
import oracle.bali.ewt.elaf.basic.BasicEWTSpinnerUI;
import oracle.bali.ewt.elaf.basic.DateEditorPainter;
import oracle.bali.ewt.elaf.basic.DateEditorUtils;
import oracle.bali.ewt.elaf.oracle.OracleEWTSpinnerUI;
import oracle.bali.ewt.olaf.OracleUIUtils;
import oracle.bali.ewt.painter.FixedBorderPainter;
import oracle.bali.ewt.painter.Painter;
import oracle.bali.ewt.painter.TextPainter;
import oracle.bali.ewt.plaf.DisablingPainter;
import oracle.bali.ewt.util.ImmInsets;

public class OracleEWTDateEditorUI
extends OracleEWTSpinnerUI
implements EWTDateEditorUI {
    private static final int _GAP = 1;
    private static Painter _sTextPainter;
    private static Painter _sSelectionPainter;
    private static OracleEWTDateEditorUI _sInstance;
    private static Painter _sBasicTextPainter;
    private static final BackGroundChangeListener _BACKGROUND_CHANGE_LISTENER;

    private OracleEWTDateEditorUI() {
    }

    public void installUI(JComponent jComponent) {
        super.installUI(jComponent);
        jComponent.addPropertyChangeListener(_BACKGROUND_CHANGE_LISTENER);
    }

    public void uninstallUI(JComponent jComponent) {
        super.uninstallUI(jComponent);
        jComponent.removePropertyChangeListener(_BACKGROUND_CHANGE_LISTENER);
    }

    public static ComponentUI createUI(JComponent jComponent) {
        if (_sInstance == null) {
            _sInstance = new OracleEWTDateEditorUI();
        }
        return _sInstance;
    }

    public Painter getTextPainter(JComponent jComponent) {
        if (_sTextPainter == null) {
            _sTextPainter = new DisablingPainter(_sBasicTextPainter, true);
        }
        return _sTextPainter;
    }

    public Painter getSelectionTextPainter(JComponent jComponent) {
        if (_sSelectionPainter == null) {
            _sSelectionPainter = new DateEditorPainter(_sBasicTextPainter);
        }
        return _sSelectionPainter;
    }

    public Dimension getPreferredSize(JComponent jComponent) {
        DateEditor dateEditor = (DateEditor)jComponent;
        Component component = BasicEWTSpinnerUI.getSpinButton(dateEditor);
        Dimension dimension = component.getPreferredSize();
        Dimension dimension2 = DateEditorUtils.getPreferredSize(dateEditor, this);
        ImmInsets immInsets = dateEditor.getBorderInsets();
        ImmInsets immInsets2 = this.getSpinButtonInsets(jComponent);
        int n = immInsets.top + immInsets.bottom;
        return new Dimension(dimension.width + dimension2.width + 1 + immInsets.left + immInsets.right + immInsets2.left + immInsets2.right, Math.max(dimension2.height + n, dimension.height + n + immInsets2.top + immInsets2.bottom));
    }

    public Dimension getMinimumSize(JComponent jComponent) {
        DateEditor dateEditor = (DateEditor)jComponent;
        Painter painter = this.getTextPainter(dateEditor);
        Dimension dimension = painter.getMinimumSize(dateEditor.getPaintContext());
        Component component = BasicEWTSpinnerUI.getSpinButton(dateEditor);
        Dimension dimension2 = component.getMinimumSize();
        if (dimension.height < dimension2.height) {
            dimension.height = dimension2.height;
        }
        dimension.width += dimension2.width;
        return dimension;
    }

    public Dimension getMaximumSize(JComponent jComponent) {
        Dimension dimension = this.getPreferredSize(jComponent);
        return dimension;
    }

    public void update(Graphics graphics, JComponent jComponent) {
        DateEditor dateEditor = (DateEditor)jComponent;
        OracleUIUtils.fillBackground(graphics, dateEditor);
        Shape shape = graphics.getClip();
        ImmInsets immInsets = OracleUIUtils.getInsets(dateEditor);
        graphics.setClip(immInsets.left, immInsets.top, dateEditor.getWidth() - (immInsets.left + immInsets.right), dateEditor.getHeight() - (immInsets.top + immInsets.bottom));
        graphics.translate(immInsets.left, immInsets.top);
        dateEditor.paintInterior(graphics);
        graphics.translate(-immInsets.left, -immInsets.top);
        graphics.setClip(shape);
    }

    static {
        _sBasicTextPainter = new FixedBorderPainter(new TextPainter(), 0, 2, 0, 2);
        _BACKGROUND_CHANGE_LISTENER = new BackGroundChangeListener();
    }

    private static class BackGroundChangeListener
    implements PropertyChangeListener {
        private BackGroundChangeListener() {
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            if ("enabled".equals(propertyChangeEvent.getPropertyName())) {
                JComponent jComponent = (JComponent)propertyChangeEvent.getSource();
                boolean bl = Boolean.TRUE.equals(propertyChangeEvent.getNewValue());
                if (jComponent.getBackground() instanceof UIResource) {
                    UIDefaults uIDefaults = OracleUIUtils.getUIDefaults(jComponent);
                    jComponent.setBackground(uIDefaults.getColor(bl ? "EWTSpinner.background" : "control"));
                }
            }
        }
    }
}

