/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.ewt.elaf.oracle;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import javax.swing.UIDefaults;
import oracle.bali.ewt.LookAndFeel;
import oracle.bali.ewt.elaf.EWTBusyBarUI;
import oracle.bali.ewt.elaf.oracle.OracleUIUtils;
import oracle.bali.ewt.graphics.ImageStrip;
import oracle.bali.ewt.olaf.ColorScheme;
import oracle.bali.ewt.olaf.OracleButtonPainter;
import oracle.bali.ewt.painter.AbstractBorderPainter;
import oracle.bali.ewt.painter.PaintContext;
import oracle.bali.ewt.painter.Painter;
import oracle.bali.ewt.util.ImmInsets;

class OracleBusyBarPainter
extends AbstractBorderPainter {
    private static final int _MIN_STATES = 11;
    private static final int _BIG_END_CAP_WIDTH = 7;
    private static final ImageStrip _LARGE_SCANNERS = new ImageStrip(OracleUIUtils.getImage("largeBusyScanStrip.gif"), 1);
    private static final ImageStrip _SMALL_SCANNERS = new ImageStrip(OracleUIUtils.getImage("smallBusyScanStrip.gif"), 1);
    private static final ImageStrip _SMALL_ENDS = new ImageStrip(OracleUIUtils.getImage("smallBusyEndStrip.gif"), 7);
    private static final int _MIN_BUSY_WIDTH = 80;
    private static Dimension _LARGE_SCAN_SIZE = _LARGE_SCANNERS.getSize();
    private static Dimension _SMALL_SCAN_SIZE = _SMALL_SCANNERS.getSize();
    private static Dimension _SMALL_END_SIZE = _SMALL_ENDS.getSize();
    private static final ImmInsets _BIG_INSETS = new ImmInsets(1, 7, 1, 7);
    private static final ImmInsets _SMALL_INSETS = new ImmInsets(1, OracleBusyBarPainter._SMALL_END_SIZE.width, 1, OracleBusyBarPainter._SMALL_END_SIZE.width);

    public OracleBusyBarPainter(Painter painter) {
        super(painter, true);
    }

    public int getRepaintFlags(PaintContext paintContext) {
        return super.getRepaintFlags(paintContext) | 4;
    }

    public Dimension getPreferredSize(PaintContext paintContext) {
        Dimension dimension = super.getPreferredSize(paintContext);
        int n = this._getMinimumHeight(paintContext);
        if (dimension.height < n) {
            dimension.height = n;
        }
        if (dimension.width < 80) {
            dimension.width = 80;
        }
        return dimension;
    }

    public Dimension getMinimumSize(PaintContext paintContext) {
        Dimension dimension = super.getMinimumSize(paintContext);
        int n = this._getMinimumHeight(paintContext);
        if (dimension.height < n) {
            dimension.height = n;
        }
        if (dimension.width < 80) {
            dimension.width = 80;
        }
        return dimension;
    }

    protected ImmInsets getOwnInsets(PaintContext paintContext) {
        if (this._hasContent(paintContext)) {
            return _BIG_INSETS;
        }
        return _SMALL_INSETS;
    }

    protected boolean isBorderTransparent(PaintContext paintContext) {
        return true;
    }

    protected void paintBorder(PaintContext paintContext, Graphics graphics, int n, int n2, int n3, int n4) {
        Color color;
        boolean bl = this._isRunning(paintContext);
        if (!bl) {
            return;
        }
        boolean bl2 = !this._hasContent(paintContext);
        UIDefaults uIDefaults = paintContext.getPaintUIDefaults();
        Color color2 = graphics.getColor();
        Color color3 = uIDefaults.getColor(LookAndFeel.TEXT_HIGHLIGHT);
        Color color4 = color = uIDefaults.getColor(ColorScheme.CONTROL_SHADOW_DARK);
        Color color5 = color;
        Color color6 = color;
        if (bl) {
            color4 = uIDefaults.getColor(ColorScheme.CONTROL_SHADOW_DARK_LIGHT);
            color5 = uIDefaults.getColor(LookAndFeel.CONTROL_LT_HIGHLIGHT);
            color6 = uIDefaults.getColor(LookAndFeel.NORMAL_INTENSITY);
        }
        ImageStrip imageStrip = _LARGE_SCANNERS;
        Dimension dimension = _LARGE_SCAN_SIZE;
        int n5 = OracleBusyBarPainter._BIG_INSETS.left;
        if (bl2) {
            imageStrip = _SMALL_SCANNERS;
            dimension = _SMALL_SCAN_SIZE;
            n5 = OracleBusyBarPainter._SMALL_INSETS.left;
        }
        int n6 = n + n5 + 1;
        int n7 = n + n3 - n5 - 1;
        int n8 = n3 - 2 * n5 - 2;
        int n9 = n8 / 30;
        if (n9 < 11) {
            n9 = 11;
        }
        int n10 = (n8 - dimension.width) / (n9 - 1);
        int n11 = n2 + (n4 - dimension.height) / 2;
        Integer n12 = (Integer)paintContext.getPaintData(EWTBusyBarUI.STATE_KEY);
        int n13 = n12 % n9;
        graphics.setColor(color3);
        graphics.fillRect(n6, n11, n8, dimension.height);
        imageStrip.paintImage(0, graphics, n6 + n13 * n10, n11, null);
        imageStrip.paintImage(1, graphics, n7 - dimension.width - n13 * n10, n11, null);
        graphics.setColor(color4);
        graphics.drawLine(n6, n11 - 1, n6 + n8 - 1, n11 - 1);
        graphics.setColor(color5);
        graphics.drawLine(n6, n11 + dimension.height, n6 + n8 - 1, n11 + dimension.height);
        if (bl2) {
            int n14 = paintContext.getPaintState() & 4 | 2;
            _SMALL_ENDS.paintImage(n14, graphics, n + 1, n11 - 1, null);
            _SMALL_ENDS.paintImage(n14 + 1, graphics, n7, n11 - 1, null);
        } else {
            OracleButtonPainter.drawSideCurve(graphics, color4, color4, color6, color5, color5, color3, n + n5, n11 - 1, n11 + dimension.height, 1);
            OracleButtonPainter.drawSideCurve(graphics, color4, color6, color5, color5, color5, color3, n3 - n5, n11 - 1, n11 + dimension.height, -1);
        }
        graphics.setColor(color2);
    }

    private boolean _hasContent(PaintContext paintContext) {
        String string = (String)paintContext.getPaintData(PaintContext.LABEL_KEY);
        return string != null && string.length() != 0;
    }

    private int _getMinimumHeight(PaintContext paintContext) {
        Dimension dimension = this._hasContent(paintContext) ? _LARGE_SCAN_SIZE : _SMALL_SCAN_SIZE;
        return dimension.height + 2;
    }

    private boolean _isRunning(PaintContext paintContext) {
        return (Boolean)paintContext.getPaintData(EWTBusyBarUI.IS_RUNNING_KEY);
    }
}

