/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.ewt.elaf.basic;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.PrintGraphics;
import java.awt.print.PrinterGraphics;
import javax.swing.UIDefaults;
import oracle.bali.ewt.LookAndFeel;
import oracle.bali.ewt.painter.AbstractPainter;
import oracle.bali.ewt.painter.PaintContext;
import oracle.bali.ewt.painter.Painter;

public class PivotGrippyPainter
extends AbstractPainter {
    private static final int _GRIPPY_SIZE = 3;
    private static final int _GRIPPY_GAP = 4;
    private static final int _GRIPPY_STRIDE = 7;
    private static final int _MIN_GRIPPIES = 3;
    private static final int _MIN_PERP_GRIPPY_SIZE = 5;
    private static final int _MIN_ORIENT_GRIPPY_SIZE = 17;
    private boolean _isHorizontal;
    private static Painter _sVertcialPainter;
    private static Painter _sHorizontalPainter;

    public static Painter getPainter(boolean bl) {
        if (bl) {
            if (_sHorizontalPainter == null) {
                _sHorizontalPainter = new PivotGrippyPainter(true);
            }
            return _sHorizontalPainter;
        }
        if (_sVertcialPainter == null) {
            _sVertcialPainter = new PivotGrippyPainter(false);
        }
        return _sVertcialPainter;
    }

    public Dimension getSize(PaintContext paintContext, int n, int n2) {
        if (this._isHorizontal) {
            if (n > 17) {
                n = 17;
            }
            if (n2 > 5) {
                n2 = 5;
            }
        } else {
            if (n > 5) {
                n = 5;
            }
            if (n2 > 17) {
                n2 = 17;
            }
        }
        return new Dimension(n, n2);
    }

    public Dimension getMinimumSize(PaintContext paintContext) {
        if (this._isHorizontal) {
            return new Dimension(17, 5);
        }
        return new Dimension(5, 17);
    }

    public int getRepaintFlags(PaintContext paintContext) {
        return 135;
    }

    public void paint(PaintContext paintContext, Graphics graphics, int n, int n2, int n3, int n4) {
        boolean bl;
        boolean bl2;
        Color color = graphics.getColor();
        graphics.setColor(paintContext.getPaintBackground());
        graphics.fillRect(n, n2, n3, n4);
        boolean bl3 = graphics instanceof PrintGraphics || graphics instanceof PrinterGraphics;
        int n5 = paintContext.getPaintState();
        boolean bl4 = (n5 & 1) == 0;
        boolean bl5 = bl2 = (n5 & 4) == 0;
        boolean bl6 = bl3 ? false : (bl = bl4 && bl2);
        if (bl) {
            int n6 = 3;
            int n7 = n6 * 3 + (n6 - 1) * 4;
            int n8 = 3;
            int n9 = 3;
            int n10 = 0;
            int n11 = 0;
            if (this._isHorizontal) {
                n8 = n7;
                n10 = 7;
            } else {
                n9 = n7;
                n11 = 7;
            }
            int n12 = n + (n3 - n8) / 2;
            int n13 = n2 + (n4 - n9) / 2;
            UIDefaults uIDefaults = paintContext.getPaintUIDefaults();
            Color color2 = uIDefaults.getColor(LookAndFeel.CONTROL_LT_HIGHLIGHT);
            Color color3 = uIDefaults.getColor(LookAndFeel.CONTROL_SHADOW);
            boolean bl7 = (n5 & 2) != 0;
            while (n6 > 0) {
                PivotGrippyPainter.__drawGrippy(graphics, n12, n13, color2, color3, bl7);
                --n6;
                n12 += n10;
                n13 += n11;
            }
        }
        graphics.setColor(color);
    }

    static void __drawGrippy(Graphics graphics, int n, int n2, Color color, Color color2, boolean bl) {
        graphics.setColor(color);
        graphics.drawLine(n + 1, n2 + 2, n + 2, n2 + 1);
        if (bl) {
            graphics.drawLine(n + 2, n2 + 2, n + 2, n2 + 2);
            n -= 2;
            n2 -= 2;
        } else {
            graphics.drawLine(n + 1, n2 + 1, n + 1, n2 + 1);
        }
        graphics.setColor(color2);
        graphics.drawLine(n + 2, n2 + 3, n + 3, n2 + 2);
    }

    private PivotGrippyPainter(boolean bl) {
        this._isHorizontal = bl;
    }
}

