/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.ewt.elaf.basic;

import java.awt.Dimension;
import java.awt.Graphics;
import javax.swing.JComponent;
import javax.swing.LookAndFeel;
import javax.swing.UIDefaults;
import javax.swing.border.Border;
import javax.swing.plaf.ComponentUI;
import oracle.bali.ewt.elaf.EWTRulerUI;
import oracle.bali.ewt.painter.AbstractBorderPainter;
import oracle.bali.ewt.painter.PaintContext;
import oracle.bali.ewt.plaf.BorderAdapter;
import oracle.bali.ewt.ruler.Ruler;
import oracle.bali.ewt.util.ImmInsets;

public class BasicEWTRulerUI
extends EWTRulerUI {
    private static BasicEWTRulerUI _sInstance;
    private static Border _sBorder;

    private BasicEWTRulerUI() {
    }

    public static ComponentUI createUI(JComponent jComponent) {
        if (_sInstance == null) {
            _sInstance = new BasicEWTRulerUI();
        }
        return _sInstance;
    }

    public void installUI(JComponent jComponent) {
        LookAndFeel.installColors(jComponent, "EWTRuler.background", "EWTRuler.foreground");
        LookAndFeel.installBorder(jComponent, "EWTRuler.border");
        jComponent.setOpaque(true);
    }

    public void uninstallUI(JComponent jComponent) {
        LookAndFeel.uninstallBorder(jComponent);
    }

    public Dimension getMinimumSize(JComponent jComponent) {
        Ruler ruler = (Ruler)jComponent;
        Dimension dimension = jComponent.getPreferredSize();
        if (ruler.getOrientation() == 0) {
            dimension.width = dimension.height;
        } else {
            dimension.height = dimension.width;
        }
        return dimension;
    }

    public static Object instantiate(UIDefaults uIDefaults, Object object, String string) {
        if ("EWTRuler.border".equals(object)) {
            return _sBorder;
        }
        return null;
    }

    static {
        _sBorder = new BorderAdapter(new RulerBorder());
    }

    private static class RulerBorder
    extends AbstractBorderPainter {
        private ImmInsets _hInsets = new ImmInsets(0, 0, 1, 0);
        private ImmInsets _vInsets = new ImmInsets(0, 0, 0, 1);

        private RulerBorder() {
        }

        protected boolean isBorderTransparent(PaintContext paintContext) {
            return false;
        }

        protected void paintBorder(PaintContext paintContext, Graphics graphics, int n, int n2, int n3, int n4) {
            boolean bl = Boolean.TRUE.equals(paintContext.getPaintData("ruler.horizontal"));
            int n5 = n2 + n4 - 1;
            int n6 = n + n3 - 1;
            if (bl) {
                graphics.drawLine(n, n5, n6, n5);
            } else {
                graphics.drawLine(n6, n2, n6, n5);
            }
        }

        protected ImmInsets getOwnInsets(PaintContext paintContext) {
            boolean bl = Boolean.TRUE.equals(paintContext.getPaintData("ruler.horizontal"));
            return bl ? this._hInsets : this._vInsets;
        }
    }
}

