/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.ewt.elaf.basic;

import java.awt.Component;
import java.awt.Container;
import java.awt.Font;
import java.awt.FontMetrics;
import javax.swing.JComponent;
import javax.swing.JScrollPane;
import javax.swing.JViewport;
import javax.swing.UIDefaults;
import javax.swing.UIManager;
import javax.swing.plaf.UIResource;
import oracle.bali.ewt.LookAndFeel;
import oracle.bali.ewt.elaf.EWTGridUI;
import oracle.bali.ewt.elaf.basic.GridImageSetPainter;
import oracle.bali.ewt.elaf.basic.GridSeparator;
import oracle.bali.ewt.elaf.basic.UIResourceAppearance;
import oracle.bali.ewt.graphics.Appearance;
import oracle.bali.ewt.grid.Grid;
import oracle.bali.ewt.painter.BorderPainter;
import oracle.bali.ewt.painter.PaintContext;
import oracle.bali.ewt.painter.Painter;
import oracle.bali.ewt.painter.TruncatingTextPainter;
import oracle.bali.ewt.pivot.PivotGrid;
import oracle.bali.ewt.pivot.PivotHeader;
import oracle.bali.ewt.pivot.PivotScrollPaneView;
import oracle.bali.ewt.pivot.PivotTable;
import oracle.bali.ewt.plaf.GridFocusPainter;
import oracle.bali.ewt.table.SpreadTable;
import oracle.bali.ewt.util.ImmInsets;

public abstract class BasicEWTGridUI
extends EWTGridUI {
    private static Painter _sDefaultPainter;
    private static final ImmInsets _sDefaultInsets;

    protected BasicEWTGridUI() {
    }

    public void installUI(JComponent jComponent) {
        Container container;
        javax.swing.LookAndFeel.installColors(jComponent, "EWTGrid.background", "EWTGrid.foreground");
        Container container2 = jComponent.getParent();
        if (!(container2 != null && (container2 instanceof SpreadTable || container2 instanceof JViewport || container2 instanceof PivotGrid || container2 instanceof PivotTable || container2 instanceof PivotHeader || container2 instanceof PivotScrollPaneView))) {
            javax.swing.LookAndFeel.installBorder(jComponent, "EWTGrid.border");
        } else if (container2 instanceof JViewport && (container = container2.getParent()) instanceof JScrollPane) {
            javax.swing.LookAndFeel.installBorder((JScrollPane)container, "EWTGrid.scrollPaneBorder");
        }
        container = (Grid)jComponent;
        ((JComponent)container).setAlignmentX(0.0f);
        ((JComponent)container).setAlignmentY(0.5f);
        ((JComponent)container).setOpaque(true);
        ((Grid)container).setVerticalSeparatorPainter(GridSeparator.getVerticalSeparator());
        ((Grid)container).setHorizontalSeparatorPainter(GridSeparator.getHorizontalSeparator());
    }

    public void uninstallUI(JComponent jComponent) {
        Container container;
        Grid grid = (Grid)jComponent;
        javax.swing.LookAndFeel.uninstallBorder(jComponent);
        Container container2 = jComponent.getParent();
        if (container2 != null && container2 instanceof JViewport && (container = container2.getParent()) instanceof JScrollPane) {
            javax.swing.LookAndFeel.uninstallBorder((JScrollPane)container);
        }
        if (grid.getDefaultPainter() instanceof UIResource) {
            grid.setDefaultPainter(null);
        }
    }

    public int getDefaultRowHeight(JComponent jComponent) {
        Font font = jComponent.getFont();
        int n = 0;
        if (font != null) {
            FontMetrics fontMetrics = ((Component)jComponent).getFontMetrics(font);
            n = fontMetrics.getHeight() + 3 + 3;
        }
        return n;
    }

    public int getDefaultColumnWidth(JComponent jComponent) {
        Font font = jComponent.getFont();
        int n = 0;
        if (font != null) {
            FontMetrics fontMetrics = ((Component)jComponent).getFontMetrics(font);
            n = fontMetrics.stringWidth("12345678");
        }
        return n;
    }

    public BorderPainter getOverlayBorderPainter(JComponent jComponent) {
        return null;
    }

    public static Object instantiate(UIDefaults uIDefaults, Object object, String string) {
        if ("Grid.DefaultCellPainter".equals(object)) {
            return BasicEWTGridUI._getDefaultPainter();
        }
        if ("Grid.DefaultAppearance".equals(object)) {
            return BasicEWTGridUI._getDefaultAppearance();
        }
        if ("Grid.focusPainter".equals(object)) {
            return GridFocusPainter.getBorderPainter();
        }
        if ("Grid.checkPainter".equals(object)) {
            return new GridImageSetPainter("checkboxSet");
        }
        if ("Grid.radioPainter".equals(object)) {
            return new GridImageSetPainter("radioButtonSet");
        }
        return null;
    }

    private static Painter _getDefaultPainter() {
        if (_sDefaultPainter == null) {
            _sDefaultPainter = new TruncatingTextPainter(PaintContext.LABEL_KEY, false);
        }
        return _sDefaultPainter;
    }

    private static Appearance _getDefaultAppearance() {
        UIDefaults uIDefaults = UIManager.getDefaults();
        UIResourceAppearance uIResourceAppearance = new UIResourceAppearance();
        uIResourceAppearance.setSelectForeground(uIDefaults.getColor(LookAndFeel.TEXT_HIGHLIGHT_TEXT));
        uIResourceAppearance.setSelectBackground(uIDefaults.getColor(LookAndFeel.TEXT_HIGHLIGHT));
        uIResourceAppearance.setInsets(_sDefaultInsets);
        uIResourceAppearance.setVerticalJustify(0);
        uIResourceAppearance.setHorizontalJustify(0);
        return uIResourceAppearance;
    }

    static {
        _sDefaultInsets = new ImmInsets(3, 3, 3, 1);
    }
}

