/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.ewt.elaf;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.UIDefaults;
import javax.swing.UIManager;

public abstract class EWTLookAndFeel {
    private static final String _KEY_INSTALLED = "oracle.bali.ewt.elaf.EWTLookAndFeel.INSTALLED";
    private static boolean _tracking = false;

    public static void installEWTLookAndFeel() throws ClassNotFoundException, InstantiationException, IllegalAccessException {
        UIDefaults uIDefaults = UIManager.getLookAndFeelDefaults();
        if (Boolean.TRUE.equals(uIDefaults.get(_KEY_INSTALLED))) {
            return;
        }
        uIDefaults.put(_KEY_INSTALLED, Boolean.TRUE);
        EWTLookAndFeel eWTLookAndFeel = EWTLookAndFeel.getEWTLookAndFeelByName(UIManager.getLookAndFeel().getName());
        eWTLookAndFeel.installDefaults(uIDefaults);
        if (!_tracking) {
            _tracking = true;
            UIManager.addPropertyChangeListener(new PropertyChangeListener(){

                public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                    try {
                        if ("lookAndFeel".equals(propertyChangeEvent.getPropertyName())) {
                            UIManager.getLookAndFeelDefaults().put(EWTLookAndFeel._KEY_INSTALLED, Boolean.FALSE);
                            EWTLookAndFeel.installEWTLookAndFeel();
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            });
        }
    }

    private static EWTLookAndFeel getEWTLookAndFeelByName(String string) throws ClassNotFoundException, InstantiationException, IllegalAccessException {
        String string2 = "oracle.bali.ewt.elaf.oracle.OracleLookAndFeel";
        if ("Oracle Browser Look and Feel".equals(string)) {
            string2 = "oracle.bali.ewt.elaf.oracle.BrowserLookAndFeel";
        }
        if (string.equals("Windows")) {
            string2 = "oracle.bali.ewt.elaf.windows.WindowsLookAndFeel";
        } else if (string.equals("Metal")) {
            string2 = "oracle.bali.ewt.elaf.windows.WindowsLookAndFeel";
        } else if (string.equals("CDE/Motif")) {
            string2 = "oracle.bali.ewt.elaf.motif.MotifLookAndFeel";
        } else if (string.equals("MacOS")) {
            string2 = "oracle.bali.ewt.elaf.windows.WindowsLookAndFeel";
        }
        return EWTLookAndFeel.getEWTLookAndFeel(string2);
    }

    private static EWTLookAndFeel getEWTLookAndFeel(String string) throws ClassNotFoundException, InstantiationException, IllegalAccessException {
        Class<?> clazz = Class.forName(string);
        return (EWTLookAndFeel)clazz.newInstance();
    }

    protected abstract void installDefaults(UIDefaults var1);
}

