/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.ewt.drawer;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import oracle.bali.ewt.drawer.Drawer;
import oracle.bali.ewt.elaf.EWTDrawerUI;
import oracle.bali.share.thread.Task;
import oracle.bali.share.thread.TaskEvent;
import oracle.bali.share.thread.TaskScheduler;

class DrawerPopup
extends JComponent {
    static TaskScheduler _sTaskScheduler = TaskScheduler.getDefaultTaskScheduler();
    private static final int _SLIDE_OUT_TIME = 200;
    private static final int _STATE_CLOSED = 0;
    private static final int _STATE_OPENING = 1;
    private static final int _STATE_OPEN = 2;
    private transient int _state;
    private transient Slide _slide;
    private transient int _slidingPos;
    private transient int _multiplier;
    private transient boolean _horizontal;
    private transient Image _offscreen;
    private Drawer _parent;
    private JComponent _content;
    private transient JButton _button;

    public DrawerPopup(Drawer drawer) {
        this.setLayout(null);
        this._parent = drawer;
        this._content = new JPanel();
        this._content.setLayout(new BorderLayout(2, 2));
        this.add(this._content);
        this._state = 0;
    }

    public void setContent(Component component) {
        if (this._content.getComponentCount() > 0) {
            this._content.remove(0);
        }
        if (component != null) {
            this._content.add(component, "Center");
            this._fixContentUI();
            if (component instanceof JComponent) {
                ((JComponent)component).setBorder(null);
            }
            this._content.setBackground(component.getBackground());
        }
    }

    public void open() {
        Object object = this.getTreeLock();
        synchronized (object) {
            DrawerPopup drawerPopup = this;
            synchronized (drawerPopup) {
                if (this._state == 0) {
                    this._setUI();
                    this._fillBuffer();
                    if (this._offscreen == null) {
                        this._state = 2;
                    } else {
                        this._state = 1;
                        Dimension dimension = this._content.getSize();
                        Dimension dimension2 = this._button.getSize();
                        Dimension dimension3 = this.getSize();
                        int n = this._parent.getOrientation();
                        switch (n) {
                            case 1: {
                                this._horizontal = false;
                                this._slidingPos = dimension3.height;
                                break;
                            }
                            case 3: {
                                this._horizontal = false;
                                this._slidingPos = dimension2.height - dimension.height;
                                break;
                            }
                            default: {
                                this._horizontal = true;
                                this._slidingPos = dimension2.width - dimension.width;
                                break;
                            }
                            case 2: {
                                this._horizontal = true;
                                this._slidingPos = dimension3.width;
                            }
                        }
                        this._multiplier = n == 2 || n == 1 ? -1 : 1;
                        if (this._slide == null) {
                            this._slide = new Slide();
                        }
                        this._slide.start();
                    }
                }
            }
        }
        if (this._state == 2) {
            this.revalidate();
        }
    }

    public void closeLater() {
        ActionListener actionListener = new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                DrawerPopup.this.close();
            }
        };
        Timer timer = new Timer(200, actionListener);
        timer.setRepeats(false);
        timer.start();
    }

    public void close() {
        Object object = this.getTreeLock();
        synchronized (object) {
            DrawerPopup drawerPopup = this;
            synchronized (drawerPopup) {
                if (this._state != 0) {
                    if (this._state == 1) {
                        this._slide.cancel();
                    }
                    this._state = 0;
                    this._parent.popupClosed();
                    if (this._offscreen != null) {
                        this._offscreen.flush();
                        this._offscreen = null;
                    }
                    this._content.remove(this._button);
                    this._button = null;
                }
            }
        }
    }

    public void paintInterior(Graphics graphics) {
        Image image;
        if (this._state == 1 && (image = this._offscreen) != null) {
            if (this._horizontal) {
                graphics.drawImage(image, this._slidingPos, 0, this);
            } else {
                graphics.drawImage(image, 0, this._slidingPos, this);
            }
        }
    }

    public void doLayout() {
        int n = this._state;
        Dimension dimension = this.getSize();
        Dimension dimension2 = this.getPreferredSize();
        int n2 = this._parent.getOrientation();
        int n3 = dimension.width;
        int n4 = dimension.height;
        switch (this._parent.getOrientation()) {
            default: {
                n4 = Math.max(dimension.height, dimension2.height);
                break;
            }
            case 2: 
            case 4: {
                n3 = Math.max(dimension.width, dimension2.width);
            }
        }
        if (n == 2) {
            int n5 = 0;
            int n6 = 0;
            switch (n2) {
                default: {
                    break;
                }
                case 3: {
                    n6 = dimension.height - n4;
                    break;
                }
                case 4: {
                    n5 = dimension.width - n3;
                }
            }
            this._content.setBounds(n5, n6, n3, n4);
        } else {
            this._content.setBounds(-n3, 0, n3, n4);
        }
    }

    public Dimension getMinimumSize() {
        this._setUI();
        return this._content.getMinimumSize();
    }

    private void _fixContentUI() {
        Component component = this._parent.getContent();
        if (component != null) {
            if (component instanceof JComponent) {
                ((JComponent)component).setBorder(null);
            }
            this._content.setBackground(component.getBackground());
        }
    }

    public Dimension getPreferredSize() {
        this._setUI();
        return this._content.getPreferredSize();
    }

    public void updateComponentTreeUI() {
        SwingUtilities.updateComponentTreeUI(this);
        this._fixContentUI();
    }

    public void updateUI() {
        super.updateUI();
        if (!this.isShowing()) {
            this._button = null;
        }
    }

    boolean slideOnceMore(int n) {
        int n2;
        int n3;
        Dimension dimension = this._content.getSize();
        Dimension dimension2 = this.getSize();
        if (this._horizontal) {
            n3 = dimension2.width - dimension.width;
            n2 = (dimension2.width - n3) * n / 200;
        } else {
            n3 = dimension2.height - dimension.height;
            n2 = (dimension2.height - n3) * n / 200;
        }
        if (n2 == 0) {
            n2 = 1;
        }
        this._slidingPos += this._multiplier * n2;
        if (this._multiplier < 0) {
            n3 = 0;
        }
        if (this._slidingPos * this._multiplier < n3) {
            if (this._horizontal) {
                this._paintBuffer(this._slidingPos, 0);
            } else {
                this._paintBuffer(0, this._slidingPos);
            }
            return true;
        }
        this._state = 2;
        this.revalidate();
        return false;
    }

    private void _paintBuffer(int n, int n2) {
        Image image = this._offscreen;
        if (image != null) {
            Graphics graphics = this.getGraphics();
            try {
                graphics.drawImage(image, n, n2, null);
                Object var6_5 = null;
                graphics.dispose();
            }
            catch (Throwable throwable) {
                Object var6_6 = null;
                graphics.dispose();
                throw throwable;
            }
        }
    }

    private void _setUI() {
        if (this._button == null) {
            String string;
            EWTDrawerUI eWTDrawerUI = this._parent.getEWTDrawerUI();
            int n = this._parent.getOrientation();
            switch (n) {
                case 1: {
                    string = "North";
                    break;
                }
                case 3: {
                    string = "South";
                    break;
                }
                case 2: {
                    string = "West";
                    break;
                }
                default: {
                    string = "East";
                }
            }
            this._button = eWTDrawerUI.getPopUpArrowButton(this._parent);
            this._button.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    DrawerPopup.this.close();
                }
            });
            this._content.add((Component)this._button, string);
            this._content.setBorder(eWTDrawerUI.getDrawerBorder(this._parent));
        }
    }

    private void _fillBuffer() {
        JComponent jComponent = this._content;
        if (this._offscreen != null) {
            this._offscreen.flush();
        }
        Dimension dimension = jComponent.getSize();
        this._offscreen = jComponent.createImage(dimension.width, dimension.height);
        if (this._offscreen != null) {
            Graphics graphics = this._offscreen.getGraphics();
            graphics.setColor(jComponent.getBackground());
            graphics.fillRect(0, 0, dimension.width, dimension.height);
            graphics.setClip(0, 0, dimension.width, dimension.height);
            graphics.setColor(jComponent.getForeground());
            graphics.setFont(jComponent.getFont());
            jComponent.paint(graphics);
        }
    }

    private class Slide
    implements Task {
        private int _count;

        private Slide() {
        }

        public void runTask(TaskEvent taskEvent) {
            if (DrawerPopup.this.slideOnceMore(this._count)) {
                this._count = 1 + (int)taskEvent.getTimeDelta();
                _sTaskScheduler.schedule(this, 1);
            }
        }

        public void start() {
            this._count = 1;
            _sTaskScheduler.schedule(this, 1);
        }

        public void cancel() {
            _sTaskScheduler.cancel(this);
        }
    }
}

