/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.ewt.dnd;

import java.awt.Component;
import java.awt.Cursor;
import java.awt.Image;
import java.awt.Point;
import java.awt.datatransfer.Transferable;
import oracle.bali.ewt.dnd.DragGestureEvent;
import oracle.bali.ewt.dnd.DragGestureListener;
import oracle.bali.ewt.dnd.DragGestureRecognizer;
import oracle.bali.ewt.dnd.DragSourceContext;
import oracle.bali.ewt.dnd.DragSourceListener;
import oracle.bali.ewt.dnd.EWTDragGestureRecognizer;
import oracle.bali.ewt.dnd.InvalidDnDOperationException;

public class DragSource {
    private static Cursor _sHandCursor = Cursor.getPredefinedCursor(12);
    private static Cursor _sCrosshairCursor = Cursor.getPredefinedCursor(1);
    private static Cursor _sMoveCursor = Cursor.getPredefinedCursor(13);
    public static final Cursor DefaultCopyDrop = _sHandCursor;
    public static final Cursor DefaultMoveDrop = _sHandCursor;
    public static final Cursor DefaultLinkDrop = _sHandCursor;
    public static final Cursor DefaultCopyNoDrop = _sCrosshairCursor;
    public static final Cursor DefaultMoveNoDrop = _sCrosshairCursor;
    public static final Cursor DefaultLinkNoDrop = _sCrosshairCursor;
    private static DragSourceContext _sCurrentContext;
    private static DragSource _sDefaultSource;
    private static final Object _sLock;
    static /* synthetic */ Class class$oracle$bali$ewt$dnd$DragGestureRecognizer;
    static /* synthetic */ Class class$oracle$bali$ewt$dnd$MouseDragGestureRecognizer;

    public static DragSource getDefaultDragSource() {
        if (_sDefaultSource == null) {
            _sDefaultSource = new DragSource();
        }
        return _sDefaultSource;
    }

    public static boolean isDragImageSupported() {
        return true;
    }

    public void startDrag(DragGestureEvent dragGestureEvent, Cursor cursor, Image image, Point point, Transferable transferable, DragSourceListener dragSourceListener) throws InvalidDnDOperationException {
        DragSourceContext dragSourceContext = this.createDragSourceContext(dragGestureEvent, cursor, image, point, transferable, dragSourceListener);
        if (dragSourceContext == null) {
            throw new InvalidDnDOperationException();
        }
        dragSourceContext.startDrag();
        dragGestureEvent.getTriggerEvent().consume();
    }

    public void startDrag(DragGestureEvent dragGestureEvent, Cursor cursor, Transferable transferable, DragSourceListener dragSourceListener) throws InvalidDnDOperationException {
        this.startDrag(dragGestureEvent, cursor, null, null, transferable, dragSourceListener);
    }

    DragSourceContext createDragSourceContext(DragGestureEvent dragGestureEvent, Cursor cursor, Image image, Point point, Transferable transferable, DragSourceListener dragSourceListener) {
        return new DragSourceContext(dragGestureEvent, cursor, image, point, transferable, dragSourceListener);
    }

    public DragGestureRecognizer createDragGestureRecognizer(Class clazz, Component component, int n, DragGestureListener dragGestureListener) {
        if (clazz == (class$oracle$bali$ewt$dnd$DragGestureRecognizer == null ? (class$oracle$bali$ewt$dnd$DragGestureRecognizer = DragSource.class$("oracle.bali.ewt.dnd.DragGestureRecognizer")) : class$oracle$bali$ewt$dnd$DragGestureRecognizer) || clazz == (class$oracle$bali$ewt$dnd$MouseDragGestureRecognizer == null ? (class$oracle$bali$ewt$dnd$MouseDragGestureRecognizer = DragSource.class$("oracle.bali.ewt.dnd.MouseDragGestureRecognizer")) : class$oracle$bali$ewt$dnd$MouseDragGestureRecognizer)) {
            return this.createDefaultDragGestureRecognizer(component, n, dragGestureListener);
        }
        return null;
    }

    public DragGestureRecognizer createDefaultDragGestureRecognizer(Component component, int n, DragGestureListener dragGestureListener) {
        return new EWTDragGestureRecognizer(this, component, n, dragGestureListener);
    }

    static void setCurrentDragSourceContext(DragSourceContext dragSourceContext) throws InvalidDnDOperationException {
        Object object = _sLock;
        synchronized (object) {
            if (_sCurrentContext != null && dragSourceContext != null) {
                throw new InvalidDnDOperationException();
            }
            Component component = null;
            if (dragSourceContext != null) {
                component = dragSourceContext.getComponent();
            } else if (_sCurrentContext != null) {
                component = _sCurrentContext.getComponent();
            }
            _sCurrentContext = dragSourceContext;
        }
    }

    static DragSourceContext getCurrentDragSourceContext() {
        return _sCurrentContext;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        _sLock = new Object();
    }
}

