/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.ewt.dTree;

import java.awt.Dimension;
import java.io.IOException;
import java.io.NotActiveException;
import java.io.ObjectInputStream;
import javax.accessibility.Accessible;
import javax.swing.Icon;
import oracle.bali.ewt.dTree.DTree;
import oracle.bali.ewt.dTree.DTreeExplicitParent;
import oracle.bali.ewt.dTree.DTreeItem;
import oracle.bali.ewt.dTree.DTreeItemEvent;
import oracle.bali.ewt.dTree.DTreeItemValidateEvent;
import oracle.bali.ewt.dTree.DTreeSimpleChild;

public class DTreeSimpleParent
extends DTreeSimpleChild
implements DTreeExplicitParent {
    private static final long serialVersionUID = -7133055331596216079L;
    private DTreeItem[] _children;
    private int _nchildren;
    private transient int _subheight;
    private transient int _subwidth;
    private boolean _expanded;

    public DTreeSimpleParent(String string, Icon icon) {
        super(string, icon);
    }

    public final void addItem(DTreeItem dTreeItem) {
        this.addItem(dTreeItem, -1);
    }

    public final void addItem(DTreeItem dTreeItem, int n) {
        if (dTreeItem == null) {
            throw new NullPointerException();
        }
        DTreeItem[] dTreeItemArray = new DTreeItem[]{dTreeItem};
        this.addItems(dTreeItemArray, n);
    }

    public void addItems(DTreeItem[] dTreeItemArray, int n) {
        int n2 = dTreeItemArray.length;
        if (n2 <= 0) {
            return;
        }
        int n3 = this.getItemCount();
        if (n < 0 || n > n3) {
            n = n3;
        }
        if (this._children == null) {
            this._children = new DTreeItem[n2];
        } else if (this._children.length < n2 + n3) {
            DTreeItem[] dTreeItemArray2 = new DTreeItem[n2 + n3];
            System.arraycopy(this._children, 0, dTreeItemArray2, 0, n);
            System.arraycopy(this._children, n, dTreeItemArray2, n + n2, n3 - n);
            this._children = dTreeItemArray2;
        } else {
            System.arraycopy(this._children, n, this._children, n + n2, n3 - n);
        }
        System.arraycopy(dTreeItemArray, 0, this._children, n, n2);
        this._nchildren = n3 + n2;
        int n4 = n;
        while (n4 < n + n2) {
            this._children[n4].itemAdded(this, n4);
            ++n4;
        }
        while (n4 < this._nchildren) {
            this._children[n4].setIndex(n4);
            ++n4;
        }
        DTree dTree = this.getTree();
        if (dTree != null) {
            dTree.itemsAdded(this, n, n2);
        }
    }

    public Object clone() throws CloneNotSupportedException {
        DTreeSimpleParent dTreeSimpleParent = (DTreeSimpleParent)super.clone();
        dTreeSimpleParent._nchildren = 0;
        dTreeSimpleParent.itemRemoved();
        DTreeItem[] dTreeItemArray = new DTreeItem[this._nchildren];
        int n = 0;
        while (n < this._nchildren) {
            DTreeItem dTreeItem;
            dTreeItemArray[n] = dTreeItem = (DTreeItem)this._children[n].clone();
            dTreeItem.itemAdded(dTreeSimpleParent, dTreeItem.getIndex());
            ++n;
        }
        dTreeSimpleParent._children = dTreeItemArray;
        dTreeSimpleParent._nchildren = dTreeItemArray.length;
        return dTreeSimpleParent;
    }

    public DTreeItem getItem(int n) {
        if (n >= this._nchildren) {
            return null;
        }
        return this._children[n];
    }

    public DTreeItem getItemAt(int n, int n2) {
        int n3 = this.getSubTreeHeight();
        if (n2 > n3) {
            return null;
        }
        int n4 = this.getSize().height;
        if (n2 < n4) {
            return this;
        }
        if (this.isExpanded() && this._nchildren > 0) {
            int n5 = 0;
            int n6 = this.getY();
            while (n5 < this._nchildren) {
                DTreeItem dTreeItem = this.getItem(n5);
                int n7 = dTreeItem.getY() - n6;
                if (n2 >= n7 && n2 < n7 + dTreeItem.getSubTreeHeight()) {
                    return dTreeItem.getItemAt(n, n2 - n7);
                }
                if (n2 < n7) {
                    return null;
                }
                ++n5;
            }
        }
        return null;
    }

    public int getItemCount() {
        return this._nchildren;
    }

    public DTreeItem getNextExpandedChild(DTreeItem dTreeItem) {
        int n = dTreeItem == null ? 0 : dTreeItem.getIndex() + 1;
        while (n < this._nchildren) {
            DTreeItem dTreeItem2 = this._children[n];
            if (dTreeItem2.isExpanded()) {
                return dTreeItem2;
            }
            ++n;
        }
        return null;
    }

    public int getSubTreeHeight() {
        return this._subheight;
    }

    public int getSubTreeWidth() {
        return this._subwidth;
    }

    public boolean isExpandable() {
        return this.getItemCount() > 0;
    }

    public boolean isExpanded() {
        return this._expanded;
    }

    public void layout(int n, int n2) {
        super.layout(n, n2);
        Dimension dimension = this.getSize();
        int n3 = dimension.height;
        this._subwidth = dimension.width;
        if (this._expanded && this._nchildren != 0) {
            DTreeItem dTreeItem = this.getParent();
            DTree dTree = this.getTree();
            int n4 = 0;
            int n5 = dTreeItem == null ? 0 : dTree.getIndentWidth();
            int n6 = n;
            int n7 = n2 + this.getChildrenYOffset(n3);
            n6 += this.getChildrenXOffset(n5);
            while (n4 < this._nchildren) {
                DTreeItem dTreeItem2 = this.getItem(n4);
                dTreeItem2.layout(n6, n7);
                n7 += dTreeItem2.getSubTreeHeight();
                this._subwidth = Math.max(this._subwidth, dTreeItem2.getSubTreeWidth() + n5);
                ++n4;
            }
            n3 = n7 - n2;
        }
        this._subheight = n3;
    }

    public void removeItems(int n, int n2) {
        Accessible accessible;
        if (n2 == 0) {
            return;
        }
        int n3 = n;
        while (n3 < n + n2) {
            accessible = this._children[n3];
            accessible.itemRemoved();
            ++n3;
        }
        System.arraycopy(this._children, n + n2, this._children, n, this._nchildren - (n + n2));
        this._nchildren -= n2;
        n3 = n;
        while (n3 < this._nchildren) {
            this._children[n3].setIndex(n3);
            ++n3;
        }
        accessible = this.getTree();
        ((DTree)accessible).itemsRemoved(this, n, n2);
    }

    public void setExpanded(boolean bl) {
        if (bl == this.isExpanded()) {
            return;
        }
        DTree dTree = this.getTree();
        if (!this._fireExpansionChanging(dTree, bl)) {
            this._expanded = bl;
            this._fireExpansionChanged(dTree, bl);
        }
    }

    protected int getChildrenXOffset(int n) {
        return n;
    }

    protected int getChildrenYOffset(int n) {
        return n;
    }

    protected void setSubTreeHeight(int n) {
        this._subheight = n;
    }

    private boolean _fireExpansionChanging(DTree dTree, boolean bl) {
        if (dTree == null) {
            return false;
        }
        int n = bl ? 2000 : 2002;
        DTreeItemValidateEvent dTreeItemValidateEvent = new DTreeItemValidateEvent(dTree, n, this);
        dTree.dispatchEvent(dTreeItemValidateEvent);
        return dTreeItemValidateEvent.isCancelled();
    }

    private void _fireExpansionChanged(DTree dTree, boolean bl) {
        if (dTree == null) {
            return;
        }
        int n = bl ? 2001 : 2003;
        DTreeItemEvent dTreeItemEvent = new DTreeItemEvent(dTree, n, this);
        dTree.dispatchEvent(dTreeItemEvent);
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException, NotActiveException {
        objectInputStream.defaultReadObject();
        int n = 0;
        while (n < this._nchildren) {
            this._children[n].itemAdded(this, n);
            ++n;
        }
    }
}

